/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.client.feature.ship_water_pockets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1723;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_284;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4184;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.primitives.AABBdc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.valkyrienair.config.ValkyrienAirConfig;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipPocketAsyncRuntime;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipPocketAsyncSubsystem;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketAsyncCull;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketManager;

public final class ShipWaterPocketExternalWaterCull {
    private static final Logger LOGGER = LogManager.getLogger((String)"ValkyrienAir ShipWaterCull");
    private static final int MAX_SHIPS = 9;
    private static final int SUB = 8;
    private static final int OCC_WORDS_PER_VOXEL = 16;
    private static final int MASK_TEX_WIDTH = 4096;
    private static final int MASK_TEX_WIDTH_MASK = 4095;
    private static final int MASK_TEX_WIDTH_SHIFT = 12;
    private static final int BASE_MASK_TEX_UNIT = 2;
    private static final int GLSTATEMANAGER_SAFE_TEXTURE_UNITS = 12;
    private static final class_2960 WATER_STILL = new class_2960("minecraft", "block/water_still");
    private static final class_2960 WATER_FLOW = new class_2960("minecraft", "block/water_flow");
    private static final class_2960 WATER_OVERLAY = new class_2960("minecraft", "block/water_overlay");
    private static final class_2960 LAVA_STILL = new class_2960("minecraft", "block/lava_still");
    private static final class_2960 LAVA_FLOW = new class_2960("minecraft", "block/lava_flow");
    private static int fluidMaskTexId = 0;
    private static int fluidMaskWidth = 0;
    private static int fluidMaskHeight = 0;
    private static int fluidMaskLastAtlasTexId = 0;
    private static byte[] fluidMaskData = null;
    private static ByteBuffer fluidMaskBuffer = null;
    private static boolean loggedFluidMaskBuildFailed = false;
    private static CompletableFuture<byte[]> pendingFluidMaskFuture = null;
    private static int pendingFluidMaskAtlasTexId = 0;
    private static int pendingFluidMaskWidth = 0;
    private static int pendingFluidMaskHeight = 0;
    private static boolean forgeFluidTexturesChecked = false;
    private static Method forgeFluidExtOf = null;
    private static Method forgeGetStill0 = null;
    private static Method forgeGetFlow0 = null;
    private static Method forgeGetOverlay0 = null;
    private static Method forgeGetStill3 = null;
    private static Method forgeGetFlow3 = null;
    private static Method forgeGetOverlay3 = null;
    private static boolean fabricFluidTexturesChecked = false;
    private static Object fabricFluidRenderHandlerRegistry = null;
    private static Method fabricRegistryGetHandler = null;
    private static Method fabricHandlerGetSprites = null;
    private static final Matrix4f IDENTITY_MAT4 = new Matrix4f();
    private static class_638 lastLevel = null;
    private static final Map<Long, ShipMasks> SHIP_MASKS = new HashMap<Long, ShipMasks>();
    private static final Int2ObjectOpenHashMap<ProgramHandles> PROGRAM_HANDLES = new Int2ObjectOpenHashMap();
    private static boolean programEverSupported = false;
    private static final ThreadLocal<FloatBuffer> MATRIX_BUFFER = ThreadLocal.withInitial(() -> BufferUtils.createFloatBuffer((int)16));
    private static final ShaderHandles SHADER = new ShaderHandles();
    private static boolean everEnabled = false;
    private static boolean shaderEverSupported = false;
    private static boolean loggedEmbeddiumProgramMissingUniforms = false;

    private ShipWaterPocketExternalWaterCull() {
    }

    public static void clear() {
        ShipWaterPocketExternalWaterCull.SHADER.shader = null;
        ShipWaterPocketExternalWaterCull.SHADER.supported = false;
        everEnabled = false;
        shaderEverSupported = false;
        programEverSupported = false;
        PROGRAM_HANDLES.clear();
        for (ShipMasks masks : SHIP_MASKS.values()) {
            masks.close();
        }
        SHIP_MASKS.clear();
        if (fluidMaskTexId != 0) {
            TextureUtil.releaseTextureId((int)fluidMaskTexId);
            fluidMaskTexId = 0;
        }
        if (pendingFluidMaskFuture != null) {
            pendingFluidMaskFuture.cancel(true);
            pendingFluidMaskFuture = null;
        }
        fluidMaskWidth = 0;
        fluidMaskHeight = 0;
        fluidMaskLastAtlasTexId = 0;
        fluidMaskData = null;
        fluidMaskBuffer = null;
        loggedFluidMaskBuildFailed = false;
        pendingFluidMaskAtlasTexId = 0;
        pendingFluidMaskWidth = 0;
        pendingFluidMaskHeight = 0;
        lastLevel = null;
    }

    public static boolean isShaderCullingActive() {
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return false;
        }
        return (shaderEverSupported || programEverSupported) && everEnabled;
    }

    public static void setupForWorldTranslucentPass(class_5944 shader, class_638 level, class_4184 camera) {
        if (level == null || camera == null) {
            return;
        }
        class_243 cameraPos = camera.method_19326();
        ShipWaterPocketExternalWaterCull.setupForWorldTranslucentPass(shader, level, cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350);
    }

    public static void setupForWorldTranslucentPass(class_5944 shader, class_638 level, double cameraX, double cameraY, double cameraZ) {
        if (level == null) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        if (lastLevel != level) {
            ShipWaterPocketExternalWaterCull.clear();
            lastLevel = level;
        }
        ShipWaterPocketExternalWaterCull.bindShaderHandles(shader);
        if (!ShipWaterPocketExternalWaterCull.SHADER.supported) {
            return;
        }
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            ShipWaterPocketExternalWaterCull.disable(shader);
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.cullEnabled.method_1251(1.0f);
        ShipWaterPocketExternalWaterCull.SHADER.cullEnabled.method_1300();
        everEnabled = true;
        ShipWaterPocketExternalWaterCull.setShipPass(shader, false);
        class_243 cameraPos = new class_243(cameraX, cameraY, cameraZ);
        ShipWaterPocketExternalWaterCull.SHADER.shader.method_34583("ValkyrienAir_FluidMask", (Object)ShipWaterPocketExternalWaterCull.ensureFluidMaskTexture(level));
        ShipWaterPocketExternalWaterCull.updateCameraAndWaterUv(cameraPos);
        List<LoadedShip> ships = ShipWaterPocketExternalWaterCull.selectClosestShips(level, cameraPos, 9);
        ShipWaterPocketExternalWaterCull.updateShipUniformsAndMasks(level, ships, cameraX, cameraY, cameraZ);
    }

    public static void setupForWorldTranslucentPassProgram(int programId, class_638 level, double cameraX, double cameraY, double cameraZ) {
        ProgramHandles handles;
        if (programId == 0 || level == null) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        if (lastLevel != level) {
            ShipWaterPocketExternalWaterCull.clear();
            lastLevel = level;
        }
        if ((handles = ShipWaterPocketExternalWaterCull.bindProgramHandles(programId)) == null || !handles.supported) {
            if (!loggedEmbeddiumProgramMissingUniforms && handles != null && handles.embeddiumChunkProgram && ValkyrienAirConfig.getEnableShipWaterPockets()) {
                loggedEmbeddiumProgramMissingUniforms = true;
                if (handles.cullEnabledLoc < 0) {
                    LOGGER.warn("Embeddium chunk shader program {} is missing ValkyrienAir uniforms; water culling is inactive (shader injection not applied?)", (Object)programId);
                } else {
                    LOGGER.warn("Embeddium chunk shader program {} has incomplete ValkyrienAir uniforms; water culling is inactive", (Object)programId);
                }
            }
            return;
        }
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            ShipWaterPocketExternalWaterCull.disableProgram(programId);
            return;
        }
        if (handles.cullEnabledLoc >= 0) {
            GL20.glUniform1f((int)handles.cullEnabledLoc, (float)1.0f);
        }
        everEnabled = true;
        if (handles.isShipPassLoc >= 0) {
            GL20.glUniform1f((int)handles.isShipPassLoc, (float)0.0f);
        }
        class_243 cameraPos = new class_243(cameraX, cameraY, cameraZ);
        if (handles.chunkWorldOriginLoc >= 0) {
            GL20.glUniform3f((int)handles.chunkWorldOriginLoc, (float)((float)cameraPos.field_1352), (float)((float)cameraPos.field_1351), (float)((float)cameraPos.field_1350));
        }
        ShipWaterPocketExternalWaterCull.bindProgramFluidMaskTexture(handles, ShipWaterPocketExternalWaterCull.ensureFluidMaskTexture(level));
        ShipWaterPocketExternalWaterCull.updateCameraAndWaterUvProgram(handles, cameraPos);
        List<LoadedShip> ships = ShipWaterPocketExternalWaterCull.selectClosestShips(level, cameraPos, handles.maxMaskSlots);
        ShipWaterPocketExternalWaterCull.updateShipUniformsAndMasksProgram(handles, level, ships, cameraX, cameraY, cameraZ);
    }

    public static void disableProgram(int programId) {
        if (programId == 0) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        ProgramHandles handles = ShipWaterPocketExternalWaterCull.bindProgramHandles(programId);
        if (handles == null) {
            return;
        }
        if (handles.cullEnabledLoc >= 0) {
            GL20.glUniform1f((int)handles.cullEnabledLoc, (float)0.0f);
        }
        if (handles.isShipPassLoc >= 0) {
            GL20.glUniform1f((int)handles.isShipPassLoc, (float)0.0f);
        }
        if (handles.shipWaterTintEnabledLoc >= 0) {
            GL20.glUniform1f((int)handles.shipWaterTintEnabledLoc, (float)0.0f);
        }
        if (handles.shipWaterTintLoc >= 0) {
            GL20.glUniform3f((int)handles.shipWaterTintLoc, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void setShipPassProgram(int programId, boolean shipPass) {
        if (programId == 0) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        ProgramHandles handles = ShipWaterPocketExternalWaterCull.bindProgramHandles(programId);
        if (handles == null || handles.isShipPassLoc < 0) {
            return;
        }
        if (handles.isShipPassLoc >= 0) {
            GL20.glUniform1f((int)handles.isShipPassLoc, (float)(shipPass ? 1.0f : 0.0f));
        }
    }

    public static void disable(class_5944 shader) {
        if (shader == null) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        ShipWaterPocketExternalWaterCull.bindShaderHandles(shader);
        if (!ShipWaterPocketExternalWaterCull.SHADER.supported || ShipWaterPocketExternalWaterCull.SHADER.cullEnabled == null) {
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.cullEnabled.method_1251(0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.cullEnabled.method_1300();
        if (ShipWaterPocketExternalWaterCull.SHADER.isShipPass != null) {
            ShipWaterPocketExternalWaterCull.SHADER.isShipPass.method_1251(0.0f);
            ShipWaterPocketExternalWaterCull.SHADER.isShipPass.method_1300();
        }
        if (ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled != null) {
            ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled.method_1251(0.0f);
            ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled.method_1300();
        }
        if (ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint != null) {
            ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint.method_1249(1.0f, 1.0f, 1.0f);
            ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint.method_1300();
        }
    }

    public static void setShipPass(class_5944 shader, boolean shipPass) {
        if (shader == null) {
            return;
        }
        if (!SHIP_MASKS.isEmpty()) {
            ShipWaterPocketExternalWaterCull.bindShaderHandles(shader);
        }
        if (!ShipWaterPocketExternalWaterCull.SHADER.supported || ShipWaterPocketExternalWaterCull.SHADER.isShipPass == null) {
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.isShipPass.method_1251(shipPass ? 1.0f : 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.isShipPass.method_1300();
    }

    public static void setShipWaterTintEnabled(class_5944 shader, boolean enabled) {
        if (shader == null) {
            return;
        }
        if (!SHIP_MASKS.isEmpty()) {
            ShipWaterPocketExternalWaterCull.bindShaderHandles(shader);
        }
        if (!ShipWaterPocketExternalWaterCull.SHADER.supported || ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled == null) {
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled.method_1251(enabled ? 1.0f : 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled.method_1300();
    }

    public static void setShipWaterTint(class_5944 shader, int rgb) {
        if (shader == null) {
            return;
        }
        if (!SHIP_MASKS.isEmpty()) {
            ShipWaterPocketExternalWaterCull.bindShaderHandles(shader);
        }
        if (!ShipWaterPocketExternalWaterCull.SHADER.supported || ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint == null) {
            return;
        }
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint.method_1249(r, g, b);
        ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint.method_1300();
    }

    public static void setShipWaterTintEnabledProgram(int programId, boolean enabled) {
        if (programId == 0) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        ProgramHandles handles = ShipWaterPocketExternalWaterCull.bindProgramHandles(programId);
        if (handles == null || handles.shipWaterTintEnabledLoc < 0) {
            return;
        }
        GL20.glUniform1f((int)handles.shipWaterTintEnabledLoc, (float)(enabled ? 1.0f : 0.0f));
    }

    public static void setShipWaterTintProgram(int programId, int rgb) {
        if (programId == 0) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        ProgramHandles handles = ShipWaterPocketExternalWaterCull.bindProgramHandles(programId);
        if (handles == null || handles.shipWaterTintLoc < 0) {
            return;
        }
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        GL20.glUniform3f((int)handles.shipWaterTintLoc, (float)r, (float)g, (float)b);
    }

    private static void bindShaderHandles(class_5944 shader) {
        if (shader == null) {
            ShipWaterPocketExternalWaterCull.SHADER.shader = null;
            ShipWaterPocketExternalWaterCull.SHADER.supported = false;
            return;
        }
        if (ShipWaterPocketExternalWaterCull.SHADER.shader == shader) {
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.shader = shader;
        ShipWaterPocketExternalWaterCull.SHADER.supported = false;
        ShipWaterPocketExternalWaterCull.SHADER.cullEnabled = shader.method_34582("ValkyrienAir_CullEnabled");
        if (ShipWaterPocketExternalWaterCull.SHADER.cullEnabled == null) {
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.isShipPass = shader.method_34582("ValkyrienAir_IsShipPass");
        ShipWaterPocketExternalWaterCull.SHADER.cameraWorldPos = shader.method_34582("ValkyrienAir_CameraWorldPos");
        ShipWaterPocketExternalWaterCull.SHADER.waterStillUv = shader.method_34582("ValkyrienAir_WaterStillUv");
        ShipWaterPocketExternalWaterCull.SHADER.waterFlowUv = shader.method_34582("ValkyrienAir_WaterFlowUv");
        ShipWaterPocketExternalWaterCull.SHADER.waterOverlayUv = shader.method_34582("ValkyrienAir_WaterOverlayUv");
        ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled = shader.method_34582("ValkyrienAir_ShipWaterTintEnabled");
        ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint = shader.method_34582("ValkyrienAir_ShipWaterTint");
        if (ShipWaterPocketExternalWaterCull.SHADER.isShipPass == null || ShipWaterPocketExternalWaterCull.SHADER.cameraWorldPos == null || ShipWaterPocketExternalWaterCull.SHADER.waterStillUv == null || ShipWaterPocketExternalWaterCull.SHADER.waterFlowUv == null || ShipWaterPocketExternalWaterCull.SHADER.waterOverlayUv == null) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ShipWaterPocketExternalWaterCull.SHADER.shipAabbMin[i] = shader.method_34582("ValkyrienAir_ShipAabbMin" + i);
            ShipWaterPocketExternalWaterCull.SHADER.shipAabbMax[i] = shader.method_34582("ValkyrienAir_ShipAabbMax" + i);
            ShipWaterPocketExternalWaterCull.SHADER.cameraShipPos[i] = shader.method_34582("ValkyrienAir_CameraShipPos" + i);
            ShipWaterPocketExternalWaterCull.SHADER.gridMin[i] = shader.method_34582("ValkyrienAir_GridMin" + i);
            ShipWaterPocketExternalWaterCull.SHADER.gridSize[i] = shader.method_34582("ValkyrienAir_GridSize" + i);
            ShipWaterPocketExternalWaterCull.SHADER.worldToShip[i] = shader.method_34582("ValkyrienAir_WorldToShip" + i);
            if (ShipWaterPocketExternalWaterCull.SHADER.shipAabbMin[i] != null && ShipWaterPocketExternalWaterCull.SHADER.shipAabbMax[i] != null && ShipWaterPocketExternalWaterCull.SHADER.gridMin[i] != null && ShipWaterPocketExternalWaterCull.SHADER.gridSize[i] != null && ShipWaterPocketExternalWaterCull.SHADER.worldToShip[i] != null && ShipWaterPocketExternalWaterCull.SHADER.cameraShipPos[i] != null) continue;
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.supported = true;
        shaderEverSupported = true;
    }

    private static ProgramHandles bindProgramHandles(int programId) {
        boolean requiredOk;
        boolean looksLikeEmbeddiumChunkProgram;
        int maxSafeUnits;
        ProgramHandles handles = (ProgramHandles)PROGRAM_HANDLES.get(programId);
        if (handles != null) {
            return handles;
        }
        handles = new ProgramHandles(programId);
        int maxCombined = GL11.glGetInteger((int)35661);
        handles.maxSafeTextureUnits = maxSafeUnits = Math.min(maxCombined, 12);
        int availableUnits = maxSafeUnits - 2;
        int availableUnitsForShipMasks = Math.max(0, availableUnits - 1);
        handles.maxMaskSlots = Math.max(0, Math.min(9, availableUnitsForShipMasks));
        handles.regionOffsetLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"u_RegionOffset");
        handles.blockTexLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"u_BlockTex");
        handles.embeddiumChunkProgram = looksLikeEmbeddiumChunkProgram = handles.regionOffsetLoc >= 0 || handles.blockTexLoc >= 0;
        handles.cullEnabledLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_CullEnabled");
        if (handles.cullEnabledLoc < 0) {
            PROGRAM_HANDLES.put(programId, (Object)handles);
            return handles;
        }
        handles.isShipPassLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_IsShipPass");
        handles.cameraWorldPosLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_CameraWorldPos");
        handles.waterStillUvLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_WaterStillUv");
        handles.waterFlowUvLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_WaterFlowUv");
        handles.waterOverlayUvLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_WaterOverlayUv");
        handles.fluidMaskLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_FluidMask");
        handles.shipWaterTintEnabledLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_ShipWaterTintEnabled");
        handles.shipWaterTintLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_ShipWaterTint");
        handles.chunkWorldOriginLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_ChunkWorldOrigin");
        for (int i = 0; i < 9; ++i) {
            handles.shipAabbMinLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_ShipAabbMin" + i));
            handles.shipAabbMaxLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_ShipAabbMax" + i));
            handles.cameraShipPosLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_CameraShipPos" + i));
            handles.gridMinLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_GridMin" + i));
            handles.gridSizeLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_GridSize" + i));
            handles.worldToShipLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_WorldToShip" + i));
            handles.maskLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_Mask" + i));
            handles.shipSlotSupported[i] = i < handles.maxMaskSlots && handles.shipAabbMinLoc[i] >= 0 && handles.shipAabbMaxLoc[i] >= 0 && handles.gridSizeLoc[i] >= 0 && handles.worldToShipLoc[i] >= 0 && handles.maskLoc[i] >= 0;
        }
        handles.supported = requiredOk = looksLikeEmbeddiumChunkProgram && handles.cullEnabledLoc >= 0 && handles.isShipPassLoc >= 0 && handles.cameraWorldPosLoc >= 0 && handles.fluidMaskLoc >= 0 && handles.maxMaskSlots > 0 && handles.shipSlotSupported[0];
        programEverSupported |= handles.supported;
        PROGRAM_HANDLES.put(programId, (Object)handles);
        return handles;
    }

    private static void updateCameraAndWaterUv(class_243 cameraPos) {
        ShipWaterPocketExternalWaterCull.SHADER.cameraWorldPos.method_1249((float)cameraPos.field_1352, (float)cameraPos.field_1351, (float)cameraPos.field_1350);
        ShipWaterPocketExternalWaterCull.SHADER.cameraWorldPos.method_1300();
        Function atlas = class_310.method_1551().method_1549(class_1723.field_21668);
        class_1058 still = (class_1058)atlas.apply(WATER_STILL);
        class_1058 flow = (class_1058)atlas.apply(WATER_FLOW);
        class_1058 overlay = (class_1058)atlas.apply(WATER_OVERLAY);
        ShipWaterPocketExternalWaterCull.SHADER.waterStillUv.method_1254(still.method_4594(), still.method_4593(), still.method_4577(), still.method_4575());
        ShipWaterPocketExternalWaterCull.SHADER.waterFlowUv.method_1254(flow.method_4594(), flow.method_4593(), flow.method_4577(), flow.method_4575());
        ShipWaterPocketExternalWaterCull.SHADER.waterOverlayUv.method_1254(overlay.method_4594(), overlay.method_4593(), overlay.method_4577(), overlay.method_4575());
        ShipWaterPocketExternalWaterCull.SHADER.waterStillUv.method_1300();
        ShipWaterPocketExternalWaterCull.SHADER.waterFlowUv.method_1300();
        ShipWaterPocketExternalWaterCull.SHADER.waterOverlayUv.method_1300();
    }

    private static void updateCameraAndWaterUvProgram(ProgramHandles handles, class_243 cameraPos) {
        if (handles.cameraWorldPosLoc >= 0) {
            GL20.glUniform3f((int)handles.cameraWorldPosLoc, (float)((float)cameraPos.field_1352), (float)((float)cameraPos.field_1351), (float)((float)cameraPos.field_1350));
        }
        Function atlas = class_310.method_1551().method_1549(class_1723.field_21668);
        class_1058 still = (class_1058)atlas.apply(WATER_STILL);
        class_1058 flow = (class_1058)atlas.apply(WATER_FLOW);
        class_1058 overlay = (class_1058)atlas.apply(WATER_OVERLAY);
        if (handles.waterStillUvLoc >= 0) {
            GL20.glUniform4f((int)handles.waterStillUvLoc, (float)still.method_4594(), (float)still.method_4593(), (float)still.method_4577(), (float)still.method_4575());
        }
        if (handles.waterFlowUvLoc >= 0) {
            GL20.glUniform4f((int)handles.waterFlowUvLoc, (float)flow.method_4594(), (float)flow.method_4593(), (float)flow.method_4577(), (float)flow.method_4575());
        }
        if (handles.waterOverlayUvLoc >= 0) {
            GL20.glUniform4f((int)handles.waterOverlayUvLoc, (float)overlay.method_4594(), (float)overlay.method_4593(), (float)overlay.method_4577(), (float)overlay.method_4575());
        }
    }

    private static class_2960[] queryForgeFluidTextures(class_638 level, class_3611 fluid, class_3610 fluidState) {
        if (!ShipWaterPocketExternalWaterCull.ensureForgeFluidTextureAccess()) {
            return null;
        }
        try {
            Object ext = forgeFluidExtOf.invoke(null, fluid);
            if (ext == null) {
                return null;
            }
            class_2960 still = ShipWaterPocketExternalWaterCull.invokeTexture(ext, forgeGetStill0, forgeGetStill3, fluidState, level);
            class_2960 flow = ShipWaterPocketExternalWaterCull.invokeTexture(ext, forgeGetFlow0, forgeGetFlow3, fluidState, level);
            class_2960 overlay = ShipWaterPocketExternalWaterCull.invokeTexture(ext, forgeGetOverlay0, forgeGetOverlay3, fluidState, level);
            if (still == null && flow == null && overlay == null) {
                return null;
            }
            return new class_2960[]{still, flow, overlay};
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static boolean ensureForgeFluidTextureAccess() {
        if (forgeFluidTexturesChecked) {
            return forgeFluidExtOf != null;
        }
        forgeFluidTexturesChecked = true;
        try {
            Class<?> extClass = Class.forName("net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions");
            forgeFluidExtOf = extClass.getMethod("of", class_3611.class);
            forgeGetStill0 = ShipWaterPocketExternalWaterCull.findMethod(extClass, "getStillTexture", new Class[0]);
            forgeGetFlow0 = ShipWaterPocketExternalWaterCull.findMethod(extClass, "getFlowingTexture", new Class[0]);
            forgeGetOverlay0 = ShipWaterPocketExternalWaterCull.findMethod(extClass, "getOverlayTexture", new Class[0]);
            forgeGetStill3 = ShipWaterPocketExternalWaterCull.findMethod(extClass, "getStillTexture", class_3610.class, class_1920.class, class_2338.class);
            forgeGetFlow3 = ShipWaterPocketExternalWaterCull.findMethod(extClass, "getFlowingTexture", class_3610.class, class_1920.class, class_2338.class);
            forgeGetOverlay3 = ShipWaterPocketExternalWaterCull.findMethod(extClass, "getOverlayTexture", class_3610.class, class_1920.class, class_2338.class);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        catch (Throwable t) {
            if (!loggedFluidMaskBuildFailed) {
                loggedFluidMaskBuildFailed = true;
                LOGGER.warn("Failed to query Forge fluid render textures for fluid culling; some modded fluids may not be culled.", t);
            }
            return false;
        }
    }

    private static class_1058[] queryFabricFluidSprites(class_638 level, class_3611 fluid, class_3610 fluidState) {
        if (!ShipWaterPocketExternalWaterCull.ensureFabricFluidTextureAccess()) {
            return null;
        }
        try {
            Object handler = fabricRegistryGetHandler.invoke(fabricFluidRenderHandlerRegistry, fluid);
            if (handler == null) {
                return null;
            }
            return (class_1058[])fabricHandlerGetSprites.invoke(handler, level, class_2338.field_10980, fluidState);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static boolean ensureFabricFluidTextureAccess() {
        if (fabricFluidTexturesChecked) {
            return fabricFluidRenderHandlerRegistry != null;
        }
        fabricFluidTexturesChecked = true;
        try {
            Class<?> registryClass = Class.forName("net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry");
            Field instanceField = registryClass.getField("INSTANCE");
            fabricFluidRenderHandlerRegistry = instanceField.get(null);
            fabricRegistryGetHandler = registryClass.getMethod("get", class_3611.class);
            Class<?> handlerClass = Class.forName("net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler");
            fabricHandlerGetSprites = handlerClass.getMethod("getFluidSprites", class_1920.class, class_2338.class, class_3610.class);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        catch (Throwable t) {
            if (!loggedFluidMaskBuildFailed) {
                loggedFluidMaskBuildFailed = true;
                LOGGER.warn("Failed to query Fabric fluid sprites for fluid culling; some modded fluids may not be culled.", t);
            }
            return false;
        }
    }

    private static List<LoadedShip> selectClosestShips(class_638 level, class_243 cameraPos, int maxCount) {
        ArrayList<LoadedShip> candidates = new ArrayList<LoadedShip>();
        for (LoadedShip ship2 : VSGameUtilsKt.getShipObjectWorld((class_638)level).getLoadedShips()) {
            candidates.add(ship2);
        }
        candidates.sort(Comparator.comparingDouble(ship -> ShipWaterPocketExternalWaterCull.distanceSqToShipAabb(cameraPos, ship)));
        if (candidates.size() > maxCount) {
            return candidates.subList(0, maxCount);
        }
        return candidates;
    }

    private static double distanceSqToShipAabb(class_243 cameraPos, LoadedShip ship) {
        AABBdc shipWorldAabbDc = ShipWaterPocketExternalWaterCull.getShipWorldAabb(ship).orElse(null);
        if (shipWorldAabbDc == null) {
            return Double.POSITIVE_INFINITY;
        }
        double closestX = class_3532.method_15350((double)cameraPos.field_1352, (double)shipWorldAabbDc.minX(), (double)shipWorldAabbDc.maxX());
        double closestY = class_3532.method_15350((double)cameraPos.field_1351, (double)shipWorldAabbDc.minY(), (double)shipWorldAabbDc.maxY());
        double closestZ = class_3532.method_15350((double)cameraPos.field_1350, (double)shipWorldAabbDc.minZ(), (double)shipWorldAabbDc.maxZ());
        double dx = closestX - cameraPos.field_1352;
        double dy = closestY - cameraPos.field_1351;
        double dz = closestZ - cameraPos.field_1350;
        return dx * dx + dy * dy + dz * dz;
    }

    private static Optional<AABBdc> getShipWorldAabb(LoadedShip ship) {
        if (ship instanceof ClientShip) {
            ClientShip clientShip = (ClientShip)ship;
            return Optional.ofNullable(clientShip.getRenderAABB());
        }
        return Optional.ofNullable(ship.getWorldAABB());
    }

    private static ShipTransform getShipTransform(LoadedShip ship) {
        if (ship instanceof ClientShip) {
            ClientShip clientShip = (ClientShip)ship;
            return clientShip.getRenderTransform();
        }
        return ship.getShipTransform();
    }

    private static void updateShipUniformsAndMasks(class_638 level, List<LoadedShip> ships, double cameraX, double cameraY, double cameraZ) {
        long gameTime = level.method_8510();
        for (int slot = 0; slot < 9; ++slot) {
            boolean boundsChanged;
            if (slot >= ships.size()) {
                ShipWaterPocketExternalWaterCull.disableShipSlot(slot);
                continue;
            }
            LoadedShip ship = ships.get(slot);
            long shipId = ship.getId();
            AABBdc shipWorldAabbDc = ShipWaterPocketExternalWaterCull.getShipWorldAabb(ship).orElse(null);
            if (shipWorldAabbDc == null) {
                ShipWaterPocketExternalWaterCull.disableShipSlot(slot);
                continue;
            }
            ShipWaterPocketManager.ClientWaterReachableSnapshot snapshot = ShipWaterPocketManager.getClientWaterReachableSnapshot((class_1937)level, shipId);
            if (snapshot == null) {
                ShipWaterPocketExternalWaterCull.disableShipSlot(slot);
                continue;
            }
            ShipMasks masks = SHIP_MASKS.computeIfAbsent(shipId, ShipMasks::new);
            int minX = snapshot.getMinX();
            int minY = snapshot.getMinY();
            int minZ = snapshot.getMinZ();
            int sizeX = snapshot.getSizeX();
            int sizeY = snapshot.getSizeY();
            int sizeZ = snapshot.getSizeZ();
            long geometryRevision = snapshot.getGeometryRevision();
            boolean bl = boundsChanged = masks.minX != minX || masks.minY != minY || masks.minZ != minZ || masks.sizeX != sizeX || masks.sizeY != sizeY || masks.sizeZ != sizeZ;
            if (boundsChanged || masks.geometryRevision != geometryRevision) {
                ShipWaterPocketExternalWaterCull.rebuildMask(level, masks, snapshot, minX, minY, minZ, sizeX, sizeY, sizeZ, geometryRevision);
            }
            ShipWaterPocketExternalWaterCull.applyPendingMaskBuild(masks, geometryRevision);
            ShipTransform shipTransform = ShipWaterPocketExternalWaterCull.getShipTransform(ship);
            Matrix4dc worldToShip = shipTransform.getWorldToShip();
            double biasedM30 = worldToShip.m30() - (double)minX;
            double biasedM31 = worldToShip.m31() - (double)minY;
            double biasedM32 = worldToShip.m32() - (double)minZ;
            ShipWaterPocketExternalWaterCull.SHADER.shader.method_34583("ValkyrienAir_Mask" + slot, (Object)masks.maskTexId);
            ShipWaterPocketExternalWaterCull.SHADER.shipAabbMin[slot].method_1254((float)shipWorldAabbDc.minX(), (float)shipWorldAabbDc.minY(), (float)shipWorldAabbDc.minZ(), 0.0f);
            ShipWaterPocketExternalWaterCull.SHADER.shipAabbMax[slot].method_1254((float)shipWorldAabbDc.maxX(), (float)shipWorldAabbDc.maxY(), (float)shipWorldAabbDc.maxZ(), 0.0f);
            ShipWaterPocketExternalWaterCull.SHADER.gridMin[slot].method_1254(0.0f, 0.0f, 0.0f, 0.0f);
            ShipWaterPocketExternalWaterCull.SHADER.gridSize[slot].method_1254((float)sizeX, (float)sizeY, (float)sizeZ, 0.0f);
            masks.worldToShip.set((float)worldToShip.m00(), (float)worldToShip.m01(), (float)worldToShip.m02(), (float)worldToShip.m03(), (float)worldToShip.m10(), (float)worldToShip.m11(), (float)worldToShip.m12(), (float)worldToShip.m13(), (float)worldToShip.m20(), (float)worldToShip.m21(), (float)worldToShip.m22(), (float)worldToShip.m23(), (float)biasedM30, (float)biasedM31, (float)biasedM32, (float)worldToShip.m33());
            ShipWaterPocketExternalWaterCull.SHADER.worldToShip[slot].method_1250(masks.worldToShip);
            double camShipX = worldToShip.m00() * cameraX + worldToShip.m10() * cameraY + worldToShip.m20() * cameraZ + biasedM30;
            double camShipY = worldToShip.m01() * cameraX + worldToShip.m11() * cameraY + worldToShip.m21() * cameraZ + biasedM31;
            double camShipZ = worldToShip.m02() * cameraX + worldToShip.m12() * cameraY + worldToShip.m22() * cameraZ + biasedM32;
            ShipWaterPocketExternalWaterCull.SHADER.cameraShipPos[slot].method_1249((float)camShipX, (float)camShipY, (float)camShipZ);
            ShipWaterPocketExternalWaterCull.SHADER.shipAabbMin[slot].method_1300();
            ShipWaterPocketExternalWaterCull.SHADER.shipAabbMax[slot].method_1300();
            ShipWaterPocketExternalWaterCull.SHADER.cameraShipPos[slot].method_1300();
            ShipWaterPocketExternalWaterCull.SHADER.gridMin[slot].method_1300();
            ShipWaterPocketExternalWaterCull.SHADER.gridSize[slot].method_1300();
            ShipWaterPocketExternalWaterCull.SHADER.worldToShip[slot].method_1300();
        }
        LongOpenHashSet loadedIds = new LongOpenHashSet();
        for (LoadedShip loadedShip : VSGameUtilsKt.getShipObjectWorld((class_638)level).getLoadedShips()) {
            loadedIds.add(loadedShip.getId());
        }
        SHIP_MASKS.entrySet().removeIf(entry -> {
            if (loadedIds.contains(entry.getKey())) {
                return false;
            }
            ((ShipMasks)entry.getValue()).close();
            return true;
        });
    }

    private static void updateShipUniformsAndMasksProgram(ProgramHandles handles, class_638 level, List<LoadedShip> ships, double cameraX, double cameraY, double cameraZ) {
        long gameTime = level.method_8510();
        for (int slot = 0; slot < 9; ++slot) {
            boolean boundsChanged;
            if (!handles.shipSlotSupported[slot]) {
                ShipWaterPocketExternalWaterCull.disableShipSlotProgram(handles, slot);
                continue;
            }
            if (slot >= ships.size()) {
                ShipWaterPocketExternalWaterCull.disableShipSlotProgram(handles, slot);
                continue;
            }
            LoadedShip ship = ships.get(slot);
            long shipId = ship.getId();
            AABBdc shipWorldAabbDc = ShipWaterPocketExternalWaterCull.getShipWorldAabb(ship).orElse(null);
            if (shipWorldAabbDc == null) {
                ShipWaterPocketExternalWaterCull.disableShipSlotProgram(handles, slot);
                continue;
            }
            ShipWaterPocketManager.ClientWaterReachableSnapshot snapshot = ShipWaterPocketManager.getClientWaterReachableSnapshot((class_1937)level, shipId);
            if (snapshot == null) {
                ShipWaterPocketExternalWaterCull.disableShipSlotProgram(handles, slot);
                continue;
            }
            ShipMasks masks = SHIP_MASKS.computeIfAbsent(shipId, ShipMasks::new);
            int minX = snapshot.getMinX();
            int minY = snapshot.getMinY();
            int minZ = snapshot.getMinZ();
            int sizeX = snapshot.getSizeX();
            int sizeY = snapshot.getSizeY();
            int sizeZ = snapshot.getSizeZ();
            long geometryRevision = snapshot.getGeometryRevision();
            boolean bl = boundsChanged = masks.minX != minX || masks.minY != minY || masks.minZ != minZ || masks.sizeX != sizeX || masks.sizeY != sizeY || masks.sizeZ != sizeZ;
            if (boundsChanged || masks.geometryRevision != geometryRevision) {
                ShipWaterPocketExternalWaterCull.rebuildMask(level, masks, snapshot, minX, minY, minZ, sizeX, sizeY, sizeZ, geometryRevision);
            }
            ShipWaterPocketExternalWaterCull.applyPendingMaskBuild(masks, geometryRevision);
            ShipTransform shipTransform = ShipWaterPocketExternalWaterCull.getShipTransform(ship);
            Matrix4dc worldToShip = shipTransform.getWorldToShip();
            double biasedM30 = worldToShip.m30() - (double)minX;
            double biasedM31 = worldToShip.m31() - (double)minY;
            double biasedM32 = worldToShip.m32() - (double)minZ;
            ShipWaterPocketExternalWaterCull.bindProgramMaskTexture(handles, slot, masks.maskTexId);
            if (handles.shipAabbMinLoc[slot] >= 0) {
                GL20.glUniform4f((int)handles.shipAabbMinLoc[slot], (float)((float)shipWorldAabbDc.minX()), (float)((float)shipWorldAabbDc.minY()), (float)((float)shipWorldAabbDc.minZ()), (float)0.0f);
            }
            if (handles.shipAabbMaxLoc[slot] >= 0) {
                GL20.glUniform4f((int)handles.shipAabbMaxLoc[slot], (float)((float)shipWorldAabbDc.maxX()), (float)((float)shipWorldAabbDc.maxY()), (float)((float)shipWorldAabbDc.maxZ()), (float)0.0f);
            }
            if (handles.gridMinLoc[slot] >= 0) {
                GL20.glUniform4f((int)handles.gridMinLoc[slot], (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            }
            if (handles.gridSizeLoc[slot] >= 0) {
                GL20.glUniform4f((int)handles.gridSizeLoc[slot], (float)sizeX, (float)sizeY, (float)sizeZ, (float)0.0f);
            }
            masks.worldToShip.set((float)worldToShip.m00(), (float)worldToShip.m01(), (float)worldToShip.m02(), (float)worldToShip.m03(), (float)worldToShip.m10(), (float)worldToShip.m11(), (float)worldToShip.m12(), (float)worldToShip.m13(), (float)worldToShip.m20(), (float)worldToShip.m21(), (float)worldToShip.m22(), (float)worldToShip.m23(), (float)biasedM30, (float)biasedM31, (float)biasedM32, (float)worldToShip.m33());
            ShipWaterPocketExternalWaterCull.uploadMatrixUniform(handles.worldToShipLoc[slot], masks.worldToShip);
            double camShipX = worldToShip.m00() * cameraX + worldToShip.m10() * cameraY + worldToShip.m20() * cameraZ + biasedM30;
            double camShipY = worldToShip.m01() * cameraX + worldToShip.m11() * cameraY + worldToShip.m21() * cameraZ + biasedM31;
            double camShipZ = worldToShip.m02() * cameraX + worldToShip.m12() * cameraY + worldToShip.m22() * cameraZ + biasedM32;
            if (handles.cameraShipPosLoc[slot] < 0) continue;
            GL20.glUniform3f((int)handles.cameraShipPosLoc[slot], (float)((float)camShipX), (float)((float)camShipY), (float)((float)camShipZ));
        }
        LongOpenHashSet loadedIds = new LongOpenHashSet();
        for (LoadedShip loadedShip : VSGameUtilsKt.getShipObjectWorld((class_638)level).getLoadedShips()) {
            loadedIds.add(loadedShip.getId());
        }
        SHIP_MASKS.entrySet().removeIf(entry -> {
            if (loadedIds.contains(entry.getKey())) {
                return false;
            }
            ((ShipMasks)entry.getValue()).close();
            return true;
        });
    }

    private static void disableShipSlot(int slot) {
        ShipWaterPocketExternalWaterCull.SHADER.shader.method_34583("ValkyrienAir_Mask" + slot, (Object)0);
        ShipWaterPocketExternalWaterCull.SHADER.shipAabbMin[slot].method_1254(0.0f, 0.0f, 0.0f, 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.shipAabbMax[slot].method_1254(-1.0f, -1.0f, -1.0f, 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.cameraShipPos[slot].method_1249(0.0f, 0.0f, 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.gridMin[slot].method_1254(0.0f, 0.0f, 0.0f, 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.gridSize[slot].method_1254(0.0f, 0.0f, 0.0f, 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.worldToShip[slot].method_1250(IDENTITY_MAT4);
        ShipWaterPocketExternalWaterCull.SHADER.shipAabbMin[slot].method_1300();
        ShipWaterPocketExternalWaterCull.SHADER.shipAabbMax[slot].method_1300();
        ShipWaterPocketExternalWaterCull.SHADER.cameraShipPos[slot].method_1300();
        ShipWaterPocketExternalWaterCull.SHADER.gridMin[slot].method_1300();
        ShipWaterPocketExternalWaterCull.SHADER.gridSize[slot].method_1300();
        ShipWaterPocketExternalWaterCull.SHADER.worldToShip[slot].method_1300();
    }

    private static void disableShipSlotProgram(ProgramHandles handles, int slot) {
        if (handles.shipAabbMinLoc[slot] >= 0) {
            GL20.glUniform4f((int)handles.shipAabbMinLoc[slot], (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        }
        if (handles.shipAabbMaxLoc[slot] >= 0) {
            GL20.glUniform4f((int)handles.shipAabbMaxLoc[slot], (float)-1.0f, (float)-1.0f, (float)-1.0f, (float)0.0f);
        }
        if (handles.cameraShipPosLoc[slot] >= 0) {
            GL20.glUniform3f((int)handles.cameraShipPosLoc[slot], (float)0.0f, (float)0.0f, (float)0.0f);
        }
        if (handles.gridMinLoc[slot] >= 0) {
            GL20.glUniform4f((int)handles.gridMinLoc[slot], (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        }
        if (handles.gridSizeLoc[slot] >= 0) {
            GL20.glUniform4f((int)handles.gridSizeLoc[slot], (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        }
        ShipWaterPocketExternalWaterCull.uploadMatrixUniform(handles.worldToShipLoc[slot], IDENTITY_MAT4);
        if (slot < handles.maxMaskSlots) {
            ShipWaterPocketExternalWaterCull.bindProgramMaskTexture(handles, slot, 0);
        }
    }

    private static void bindProgramMaskTexture(ProgramHandles handles, int slot, int maskTexId) {
        if (handles == null) {
            return;
        }
        if (slot < 0 || slot >= handles.maxMaskSlots) {
            return;
        }
        int unit = 2 + slot;
        if (unit < 0 || unit >= handles.maxSafeTextureUnits) {
            return;
        }
        if (handles.maskLoc[slot] >= 0) {
            GL20.glUniform1i((int)handles.maskLoc[slot], (int)unit);
        }
        GlStateManager._activeTexture((int)(33984 + unit));
        GlStateManager._bindTexture((int)maskTexId);
        GlStateManager._activeTexture((int)33984);
    }

    private static void bindProgramFluidMaskTexture(ProgramHandles handles, int fluidMaskTexId) {
        if (handles == null) {
            return;
        }
        if (handles.fluidMaskLoc < 0) {
            return;
        }
        int fluidUnit = 2 + handles.maxMaskSlots;
        if (fluidUnit < 0 || fluidUnit >= handles.maxSafeTextureUnits) {
            return;
        }
        GL20.glUniform1i((int)handles.fluidMaskLoc, (int)fluidUnit);
        GlStateManager._activeTexture((int)(33984 + fluidUnit));
        GlStateManager._bindTexture((int)fluidMaskTexId);
        GlStateManager._activeTexture((int)33984);
    }

    private static void uploadMatrixUniform(int location, Matrix4f matrix) {
        if (location < 0) {
            return;
        }
        FloatBuffer buffer = MATRIX_BUFFER.get();
        buffer.clear();
        matrix.get(buffer);
        buffer.position(16);
        buffer.flip();
        GL20.glUniformMatrix4fv((int)location, (boolean)false, (FloatBuffer)buffer);
    }

    private static void rebuildMask(class_638 level, ShipMasks masks, ShipWaterPocketManager.ClientWaterReachableSnapshot snapshot, int minX, int minY, int minZ, int sizeX, int sizeY, int sizeZ, long geometryRevision) {
        masks.geometryRevision = geometryRevision;
        masks.minX = minX;
        masks.minY = minY;
        masks.minZ = minZ;
        masks.sizeX = sizeX;
        masks.sizeY = sizeY;
        masks.sizeZ = sizeZ;
        int volume = sizeX * sizeY * sizeZ;
        ShipWaterPocketExternalWaterCull.ensureMaskTextureStorage(masks, volume);
        ShipWaterPocketExternalWaterCull.applyPendingMaskBuild(masks, geometryRevision);
        if (masks.lastMaskUploadRevision == geometryRevision && masks.maskTexId != 0) {
            return;
        }
        if (masks.pendingMaskWordsFuture != null && masks.pendingMaskBuildRevision == geometryRevision) {
            return;
        }
        class_265[] shapeSnapshot = new class_265[volume];
        class_2338.class_2339 pos = new class_2338.class_2339();
        int idx = 0;
        for (int lz = 0; lz < sizeZ; ++lz) {
            for (int ly = 0; ly < sizeY; ++ly) {
                for (int lx = 0; lx < sizeX; ++lx) {
                    pos.method_10103(minX + lx, minY + ly, minZ + lz);
                    class_2680 state = level.method_8320((class_2338)pos);
                    class_265 shape = state.method_26201((class_1922)level, (class_2338)pos);
                    if (shape.method_1110()) {
                        shape = state.method_26220((class_1922)level, (class_2338)pos);
                    }
                    shapeSnapshot[idx++] = shape;
                }
            }
        }
        BitSet interiorSnapshot = snapshot.getInterior() == null ? new BitSet() : (BitSet)snapshot.getInterior().clone();
        Supplier<int[]> task = () -> {
            int[] occWords = ShipWaterPocketAsyncCull.buildOccMaskWords(shapeSnapshot, sizeX, sizeY, sizeZ, 8);
            int[] airWords = ShipWaterPocketAsyncCull.buildAirMaskWords(interiorSnapshot, volume);
            int[] out = new int[occWords.length + airWords.length];
            System.arraycopy(occWords, 0, out, 0, occWords.length);
            System.arraycopy(airWords, 0, out, occWords.length, airWords.length);
            return out;
        };
        CompletableFuture<int[]> submitted = ShipPocketAsyncRuntime.trySubmitJava(ShipPocketAsyncSubsystem.CLIENT_CULL, task);
        if (submitted == null) {
            if (masks.pendingMaskWordsFuture != null) {
                masks.pendingMaskWordsFuture.cancel(true);
                masks.pendingMaskWordsFuture = null;
            }
            ShipWaterPocketExternalWaterCull.applyMaskWords(masks, task.get(), geometryRevision);
            return;
        }
        if (masks.pendingMaskWordsFuture != null) {
            masks.pendingMaskWordsFuture.cancel(true);
        }
        masks.pendingMaskWordsFuture = submitted;
        masks.pendingMaskBuildRevision = geometryRevision;
    }

    private static void ensureMaskTextureStorage(ShipMasks masks, int volume) {
        int occWordCount = volume * 16;
        int airWordCount = volume + 31 >> 5;
        int wordCount = occWordCount + airWordCount;
        int height = Math.max(1, (wordCount + 4096 - 1) / 4096);
        boolean newOrResized = false;
        if (masks.maskTexId != 0 && masks.maskTexHeight != height) {
            TextureUtil.releaseTextureId((int)masks.maskTexId);
            masks.maskTexId = 0;
            newOrResized = true;
        }
        int prevId = masks.maskTexId;
        masks.maskTexId = ShipWaterPocketExternalWaterCull.ensureIntTexture(masks.maskTexId, 4096, height);
        masks.maskTexHeight = height;
        if ((newOrResized |= prevId == 0 && masks.maskTexId != 0) && masks.maskTexId != 0) {
            int capacity = 4096 * height;
            if (masks.maskData == null || masks.maskData.length != capacity) {
                masks.maskData = new int[capacity];
                masks.maskBuffer = BufferUtils.createIntBuffer((int)capacity);
            } else {
                Arrays.fill(masks.maskData, 0);
            }
            masks.maskBuffer.clear();
            masks.maskBuffer.put(masks.maskData);
            masks.maskBuffer.flip();
            ShipWaterPocketExternalWaterCull.uploadIntTexture(masks.maskTexId, 4096, height, masks.maskBuffer);
            masks.lastMaskUploadRevision = Long.MIN_VALUE;
        }
    }

    private static void applyPendingMaskBuild(ShipMasks masks, long currentGeometryRevision) {
        int[] words;
        CompletableFuture<int[]> pending = masks.pendingMaskWordsFuture;
        if (pending == null || !pending.isDone()) {
            return;
        }
        long uploadRevision = masks.pendingMaskBuildRevision;
        masks.pendingMaskWordsFuture = null;
        if (uploadRevision != currentGeometryRevision) {
            return;
        }
        try {
            words = pending.join();
        }
        catch (Throwable ignored) {
            return;
        }
        ShipWaterPocketExternalWaterCull.applyMaskWords(masks, words, uploadRevision);
    }

    private static void applyMaskWords(ShipMasks masks, int[] words, long uploadRevision) {
        if (masks.maskTexId == 0) {
            return;
        }
        int capacity = 4096 * masks.maskTexHeight;
        if (masks.maskData == null || masks.maskData.length != capacity) {
            masks.maskData = new int[capacity];
            masks.maskBuffer = BufferUtils.createIntBuffer((int)capacity);
        } else {
            Arrays.fill(masks.maskData, 0);
        }
        int maxWords = Math.min(words.length, masks.maskData.length);
        for (int wordIdx = 0; wordIdx < maxWords; ++wordIdx) {
            int texIdx = (wordIdx & 0xFFF) + (wordIdx >> 12) * 4096;
            if (texIdx < 0 || texIdx >= masks.maskData.length) continue;
            masks.maskData[texIdx] = words[wordIdx];
        }
        masks.maskBuffer.clear();
        masks.maskBuffer.put(masks.maskData);
        masks.maskBuffer.flip();
        ShipWaterPocketExternalWaterCull.uploadIntTexture(masks.maskTexId, 4096, masks.maskTexHeight, masks.maskBuffer);
        masks.lastMaskUploadRevision = uploadRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int ensureFluidMaskTexture(class_638 level) {
        boolean needsRebuild;
        if (level == null) {
            return 0;
        }
        class_310 mc = class_310.method_1551();
        class_1044 atlasTexture = mc.method_1531().method_4619(class_1723.field_21668);
        if (atlasTexture == null) {
            return 0;
        }
        int atlasTexId = atlasTexture.method_4624();
        if (atlasTexId == 0) {
            return 0;
        }
        int atlasWidth = 0;
        int atlasHeight = 0;
        int prevBinding = GL11.glGetInteger((int)32873);
        try {
            GlStateManager._bindTexture((int)atlasTexId);
            atlasWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            atlasHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        }
        finally {
            GlStateManager._bindTexture((int)prevBinding);
        }
        if (atlasWidth <= 0 || atlasHeight <= 0) {
            return 0;
        }
        if (fluidMaskTexId != 0 && (fluidMaskWidth != atlasWidth || fluidMaskHeight != atlasHeight)) {
            TextureUtil.releaseTextureId((int)fluidMaskTexId);
            fluidMaskTexId = 0;
        }
        fluidMaskTexId = ShipWaterPocketExternalWaterCull.ensureByteTexture(fluidMaskTexId, atlasWidth, atlasHeight);
        fluidMaskWidth = atlasWidth;
        fluidMaskHeight = atlasHeight;
        ShipWaterPocketExternalWaterCull.applyPendingFluidMaskBuild(atlasTexId, atlasWidth, atlasHeight);
        boolean bl = needsRebuild = fluidMaskTexId == 0 || fluidMaskWidth != atlasWidth || fluidMaskHeight != atlasHeight || fluidMaskLastAtlasTexId != atlasTexId;
        if (!needsRebuild) {
            return fluidMaskTexId;
        }
        if (pendingFluidMaskFuture != null && pendingFluidMaskAtlasTexId == atlasTexId && pendingFluidMaskWidth == atlasWidth && pendingFluidMaskHeight == atlasHeight) {
            return fluidMaskTexId;
        }
        Function atlas = mc.method_1549(class_1723.field_21668);
        ArrayList<class_1058> sprites = new ArrayList<class_1058>();
        sprites.add((class_1058)atlas.apply(WATER_STILL));
        sprites.add((class_1058)atlas.apply(WATER_FLOW));
        sprites.add((class_1058)atlas.apply(WATER_OVERLAY));
        sprites.add((class_1058)atlas.apply(LAVA_STILL));
        sprites.add((class_1058)atlas.apply(LAVA_FLOW));
        HashSet<class_2960> textureIds = new HashSet<class_2960>();
        for (class_3611 regFluid : class_7923.field_41173) {
            try {
                class_3611 class_36112;
                if (regFluid instanceof class_3609) {
                    class_3609 flowing = (class_3609)regFluid;
                    class_36112 = flowing.method_15751();
                } else {
                    class_36112 = regFluid;
                }
                class_3611 fluid = class_36112;
                class_3610 fs = fluid.method_15785();
                class_2960[] forge = ShipWaterPocketExternalWaterCull.queryForgeFluidTextures(level, fluid, fs);
                if (forge != null) {
                    if (forge.length > 0 && forge[0] != null && textureIds.add(forge[0])) {
                        sprites.add((class_1058)atlas.apply(forge[0]));
                    }
                    if (forge.length > 1 && forge[1] != null && textureIds.add(forge[1])) {
                        sprites.add((class_1058)atlas.apply(forge[1]));
                    }
                    if (forge.length <= 2 || forge[2] == null || !textureIds.add(forge[2])) continue;
                    sprites.add((class_1058)atlas.apply(forge[2]));
                    continue;
                }
                class_1058[] fabric = ShipWaterPocketExternalWaterCull.queryFabricFluidSprites(level, fluid, fs);
                if (fabric == null) continue;
                for (class_1058 sprite : fabric) {
                    if (sprite == null) continue;
                    sprites.add(sprite);
                }
            }
            catch (Throwable fluid) {
            }
        }
        HashSet<class_2960> seenSprites = new HashSet<class_2960>();
        int[] rects = new int[sprites.size() * 4];
        int rectCount = 0;
        for (class_1058 sprite : sprites) {
            class_2960 name;
            if (sprite == null || !seenSprites.add(name = sprite.method_45851().method_45816())) continue;
            int x0 = sprite.method_35806();
            int y0 = sprite.method_35807();
            int w = sprite.method_45851().method_45807();
            int h = sprite.method_45851().method_45815();
            if (w <= 0 || h <= 0 || x0 < 0 || y0 < 0) continue;
            int x1 = Math.min(atlasWidth, x0 + w);
            int y1 = Math.min(atlasHeight, y0 + h);
            if (x1 <= x0 || y1 <= y0) continue;
            int base = rectCount * 4;
            rects[base] = x0;
            rects[base + 1] = y0;
            rects[base + 2] = x1;
            rects[base + 3] = y1;
            ++rectCount;
        }
        int buildWidth = atlasWidth;
        int buildHeight = atlasHeight;
        int[] rectPayload = Arrays.copyOf(rects, rectCount * 4);
        Supplier<byte[]> task = () -> ShipWaterPocketAsyncCull.paintFluidMask(buildWidth, buildHeight, rectPayload);
        CompletableFuture<byte[]> submitted = ShipPocketAsyncRuntime.trySubmitJava(ShipPocketAsyncSubsystem.CLIENT_CULL, task);
        if (submitted == null) {
            if (pendingFluidMaskFuture != null) {
                pendingFluidMaskFuture.cancel(true);
                pendingFluidMaskFuture = null;
            }
            ShipWaterPocketExternalWaterCull.applyFluidMaskBytes(task.get(), atlasWidth, atlasHeight, atlasTexId);
            return fluidMaskTexId;
        }
        if (pendingFluidMaskFuture != null) {
            pendingFluidMaskFuture.cancel(true);
        }
        pendingFluidMaskFuture = submitted;
        pendingFluidMaskAtlasTexId = atlasTexId;
        pendingFluidMaskWidth = atlasWidth;
        pendingFluidMaskHeight = atlasHeight;
        return fluidMaskTexId;
    }

    private static void applyPendingFluidMaskBuild(int atlasTexId, int atlasWidth, int atlasHeight) {
        byte[] bytes;
        if (pendingFluidMaskFuture == null || !pendingFluidMaskFuture.isDone()) {
            return;
        }
        if (pendingFluidMaskAtlasTexId != atlasTexId || pendingFluidMaskWidth != atlasWidth || pendingFluidMaskHeight != atlasHeight) {
            pendingFluidMaskFuture = null;
            return;
        }
        try {
            bytes = pendingFluidMaskFuture.join();
        }
        catch (Throwable ignored) {
            pendingFluidMaskFuture = null;
            return;
        }
        pendingFluidMaskFuture = null;
        ShipWaterPocketExternalWaterCull.applyFluidMaskBytes(bytes, atlasWidth, atlasHeight, atlasTexId);
    }

    private static void applyFluidMaskBytes(byte[] bytes, int atlasWidth, int atlasHeight, int atlasTexId) {
        int capacity = atlasWidth * atlasHeight;
        if (fluidMaskData == null || fluidMaskData.length != capacity) {
            fluidMaskData = new byte[capacity];
            fluidMaskBuffer = BufferUtils.createByteBuffer((int)capacity);
        }
        Arrays.fill(fluidMaskData, (byte)0);
        System.arraycopy(bytes, 0, fluidMaskData, 0, Math.min(bytes.length, fluidMaskData.length));
        fluidMaskBuffer.clear();
        fluidMaskBuffer.put(fluidMaskData);
        fluidMaskBuffer.flip();
        ShipWaterPocketExternalWaterCull.uploadByteTexture(fluidMaskTexId, atlasWidth, atlasHeight, fluidMaskBuffer);
        fluidMaskLastAtlasTexId = atlasTexId;
    }

    private static Method findMethod(Class<?> owner, String name, Class<?> ... params) {
        try {
            return owner.getMethod(name, params);
        }
        catch (NoSuchMethodException ignored) {}
        finally {
            return null;
        }
    }

    private static class_2960 invokeTexture(Object ext, Method noArgs, Method withState, class_3610 fluidState, class_638 level) throws Exception {
        Object v;
        if (noArgs != null && (v = noArgs.invoke(ext, new Object[0])) instanceof class_2960) {
            class_2960 rl = (class_2960)v;
            return rl;
        }
        if (withState != null && level != null && (v = withState.invoke(ext, fluidState, level, class_2338.field_10980)) instanceof class_2960) {
            class_2960 rl = (class_2960)v;
            return rl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int ensureIntTexture(int existingId, int width, int height) {
        int prevBinding = GL11.glGetInteger((int)32873);
        int prevUnpackAlignment = GL11.glGetInteger((int)3317);
        try {
            if (existingId != 0) {
                GlStateManager._bindTexture((int)existingId);
                int n = existingId;
                return n;
            }
            int id = TextureUtil.generateTextureId();
            GlStateManager._bindTexture((int)id);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glPixelStorei((int)3317, (int)1);
            GL11.glTexImage2D((int)3553, (int)0, (int)33334, (int)width, (int)height, (int)0, (int)36244, (int)5125, (IntBuffer)null);
            int n = id;
            return n;
        }
        finally {
            GL11.glPixelStorei((int)3317, (int)prevUnpackAlignment);
            GlStateManager._bindTexture((int)prevBinding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int ensureByteTexture(int existingId, int width, int height) {
        int prevBinding = GL11.glGetInteger((int)32873);
        int prevUnpackAlignment = GL11.glGetInteger((int)3317);
        try {
            if (existingId != 0) {
                GlStateManager._bindTexture((int)existingId);
                int n = existingId;
                return n;
            }
            int id = TextureUtil.generateTextureId();
            GlStateManager._bindTexture((int)id);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glPixelStorei((int)3317, (int)1);
            GL11.glTexImage2D((int)3553, (int)0, (int)33321, (int)width, (int)height, (int)0, (int)6403, (int)5121, (ByteBuffer)null);
            int n = id;
            return n;
        }
        finally {
            GL11.glPixelStorei((int)3317, (int)prevUnpackAlignment);
            GlStateManager._bindTexture((int)prevBinding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadByteTexture(int texId, int width, int height, ByteBuffer data) {
        int prevBinding = GL11.glGetInteger((int)32873);
        int prevUnpackAlignment = GL11.glGetInteger((int)3317);
        try {
            GlStateManager._bindTexture((int)texId);
            GL11.glPixelStorei((int)3317, (int)1);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)6403, (int)5121, (ByteBuffer)data);
        }
        finally {
            GL11.glPixelStorei((int)3317, (int)prevUnpackAlignment);
            GlStateManager._bindTexture((int)prevBinding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadIntTexture(int texId, int width, int height, IntBuffer data) {
        int prevBinding = GL11.glGetInteger((int)32873);
        int prevUnpackAlignment = GL11.glGetInteger((int)3317);
        try {
            GlStateManager._bindTexture((int)texId);
            GL11.glPixelStorei((int)3317, (int)1);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)36244, (int)5125, (IntBuffer)data);
        }
        finally {
            GL11.glPixelStorei((int)3317, (int)prevUnpackAlignment);
            GlStateManager._bindTexture((int)prevBinding);
        }
    }

    private static final class ShaderHandles {
        private class_5944 shader;
        private boolean supported;
        private class_284 cullEnabled;
        private class_284 isShipPass;
        private class_284 cameraWorldPos;
        private class_284 waterStillUv;
        private class_284 waterFlowUv;
        private class_284 waterOverlayUv;
        private class_284 shipWaterTintEnabled;
        private class_284 shipWaterTint;
        private final class_284[] shipAabbMin = new class_284[9];
        private final class_284[] shipAabbMax = new class_284[9];
        private final class_284[] cameraShipPos = new class_284[9];
        private final class_284[] gridMin = new class_284[9];
        private final class_284[] gridSize = new class_284[9];
        private final class_284[] worldToShip = new class_284[9];

        private ShaderHandles() {
        }
    }

    private static final class ShipMasks {
        private final long shipId;
        private long geometryRevision;
        private int minX;
        private int minY;
        private int minZ;
        private int sizeX;
        private int sizeY;
        private int sizeZ;
        private int maskTexId;
        private int maskTexHeight;
        private long lastMaskUploadRevision = Long.MIN_VALUE;
        private final Matrix4f worldToShip = new Matrix4f();
        private int[] maskData;
        private IntBuffer maskBuffer;
        private CompletableFuture<int[]> pendingMaskWordsFuture;
        private long pendingMaskBuildRevision = Long.MIN_VALUE;

        private ShipMasks(long shipId) {
            this.shipId = shipId;
        }

        private void close() {
            if (this.pendingMaskWordsFuture != null) {
                this.pendingMaskWordsFuture.cancel(true);
                this.pendingMaskWordsFuture = null;
            }
            if (this.maskTexId != 0) {
                TextureUtil.releaseTextureId((int)this.maskTexId);
                this.maskTexId = 0;
            }
        }
    }

    private static final class ProgramHandles {
        private final int programId;
        private boolean supported = false;
        private boolean embeddiumChunkProgram = false;
        private int regionOffsetLoc = -1;
        private int blockTexLoc = -1;
        private int cullEnabledLoc = -1;
        private int isShipPassLoc = -1;
        private int cameraWorldPosLoc = -1;
        private int waterStillUvLoc = -1;
        private int waterFlowUvLoc = -1;
        private int waterOverlayUvLoc = -1;
        private int fluidMaskLoc = -1;
        private int shipWaterTintEnabledLoc = -1;
        private int shipWaterTintLoc = -1;
        private int chunkWorldOriginLoc = -1;
        private int maxMaskSlots = 9;
        private int maxSafeTextureUnits = 12;
        private final int[] shipAabbMinLoc = new int[9];
        private final int[] shipAabbMaxLoc = new int[9];
        private final int[] cameraShipPosLoc = new int[9];
        private final int[] gridMinLoc = new int[9];
        private final int[] gridSizeLoc = new int[9];
        private final int[] worldToShipLoc = new int[9];
        private final int[] maskLoc = new int[9];
        private final boolean[] shipSlotSupported = new boolean[9];

        private ProgramHandles(int programId) {
            this.programId = programId;
        }
    }
}

