/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.client.feature.ship_water_pockets;

import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.class_1921;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4696;
import net.minecraft.class_638;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class ShipWaterPocketExternalWaterCullRenderContext {
    private static int worldFluidDepth = 0;
    private static int shipRenderDepth = 0;
    @Nullable
    private static class_638 level = null;
    private static double camX;
    private static double camY;
    private static double camZ;
    private static boolean fluidChunkLayersInitialized;
    private static final HashSet<class_1921> FLUID_CHUNK_LAYERS;
    private static final int MAX_WORLD_STACK_DEPTH = 8;
    @Nullable
    private static final class_638[] LEVEL_STACK;
    private static final double[] CAM_X_STACK;
    private static final double[] CAM_Y_STACK;
    private static final double[] CAM_Z_STACK;

    private ShipWaterPocketExternalWaterCullRenderContext() {
    }

    private static void ensureFluidChunkLayersInitialized() {
        if (fluidChunkLayersInitialized) {
            return;
        }
        fluidChunkLayersInitialized = true;
        FLUID_CHUNK_LAYERS.clear();
        try {
            for (class_3611 fluid : class_7923.field_41173) {
                if (fluid == null) continue;
                if (fluid instanceof class_3609) {
                    class_3609 flowing = (class_3609)fluid;
                    ShipWaterPocketExternalWaterCullRenderContext.addFluidChunkLayer(flowing.method_15751().method_15785());
                    ShipWaterPocketExternalWaterCullRenderContext.addFluidChunkLayer(flowing.method_15750().method_15785());
                    continue;
                }
                ShipWaterPocketExternalWaterCullRenderContext.addFluidChunkLayer(fluid.method_15785());
            }
        }
        catch (Throwable ignored) {
            FLUID_CHUNK_LAYERS.add(class_1921.method_23583());
        }
    }

    private static void addFluidChunkLayer(class_3610 state) {
        if (state == null || state.method_15769()) {
            return;
        }
        class_1921 layer = class_4696.method_23680((class_3610)state);
        if (layer != null) {
            FLUID_CHUNK_LAYERS.add(layer);
        }
    }

    public static boolean isFluidChunkLayer(class_1921 renderType) {
        if (renderType == null) {
            return false;
        }
        ShipWaterPocketExternalWaterCullRenderContext.ensureFluidChunkLayersInitialized();
        return FLUID_CHUNK_LAYERS.contains(renderType);
    }

    public static void beginWorldFluidChunkLayer(class_638 level, class_1921 renderType, double camX, double camY, double camZ) {
        if (level == null) {
            return;
        }
        if (!ShipWaterPocketExternalWaterCullRenderContext.isFluidChunkLayer(renderType)) {
            return;
        }
        if (worldFluidDepth < 8) {
            int idx = worldFluidDepth;
            ShipWaterPocketExternalWaterCullRenderContext.LEVEL_STACK[idx] = ShipWaterPocketExternalWaterCullRenderContext.level;
            ShipWaterPocketExternalWaterCullRenderContext.CAM_X_STACK[idx] = ShipWaterPocketExternalWaterCullRenderContext.camX;
            ShipWaterPocketExternalWaterCullRenderContext.CAM_Y_STACK[idx] = ShipWaterPocketExternalWaterCullRenderContext.camY;
            ShipWaterPocketExternalWaterCullRenderContext.CAM_Z_STACK[idx] = ShipWaterPocketExternalWaterCullRenderContext.camZ;
        }
        ++worldFluidDepth;
        ShipWaterPocketExternalWaterCullRenderContext.level = level;
        ShipWaterPocketExternalWaterCullRenderContext.camX = camX;
        ShipWaterPocketExternalWaterCullRenderContext.camY = camY;
        ShipWaterPocketExternalWaterCullRenderContext.camZ = camZ;
    }

    public static void endWorldFluidChunkLayer() {
        if (--worldFluidDepth <= 0) {
            worldFluidDepth = 0;
            level = null;
            camX = 0.0;
            camY = 0.0;
            camZ = 0.0;
            return;
        }
        int idx = worldFluidDepth;
        if (idx >= 0 && idx < 8) {
            level = LEVEL_STACK[idx];
            camX = CAM_X_STACK[idx];
            camY = CAM_Y_STACK[idx];
            camZ = CAM_Z_STACK[idx];
            ShipWaterPocketExternalWaterCullRenderContext.LEVEL_STACK[idx] = null;
        }
    }

    public static void beginShipRender() {
        ++shipRenderDepth;
    }

    public static void endShipRender() {
        if (--shipRenderDepth < 0) {
            shipRenderDepth = 0;
        }
    }

    public static void clear() {
        worldFluidDepth = 0;
        level = null;
        camX = 0.0;
        camY = 0.0;
        camZ = 0.0;
        Arrays.fill(LEVEL_STACK, null);
        shipRenderDepth = 0;
        fluidChunkLayersInitialized = false;
        FLUID_CHUNK_LAYERS.clear();
    }

    public static boolean isInWorldFluidChunkLayer() {
        return worldFluidDepth > 0;
    }

    public static boolean isInShipRender() {
        return shipRenderDepth > 0;
    }

    @Nullable
    public static class_638 getLevel() {
        return level;
    }

    public static double getCamX() {
        return camX;
    }

    public static double getCamY() {
        return camY;
    }

    public static double getCamZ() {
        return camZ;
    }

    static {
        fluidChunkLayersInitialized = false;
        FLUID_CHUNK_LAYERS = new HashSet();
        LEVEL_STACK = new class_638[8];
        CAM_X_STACK = new double[8];
        CAM_Y_STACK = new double[8];
        CAM_Z_STACK = new double[8];
    }
}

