/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.feature.ship_water_pockets;

import java.util.Arrays;
import java.util.BitSet;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J?\u0010\u000b\u001a\u00020\n2\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\u0010\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipWaterPocketAsyncCull;", "", "", "Lnet/minecraft/class_265;", "shapes", "", "sizeX", "sizeY", "sizeZ", "sub", "", "buildOccMaskWords", "([Lnet/minecraft/class_265;IIII)[I", "Ljava/util/BitSet;", "interior", "volume", "buildAirMaskWords", "(Ljava/util/BitSet;I)[I", "width", "height", "rects", "", "paintFluidMask", "(II[I)[B", "<init>", "()V", "valkyrien-air"})
public final class ShipWaterPocketAsyncCull {
    @NotNull
    public static final ShipWaterPocketAsyncCull INSTANCE = new ShipWaterPocketAsyncCull();

    private ShipWaterPocketAsyncCull() {
    }

    @JvmStatic
    @NotNull
    public static final int[] buildOccMaskWords(@NotNull class_265[] shapes, int sizeX, int sizeY, int sizeZ, int sub) {
        Intrinsics.checkNotNullParameter((Object)shapes, (String)"shapes");
        if (sizeX <= 0 || sizeY <= 0 || sizeZ <= 0 || sub <= 0) {
            return new int[0];
        }
        int subCount = sub * sub * sub;
        int occWordsPerVoxel = subCount >>> 5;
        int volume = sizeX * sizeY * sizeZ;
        int[] words = new int[volume * occWordsPerVoxel];
        for (int lz = 0; lz < sizeZ; ++lz) {
            for (int ly = 0; ly < sizeY; ++ly) {
                for (int lx = 0; lx < sizeX; ++lx) {
                    class_265 shape;
                    int voxelIdx = lx + sizeX * (ly + sizeY * lz);
                    if ((class_265)ArraysKt.getOrNull((Object[])shapes, (int)voxelIdx) == null || shape.method_1110()) continue;
                    int wordBase = voxelIdx * occWordsPerVoxel;
                    for (class_238 box : shape.method_1090()) {
                        int x0 = class_3532.method_15340((int)class_3532.method_15357((double)(box.field_1323 * (double)sub)), (int)0, (int)sub);
                        int x1 = class_3532.method_15340((int)class_3532.method_15384((double)(box.field_1320 * (double)sub)), (int)0, (int)sub);
                        int y0 = class_3532.method_15340((int)class_3532.method_15357((double)(box.field_1322 * (double)sub)), (int)0, (int)sub);
                        int y1 = class_3532.method_15340((int)class_3532.method_15384((double)(box.field_1325 * (double)sub)), (int)0, (int)sub);
                        int z0 = class_3532.method_15340((int)class_3532.method_15357((double)(box.field_1321 * (double)sub)), (int)0, (int)sub);
                        int z1 = class_3532.method_15340((int)class_3532.method_15384((double)(box.field_1324 * (double)sub)), (int)0, (int)sub);
                        for (int sz = z0; sz < z1; ++sz) {
                            for (int sy = y0; sy < y1; ++sy) {
                                for (int sx = x0; sx < x1; ++sx) {
                                    int subIdx = sx + sub * (sy + sub * sz);
                                    int wordIdx = wordBase + (subIdx >>> 5);
                                    int bit = subIdx & 0x1F;
                                    words[wordIdx] = words[wordIdx] | 1 << bit;
                                }
                            }
                        }
                    }
                }
            }
        }
        return words;
    }

    @JvmStatic
    @NotNull
    public static final int[] buildAirMaskWords(@Nullable BitSet interior, int volume) {
        if (volume <= 0) {
            return new int[0];
        }
        int[] words = new int[volume + 31 >>> 5];
        if (interior == null || interior.isEmpty()) {
            return words;
        }
        int idx = interior.nextSetBit(0);
        while (idx >= 0 && idx < volume) {
            int wordIdx = idx >>> 5;
            int bit = idx & 0x1F;
            words[wordIdx] = words[wordIdx] | 1 << bit;
            idx = interior.nextSetBit(idx + 1);
        }
        return words;
    }

    @JvmStatic
    @NotNull
    public static final byte[] paintFluidMask(int width, int height, @NotNull int[] rects) {
        Intrinsics.checkNotNullParameter((Object)rects, (String)"rects");
        if (width <= 0 || height <= 0) {
            return new byte[0];
        }
        byte[] out = new byte[width * height];
        if (rects.length == 0) {
            return out;
        }
        int i = 0;
        while (i + 3 < rects.length) {
            int x0 = rects[i];
            int y0 = rects[i + 1];
            int x1 = rects[i + 2];
            int y1 = rects[i + 3];
            i += 4;
            if (x1 <= x0 || y1 <= y0) continue;
            int clampedX0 = RangesKt.coerceIn((int)x0, (int)0, (int)width);
            int clampedX1 = RangesKt.coerceIn((int)x1, (int)0, (int)width);
            int clampedY0 = RangesKt.coerceIn((int)y0, (int)0, (int)height);
            int clampedY1 = RangesKt.coerceIn((int)y1, (int)0, (int)height);
            if (clampedX1 <= clampedX0 || clampedY1 <= clampedY0) continue;
            for (int y = clampedY0; y < clampedY1; ++y) {
                int rowBase = y * width;
                Arrays.fill(out, rowBase + clampedX0, rowBase + clampedX1, (byte)-1);
            }
        }
        return out;
    }
}

