/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.feature.ship_water_pockets;

import java.util.BitSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketGraphKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0017\n\u0002\b\t\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001aY\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001aQ\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"", "v", "", "condU16", "(S)I", "Ljava/util/BitSet;", "open", "simulationDomain", "sizeX", "sizeY", "sizeZ", "", "faceCondXP", "faceCondYP", "faceCondZP", "passCondThreshold", "computeOutsideVoidFromGeometry", "(Ljava/util/BitSet;Ljava/util/BitSet;III[S[S[SI)Ljava/util/BitSet;", "computeEnclosedHeuristicFromGeometry", "(Ljava/util/BitSet;III[S[S[SI)Ljava/util/BitSet;", "valkyrien-air"})
public final class ShipWaterPocketDomainKt {
    private static final int condU16(short v) {
        return v & 0xFFFF;
    }

    @NotNull
    public static final BitSet computeOutsideVoidFromGeometry(@NotNull BitSet open, @NotNull BitSet simulationDomain, int sizeX, int sizeY, int sizeZ, @NotNull short[] faceCondXP, @NotNull short[] faceCondYP, @NotNull short[] faceCondZP, int passCondThreshold) {
        Intrinsics.checkNotNullParameter((Object)open, (String)"open");
        Intrinsics.checkNotNullParameter((Object)simulationDomain, (String)"simulationDomain");
        Intrinsics.checkNotNullParameter((Object)faceCondXP, (String)"faceCondXP");
        Intrinsics.checkNotNullParameter((Object)faceCondYP, (String)"faceCondYP");
        Intrinsics.checkNotNullParameter((Object)faceCondZP, (String)"faceCondZP");
        long volumeLong = (long)sizeX * (long)sizeY * (long)sizeZ;
        if (volumeLong <= 0L) {
            return new BitSet();
        }
        int volume = (int)volumeLong;
        Object object = open.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.BitSet");
        BitSet outsideCandidates = (BitSet)object;
        outsideCandidates.andNot(simulationDomain);
        if (outsideCandidates.isEmpty()) {
            return new BitSet(volume);
        }
        BitSet visited = new BitSet(volume);
        int[] queue = new int[volume];
        int head = 0;
        Ref.IntRef tail = new Ref.IntRef();
        int strideY = sizeX;
        int strideZ = sizeX * sizeY;
        ShipWaterPocketGraphKt.forEachBoundaryIndexGraph(sizeX, sizeY, sizeZ, (Function1<? super Integer, Unit>)((Function1)arg_0 -> ShipWaterPocketDomainKt.computeOutsideVoidFromGeometry$lambda$0(volume, outsideCandidates, visited, queue, tail, arg_0)));
        while (head < tail.element) {
            int cur = queue[head++];
            int lx = cur % sizeX;
            int t = cur / sizeX;
            int ly = t % sizeY;
            int lz = t / sizeY;
            if (lx > 0) {
                ShipWaterPocketDomainKt.computeOutsideVoidFromGeometry$trySpread(volume, outsideCandidates, visited, passCondThreshold, queue, tail, faceCondXP, sizeX, faceCondYP, strideY, sizeY, faceCondZP, strideZ, sizeZ, cur, lx, ly, lz, cur - 1, 0);
            }
            if (lx + 1 < sizeX) {
                ShipWaterPocketDomainKt.computeOutsideVoidFromGeometry$trySpread(volume, outsideCandidates, visited, passCondThreshold, queue, tail, faceCondXP, sizeX, faceCondYP, strideY, sizeY, faceCondZP, strideZ, sizeZ, cur, lx, ly, lz, cur + 1, 1);
            }
            if (ly > 0) {
                ShipWaterPocketDomainKt.computeOutsideVoidFromGeometry$trySpread(volume, outsideCandidates, visited, passCondThreshold, queue, tail, faceCondXP, sizeX, faceCondYP, strideY, sizeY, faceCondZP, strideZ, sizeZ, cur, lx, ly, lz, cur - strideY, 2);
            }
            if (ly + 1 < sizeY) {
                ShipWaterPocketDomainKt.computeOutsideVoidFromGeometry$trySpread(volume, outsideCandidates, visited, passCondThreshold, queue, tail, faceCondXP, sizeX, faceCondYP, strideY, sizeY, faceCondZP, strideZ, sizeZ, cur, lx, ly, lz, cur + strideY, 3);
            }
            if (lz > 0) {
                ShipWaterPocketDomainKt.computeOutsideVoidFromGeometry$trySpread(volume, outsideCandidates, visited, passCondThreshold, queue, tail, faceCondXP, sizeX, faceCondYP, strideY, sizeY, faceCondZP, strideZ, sizeZ, cur, lx, ly, lz, cur - strideZ, 4);
            }
            if (lz + 1 >= sizeZ) continue;
            ShipWaterPocketDomainKt.computeOutsideVoidFromGeometry$trySpread(volume, outsideCandidates, visited, passCondThreshold, queue, tail, faceCondXP, sizeX, faceCondYP, strideY, sizeY, faceCondZP, strideZ, sizeZ, cur, lx, ly, lz, cur + strideZ, 5);
        }
        return visited;
    }

    public static /* synthetic */ BitSet computeOutsideVoidFromGeometry$default(BitSet bitSet, BitSet bitSet2, int n, int n2, int n3, short[] sArray, short[] sArray2, short[] sArray3, int n4, int n5, Object object) {
        if ((n5 & 0x100) != 0) {
            n4 = 4;
        }
        return ShipWaterPocketDomainKt.computeOutsideVoidFromGeometry(bitSet, bitSet2, n, n2, n3, sArray, sArray2, sArray3, n4);
    }

    @NotNull
    public static final BitSet computeEnclosedHeuristicFromGeometry(@NotNull BitSet open, int sizeX, int sizeY, int sizeZ, @NotNull short[] faceCondXP, @NotNull short[] faceCondYP, @NotNull short[] faceCondZP, int passCondThreshold) {
        int cond;
        int idx;
        boolean seenWall;
        int x;
        int z;
        Intrinsics.checkNotNullParameter((Object)open, (String)"open");
        Intrinsics.checkNotNullParameter((Object)faceCondXP, (String)"faceCondXP");
        Intrinsics.checkNotNullParameter((Object)faceCondYP, (String)"faceCondYP");
        Intrinsics.checkNotNullParameter((Object)faceCondZP, (String)"faceCondZP");
        long volumeLong = (long)sizeX * (long)sizeY * (long)sizeZ;
        if (volumeLong <= 0L) {
            return new BitSet();
        }
        int volume = (int)volumeLong;
        if (open.isEmpty()) {
            return new BitSet(volume);
        }
        int strideY = sizeX;
        int strideZ = sizeX * sizeY;
        BitSet negX = new BitSet(volume);
        BitSet posX = new BitSet(volume);
        BitSet negY = new BitSet(volume);
        BitSet posY = new BitSet(volume);
        BitSet negZ = new BitSet(volume);
        BitSet posZ = new BitSet(volume);
        for (z = 0; z < sizeZ; ++z) {
            for (int y = 0; y < sizeY; ++y) {
                int cond2;
                int idx2;
                int x2;
                int base = sizeX * (y + sizeY * z);
                boolean seenWall2 = false;
                for (x2 = 0; x2 < sizeX; ++x2) {
                    idx2 = base + x2;
                    if (!open.get(idx2)) {
                        seenWall2 = true;
                        continue;
                    }
                    if (x2 > 0 && open.get(idx2 - 1) && (cond2 = ShipWaterPocketDomainKt.condU16(faceCondXP[idx2 - 1])) < passCondThreshold) {
                        seenWall2 = true;
                    }
                    if (!seenWall2) continue;
                    negX.set(idx2);
                }
                seenWall2 = false;
                for (x2 = sizeX - 1; -1 < x2; --x2) {
                    idx2 = base + x2;
                    if (!open.get(idx2)) {
                        seenWall2 = true;
                        continue;
                    }
                    if (x2 + 1 < sizeX && open.get(idx2 + 1) && (cond2 = ShipWaterPocketDomainKt.condU16(faceCondXP[idx2])) < passCondThreshold) {
                        seenWall2 = true;
                    }
                    if (!seenWall2) continue;
                    posX.set(idx2);
                }
            }
        }
        for (z = 0; z < sizeZ; ++z) {
            for (x = 0; x < sizeX; ++x) {
                int y;
                seenWall = false;
                idx = x + strideZ * z;
                for (y = 0; y < sizeY; ++y) {
                    if (!open.get(idx)) {
                        seenWall = true;
                    } else {
                        if (y > 0 && open.get(idx - strideY) && (cond = ShipWaterPocketDomainKt.condU16(faceCondYP[idx - strideY])) < passCondThreshold) {
                            seenWall = true;
                        }
                        if (seenWall) {
                            negY.set(idx);
                        }
                    }
                    idx += strideY;
                }
                seenWall = false;
                idx = x + strideZ * z + strideY * (sizeY - 1);
                for (y = sizeY - 1; -1 < y; --y) {
                    if (!open.get(idx)) {
                        seenWall = true;
                    } else {
                        if (y + 1 < sizeY && open.get(idx + strideY) && (cond = ShipWaterPocketDomainKt.condU16(faceCondYP[idx])) < passCondThreshold) {
                            seenWall = true;
                        }
                        if (seenWall) {
                            posY.set(idx);
                        }
                    }
                    idx -= strideY;
                }
            }
        }
        for (int y = 0; y < sizeY; ++y) {
            for (x = 0; x < sizeX; ++x) {
                int z2;
                seenWall = false;
                idx = x + strideY * y;
                for (z2 = 0; z2 < sizeZ; ++z2) {
                    if (!open.get(idx)) {
                        seenWall = true;
                    } else {
                        if (z2 > 0 && open.get(idx - strideZ) && (cond = ShipWaterPocketDomainKt.condU16(faceCondZP[idx - strideZ])) < passCondThreshold) {
                            seenWall = true;
                        }
                        if (seenWall) {
                            negZ.set(idx);
                        }
                    }
                    idx += strideZ;
                }
                seenWall = false;
                idx = x + strideY * y + strideZ * (sizeZ - 1);
                for (z2 = sizeZ - 1; -1 < z2; --z2) {
                    if (!open.get(idx)) {
                        seenWall = true;
                    } else {
                        if (z2 + 1 < sizeZ && open.get(idx + strideZ) && (cond = ShipWaterPocketDomainKt.condU16(faceCondZP[idx])) < passCondThreshold) {
                            seenWall = true;
                        }
                        if (seenWall) {
                            posZ.set(idx);
                        }
                    }
                    idx -= strideZ;
                }
            }
        }
        BitSet enclosed = new BitSet(volume);
        int idx3 = open.nextSetBit(0);
        while (idx3 >= 0 && idx3 < volume) {
            int lx = idx3 % sizeX;
            int t = idx3 / sizeX;
            int ly = t % sizeY;
            int lz = t / sizeY;
            if (lx == 0 || lx + 1 == sizeX || ly == 0 || ly + 1 == sizeY || lz == 0 || lz + 1 == sizeZ) {
                idx3 = open.nextSetBit(idx3 + 1);
                continue;
            }
            int blockedDirs = 0;
            boolean bnx = negX.get(idx3);
            boolean bpx = posX.get(idx3);
            boolean bny = negY.get(idx3);
            boolean bpy = posY.get(idx3);
            boolean bnz = negZ.get(idx3);
            boolean bpz = posZ.get(idx3);
            if (bnx) {
                ++blockedDirs;
            }
            if (bpx) {
                ++blockedDirs;
            }
            if (bny) {
                ++blockedDirs;
            }
            if (bpy) {
                ++blockedDirs;
            }
            if (bnz) {
                ++blockedDirs;
            }
            if (bpz) {
                ++blockedDirs;
            }
            int axisPairs = 0;
            if (bnx && bpx) {
                ++axisPairs;
            }
            if (bny && bpy) {
                ++axisPairs;
            }
            if (bnz && bpz) {
                ++axisPairs;
            }
            if (blockedDirs >= 4 && axisPairs >= 2) {
                enclosed.set(idx3);
            }
            idx3 = open.nextSetBit(idx3 + 1);
        }
        return enclosed;
    }

    public static /* synthetic */ BitSet computeEnclosedHeuristicFromGeometry$default(BitSet bitSet, int n, int n2, int n3, short[] sArray, short[] sArray2, short[] sArray3, int n4, int n5, Object object) {
        if ((n5 & 0x80) != 0) {
            n4 = 4;
        }
        return ShipWaterPocketDomainKt.computeEnclosedHeuristicFromGeometry(bitSet, n, n2, n3, sArray, sArray2, sArray3, n4);
    }

    private static final int computeOutsideVoidFromGeometry$edgeCond(short[] $faceCondXP, int $sizeX, short[] $faceCondYP, int strideY, int $sizeY, short[] $faceCondZP, int strideZ, int $sizeZ, int idxCur, int lx, int ly, int lz, int dirCode) {
        return switch (dirCode) {
            case 0 -> {
                if (lx > 0) {
                    yield ShipWaterPocketDomainKt.condU16($faceCondXP[idxCur - 1]);
                }
                yield 0;
            }
            case 1 -> {
                if (lx + 1 < $sizeX) {
                    yield ShipWaterPocketDomainKt.condU16($faceCondXP[idxCur]);
                }
                yield 0;
            }
            case 2 -> {
                if (ly > 0) {
                    yield ShipWaterPocketDomainKt.condU16($faceCondYP[idxCur - strideY]);
                }
                yield 0;
            }
            case 3 -> {
                if (ly + 1 < $sizeY) {
                    yield ShipWaterPocketDomainKt.condU16($faceCondYP[idxCur]);
                }
                yield 0;
            }
            case 4 -> {
                if (lz > 0) {
                    yield ShipWaterPocketDomainKt.condU16($faceCondZP[idxCur - strideZ]);
                }
                yield 0;
            }
            default -> lz + 1 < $sizeZ ? ShipWaterPocketDomainKt.condU16($faceCondZP[idxCur]) : 0;
        };
    }

    private static final void computeOutsideVoidFromGeometry$tryEnqueue(int volume, BitSet outsideCandidates, BitSet visited, int[] queue, Ref.IntRef tail, int i) {
        if (i < 0 || i >= volume) {
            return;
        }
        if (!outsideCandidates.get(i) || visited.get(i)) {
            return;
        }
        visited.set(i);
        int n = tail.element;
        tail.element = n + 1;
        queue[n] = i;
    }

    private static final Unit computeOutsideVoidFromGeometry$lambda$0(int $volume, BitSet $outsideCandidates, BitSet $visited, int[] $queue, Ref.IntRef $tail, int boundaryIdx) {
        Intrinsics.checkNotNullParameter((Object)$outsideCandidates, (String)"$outsideCandidates");
        Intrinsics.checkNotNullParameter((Object)$visited, (String)"$visited");
        Intrinsics.checkNotNullParameter((Object)$queue, (String)"$queue");
        Intrinsics.checkNotNullParameter((Object)$tail, (String)"$tail");
        ShipWaterPocketDomainKt.computeOutsideVoidFromGeometry$tryEnqueue($volume, $outsideCandidates, $visited, $queue, $tail, boundaryIdx);
        return Unit.INSTANCE;
    }

    private static final void computeOutsideVoidFromGeometry$trySpread(int volume, BitSet outsideCandidates, BitSet visited, int $passCondThreshold, int[] queue, Ref.IntRef tail, short[] $faceCondXP, int $sizeX, short[] $faceCondYP, int strideY, int $sizeY, short[] $faceCondZP, int strideZ, int $sizeZ, int cur, int lx, int ly, int lz, int n, int dirCode) {
        if (n < 0 || n >= volume) {
            return;
        }
        if (!outsideCandidates.get(n) || visited.get(n)) {
            return;
        }
        int cond = ShipWaterPocketDomainKt.computeOutsideVoidFromGeometry$edgeCond($faceCondXP, $sizeX, $faceCondYP, strideY, $sizeY, $faceCondZP, strideZ, $sizeZ, cur, lx, ly, lz, dirCode);
        if (cond >= $passCondThreshold) {
            visited.set(n);
            int n2 = tail.element;
            tail.element = n2 + 1;
            queue[n2] = n;
        }
    }
}

