/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.feature.ship_water_pockets;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.PointVoidClass;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.PointVoidClassification;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShapeCellTemplate;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipPocketState;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketGeometryKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\u001a/\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001f\u0010\f\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\f\u0010\u000b\u001a\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u001f\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0010H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a'\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a?\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001aC\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00022\b\b\u0002\u0010\u001d\u001a\u00020\r2\b\b\u0002\u0010\u001e\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b\u001f\u0010 \u001a;\u0010%\u001a\u00020\u00102\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0004\b%\u0010&\u001a;\u0010'\u001a\u00020\u00102\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0004\b'\u0010&\u001a7\u0010)\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!2\u0006\u0010(\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b)\u0010*\u001a\u001f\u0010-\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010,\u001a\u00020+H\u0000\u00a2\u0006\u0004\b-\u0010.\u001a\u001f\u0010/\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010,\u001a\u00020+H\u0000\u00a2\u0006\u0004\b/\u0010.\u001a\u001f\u00100\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010,\u001a\u00020+H\u0000\u00a2\u0006\u0004\b0\u0010.\u001a\u001f\u00101\u001a\u00020\t2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010,\u001a\u00020+H\u0000\u00a2\u0006\u0004\b1\u0010.\"\u0014\u00102\u001a\u00020!8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b2\u00103\u00a8\u00064"}, d2={"Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;", "state", "", "lx", "ly", "lz", "indexOf", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;III)I", "idx", "", "isBoundaryShellIndex", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;I)Z", "shouldPreventExteriorWaterlogging", "", "simulationComponentMaskAt", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;I)J", "Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/PointVoidClassification;", "classification", "isClassificationInSimulationDomain", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/PointVoidClassification;)Z", "Lnet/minecraft/class_2338$class_2339;", "out", "posFromIndex", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;ILnet/minecraft/class_2338$class_2339;)Lnet/minecraft/class_2338$class_2339;", "dirCode", "edgeConductance", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;IIIII)I", "idxA", "idxB", "componentMaskA", "componentMaskB", "computeFilteredFaceConductance", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;IIIJJ)I", "", "x", "y", "z", "classifyShipPoint", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;DDDLnet/minecraft/class_2338$class_2339;)Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/PointVoidClassification;", "classifyShipPointWithEpsilon", "tmp", "isOpenAtShipPoint", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;DDDLnet/minecraft/class_2338$class_2339;)Z", "Lnet/minecraft/class_2338;", "shipPos", "isInterior", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;Lnet/minecraft/class_2338;)Z", "isOpen", "isAirPocket", "isWorldFluidSuppressionCell", "POINT_CLASSIFY_EPS", "D", "valkyrien-air"})
public final class ShipWaterPocketStateAccessKt {
    private static final double POINT_CLASSIFY_EPS = 1.0E-5;

    public static final int indexOf(@NotNull ShipPocketState state, int lx, int ly, int lz) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return lx + state.getSizeX() * (ly + state.getSizeY() * lz);
    }

    public static final boolean isBoundaryShellIndex(@NotNull ShipPocketState state, int idx) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int volume = state.getSizeX() * state.getSizeY() * state.getSizeZ();
        if (!(0 <= idx ? idx < volume : false)) {
            return false;
        }
        int sx = state.getSizeX();
        int sy = state.getSizeY();
        int lx = idx % sx;
        int t = idx / sx;
        int ly = t % sy;
        int lz = t / sy;
        return lx == 0 || lx + 1 == state.getSizeX() || ly == 0 || ly + 1 == state.getSizeY() || lz == 0 || lz + 1 == state.getSizeZ();
    }

    public static final boolean shouldPreventExteriorWaterlogging(@NotNull ShipPocketState state, int idx) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int volume = state.getSizeX() * state.getSizeY() * state.getSizeZ();
        if (!(0 <= idx ? idx < volume : false)) {
            return false;
        }
        if (!state.getOpen().get(idx)) {
            return false;
        }
        return !state.getSimulationDomain().get(idx);
    }

    public static final long simulationComponentMaskAt(@NotNull ShipPocketState state, int idx) {
        long direct;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (idx < 0) {
            return 0L;
        }
        if (idx < state.getVoxelSimulationComponentMask().length && (direct = state.getVoxelSimulationComponentMask()[idx]) != 0L) {
            return direct;
        }
        int volume = state.getSizeX() * state.getSizeY() * state.getSizeZ();
        if (!(0 <= idx ? idx < volume : false)) {
            return 0L;
        }
        if (!state.getSimulationDomain().get(idx)) {
            return 0L;
        }
        int[] templateIndices = state.getTemplateIndexByVoxel();
        List<ShapeCellTemplate> templates = state.getShapeTemplatePalette();
        if (templateIndices.length == volume && !((Collection)templates).isEmpty()) {
            int templateIdx = templateIndices[idx];
            boolean bl = 0 <= templateIdx ? templateIdx < ((Collection)templates).size() : false;
            if (bl) {
                return ShipWaterPocketGeometryKt.fullComponentMask(templates.get(templateIdx).getComponentCount());
            }
        }
        return -1L;
    }

    public static final boolean isClassificationInSimulationDomain(@NotNull ShipPocketState state, @NotNull PointVoidClassification classification) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)classification, (String)"classification");
        int idx = classification.getVoxelIndex();
        if (idx < 0) {
            return false;
        }
        if (!state.getOpen().get(idx)) {
            return false;
        }
        if (classification.getLocalComponent() >= 0) {
            long simMask = ShipWaterPocketStateAccessKt.simulationComponentMaskAt(state, idx);
            return (simMask >>> classification.getLocalComponent() & 1L) != 0L;
        }
        return state.getSimulationDomain().get(idx);
    }

    @NotNull
    public static final class_2338.class_2339 posFromIndex(@NotNull ShipPocketState state, int idx, @NotNull class_2338.class_2339 out) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int sx = state.getSizeX();
        int sy = state.getSizeY();
        int lx = idx % sx;
        int t = idx / sx;
        int ly = t % sy;
        int lz = t / sy;
        class_2338.class_2339 class_23392 = out.method_10103(state.getMinX() + lx, state.getMinY() + ly, state.getMinZ() + lz);
        Intrinsics.checkNotNullExpressionValue((Object)class_23392, (String)"set(...)");
        return class_23392;
    }

    public static final int edgeConductance(@NotNull ShipPocketState state, int idx, int lx, int ly, int lz, int dirCode) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state.getFaceCondXP().length == 0 || state.getFaceCondYP().length == 0 || state.getFaceCondZP().length == 0) {
            return 1;
        }
        int sizeX = state.getSizeX();
        int sizeY = state.getSizeY();
        return switch (dirCode) {
            case 0 -> {
                if (lx > 0) {
                    yield state.getFaceCondXP()[idx - 1] & 0xFFFF;
                }
                yield 0;
            }
            case 1 -> {
                if (lx + 1 < sizeX) {
                    yield state.getFaceCondXP()[idx] & 0xFFFF;
                }
                yield 0;
            }
            case 2 -> {
                if (ly > 0) {
                    yield state.getFaceCondYP()[idx - sizeX] & 0xFFFF;
                }
                yield 0;
            }
            case 3 -> {
                if (ly + 1 < sizeY) {
                    yield state.getFaceCondYP()[idx] & 0xFFFF;
                }
                yield 0;
            }
            case 4 -> {
                if (lz > 0) {
                    yield state.getFaceCondZP()[idx - sizeX * sizeY] & 0xFFFF;
                }
                yield 0;
            }
            default -> lz + 1 < state.getSizeZ() ? state.getFaceCondZP()[idx] & 0xFFFF : 0;
        };
    }

    public static final int computeFilteredFaceConductance(@NotNull ShipPocketState state, int idxA, int idxB, int dirCode, long componentMaskA, long componentMaskB) {
        int volume;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                volume = state.getSizeX() * state.getSizeY() * state.getSizeZ();
                boolean bl = 0 <= idxA ? idxA < volume : false;
                if (!bl) break block8;
                if (0 <= idxB ? idxB < volume : false) break block9;
            }
            return 0;
        }
        if (!state.getOpen().get(idxA) || !state.getOpen().get(idxB)) {
            return 0;
        }
        int[] templateIndices = state.getTemplateIndexByVoxel();
        List<ShapeCellTemplate> templates = state.getShapeTemplatePalette();
        if (templateIndices.length == volume && !((Collection)templates).isEmpty()) {
            int templateIdxA = templateIndices[idxA];
            int templateIdxB = templateIndices[idxB];
            boolean bl = 0 <= templateIdxA ? templateIdxA < ((Collection)templates).size() : false;
            if (bl) {
                boolean bl2 = 0 <= templateIdxB ? templateIdxB < ((Collection)templates).size() : false;
                if (bl2) {
                    return ShipWaterPocketGeometryKt.computeTemplateFaceConductance(templates.get(templateIdxA), templates.get(templateIdxB), dirCode, componentMaskA, componentMaskB);
                }
            }
        }
        if (componentMaskA == 0L || componentMaskB == 0L) {
            return 0;
        }
        int lx = idxA % state.getSizeX();
        int t = idxA / state.getSizeX();
        int ly = t % state.getSizeY();
        int lz = t / state.getSizeY();
        return ShipWaterPocketStateAccessKt.edgeConductance(state, idxA, lx, ly, lz, dirCode);
    }

    public static /* synthetic */ int computeFilteredFaceConductance$default(ShipPocketState shipPocketState, int n, int n2, int n3, long l, long l2, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            l = -1L;
        }
        if ((n4 & 0x20) != 0) {
            l2 = -1L;
        }
        return ShipWaterPocketStateAccessKt.computeFilteredFaceConductance(shipPocketState, n, n2, n3, l, l2);
    }

    @NotNull
    public static final PointVoidClassification classifyShipPoint(@NotNull ShipPocketState state, double x, double y, double z, @Nullable class_2338.class_2339 out) {
        int lz;
        int ly;
        int lx;
        int voxelZ;
        int voxelY;
        int voxelX;
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                voxelX = class_3532.method_15357((double)x);
                voxelY = class_3532.method_15357((double)y);
                voxelZ = class_3532.method_15357((double)z);
                lx = voxelX - state.getMinX();
                ly = voxelY - state.getMinY();
                lz = voxelZ - state.getMinZ();
                boolean bl = 0 <= lx ? lx < state.getSizeX() : false;
                if (!bl) break block12;
                boolean bl2 = 0 <= ly ? ly < state.getSizeY() : false;
                if (!bl2) break block12;
                if (0 <= lz ? lz < state.getSizeZ() : false) break block13;
            }
            return new PointVoidClassification(PointVoidClass.OUT_OF_BOUNDS, 0, 0, 0, 0, 0, 62, null);
        }
        class_2338.class_2339 class_23392 = out;
        if (class_23392 != null) {
            class_23392.method_10103(voxelX, voxelY, voxelZ);
        }
        int idx = ShipWaterPocketStateAccessKt.indexOf(state, lx, ly, lz);
        int[] templateIndices = state.getTemplateIndexByVoxel();
        List<ShapeCellTemplate> templates = state.getShapeTemplatePalette();
        if (templateIndices.length == state.getSizeX() * state.getSizeY() * state.getSizeZ() && !((Collection)templates).isEmpty()) {
            int templateIdx = templateIndices[idx];
            boolean bl = 0 <= templateIdx ? templateIdx < ((Collection)templates).size() : false;
            if (bl) {
                long exteriorMask;
                long interiorMask;
                ShapeCellTemplate template = templates.get(templateIdx);
                if (template.getComponentCount() <= 0) {
                    return new PointVoidClassification(PointVoidClass.SOLID, idx, voxelX, voxelY, voxelZ, 0, 32, null);
                }
                double fx = RangesKt.coerceIn((double)(x - (double)voxelX), (double)0.0, (double)0.999999999);
                double fy = RangesKt.coerceIn((double)(y - (double)voxelY), (double)0.0, (double)0.999999999);
                double fz = RangesKt.coerceIn((double)(z - (double)voxelZ), (double)0.0, (double)0.999999999);
                int sx = RangesKt.coerceIn((int)((int)(fx * 8.0)), (int)0, (int)7);
                int sy = RangesKt.coerceIn((int)((int)(fy * 8.0)), (int)0, (int)7);
                int sz = RangesKt.coerceIn((int)((int)(fz * 8.0)), (int)0, (int)7);
                int subIdx = sx + 8 * (sy + 8 * sz);
                byte component = template.getComponentBySubcell()[subIdx];
                if (component < 0) {
                    return new PointVoidClassification(PointVoidClass.SOLID, idx, voxelX, voxelY, voxelZ, 0, 32, null);
                }
                long l = interiorMask = idx < state.getVoxelInteriorComponentMask().length ? state.getVoxelInteriorComponentMask()[idx] : 0L;
                if ((interiorMask >>> component & 1L) != 0L) {
                    return new PointVoidClassification(PointVoidClass.INTERIOR_VOID, idx, voxelX, voxelY, voxelZ, component);
                }
                long l2 = exteriorMask = idx < state.getVoxelExteriorComponentMask().length ? state.getVoxelExteriorComponentMask()[idx] : 0L;
                if ((exteriorMask >>> component & 1L) != 0L) {
                    return new PointVoidClassification(PointVoidClass.EXTERIOR_VOID, idx, voxelX, voxelY, voxelZ, component);
                }
                if (state.getOpen().get(idx)) {
                    PointVoidClass fallbackKind = state.getStrictInterior().get(idx) ? PointVoidClass.INTERIOR_VOID : PointVoidClass.EXTERIOR_VOID;
                    return new PointVoidClassification(fallbackKind, idx, voxelX, voxelY, voxelZ, component);
                }
            }
        }
        if (!state.getOpen().get(idx)) {
            return new PointVoidClassification(PointVoidClass.SOLID, idx, voxelX, voxelY, voxelZ, 0, 32, null);
        }
        return new PointVoidClassification(state.getStrictInterior().get(idx) ? PointVoidClass.INTERIOR_VOID : PointVoidClass.EXTERIOR_VOID, idx, voxelX, voxelY, voxelZ, 0);
    }

    public static /* synthetic */ PointVoidClassification classifyShipPoint$default(ShipPocketState shipPocketState, double d, double d2, double d3, class_2338.class_2339 class_23392, int n, Object object) {
        if ((n & 0x10) != 0) {
            class_23392 = null;
        }
        return ShipWaterPocketStateAccessKt.classifyShipPoint(shipPocketState, d, d2, d3, class_23392);
    }

    @NotNull
    public static final PointVoidClassification classifyShipPointWithEpsilon(@NotNull ShipPocketState state, double x, double y, double z, @Nullable class_2338.class_2339 out) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        PointVoidClassification base = ShipWaterPocketStateAccessKt.classifyShipPoint(state, x, y, z, out);
        if (base.getKind() == PointVoidClass.INTERIOR_VOID || base.getKind() == PointVoidClass.EXTERIOR_VOID) {
            return base;
        }
        PointVoidClassification bestExterior = null;
        double eps = 1.0E-5;
        double[] dArray = new double[]{-eps, 0.0, eps};
        for (double dx : dArray) {
            double[] dArray2 = new double[]{-eps, 0.0, eps};
            for (double dy : dArray2) {
                double[] dArray3 = new double[]{-eps, 0.0, eps};
                block6: for (double dz : dArray3) {
                    if (dx == 0.0 && dy == 0.0 && dz == 0.0) continue;
                    PointVoidClassification candidate = ShipWaterPocketStateAccessKt.classifyShipPoint(state, x + dx, y + dy, z + dz, out);
                    switch (WhenMappings.$EnumSwitchMapping$0[candidate.getKind().ordinal()]) {
                        case 1: {
                            return candidate;
                        }
                        case 2: {
                            if (bestExterior != null) continue block6;
                            bestExterior = candidate;
                            continue block6;
                        }
                    }
                }
            }
        }
        PointVoidClassification pointVoidClassification = bestExterior;
        if (pointVoidClassification == null) {
            pointVoidClassification = base;
        }
        return pointVoidClassification;
    }

    public static /* synthetic */ PointVoidClassification classifyShipPointWithEpsilon$default(ShipPocketState shipPocketState, double d, double d2, double d3, class_2338.class_2339 class_23392, int n, Object object) {
        if ((n & 0x10) != 0) {
            class_23392 = null;
        }
        return ShipWaterPocketStateAccessKt.classifyShipPointWithEpsilon(shipPocketState, d, d2, d3, class_23392);
    }

    public static final boolean isOpenAtShipPoint(@NotNull ShipPocketState state, double x, double y, double z, @NotNull class_2338.class_2339 tmp) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
        tmp.method_10103(class_3532.method_15357((double)x), class_3532.method_15357((double)y), class_3532.method_15357((double)z));
        return ShipWaterPocketStateAccessKt.isOpen(state, (class_2338)tmp);
    }

    public static final boolean isInterior(@NotNull ShipPocketState state, @NotNull class_2338 shipPos) {
        int lz;
        int ly;
        int lx;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)shipPos, (String)"shipPos");
                lx = shipPos.method_10263() - state.getMinX();
                ly = shipPos.method_10264() - state.getMinY();
                lz = shipPos.method_10260() - state.getMinZ();
                boolean bl = 0 <= lx ? lx < state.getSizeX() : false;
                if (!bl) break block3;
                boolean bl2 = 0 <= ly ? ly < state.getSizeY() : false;
                if (!bl2) break block3;
                if (0 <= lz ? lz < state.getSizeZ() : false) break block4;
            }
            return false;
        }
        int idx = ShipWaterPocketStateAccessKt.indexOf(state, lx, ly, lz);
        return state.getStrictInterior().get(idx);
    }

    public static final boolean isOpen(@NotNull ShipPocketState state, @NotNull class_2338 shipPos) {
        int lz;
        int ly;
        int lx;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)shipPos, (String)"shipPos");
                lx = shipPos.method_10263() - state.getMinX();
                ly = shipPos.method_10264() - state.getMinY();
                lz = shipPos.method_10260() - state.getMinZ();
                boolean bl = 0 <= lx ? lx < state.getSizeX() : false;
                if (!bl) break block3;
                boolean bl2 = 0 <= ly ? ly < state.getSizeY() : false;
                if (!bl2) break block3;
                if (0 <= lz ? lz < state.getSizeZ() : false) break block4;
            }
            return false;
        }
        int idx = ShipWaterPocketStateAccessKt.indexOf(state, lx, ly, lz);
        return state.getOpen().get(idx);
    }

    public static final boolean isAirPocket(@NotNull ShipPocketState state, @NotNull class_2338 shipPos) {
        int lz;
        int ly;
        int lx;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)shipPos, (String)"shipPos");
                lx = shipPos.method_10263() - state.getMinX();
                ly = shipPos.method_10264() - state.getMinY();
                lz = shipPos.method_10260() - state.getMinZ();
                boolean bl = 0 <= lx ? lx < state.getSizeX() : false;
                if (!bl) break block3;
                boolean bl2 = 0 <= ly ? ly < state.getSizeY() : false;
                if (!bl2) break block3;
                if (0 <= lz ? lz < state.getSizeZ() : false) break block4;
            }
            return false;
        }
        int idx = ShipWaterPocketStateAccessKt.indexOf(state, lx, ly, lz);
        return state.getUnreachableVoid().get(idx) && !state.getMaterializedWater().get(idx);
    }

    public static final boolean isWorldFluidSuppressionCell(@NotNull ShipPocketState state, @NotNull class_2338 shipPos) {
        int lz;
        int ly;
        int lx;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Intrinsics.checkNotNullParameter((Object)shipPos, (String)"shipPos");
                lx = shipPos.method_10263() - state.getMinX();
                ly = shipPos.method_10264() - state.getMinY();
                lz = shipPos.method_10260() - state.getMinZ();
                boolean bl = 0 <= lx ? lx < state.getSizeX() : false;
                if (!bl) break block3;
                boolean bl2 = 0 <= ly ? ly < state.getSizeY() : false;
                if (!bl2) break block3;
                if (0 <= lz ? lz < state.getSizeZ() : false) break block4;
            }
            return false;
        }
        int idx = ShipWaterPocketStateAccessKt.indexOf(state, lx, ly, lz);
        return state.getSimulationDomain().get(idx) && !state.getMaterializedWater().get(idx);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PointVoidClass.values().length];
            try {
                nArray[PointVoidClass.INTERIOR_VOID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PointVoidClass.EXTERIOR_VOID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

