/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.mixin.compat.vs2;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.world.PhysLevel;
import org.valkyrienskies.mod.common.util.BuoyancyHandlerAttachment;
import org.valkyrienskies.valkyrienair.config.ValkyrienAirConfig;
import org.valkyrienskies.valkyrienair.mixinducks.compat.vs2.ValkyrienAirBuoyancyAttachmentDuck;

@Mixin(value={BuoyancyHandlerAttachment.class}, remap=false)
public abstract class MixinBuoyancyHandlerAttachment
implements ValkyrienAirBuoyancyAttachmentDuck {
    @Unique
    private static final Logger valkyrienair$LOGGER = LogManager.getLogger((String)"ValkyrienAir Buoyancy");
    @Unique
    private static final double valkyrienair$WATER_DENSITY = 1000.0;
    @Unique
    private static final double valkyrienair$GRAVITY_MAGNITUDE = 10.0;
    @Unique
    private static final double valkyrienair$MAX_POCKET_BUOYANCY_WEIGHT_MULT = 1.0;
    @Unique
    private static final double valkyrienair$DEFAULT_FLUID_VISCOSITY = 1000.0;
    @Unique
    private static final double valkyrienair$OVERLAP_EPS = 1.0E-6;
    @Unique
    private static final double valkyrienair$SMOOTH_DISPLACED_ALPHA = 0.35;
    @Unique
    private static final double valkyrienair$SMOOTH_CENTER_ALPHA = 0.25;
    @Unique
    private static final double valkyrienair$MAX_FORCE_SLEW_G_PER_TICK = 0.35;
    @Unique
    private static final double valkyrienair$MAX_BALANCED_LEVER_ARM = 32.0;
    @Unique
    private static final double valkyrienair$MIN_COM_BLEND = 0.55;
    @Unique
    private static final double valkyrienair$MAX_DAMPING_FORCE_MULT = 3.0;
    @Unique
    private volatile double valkyrienair$displacedVolume = 0.0;
    @Unique
    private volatile boolean valkyrienair$hasPocketCenter = false;
    @Unique
    private volatile double valkyrienair$buoyancyFluidDensity = 1000.0;
    @Unique
    private volatile double valkyrienair$buoyancyFluidViscosity = 1000.0;
    @Unique
    private volatile double valkyrienair$pocketCenterX = 0.0;
    @Unique
    private volatile double valkyrienair$pocketCenterY = 0.0;
    @Unique
    private volatile double valkyrienair$pocketCenterZ = 0.0;
    @Unique
    private final Vector3d valkyrienair$tmpForce = new Vector3d();
    @Unique
    private final Vector3d valkyrienair$tmpPos = new Vector3d();
    @Unique
    private double valkyrienair$smoothedDisplacedVolume = 0.0;
    @Unique
    private boolean valkyrienair$hasSmoothedCenter = false;
    @Unique
    private double valkyrienair$smoothedCenterX = 0.0;
    @Unique
    private double valkyrienair$smoothedCenterY = 0.0;
    @Unique
    private double valkyrienair$smoothedCenterZ = 0.0;
    @Unique
    private double valkyrienair$lastAppliedBuoyancyForce = 0.0;
    @Unique
    private long valkyrienair$diagOverlapClampCount = 0L;
    @Unique
    private long valkyrienair$diagForceSlewClampCount = 0L;
    @Unique
    private long valkyrienair$diagLeverClampCount = 0L;
    @Unique
    private long valkyrienair$diagDampingClampCount = 0L;

    @Override
    public double valkyrienair$getDisplacedVolume() {
        return this.valkyrienair$displacedVolume;
    }

    @Override
    public void valkyrienair$setDisplacedVolume(double volume) {
        this.valkyrienair$displacedVolume = volume;
    }

    @Override
    public boolean valkyrienair$hasPocketCenter() {
        return this.valkyrienair$hasPocketCenter;
    }

    @Override
    public double valkyrienair$getPocketCenterX() {
        return this.valkyrienair$pocketCenterX;
    }

    @Override
    public double valkyrienair$getPocketCenterY() {
        return this.valkyrienair$pocketCenterY;
    }

    @Override
    public double valkyrienair$getPocketCenterZ() {
        return this.valkyrienair$pocketCenterZ;
    }

    @Override
    public void valkyrienair$setPocketCenter(double x, double y, double z) {
        this.valkyrienair$pocketCenterX = x;
        this.valkyrienair$pocketCenterY = y;
        this.valkyrienair$pocketCenterZ = z;
        this.valkyrienair$hasPocketCenter = true;
    }

    @Override
    public double valkyrienair$getBuoyancyFluidDensity() {
        return this.valkyrienair$buoyancyFluidDensity;
    }

    @Override
    public double valkyrienair$getBuoyancyFluidViscosity() {
        return this.valkyrienair$buoyancyFluidViscosity;
    }

    @Override
    public void valkyrienair$setBuoyancyFluidDensity(double density) {
        this.valkyrienair$buoyancyFluidDensity = density;
    }

    @Override
    public void valkyrienair$setBuoyancyFluidViscosity(double viscosity) {
        this.valkyrienair$buoyancyFluidViscosity = viscosity;
    }

    @Inject(method={"physTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void valkyrienair$disableVs2PocketBuoyancy(PhysShip physShip, PhysLevel physLevel, CallbackInfo ci) {
        double maxForceThisTick;
        double maxDeltaForce;
        double prevForce;
        double minForceThisTick;
        double upwardForce;
        double pocketZ;
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return;
        }
        ci.cancel();
        physShip.setBuoyantFactor(1.0);
        if (!this.valkyrienair$hasPocketCenter) {
            this.valkyrienair$lastAppliedBuoyancyForce = 0.0;
            this.valkyrienair$smoothedDisplacedVolume = 0.0;
            this.valkyrienair$hasSmoothedCenter = false;
            return;
        }
        double displacedRaw = this.valkyrienair$displacedVolume;
        if (!Double.isFinite(displacedRaw) || displacedRaw <= 1.0E-6) {
            this.valkyrienair$smoothedDisplacedVolume *= 0.75;
            if (this.valkyrienair$smoothedDisplacedVolume <= 1.0E-6) {
                this.valkyrienair$smoothedDisplacedVolume = 0.0;
            }
            this.valkyrienair$lastAppliedBuoyancyForce = 0.0;
            return;
        }
        double overlapRaw = physShip.getLiquidOverlap();
        if (!Double.isFinite(overlapRaw)) {
            return;
        }
        double overlap = MixinBuoyancyHandlerAttachment.clamp(overlapRaw, 0.0, 1.0);
        if (Math.abs(overlap - overlapRaw) > 1.0E-9) {
            this.valkyrienair$logClamp("overlap", overlapRaw, overlap);
        }
        if (overlap <= 1.0E-6) {
            this.valkyrienair$lastAppliedBuoyancyForce = 0.0;
            return;
        }
        double mass = physShip.getMass();
        if (!Double.isFinite(mass) || mass <= 1.0E-6) {
            return;
        }
        double density = this.valkyrienair$buoyancyFluidDensity;
        if (!Double.isFinite(density) || density <= 0.0) {
            density = 1000.0;
        }
        density = Math.max(100.0, Math.min(density, 20000.0));
        this.valkyrienair$smoothedDisplacedVolume += (Math.max(0.0, displacedRaw) - this.valkyrienair$smoothedDisplacedVolume) * 0.35;
        double displaced = Math.max(0.0, this.valkyrienair$smoothedDisplacedVolume);
        if (!Double.isFinite(displaced) || displaced <= 1.0E-6) {
            this.valkyrienair$lastAppliedBuoyancyForce = 0.0;
            return;
        }
        Vector3dc com = physShip.getCenterOfMass();
        double comX = com.x();
        double comY = com.y();
        double comZ = com.z();
        if (!(Double.isFinite(comX) && Double.isFinite(comY) && Double.isFinite(comZ))) {
            return;
        }
        double rawPocketX = this.valkyrienair$pocketCenterX;
        double rawPocketY = this.valkyrienair$pocketCenterY;
        double rawPocketZ = this.valkyrienair$pocketCenterZ;
        double pocketX = Double.isFinite(rawPocketX) ? rawPocketX : comX;
        double pocketY = Double.isFinite(rawPocketY) ? rawPocketY : comY;
        double d = pocketZ = Double.isFinite(rawPocketZ) ? rawPocketZ : comZ;
        if (!this.valkyrienair$hasSmoothedCenter) {
            this.valkyrienair$smoothedCenterX = pocketX;
            this.valkyrienair$smoothedCenterY = pocketY;
            this.valkyrienair$smoothedCenterZ = pocketZ;
            this.valkyrienair$hasSmoothedCenter = true;
        } else {
            this.valkyrienair$smoothedCenterX += (pocketX - this.valkyrienair$smoothedCenterX) * 0.25;
            this.valkyrienair$smoothedCenterY += (pocketY - this.valkyrienair$smoothedCenterY) * 0.25;
            this.valkyrienair$smoothedCenterZ += (pocketZ - this.valkyrienair$smoothedCenterZ) * 0.25;
        }
        double leverX = this.valkyrienair$smoothedCenterX - comX;
        double leverY = this.valkyrienair$smoothedCenterY - comY;
        double leverZ = this.valkyrienair$smoothedCenterZ - comZ;
        double leverLenSq = leverX * leverX + leverY * leverY + leverZ * leverZ;
        if (leverLenSq > 1024.0) {
            double leverLen = Math.sqrt(leverLenSq);
            double scale = 32.0 / leverLen;
            leverX *= scale;
            leverY *= scale;
            leverZ *= scale;
            this.valkyrienair$logClamp("leverArm", leverLen, 32.0);
        }
        double clampedLeverLen = Math.sqrt(leverX * leverX + leverY * leverY + leverZ * leverZ);
        double leverRatio = MixinBuoyancyHandlerAttachment.clamp(clampedLeverLen / 32.0, 0.0, 1.0);
        double comBlend = MixinBuoyancyHandlerAttachment.clamp(1.0 - 0.45 * leverRatio, 0.55, 1.0);
        double applyX = comX + leverX * comBlend;
        double applyY = comY + leverY * comBlend;
        double applyZ = comZ + leverZ * comBlend;
        double upwardForceTarget = displaced * density * 10.0 * overlap;
        if (!Double.isFinite(upwardForceTarget) || upwardForceTarget <= 0.0) {
            this.valkyrienair$lastAppliedBuoyancyForce = 0.0;
            return;
        }
        double maxForce = mass * 10.0 * 1.0;
        if (Double.isFinite(maxForce) && maxForce > 0.0) {
            double clamped = Math.min(upwardForceTarget, maxForce);
            if (Math.abs(clamped - upwardForceTarget) > 1.0E-9) {
                this.valkyrienair$logClamp("forceSlew", upwardForceTarget, clamped);
            }
            upwardForceTarget = clamped;
        }
        if (Math.abs((upwardForce = MixinBuoyancyHandlerAttachment.clamp(upwardForceTarget, minForceThisTick = Math.max(0.0, (prevForce = Double.isFinite(this.valkyrienair$lastAppliedBuoyancyForce) && this.valkyrienair$lastAppliedBuoyancyForce > 0.0 ? this.valkyrienair$lastAppliedBuoyancyForce : 0.0) - (maxDeltaForce = mass * 10.0 * 0.35)), maxForceThisTick = prevForce + maxDeltaForce)) - upwardForceTarget) > 1.0E-9) {
            this.valkyrienair$logClamp("forceSlew", upwardForceTarget, upwardForce);
        }
        this.valkyrienair$lastAppliedBuoyancyForce = upwardForce;
        if (upwardForce <= 1.0E-6) {
            return;
        }
        this.valkyrienair$tmpForce.set(0.0, upwardForce, 0.0);
        this.valkyrienair$tmpPos.set(applyX, applyY, applyZ);
        physShip.applyWorldForceToModelPos((Vector3dc)this.valkyrienair$tmpForce, (Vector3dc)this.valkyrienair$tmpPos);
        physShip.setDoFluidDrag(true);
        double viscosity = this.valkyrienair$buoyancyFluidViscosity;
        if (Double.isFinite(viscosity) && viscosity > 1500.0) {
            double maxDamp;
            double fz;
            double fy;
            viscosity = Math.max(100.0, Math.min(viscosity, 200000.0));
            double viscosityScale = Math.max(0.25, Math.min(viscosity / 1000.0, 20.0));
            Vector3dc vel = physShip.getVelocity();
            double baseDamping = 0.35;
            double damping = 0.35 * viscosityScale * overlap;
            double fx = -vel.x() * mass * damping;
            double dampLenSq = fx * fx + (fy = -vel.y() * mass * damping) * fy + (fz = -vel.z() * mass * damping) * fz;
            if (dampLenSq > (maxDamp = mass * 10.0 * 3.0) * maxDamp && dampLenSq > 1.0E-12) {
                double rawLen = Math.sqrt(dampLenSq);
                double scale = maxDamp / rawLen;
                fx *= scale;
                fy *= scale;
                fz *= scale;
                this.valkyrienair$logClamp("damping", rawLen, maxDamp);
            }
            this.valkyrienair$tmpForce.set(fx, fy, fz);
            physShip.applyWorldForceToModelPos((Vector3dc)this.valkyrienair$tmpForce, com);
        }
    }

    @Unique
    private void valkyrienair$logClamp(String kind, double raw, double clamped) {
        if (!Double.isFinite(raw) || !Double.isFinite(clamped)) {
            return;
        }
        if (Math.abs(raw - clamped) <= 1.0E-9) {
            return;
        }
        long count = switch (kind) {
            case "overlap" -> ++this.valkyrienair$diagOverlapClampCount;
            case "leverArm" -> ++this.valkyrienair$diagLeverClampCount;
            case "damping" -> ++this.valkyrienair$diagDampingClampCount;
            default -> ++this.valkyrienair$diagForceSlewClampCount;
        };
        if (count <= 4L || count % 512L == 0L) {
            valkyrienair$LOGGER.debug("Pocket buoyancy clamp kind={} raw={} clamped={} count={}", (Object)kind, (Object)raw, (Object)clamped, (Object)count);
        }
    }

    @Unique
    private static double clamp(double v, double min, double max) {
        return v < min ? min : Math.min(v, max);
    }
}

