/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.client.feature.ship_water_pockets;

import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class EmbeddiumChunkRenderContext {
    private static final float PRECISION_MODIFIER = 128.0f;
    private static final int MAX_STACK_DEPTH = 8;
    private static final ThreadLocal<State> STATE = ThreadLocal.withInitial(State::new);

    private EmbeddiumChunkRenderContext() {
    }

    public static void pushChunkCameraWorldPos(double rawX, double rawY, double rawZ) {
        State s = STATE.get();
        if (s.depth < 8) {
            int idx = s.depth;
            s.activeStack[idx] = s.active;
            s.chunkCamXStack[idx] = s.chunkCamX;
            s.chunkCamYStack[idx] = s.chunkCamY;
            s.chunkCamZStack[idx] = s.chunkCamZ;
            s.rawXStack[idx] = s.rawX;
            s.rawYStack[idx] = s.rawY;
            s.rawZStack[idx] = s.rawZ;
        }
        ++s.depth;
        s.active = true;
        s.rawX = rawX;
        s.rawY = rawY;
        s.rawZ = rawZ;
        s.chunkCamX = EmbeddiumChunkRenderContext.computeChunkCameraOrigin(rawX);
        s.chunkCamY = EmbeddiumChunkRenderContext.computeChunkCameraOrigin(rawY);
        s.chunkCamZ = EmbeddiumChunkRenderContext.computeChunkCameraOrigin(rawZ);
    }

    public static void pop() {
        State s = STATE.get();
        --s.depth;
        if (s.depth <= 0) {
            s.depth = 0;
            s.active = false;
            s.chunkCamX = 0.0;
            s.chunkCamY = 0.0;
            s.chunkCamZ = 0.0;
            s.rawX = 0.0;
            s.rawY = 0.0;
            s.rawZ = 0.0;
            return;
        }
        int idx = Math.min(s.depth - 1, 7);
        s.active = s.activeStack[idx];
        s.chunkCamX = s.chunkCamXStack[idx];
        s.chunkCamY = s.chunkCamYStack[idx];
        s.chunkCamZ = s.chunkCamZStack[idx];
        s.rawX = s.rawXStack[idx];
        s.rawY = s.rawYStack[idx];
        s.rawZ = s.rawZStack[idx];
    }

    public static void clear() {
        State s = STATE.get();
        s.depth = 0;
        s.active = false;
        s.chunkCamX = 0.0;
        s.chunkCamY = 0.0;
        s.chunkCamZ = 0.0;
        s.rawX = 0.0;
        s.rawY = 0.0;
        s.rawZ = 0.0;
    }

    @Nullable
    public static Vec3 getChunkCameraWorldPosOrNull() {
        State s = STATE.get();
        if (!s.active) {
            return null;
        }
        return new Vec3(s.chunkCamX, s.chunkCamY, s.chunkCamZ);
    }

    public static double getChunkCamXOr(double fallback) {
        State s = STATE.get();
        return s.active ? s.chunkCamX : fallback;
    }

    public static double getChunkCamYOr(double fallback) {
        State s = STATE.get();
        return s.active ? s.chunkCamY : fallback;
    }

    public static double getChunkCamZOr(double fallback) {
        State s = STATE.get();
        return s.active ? s.chunkCamZ : fallback;
    }

    private static double computeChunkCameraOrigin(double value) {
        int integral = (int)value;
        float fullPrecision = (float)(value - (double)integral);
        float modifier = Math.copySign(128.0f, fullPrecision);
        float reduced = fullPrecision + modifier - modifier;
        return (double)integral + (double)reduced;
    }

    private static final class State {
        private boolean active;
        private double chunkCamX;
        private double chunkCamY;
        private double chunkCamZ;
        private double rawX;
        private double rawY;
        private double rawZ;
        private int depth;
        private final boolean[] activeStack = new boolean[8];
        private final double[] chunkCamXStack = new double[8];
        private final double[] chunkCamYStack = new double[8];
        private final double[] chunkCamZStack = new double[8];
        private final double[] rawXStack = new double[8];
        private final double[] rawYStack = new double[8];
        private final double[] rawZStack = new double[8];

        private State() {
        }
    }
}

