/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.client.feature.ship_water_pockets;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.primitives.AABBdc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.valkyrienair.config.ValkyrienAirConfig;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipPocketAsyncRuntime;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipPocketAsyncSubsystem;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketAsyncCull;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketManager;

public final class ShipWaterPocketExternalWaterCull {
    private static final Logger LOGGER = LogManager.getLogger((String)"ValkyrienAir ShipWaterCull");
    private static final int MAX_SHIPS = 9;
    private static final int SUB = 8;
    private static final int OCC_WORDS_PER_VOXEL = 16;
    private static final int MASK_TEX_WIDTH = 4096;
    private static final int MASK_TEX_WIDTH_MASK = 4095;
    private static final int MASK_TEX_WIDTH_SHIFT = 12;
    private static final int BASE_MASK_TEX_UNIT = 2;
    private static final int GLSTATEMANAGER_SAFE_TEXTURE_UNITS = 12;
    private static final ResourceLocation WATER_STILL = new ResourceLocation("minecraft", "block/water_still");
    private static final ResourceLocation WATER_FLOW = new ResourceLocation("minecraft", "block/water_flow");
    private static final ResourceLocation WATER_OVERLAY = new ResourceLocation("minecraft", "block/water_overlay");
    private static final ResourceLocation LAVA_STILL = new ResourceLocation("minecraft", "block/lava_still");
    private static final ResourceLocation LAVA_FLOW = new ResourceLocation("minecraft", "block/lava_flow");
    private static int fluidMaskTexId = 0;
    private static int fluidMaskWidth = 0;
    private static int fluidMaskHeight = 0;
    private static int fluidMaskLastAtlasTexId = 0;
    private static byte[] fluidMaskData = null;
    private static ByteBuffer fluidMaskBuffer = null;
    private static boolean loggedFluidMaskBuildFailed = false;
    private static CompletableFuture<byte[]> pendingFluidMaskFuture = null;
    private static int pendingFluidMaskAtlasTexId = 0;
    private static int pendingFluidMaskWidth = 0;
    private static int pendingFluidMaskHeight = 0;
    private static boolean forgeFluidTexturesChecked = false;
    private static Method forgeFluidExtOf = null;
    private static Method forgeGetStill0 = null;
    private static Method forgeGetFlow0 = null;
    private static Method forgeGetOverlay0 = null;
    private static Method forgeGetStill3 = null;
    private static Method forgeGetFlow3 = null;
    private static Method forgeGetOverlay3 = null;
    private static boolean fabricFluidTexturesChecked = false;
    private static Object fabricFluidRenderHandlerRegistry = null;
    private static Method fabricRegistryGetHandler = null;
    private static Method fabricHandlerGetSprites = null;
    private static final Matrix4f IDENTITY_MAT4 = new Matrix4f();
    private static ClientLevel lastLevel = null;
    private static final Map<Long, ShipMasks> SHIP_MASKS = new HashMap<Long, ShipMasks>();
    private static final Int2ObjectOpenHashMap<ProgramHandles> PROGRAM_HANDLES = new Int2ObjectOpenHashMap();
    private static boolean programEverSupported = false;
    private static final ThreadLocal<FloatBuffer> MATRIX_BUFFER = ThreadLocal.withInitial(() -> BufferUtils.createFloatBuffer((int)16));
    private static final ShaderHandles SHADER = new ShaderHandles();
    private static boolean everEnabled = false;
    private static boolean shaderEverSupported = false;
    private static boolean loggedEmbeddiumProgramMissingUniforms = false;

    private ShipWaterPocketExternalWaterCull() {
    }

    public static void clear() {
        ShipWaterPocketExternalWaterCull.SHADER.shader = null;
        ShipWaterPocketExternalWaterCull.SHADER.supported = false;
        everEnabled = false;
        shaderEverSupported = false;
        programEverSupported = false;
        PROGRAM_HANDLES.clear();
        for (ShipMasks masks : SHIP_MASKS.values()) {
            masks.close();
        }
        SHIP_MASKS.clear();
        if (fluidMaskTexId != 0) {
            TextureUtil.releaseTextureId((int)fluidMaskTexId);
            fluidMaskTexId = 0;
        }
        if (pendingFluidMaskFuture != null) {
            pendingFluidMaskFuture.cancel(true);
            pendingFluidMaskFuture = null;
        }
        fluidMaskWidth = 0;
        fluidMaskHeight = 0;
        fluidMaskLastAtlasTexId = 0;
        fluidMaskData = null;
        fluidMaskBuffer = null;
        loggedFluidMaskBuildFailed = false;
        pendingFluidMaskAtlasTexId = 0;
        pendingFluidMaskWidth = 0;
        pendingFluidMaskHeight = 0;
        lastLevel = null;
    }

    public static boolean isShaderCullingActive() {
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return false;
        }
        return (shaderEverSupported || programEverSupported) && everEnabled;
    }

    public static void setupForWorldTranslucentPass(ShaderInstance shader, ClientLevel level, Camera camera) {
        if (level == null || camera == null) {
            return;
        }
        Vec3 cameraPos = camera.m_90583_();
        ShipWaterPocketExternalWaterCull.setupForWorldTranslucentPass(shader, level, cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_);
    }

    public static void setupForWorldTranslucentPass(ShaderInstance shader, ClientLevel level, double cameraX, double cameraY, double cameraZ) {
        if (level == null) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        if (lastLevel != level) {
            ShipWaterPocketExternalWaterCull.clear();
            lastLevel = level;
        }
        ShipWaterPocketExternalWaterCull.bindShaderHandles(shader);
        if (!ShipWaterPocketExternalWaterCull.SHADER.supported) {
            return;
        }
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            ShipWaterPocketExternalWaterCull.disable(shader);
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.cullEnabled.m_5985_(1.0f);
        ShipWaterPocketExternalWaterCull.SHADER.cullEnabled.m_85633_();
        everEnabled = true;
        ShipWaterPocketExternalWaterCull.setShipPass(shader, false);
        Vec3 cameraPos = new Vec3(cameraX, cameraY, cameraZ);
        ShipWaterPocketExternalWaterCull.SHADER.shader.m_173350_("ValkyrienAir_FluidMask", (Object)ShipWaterPocketExternalWaterCull.ensureFluidMaskTexture(level));
        ShipWaterPocketExternalWaterCull.updateCameraAndWaterUv(cameraPos);
        List<LoadedShip> ships = ShipWaterPocketExternalWaterCull.selectClosestShips(level, cameraPos, 9);
        ShipWaterPocketExternalWaterCull.updateShipUniformsAndMasks(level, ships, cameraX, cameraY, cameraZ);
    }

    public static void setupForWorldTranslucentPassProgram(int programId, ClientLevel level, double cameraX, double cameraY, double cameraZ) {
        ProgramHandles handles;
        if (programId == 0 || level == null) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        if (lastLevel != level) {
            ShipWaterPocketExternalWaterCull.clear();
            lastLevel = level;
        }
        if ((handles = ShipWaterPocketExternalWaterCull.bindProgramHandles(programId)) == null || !handles.supported) {
            if (!loggedEmbeddiumProgramMissingUniforms && handles != null && handles.embeddiumChunkProgram && ValkyrienAirConfig.getEnableShipWaterPockets()) {
                loggedEmbeddiumProgramMissingUniforms = true;
                if (handles.cullEnabledLoc < 0) {
                    LOGGER.warn("Embeddium chunk shader program {} is missing ValkyrienAir uniforms; water culling is inactive (shader injection not applied?)", (Object)programId);
                } else {
                    LOGGER.warn("Embeddium chunk shader program {} has incomplete ValkyrienAir uniforms; water culling is inactive", (Object)programId);
                }
            }
            return;
        }
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            ShipWaterPocketExternalWaterCull.disableProgram(programId);
            return;
        }
        if (handles.cullEnabledLoc >= 0) {
            GL20.glUniform1f((int)handles.cullEnabledLoc, (float)1.0f);
        }
        everEnabled = true;
        if (handles.isShipPassLoc >= 0) {
            GL20.glUniform1f((int)handles.isShipPassLoc, (float)0.0f);
        }
        Vec3 cameraPos = new Vec3(cameraX, cameraY, cameraZ);
        if (handles.chunkWorldOriginLoc >= 0) {
            GL20.glUniform3f((int)handles.chunkWorldOriginLoc, (float)((float)cameraPos.f_82479_), (float)((float)cameraPos.f_82480_), (float)((float)cameraPos.f_82481_));
        }
        ShipWaterPocketExternalWaterCull.bindProgramFluidMaskTexture(handles, ShipWaterPocketExternalWaterCull.ensureFluidMaskTexture(level));
        ShipWaterPocketExternalWaterCull.updateCameraAndWaterUvProgram(handles, cameraPos);
        List<LoadedShip> ships = ShipWaterPocketExternalWaterCull.selectClosestShips(level, cameraPos, handles.maxMaskSlots);
        ShipWaterPocketExternalWaterCull.updateShipUniformsAndMasksProgram(handles, level, ships, cameraX, cameraY, cameraZ);
    }

    public static void disableProgram(int programId) {
        if (programId == 0) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        ProgramHandles handles = ShipWaterPocketExternalWaterCull.bindProgramHandles(programId);
        if (handles == null) {
            return;
        }
        if (handles.cullEnabledLoc >= 0) {
            GL20.glUniform1f((int)handles.cullEnabledLoc, (float)0.0f);
        }
        if (handles.isShipPassLoc >= 0) {
            GL20.glUniform1f((int)handles.isShipPassLoc, (float)0.0f);
        }
        if (handles.shipWaterTintEnabledLoc >= 0) {
            GL20.glUniform1f((int)handles.shipWaterTintEnabledLoc, (float)0.0f);
        }
        if (handles.shipWaterTintLoc >= 0) {
            GL20.glUniform3f((int)handles.shipWaterTintLoc, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void setShipPassProgram(int programId, boolean shipPass) {
        if (programId == 0) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        ProgramHandles handles = ShipWaterPocketExternalWaterCull.bindProgramHandles(programId);
        if (handles == null || handles.isShipPassLoc < 0) {
            return;
        }
        if (handles.isShipPassLoc >= 0) {
            GL20.glUniform1f((int)handles.isShipPassLoc, (float)(shipPass ? 1.0f : 0.0f));
        }
    }

    public static void disable(ShaderInstance shader) {
        if (shader == null) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        ShipWaterPocketExternalWaterCull.bindShaderHandles(shader);
        if (!ShipWaterPocketExternalWaterCull.SHADER.supported || ShipWaterPocketExternalWaterCull.SHADER.cullEnabled == null) {
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.cullEnabled.m_5985_(0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.cullEnabled.m_85633_();
        if (ShipWaterPocketExternalWaterCull.SHADER.isShipPass != null) {
            ShipWaterPocketExternalWaterCull.SHADER.isShipPass.m_5985_(0.0f);
            ShipWaterPocketExternalWaterCull.SHADER.isShipPass.m_85633_();
        }
        if (ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled != null) {
            ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled.m_5985_(0.0f);
            ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled.m_85633_();
        }
        if (ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint != null) {
            ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint.m_5889_(1.0f, 1.0f, 1.0f);
            ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint.m_85633_();
        }
    }

    public static void setShipPass(ShaderInstance shader, boolean shipPass) {
        if (shader == null) {
            return;
        }
        if (!SHIP_MASKS.isEmpty()) {
            ShipWaterPocketExternalWaterCull.bindShaderHandles(shader);
        }
        if (!ShipWaterPocketExternalWaterCull.SHADER.supported || ShipWaterPocketExternalWaterCull.SHADER.isShipPass == null) {
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.isShipPass.m_5985_(shipPass ? 1.0f : 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.isShipPass.m_85633_();
    }

    public static void setShipWaterTintEnabled(ShaderInstance shader, boolean enabled) {
        if (shader == null) {
            return;
        }
        if (!SHIP_MASKS.isEmpty()) {
            ShipWaterPocketExternalWaterCull.bindShaderHandles(shader);
        }
        if (!ShipWaterPocketExternalWaterCull.SHADER.supported || ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled == null) {
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled.m_5985_(enabled ? 1.0f : 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled.m_85633_();
    }

    public static void setShipWaterTint(ShaderInstance shader, int rgb) {
        if (shader == null) {
            return;
        }
        if (!SHIP_MASKS.isEmpty()) {
            ShipWaterPocketExternalWaterCull.bindShaderHandles(shader);
        }
        if (!ShipWaterPocketExternalWaterCull.SHADER.supported || ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint == null) {
            return;
        }
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint.m_5889_(r, g, b);
        ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint.m_85633_();
    }

    public static void setShipWaterTintEnabledProgram(int programId, boolean enabled) {
        if (programId == 0) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        ProgramHandles handles = ShipWaterPocketExternalWaterCull.bindProgramHandles(programId);
        if (handles == null || handles.shipWaterTintEnabledLoc < 0) {
            return;
        }
        GL20.glUniform1f((int)handles.shipWaterTintEnabledLoc, (float)(enabled ? 1.0f : 0.0f));
    }

    public static void setShipWaterTintProgram(int programId, int rgb) {
        if (programId == 0) {
            return;
        }
        RenderSystem.assertOnRenderThread();
        ProgramHandles handles = ShipWaterPocketExternalWaterCull.bindProgramHandles(programId);
        if (handles == null || handles.shipWaterTintLoc < 0) {
            return;
        }
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        GL20.glUniform3f((int)handles.shipWaterTintLoc, (float)r, (float)g, (float)b);
    }

    private static void bindShaderHandles(ShaderInstance shader) {
        if (shader == null) {
            ShipWaterPocketExternalWaterCull.SHADER.shader = null;
            ShipWaterPocketExternalWaterCull.SHADER.supported = false;
            return;
        }
        if (ShipWaterPocketExternalWaterCull.SHADER.shader == shader) {
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.shader = shader;
        ShipWaterPocketExternalWaterCull.SHADER.supported = false;
        ShipWaterPocketExternalWaterCull.SHADER.cullEnabled = shader.m_173348_("ValkyrienAir_CullEnabled");
        if (ShipWaterPocketExternalWaterCull.SHADER.cullEnabled == null) {
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.isShipPass = shader.m_173348_("ValkyrienAir_IsShipPass");
        ShipWaterPocketExternalWaterCull.SHADER.cameraWorldPos = shader.m_173348_("ValkyrienAir_CameraWorldPos");
        ShipWaterPocketExternalWaterCull.SHADER.waterStillUv = shader.m_173348_("ValkyrienAir_WaterStillUv");
        ShipWaterPocketExternalWaterCull.SHADER.waterFlowUv = shader.m_173348_("ValkyrienAir_WaterFlowUv");
        ShipWaterPocketExternalWaterCull.SHADER.waterOverlayUv = shader.m_173348_("ValkyrienAir_WaterOverlayUv");
        ShipWaterPocketExternalWaterCull.SHADER.shipWaterTintEnabled = shader.m_173348_("ValkyrienAir_ShipWaterTintEnabled");
        ShipWaterPocketExternalWaterCull.SHADER.shipWaterTint = shader.m_173348_("ValkyrienAir_ShipWaterTint");
        if (ShipWaterPocketExternalWaterCull.SHADER.isShipPass == null || ShipWaterPocketExternalWaterCull.SHADER.cameraWorldPos == null || ShipWaterPocketExternalWaterCull.SHADER.waterStillUv == null || ShipWaterPocketExternalWaterCull.SHADER.waterFlowUv == null || ShipWaterPocketExternalWaterCull.SHADER.waterOverlayUv == null) {
            return;
        }
        for (int i = 0; i < 9; ++i) {
            ShipWaterPocketExternalWaterCull.SHADER.shipAabbMin[i] = shader.m_173348_("ValkyrienAir_ShipAabbMin" + i);
            ShipWaterPocketExternalWaterCull.SHADER.shipAabbMax[i] = shader.m_173348_("ValkyrienAir_ShipAabbMax" + i);
            ShipWaterPocketExternalWaterCull.SHADER.cameraShipPos[i] = shader.m_173348_("ValkyrienAir_CameraShipPos" + i);
            ShipWaterPocketExternalWaterCull.SHADER.gridMin[i] = shader.m_173348_("ValkyrienAir_GridMin" + i);
            ShipWaterPocketExternalWaterCull.SHADER.gridSize[i] = shader.m_173348_("ValkyrienAir_GridSize" + i);
            ShipWaterPocketExternalWaterCull.SHADER.worldToShip[i] = shader.m_173348_("ValkyrienAir_WorldToShip" + i);
            if (ShipWaterPocketExternalWaterCull.SHADER.shipAabbMin[i] != null && ShipWaterPocketExternalWaterCull.SHADER.shipAabbMax[i] != null && ShipWaterPocketExternalWaterCull.SHADER.gridMin[i] != null && ShipWaterPocketExternalWaterCull.SHADER.gridSize[i] != null && ShipWaterPocketExternalWaterCull.SHADER.worldToShip[i] != null && ShipWaterPocketExternalWaterCull.SHADER.cameraShipPos[i] != null) continue;
            return;
        }
        ShipWaterPocketExternalWaterCull.SHADER.supported = true;
        shaderEverSupported = true;
    }

    private static ProgramHandles bindProgramHandles(int programId) {
        boolean requiredOk;
        boolean looksLikeEmbeddiumChunkProgram;
        int maxSafeUnits;
        ProgramHandles handles = (ProgramHandles)PROGRAM_HANDLES.get(programId);
        if (handles != null) {
            return handles;
        }
        handles = new ProgramHandles(programId);
        int maxCombined = GL11.glGetInteger((int)35661);
        handles.maxSafeTextureUnits = maxSafeUnits = Math.min(maxCombined, 12);
        int availableUnits = maxSafeUnits - 2;
        int availableUnitsForShipMasks = Math.max(0, availableUnits - 1);
        handles.maxMaskSlots = Math.max(0, Math.min(9, availableUnitsForShipMasks));
        handles.regionOffsetLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"u_RegionOffset");
        handles.blockTexLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"u_BlockTex");
        handles.embeddiumChunkProgram = looksLikeEmbeddiumChunkProgram = handles.regionOffsetLoc >= 0 || handles.blockTexLoc >= 0;
        handles.cullEnabledLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_CullEnabled");
        if (handles.cullEnabledLoc < 0) {
            PROGRAM_HANDLES.put(programId, (Object)handles);
            return handles;
        }
        handles.isShipPassLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_IsShipPass");
        handles.cameraWorldPosLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_CameraWorldPos");
        handles.waterStillUvLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_WaterStillUv");
        handles.waterFlowUvLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_WaterFlowUv");
        handles.waterOverlayUvLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_WaterOverlayUv");
        handles.fluidMaskLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_FluidMask");
        handles.shipWaterTintEnabledLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_ShipWaterTintEnabled");
        handles.shipWaterTintLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_ShipWaterTint");
        handles.chunkWorldOriginLoc = GL20.glGetUniformLocation((int)programId, (CharSequence)"ValkyrienAir_ChunkWorldOrigin");
        for (int i = 0; i < 9; ++i) {
            handles.shipAabbMinLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_ShipAabbMin" + i));
            handles.shipAabbMaxLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_ShipAabbMax" + i));
            handles.cameraShipPosLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_CameraShipPos" + i));
            handles.gridMinLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_GridMin" + i));
            handles.gridSizeLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_GridSize" + i));
            handles.worldToShipLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_WorldToShip" + i));
            handles.maskLoc[i] = GL20.glGetUniformLocation((int)programId, (CharSequence)("ValkyrienAir_Mask" + i));
            handles.shipSlotSupported[i] = i < handles.maxMaskSlots && handles.shipAabbMinLoc[i] >= 0 && handles.shipAabbMaxLoc[i] >= 0 && handles.gridSizeLoc[i] >= 0 && handles.worldToShipLoc[i] >= 0 && handles.maskLoc[i] >= 0;
        }
        handles.supported = requiredOk = looksLikeEmbeddiumChunkProgram && handles.cullEnabledLoc >= 0 && handles.isShipPassLoc >= 0 && handles.cameraWorldPosLoc >= 0 && handles.fluidMaskLoc >= 0 && handles.maxMaskSlots > 0 && handles.shipSlotSupported[0];
        programEverSupported |= handles.supported;
        PROGRAM_HANDLES.put(programId, (Object)handles);
        return handles;
    }

    private static void updateCameraAndWaterUv(Vec3 cameraPos) {
        ShipWaterPocketExternalWaterCull.SHADER.cameraWorldPos.m_5889_((float)cameraPos.f_82479_, (float)cameraPos.f_82480_, (float)cameraPos.f_82481_);
        ShipWaterPocketExternalWaterCull.SHADER.cameraWorldPos.m_85633_();
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        TextureAtlasSprite still = (TextureAtlasSprite)atlas.apply(WATER_STILL);
        TextureAtlasSprite flow = (TextureAtlasSprite)atlas.apply(WATER_FLOW);
        TextureAtlasSprite overlay = (TextureAtlasSprite)atlas.apply(WATER_OVERLAY);
        ShipWaterPocketExternalWaterCull.SHADER.waterStillUv.m_5805_(still.m_118409_(), still.m_118411_(), still.m_118410_(), still.m_118412_());
        ShipWaterPocketExternalWaterCull.SHADER.waterFlowUv.m_5805_(flow.m_118409_(), flow.m_118411_(), flow.m_118410_(), flow.m_118412_());
        ShipWaterPocketExternalWaterCull.SHADER.waterOverlayUv.m_5805_(overlay.m_118409_(), overlay.m_118411_(), overlay.m_118410_(), overlay.m_118412_());
        ShipWaterPocketExternalWaterCull.SHADER.waterStillUv.m_85633_();
        ShipWaterPocketExternalWaterCull.SHADER.waterFlowUv.m_85633_();
        ShipWaterPocketExternalWaterCull.SHADER.waterOverlayUv.m_85633_();
    }

    private static void updateCameraAndWaterUvProgram(ProgramHandles handles, Vec3 cameraPos) {
        if (handles.cameraWorldPosLoc >= 0) {
            GL20.glUniform3f((int)handles.cameraWorldPosLoc, (float)((float)cameraPos.f_82479_), (float)((float)cameraPos.f_82480_), (float)((float)cameraPos.f_82481_));
        }
        Function atlas = Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_);
        TextureAtlasSprite still = (TextureAtlasSprite)atlas.apply(WATER_STILL);
        TextureAtlasSprite flow = (TextureAtlasSprite)atlas.apply(WATER_FLOW);
        TextureAtlasSprite overlay = (TextureAtlasSprite)atlas.apply(WATER_OVERLAY);
        if (handles.waterStillUvLoc >= 0) {
            GL20.glUniform4f((int)handles.waterStillUvLoc, (float)still.m_118409_(), (float)still.m_118411_(), (float)still.m_118410_(), (float)still.m_118412_());
        }
        if (handles.waterFlowUvLoc >= 0) {
            GL20.glUniform4f((int)handles.waterFlowUvLoc, (float)flow.m_118409_(), (float)flow.m_118411_(), (float)flow.m_118410_(), (float)flow.m_118412_());
        }
        if (handles.waterOverlayUvLoc >= 0) {
            GL20.glUniform4f((int)handles.waterOverlayUvLoc, (float)overlay.m_118409_(), (float)overlay.m_118411_(), (float)overlay.m_118410_(), (float)overlay.m_118412_());
        }
    }

    private static ResourceLocation[] queryForgeFluidTextures(ClientLevel level, Fluid fluid, FluidState fluidState) {
        if (!ShipWaterPocketExternalWaterCull.ensureForgeFluidTextureAccess()) {
            return null;
        }
        try {
            Object ext = forgeFluidExtOf.invoke(null, fluid);
            if (ext == null) {
                return null;
            }
            ResourceLocation still = ShipWaterPocketExternalWaterCull.invokeTexture(ext, forgeGetStill0, forgeGetStill3, fluidState, level);
            ResourceLocation flow = ShipWaterPocketExternalWaterCull.invokeTexture(ext, forgeGetFlow0, forgeGetFlow3, fluidState, level);
            ResourceLocation overlay = ShipWaterPocketExternalWaterCull.invokeTexture(ext, forgeGetOverlay0, forgeGetOverlay3, fluidState, level);
            if (still == null && flow == null && overlay == null) {
                return null;
            }
            return new ResourceLocation[]{still, flow, overlay};
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static boolean ensureForgeFluidTextureAccess() {
        if (forgeFluidTexturesChecked) {
            return forgeFluidExtOf != null;
        }
        forgeFluidTexturesChecked = true;
        try {
            Class<?> extClass = Class.forName("net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions");
            forgeFluidExtOf = extClass.getMethod("of", Fluid.class);
            forgeGetStill0 = ShipWaterPocketExternalWaterCull.findMethod(extClass, "getStillTexture", new Class[0]);
            forgeGetFlow0 = ShipWaterPocketExternalWaterCull.findMethod(extClass, "getFlowingTexture", new Class[0]);
            forgeGetOverlay0 = ShipWaterPocketExternalWaterCull.findMethod(extClass, "getOverlayTexture", new Class[0]);
            forgeGetStill3 = ShipWaterPocketExternalWaterCull.findMethod(extClass, "getStillTexture", FluidState.class, BlockAndTintGetter.class, BlockPos.class);
            forgeGetFlow3 = ShipWaterPocketExternalWaterCull.findMethod(extClass, "getFlowingTexture", FluidState.class, BlockAndTintGetter.class, BlockPos.class);
            forgeGetOverlay3 = ShipWaterPocketExternalWaterCull.findMethod(extClass, "getOverlayTexture", FluidState.class, BlockAndTintGetter.class, BlockPos.class);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        catch (Throwable t) {
            if (!loggedFluidMaskBuildFailed) {
                loggedFluidMaskBuildFailed = true;
                LOGGER.warn("Failed to query Forge fluid render textures for fluid culling; some modded fluids may not be culled.", t);
            }
            return false;
        }
    }

    private static TextureAtlasSprite[] queryFabricFluidSprites(ClientLevel level, Fluid fluid, FluidState fluidState) {
        if (!ShipWaterPocketExternalWaterCull.ensureFabricFluidTextureAccess()) {
            return null;
        }
        try {
            Object handler = fabricRegistryGetHandler.invoke(fabricFluidRenderHandlerRegistry, fluid);
            if (handler == null) {
                return null;
            }
            return (TextureAtlasSprite[])fabricHandlerGetSprites.invoke(handler, level, BlockPos.f_121853_, fluidState);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static boolean ensureFabricFluidTextureAccess() {
        if (fabricFluidTexturesChecked) {
            return fabricFluidRenderHandlerRegistry != null;
        }
        fabricFluidTexturesChecked = true;
        try {
            Class<?> registryClass = Class.forName("net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry");
            Field instanceField = registryClass.getField("INSTANCE");
            fabricFluidRenderHandlerRegistry = instanceField.get(null);
            fabricRegistryGetHandler = registryClass.getMethod("get", Fluid.class);
            Class<?> handlerClass = Class.forName("net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler");
            fabricHandlerGetSprites = handlerClass.getMethod("getFluidSprites", BlockAndTintGetter.class, BlockPos.class, FluidState.class);
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
        catch (Throwable t) {
            if (!loggedFluidMaskBuildFailed) {
                loggedFluidMaskBuildFailed = true;
                LOGGER.warn("Failed to query Fabric fluid sprites for fluid culling; some modded fluids may not be culled.", t);
            }
            return false;
        }
    }

    private static List<LoadedShip> selectClosestShips(ClientLevel level, Vec3 cameraPos, int maxCount) {
        ArrayList<LoadedShip> candidates = new ArrayList<LoadedShip>();
        for (LoadedShip ship2 : VSGameUtilsKt.getShipObjectWorld((ClientLevel)level).getLoadedShips()) {
            candidates.add(ship2);
        }
        candidates.sort(Comparator.comparingDouble(ship -> ShipWaterPocketExternalWaterCull.distanceSqToShipAabb(cameraPos, ship)));
        if (candidates.size() > maxCount) {
            return candidates.subList(0, maxCount);
        }
        return candidates;
    }

    private static double distanceSqToShipAabb(Vec3 cameraPos, LoadedShip ship) {
        AABBdc shipWorldAabbDc = ShipWaterPocketExternalWaterCull.getShipWorldAabb(ship).orElse(null);
        if (shipWorldAabbDc == null) {
            return Double.POSITIVE_INFINITY;
        }
        double closestX = Mth.m_14008_((double)cameraPos.f_82479_, (double)shipWorldAabbDc.minX(), (double)shipWorldAabbDc.maxX());
        double closestY = Mth.m_14008_((double)cameraPos.f_82480_, (double)shipWorldAabbDc.minY(), (double)shipWorldAabbDc.maxY());
        double closestZ = Mth.m_14008_((double)cameraPos.f_82481_, (double)shipWorldAabbDc.minZ(), (double)shipWorldAabbDc.maxZ());
        double dx = closestX - cameraPos.f_82479_;
        double dy = closestY - cameraPos.f_82480_;
        double dz = closestZ - cameraPos.f_82481_;
        return dx * dx + dy * dy + dz * dz;
    }

    private static Optional<AABBdc> getShipWorldAabb(LoadedShip ship) {
        if (ship instanceof ClientShip) {
            ClientShip clientShip = (ClientShip)ship;
            return Optional.ofNullable(clientShip.getRenderAABB());
        }
        return Optional.ofNullable(ship.getWorldAABB());
    }

    private static ShipTransform getShipTransform(LoadedShip ship) {
        if (ship instanceof ClientShip) {
            ClientShip clientShip = (ClientShip)ship;
            return clientShip.getRenderTransform();
        }
        return ship.getShipTransform();
    }

    private static void updateShipUniformsAndMasks(ClientLevel level, List<LoadedShip> ships, double cameraX, double cameraY, double cameraZ) {
        long gameTime = level.m_46467_();
        for (int slot = 0; slot < 9; ++slot) {
            boolean boundsChanged;
            if (slot >= ships.size()) {
                ShipWaterPocketExternalWaterCull.disableShipSlot(slot);
                continue;
            }
            LoadedShip ship = ships.get(slot);
            long shipId = ship.getId();
            AABBdc shipWorldAabbDc = ShipWaterPocketExternalWaterCull.getShipWorldAabb(ship).orElse(null);
            if (shipWorldAabbDc == null) {
                ShipWaterPocketExternalWaterCull.disableShipSlot(slot);
                continue;
            }
            ShipWaterPocketManager.ClientWaterReachableSnapshot snapshot = ShipWaterPocketManager.getClientWaterReachableSnapshot((Level)level, shipId);
            if (snapshot == null) {
                ShipWaterPocketExternalWaterCull.disableShipSlot(slot);
                continue;
            }
            ShipMasks masks = SHIP_MASKS.computeIfAbsent(shipId, ShipMasks::new);
            int minX = snapshot.getMinX();
            int minY = snapshot.getMinY();
            int minZ = snapshot.getMinZ();
            int sizeX = snapshot.getSizeX();
            int sizeY = snapshot.getSizeY();
            int sizeZ = snapshot.getSizeZ();
            long geometryRevision = snapshot.getGeometryRevision();
            boolean bl = boundsChanged = masks.minX != minX || masks.minY != minY || masks.minZ != minZ || masks.sizeX != sizeX || masks.sizeY != sizeY || masks.sizeZ != sizeZ;
            if (boundsChanged || masks.geometryRevision != geometryRevision) {
                ShipWaterPocketExternalWaterCull.rebuildMask(level, masks, snapshot, minX, minY, minZ, sizeX, sizeY, sizeZ, geometryRevision);
            }
            ShipWaterPocketExternalWaterCull.applyPendingMaskBuild(masks, geometryRevision);
            ShipTransform shipTransform = ShipWaterPocketExternalWaterCull.getShipTransform(ship);
            Matrix4dc worldToShip = shipTransform.getWorldToShip();
            double biasedM30 = worldToShip.m30() - (double)minX;
            double biasedM31 = worldToShip.m31() - (double)minY;
            double biasedM32 = worldToShip.m32() - (double)minZ;
            ShipWaterPocketExternalWaterCull.SHADER.shader.m_173350_("ValkyrienAir_Mask" + slot, (Object)masks.maskTexId);
            ShipWaterPocketExternalWaterCull.SHADER.shipAabbMin[slot].m_5805_((float)shipWorldAabbDc.minX(), (float)shipWorldAabbDc.minY(), (float)shipWorldAabbDc.minZ(), 0.0f);
            ShipWaterPocketExternalWaterCull.SHADER.shipAabbMax[slot].m_5805_((float)shipWorldAabbDc.maxX(), (float)shipWorldAabbDc.maxY(), (float)shipWorldAabbDc.maxZ(), 0.0f);
            ShipWaterPocketExternalWaterCull.SHADER.gridMin[slot].m_5805_(0.0f, 0.0f, 0.0f, 0.0f);
            ShipWaterPocketExternalWaterCull.SHADER.gridSize[slot].m_5805_((float)sizeX, (float)sizeY, (float)sizeZ, 0.0f);
            masks.worldToShip.set((float)worldToShip.m00(), (float)worldToShip.m01(), (float)worldToShip.m02(), (float)worldToShip.m03(), (float)worldToShip.m10(), (float)worldToShip.m11(), (float)worldToShip.m12(), (float)worldToShip.m13(), (float)worldToShip.m20(), (float)worldToShip.m21(), (float)worldToShip.m22(), (float)worldToShip.m23(), (float)biasedM30, (float)biasedM31, (float)biasedM32, (float)worldToShip.m33());
            ShipWaterPocketExternalWaterCull.SHADER.worldToShip[slot].m_5679_(masks.worldToShip);
            double camShipX = worldToShip.m00() * cameraX + worldToShip.m10() * cameraY + worldToShip.m20() * cameraZ + biasedM30;
            double camShipY = worldToShip.m01() * cameraX + worldToShip.m11() * cameraY + worldToShip.m21() * cameraZ + biasedM31;
            double camShipZ = worldToShip.m02() * cameraX + worldToShip.m12() * cameraY + worldToShip.m22() * cameraZ + biasedM32;
            ShipWaterPocketExternalWaterCull.SHADER.cameraShipPos[slot].m_5889_((float)camShipX, (float)camShipY, (float)camShipZ);
            ShipWaterPocketExternalWaterCull.SHADER.shipAabbMin[slot].m_85633_();
            ShipWaterPocketExternalWaterCull.SHADER.shipAabbMax[slot].m_85633_();
            ShipWaterPocketExternalWaterCull.SHADER.cameraShipPos[slot].m_85633_();
            ShipWaterPocketExternalWaterCull.SHADER.gridMin[slot].m_85633_();
            ShipWaterPocketExternalWaterCull.SHADER.gridSize[slot].m_85633_();
            ShipWaterPocketExternalWaterCull.SHADER.worldToShip[slot].m_85633_();
        }
        LongOpenHashSet loadedIds = new LongOpenHashSet();
        for (LoadedShip loadedShip : VSGameUtilsKt.getShipObjectWorld((ClientLevel)level).getLoadedShips()) {
            loadedIds.add(loadedShip.getId());
        }
        SHIP_MASKS.entrySet().removeIf(entry -> {
            if (loadedIds.contains(entry.getKey())) {
                return false;
            }
            ((ShipMasks)entry.getValue()).close();
            return true;
        });
    }

    private static void updateShipUniformsAndMasksProgram(ProgramHandles handles, ClientLevel level, List<LoadedShip> ships, double cameraX, double cameraY, double cameraZ) {
        long gameTime = level.m_46467_();
        for (int slot = 0; slot < 9; ++slot) {
            boolean boundsChanged;
            if (!handles.shipSlotSupported[slot]) {
                ShipWaterPocketExternalWaterCull.disableShipSlotProgram(handles, slot);
                continue;
            }
            if (slot >= ships.size()) {
                ShipWaterPocketExternalWaterCull.disableShipSlotProgram(handles, slot);
                continue;
            }
            LoadedShip ship = ships.get(slot);
            long shipId = ship.getId();
            AABBdc shipWorldAabbDc = ShipWaterPocketExternalWaterCull.getShipWorldAabb(ship).orElse(null);
            if (shipWorldAabbDc == null) {
                ShipWaterPocketExternalWaterCull.disableShipSlotProgram(handles, slot);
                continue;
            }
            ShipWaterPocketManager.ClientWaterReachableSnapshot snapshot = ShipWaterPocketManager.getClientWaterReachableSnapshot((Level)level, shipId);
            if (snapshot == null) {
                ShipWaterPocketExternalWaterCull.disableShipSlotProgram(handles, slot);
                continue;
            }
            ShipMasks masks = SHIP_MASKS.computeIfAbsent(shipId, ShipMasks::new);
            int minX = snapshot.getMinX();
            int minY = snapshot.getMinY();
            int minZ = snapshot.getMinZ();
            int sizeX = snapshot.getSizeX();
            int sizeY = snapshot.getSizeY();
            int sizeZ = snapshot.getSizeZ();
            long geometryRevision = snapshot.getGeometryRevision();
            boolean bl = boundsChanged = masks.minX != minX || masks.minY != minY || masks.minZ != minZ || masks.sizeX != sizeX || masks.sizeY != sizeY || masks.sizeZ != sizeZ;
            if (boundsChanged || masks.geometryRevision != geometryRevision) {
                ShipWaterPocketExternalWaterCull.rebuildMask(level, masks, snapshot, minX, minY, minZ, sizeX, sizeY, sizeZ, geometryRevision);
            }
            ShipWaterPocketExternalWaterCull.applyPendingMaskBuild(masks, geometryRevision);
            ShipTransform shipTransform = ShipWaterPocketExternalWaterCull.getShipTransform(ship);
            Matrix4dc worldToShip = shipTransform.getWorldToShip();
            double biasedM30 = worldToShip.m30() - (double)minX;
            double biasedM31 = worldToShip.m31() - (double)minY;
            double biasedM32 = worldToShip.m32() - (double)minZ;
            ShipWaterPocketExternalWaterCull.bindProgramMaskTexture(handles, slot, masks.maskTexId);
            if (handles.shipAabbMinLoc[slot] >= 0) {
                GL20.glUniform4f((int)handles.shipAabbMinLoc[slot], (float)((float)shipWorldAabbDc.minX()), (float)((float)shipWorldAabbDc.minY()), (float)((float)shipWorldAabbDc.minZ()), (float)0.0f);
            }
            if (handles.shipAabbMaxLoc[slot] >= 0) {
                GL20.glUniform4f((int)handles.shipAabbMaxLoc[slot], (float)((float)shipWorldAabbDc.maxX()), (float)((float)shipWorldAabbDc.maxY()), (float)((float)shipWorldAabbDc.maxZ()), (float)0.0f);
            }
            if (handles.gridMinLoc[slot] >= 0) {
                GL20.glUniform4f((int)handles.gridMinLoc[slot], (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            }
            if (handles.gridSizeLoc[slot] >= 0) {
                GL20.glUniform4f((int)handles.gridSizeLoc[slot], (float)sizeX, (float)sizeY, (float)sizeZ, (float)0.0f);
            }
            masks.worldToShip.set((float)worldToShip.m00(), (float)worldToShip.m01(), (float)worldToShip.m02(), (float)worldToShip.m03(), (float)worldToShip.m10(), (float)worldToShip.m11(), (float)worldToShip.m12(), (float)worldToShip.m13(), (float)worldToShip.m20(), (float)worldToShip.m21(), (float)worldToShip.m22(), (float)worldToShip.m23(), (float)biasedM30, (float)biasedM31, (float)biasedM32, (float)worldToShip.m33());
            ShipWaterPocketExternalWaterCull.uploadMatrixUniform(handles.worldToShipLoc[slot], masks.worldToShip);
            double camShipX = worldToShip.m00() * cameraX + worldToShip.m10() * cameraY + worldToShip.m20() * cameraZ + biasedM30;
            double camShipY = worldToShip.m01() * cameraX + worldToShip.m11() * cameraY + worldToShip.m21() * cameraZ + biasedM31;
            double camShipZ = worldToShip.m02() * cameraX + worldToShip.m12() * cameraY + worldToShip.m22() * cameraZ + biasedM32;
            if (handles.cameraShipPosLoc[slot] < 0) continue;
            GL20.glUniform3f((int)handles.cameraShipPosLoc[slot], (float)((float)camShipX), (float)((float)camShipY), (float)((float)camShipZ));
        }
        LongOpenHashSet loadedIds = new LongOpenHashSet();
        for (LoadedShip loadedShip : VSGameUtilsKt.getShipObjectWorld((ClientLevel)level).getLoadedShips()) {
            loadedIds.add(loadedShip.getId());
        }
        SHIP_MASKS.entrySet().removeIf(entry -> {
            if (loadedIds.contains(entry.getKey())) {
                return false;
            }
            ((ShipMasks)entry.getValue()).close();
            return true;
        });
    }

    private static void disableShipSlot(int slot) {
        ShipWaterPocketExternalWaterCull.SHADER.shader.m_173350_("ValkyrienAir_Mask" + slot, (Object)0);
        ShipWaterPocketExternalWaterCull.SHADER.shipAabbMin[slot].m_5805_(0.0f, 0.0f, 0.0f, 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.shipAabbMax[slot].m_5805_(-1.0f, -1.0f, -1.0f, 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.cameraShipPos[slot].m_5889_(0.0f, 0.0f, 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.gridMin[slot].m_5805_(0.0f, 0.0f, 0.0f, 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.gridSize[slot].m_5805_(0.0f, 0.0f, 0.0f, 0.0f);
        ShipWaterPocketExternalWaterCull.SHADER.worldToShip[slot].m_5679_(IDENTITY_MAT4);
        ShipWaterPocketExternalWaterCull.SHADER.shipAabbMin[slot].m_85633_();
        ShipWaterPocketExternalWaterCull.SHADER.shipAabbMax[slot].m_85633_();
        ShipWaterPocketExternalWaterCull.SHADER.cameraShipPos[slot].m_85633_();
        ShipWaterPocketExternalWaterCull.SHADER.gridMin[slot].m_85633_();
        ShipWaterPocketExternalWaterCull.SHADER.gridSize[slot].m_85633_();
        ShipWaterPocketExternalWaterCull.SHADER.worldToShip[slot].m_85633_();
    }

    private static void disableShipSlotProgram(ProgramHandles handles, int slot) {
        if (handles.shipAabbMinLoc[slot] >= 0) {
            GL20.glUniform4f((int)handles.shipAabbMinLoc[slot], (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        }
        if (handles.shipAabbMaxLoc[slot] >= 0) {
            GL20.glUniform4f((int)handles.shipAabbMaxLoc[slot], (float)-1.0f, (float)-1.0f, (float)-1.0f, (float)0.0f);
        }
        if (handles.cameraShipPosLoc[slot] >= 0) {
            GL20.glUniform3f((int)handles.cameraShipPosLoc[slot], (float)0.0f, (float)0.0f, (float)0.0f);
        }
        if (handles.gridMinLoc[slot] >= 0) {
            GL20.glUniform4f((int)handles.gridMinLoc[slot], (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        }
        if (handles.gridSizeLoc[slot] >= 0) {
            GL20.glUniform4f((int)handles.gridSizeLoc[slot], (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        }
        ShipWaterPocketExternalWaterCull.uploadMatrixUniform(handles.worldToShipLoc[slot], IDENTITY_MAT4);
        if (slot < handles.maxMaskSlots) {
            ShipWaterPocketExternalWaterCull.bindProgramMaskTexture(handles, slot, 0);
        }
    }

    private static void bindProgramMaskTexture(ProgramHandles handles, int slot, int maskTexId) {
        if (handles == null) {
            return;
        }
        if (slot < 0 || slot >= handles.maxMaskSlots) {
            return;
        }
        int unit = 2 + slot;
        if (unit < 0 || unit >= handles.maxSafeTextureUnits) {
            return;
        }
        if (handles.maskLoc[slot] >= 0) {
            GL20.glUniform1i((int)handles.maskLoc[slot], (int)unit);
        }
        GlStateManager._activeTexture((int)(33984 + unit));
        GlStateManager._bindTexture((int)maskTexId);
        GlStateManager._activeTexture((int)33984);
    }

    private static void bindProgramFluidMaskTexture(ProgramHandles handles, int fluidMaskTexId) {
        if (handles == null) {
            return;
        }
        if (handles.fluidMaskLoc < 0) {
            return;
        }
        int fluidUnit = 2 + handles.maxMaskSlots;
        if (fluidUnit < 0 || fluidUnit >= handles.maxSafeTextureUnits) {
            return;
        }
        GL20.glUniform1i((int)handles.fluidMaskLoc, (int)fluidUnit);
        GlStateManager._activeTexture((int)(33984 + fluidUnit));
        GlStateManager._bindTexture((int)fluidMaskTexId);
        GlStateManager._activeTexture((int)33984);
    }

    private static void uploadMatrixUniform(int location, Matrix4f matrix) {
        if (location < 0) {
            return;
        }
        FloatBuffer buffer = MATRIX_BUFFER.get();
        buffer.clear();
        matrix.get(buffer);
        buffer.position(16);
        buffer.flip();
        GL20.glUniformMatrix4fv((int)location, (boolean)false, (FloatBuffer)buffer);
    }

    private static void rebuildMask(ClientLevel level, ShipMasks masks, ShipWaterPocketManager.ClientWaterReachableSnapshot snapshot, int minX, int minY, int minZ, int sizeX, int sizeY, int sizeZ, long geometryRevision) {
        masks.geometryRevision = geometryRevision;
        masks.minX = minX;
        masks.minY = minY;
        masks.minZ = minZ;
        masks.sizeX = sizeX;
        masks.sizeY = sizeY;
        masks.sizeZ = sizeZ;
        int volume = sizeX * sizeY * sizeZ;
        ShipWaterPocketExternalWaterCull.ensureMaskTextureStorage(masks, volume);
        ShipWaterPocketExternalWaterCull.applyPendingMaskBuild(masks, geometryRevision);
        if (masks.lastMaskUploadRevision == geometryRevision && masks.maskTexId != 0) {
            return;
        }
        if (masks.pendingMaskWordsFuture != null && masks.pendingMaskBuildRevision == geometryRevision) {
            return;
        }
        VoxelShape[] shapeSnapshot = new VoxelShape[volume];
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int idx = 0;
        for (int lz = 0; lz < sizeZ; ++lz) {
            for (int ly = 0; ly < sizeY; ++ly) {
                for (int lx = 0; lx < sizeX; ++lx) {
                    pos.m_122178_(minX + lx, minY + ly, minZ + lz);
                    BlockState state = level.m_8055_((BlockPos)pos);
                    VoxelShape shape = state.m_60768_((BlockGetter)level, (BlockPos)pos);
                    if (shape.m_83281_()) {
                        shape = state.m_60812_((BlockGetter)level, (BlockPos)pos);
                    }
                    shapeSnapshot[idx++] = shape;
                }
            }
        }
        BitSet interiorSnapshot = snapshot.getInterior() == null ? new BitSet() : (BitSet)snapshot.getInterior().clone();
        Supplier<int[]> task = () -> {
            int[] occWords = ShipWaterPocketAsyncCull.buildOccMaskWords(shapeSnapshot, sizeX, sizeY, sizeZ, 8);
            int[] airWords = ShipWaterPocketAsyncCull.buildAirMaskWords(interiorSnapshot, volume);
            int[] out = new int[occWords.length + airWords.length];
            System.arraycopy(occWords, 0, out, 0, occWords.length);
            System.arraycopy(airWords, 0, out, occWords.length, airWords.length);
            return out;
        };
        CompletableFuture<int[]> submitted = ShipPocketAsyncRuntime.trySubmitJava(ShipPocketAsyncSubsystem.CLIENT_CULL, task);
        if (submitted == null) {
            if (masks.pendingMaskWordsFuture != null) {
                masks.pendingMaskWordsFuture.cancel(true);
                masks.pendingMaskWordsFuture = null;
            }
            ShipWaterPocketExternalWaterCull.applyMaskWords(masks, task.get(), geometryRevision);
            return;
        }
        if (masks.pendingMaskWordsFuture != null) {
            masks.pendingMaskWordsFuture.cancel(true);
        }
        masks.pendingMaskWordsFuture = submitted;
        masks.pendingMaskBuildRevision = geometryRevision;
    }

    private static void ensureMaskTextureStorage(ShipMasks masks, int volume) {
        int occWordCount = volume * 16;
        int airWordCount = volume + 31 >> 5;
        int wordCount = occWordCount + airWordCount;
        int height = Math.max(1, (wordCount + 4096 - 1) / 4096);
        boolean newOrResized = false;
        if (masks.maskTexId != 0 && masks.maskTexHeight != height) {
            TextureUtil.releaseTextureId((int)masks.maskTexId);
            masks.maskTexId = 0;
            newOrResized = true;
        }
        int prevId = masks.maskTexId;
        masks.maskTexId = ShipWaterPocketExternalWaterCull.ensureIntTexture(masks.maskTexId, 4096, height);
        masks.maskTexHeight = height;
        if ((newOrResized |= prevId == 0 && masks.maskTexId != 0) && masks.maskTexId != 0) {
            int capacity = 4096 * height;
            if (masks.maskData == null || masks.maskData.length != capacity) {
                masks.maskData = new int[capacity];
                masks.maskBuffer = BufferUtils.createIntBuffer((int)capacity);
            } else {
                Arrays.fill(masks.maskData, 0);
            }
            masks.maskBuffer.clear();
            masks.maskBuffer.put(masks.maskData);
            masks.maskBuffer.flip();
            ShipWaterPocketExternalWaterCull.uploadIntTexture(masks.maskTexId, 4096, height, masks.maskBuffer);
            masks.lastMaskUploadRevision = Long.MIN_VALUE;
        }
    }

    private static void applyPendingMaskBuild(ShipMasks masks, long currentGeometryRevision) {
        int[] words;
        CompletableFuture<int[]> pending = masks.pendingMaskWordsFuture;
        if (pending == null || !pending.isDone()) {
            return;
        }
        long uploadRevision = masks.pendingMaskBuildRevision;
        masks.pendingMaskWordsFuture = null;
        if (uploadRevision != currentGeometryRevision) {
            return;
        }
        try {
            words = pending.join();
        }
        catch (Throwable ignored) {
            return;
        }
        ShipWaterPocketExternalWaterCull.applyMaskWords(masks, words, uploadRevision);
    }

    private static void applyMaskWords(ShipMasks masks, int[] words, long uploadRevision) {
        if (masks.maskTexId == 0) {
            return;
        }
        int capacity = 4096 * masks.maskTexHeight;
        if (masks.maskData == null || masks.maskData.length != capacity) {
            masks.maskData = new int[capacity];
            masks.maskBuffer = BufferUtils.createIntBuffer((int)capacity);
        } else {
            Arrays.fill(masks.maskData, 0);
        }
        int maxWords = Math.min(words.length, masks.maskData.length);
        for (int wordIdx = 0; wordIdx < maxWords; ++wordIdx) {
            int texIdx = (wordIdx & 0xFFF) + (wordIdx >> 12) * 4096;
            if (texIdx < 0 || texIdx >= masks.maskData.length) continue;
            masks.maskData[texIdx] = words[wordIdx];
        }
        masks.maskBuffer.clear();
        masks.maskBuffer.put(masks.maskData);
        masks.maskBuffer.flip();
        ShipWaterPocketExternalWaterCull.uploadIntTexture(masks.maskTexId, 4096, masks.maskTexHeight, masks.maskBuffer);
        masks.lastMaskUploadRevision = uploadRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int ensureFluidMaskTexture(ClientLevel level) {
        boolean needsRebuild;
        if (level == null) {
            return 0;
        }
        Minecraft mc = Minecraft.m_91087_();
        AbstractTexture atlasTexture = mc.m_91097_().m_118506_(InventoryMenu.f_39692_);
        if (atlasTexture == null) {
            return 0;
        }
        int atlasTexId = atlasTexture.m_117963_();
        if (atlasTexId == 0) {
            return 0;
        }
        int atlasWidth = 0;
        int atlasHeight = 0;
        int prevBinding = GL11.glGetInteger((int)32873);
        try {
            GlStateManager._bindTexture((int)atlasTexId);
            atlasWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            atlasHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        }
        finally {
            GlStateManager._bindTexture((int)prevBinding);
        }
        if (atlasWidth <= 0 || atlasHeight <= 0) {
            return 0;
        }
        if (fluidMaskTexId != 0 && (fluidMaskWidth != atlasWidth || fluidMaskHeight != atlasHeight)) {
            TextureUtil.releaseTextureId((int)fluidMaskTexId);
            fluidMaskTexId = 0;
        }
        fluidMaskTexId = ShipWaterPocketExternalWaterCull.ensureByteTexture(fluidMaskTexId, atlasWidth, atlasHeight);
        fluidMaskWidth = atlasWidth;
        fluidMaskHeight = atlasHeight;
        ShipWaterPocketExternalWaterCull.applyPendingFluidMaskBuild(atlasTexId, atlasWidth, atlasHeight);
        boolean bl = needsRebuild = fluidMaskTexId == 0 || fluidMaskWidth != atlasWidth || fluidMaskHeight != atlasHeight || fluidMaskLastAtlasTexId != atlasTexId;
        if (!needsRebuild) {
            return fluidMaskTexId;
        }
        if (pendingFluidMaskFuture != null && pendingFluidMaskAtlasTexId == atlasTexId && pendingFluidMaskWidth == atlasWidth && pendingFluidMaskHeight == atlasHeight) {
            return fluidMaskTexId;
        }
        Function atlas = mc.m_91258_(InventoryMenu.f_39692_);
        ArrayList<TextureAtlasSprite> sprites = new ArrayList<TextureAtlasSprite>();
        sprites.add((TextureAtlasSprite)atlas.apply(WATER_STILL));
        sprites.add((TextureAtlasSprite)atlas.apply(WATER_FLOW));
        sprites.add((TextureAtlasSprite)atlas.apply(WATER_OVERLAY));
        sprites.add((TextureAtlasSprite)atlas.apply(LAVA_STILL));
        sprites.add((TextureAtlasSprite)atlas.apply(LAVA_FLOW));
        HashSet<ResourceLocation> textureIds = new HashSet<ResourceLocation>();
        for (Fluid regFluid : BuiltInRegistries.f_257020_) {
            try {
                Fluid fluid;
                if (regFluid instanceof FlowingFluid) {
                    FlowingFluid flowing = (FlowingFluid)regFluid;
                    fluid = flowing.m_5613_();
                } else {
                    fluid = regFluid;
                }
                Fluid fluid2 = fluid;
                FluidState fs = fluid2.m_76145_();
                ResourceLocation[] forge = ShipWaterPocketExternalWaterCull.queryForgeFluidTextures(level, fluid2, fs);
                if (forge != null) {
                    if (forge.length > 0 && forge[0] != null && textureIds.add(forge[0])) {
                        sprites.add((TextureAtlasSprite)atlas.apply(forge[0]));
                    }
                    if (forge.length > 1 && forge[1] != null && textureIds.add(forge[1])) {
                        sprites.add((TextureAtlasSprite)atlas.apply(forge[1]));
                    }
                    if (forge.length <= 2 || forge[2] == null || !textureIds.add(forge[2])) continue;
                    sprites.add((TextureAtlasSprite)atlas.apply(forge[2]));
                    continue;
                }
                TextureAtlasSprite[] fabric = ShipWaterPocketExternalWaterCull.queryFabricFluidSprites(level, fluid2, fs);
                if (fabric == null) continue;
                for (TextureAtlasSprite sprite : fabric) {
                    if (sprite == null) continue;
                    sprites.add(sprite);
                }
            }
            catch (Throwable fluid2) {
            }
        }
        HashSet<ResourceLocation> seenSprites = new HashSet<ResourceLocation>();
        int[] rects = new int[sprites.size() * 4];
        int rectCount = 0;
        for (TextureAtlasSprite sprite : sprites) {
            ResourceLocation name;
            if (sprite == null || !seenSprites.add(name = sprite.m_245424_().m_246162_())) continue;
            int x0 = sprite.m_174743_();
            int y0 = sprite.m_174744_();
            int w = sprite.m_245424_().m_246492_();
            int h = sprite.m_245424_().m_245330_();
            if (w <= 0 || h <= 0 || x0 < 0 || y0 < 0) continue;
            int x1 = Math.min(atlasWidth, x0 + w);
            int y1 = Math.min(atlasHeight, y0 + h);
            if (x1 <= x0 || y1 <= y0) continue;
            int base = rectCount * 4;
            rects[base] = x0;
            rects[base + 1] = y0;
            rects[base + 2] = x1;
            rects[base + 3] = y1;
            ++rectCount;
        }
        int buildWidth = atlasWidth;
        int buildHeight = atlasHeight;
        int[] rectPayload = Arrays.copyOf(rects, rectCount * 4);
        Supplier<byte[]> task = () -> ShipWaterPocketAsyncCull.paintFluidMask(buildWidth, buildHeight, rectPayload);
        CompletableFuture<byte[]> submitted = ShipPocketAsyncRuntime.trySubmitJava(ShipPocketAsyncSubsystem.CLIENT_CULL, task);
        if (submitted == null) {
            if (pendingFluidMaskFuture != null) {
                pendingFluidMaskFuture.cancel(true);
                pendingFluidMaskFuture = null;
            }
            ShipWaterPocketExternalWaterCull.applyFluidMaskBytes(task.get(), atlasWidth, atlasHeight, atlasTexId);
            return fluidMaskTexId;
        }
        if (pendingFluidMaskFuture != null) {
            pendingFluidMaskFuture.cancel(true);
        }
        pendingFluidMaskFuture = submitted;
        pendingFluidMaskAtlasTexId = atlasTexId;
        pendingFluidMaskWidth = atlasWidth;
        pendingFluidMaskHeight = atlasHeight;
        return fluidMaskTexId;
    }

    private static void applyPendingFluidMaskBuild(int atlasTexId, int atlasWidth, int atlasHeight) {
        byte[] bytes;
        if (pendingFluidMaskFuture == null || !pendingFluidMaskFuture.isDone()) {
            return;
        }
        if (pendingFluidMaskAtlasTexId != atlasTexId || pendingFluidMaskWidth != atlasWidth || pendingFluidMaskHeight != atlasHeight) {
            pendingFluidMaskFuture = null;
            return;
        }
        try {
            bytes = pendingFluidMaskFuture.join();
        }
        catch (Throwable ignored) {
            pendingFluidMaskFuture = null;
            return;
        }
        pendingFluidMaskFuture = null;
        ShipWaterPocketExternalWaterCull.applyFluidMaskBytes(bytes, atlasWidth, atlasHeight, atlasTexId);
    }

    private static void applyFluidMaskBytes(byte[] bytes, int atlasWidth, int atlasHeight, int atlasTexId) {
        int capacity = atlasWidth * atlasHeight;
        if (fluidMaskData == null || fluidMaskData.length != capacity) {
            fluidMaskData = new byte[capacity];
            fluidMaskBuffer = BufferUtils.createByteBuffer((int)capacity);
        }
        Arrays.fill(fluidMaskData, (byte)0);
        System.arraycopy(bytes, 0, fluidMaskData, 0, Math.min(bytes.length, fluidMaskData.length));
        fluidMaskBuffer.clear();
        fluidMaskBuffer.put(fluidMaskData);
        fluidMaskBuffer.flip();
        ShipWaterPocketExternalWaterCull.uploadByteTexture(fluidMaskTexId, atlasWidth, atlasHeight, fluidMaskBuffer);
        fluidMaskLastAtlasTexId = atlasTexId;
    }

    private static Method findMethod(Class<?> owner, String name, Class<?> ... params) {
        try {
            return owner.getMethod(name, params);
        }
        catch (NoSuchMethodException ignored) {}
        finally {
            return null;
        }
    }

    private static ResourceLocation invokeTexture(Object ext, Method noArgs, Method withState, FluidState fluidState, ClientLevel level) throws Exception {
        Object v;
        if (noArgs != null && (v = noArgs.invoke(ext, new Object[0])) instanceof ResourceLocation) {
            ResourceLocation rl = (ResourceLocation)v;
            return rl;
        }
        if (withState != null && level != null && (v = withState.invoke(ext, fluidState, level, BlockPos.f_121853_)) instanceof ResourceLocation) {
            ResourceLocation rl = (ResourceLocation)v;
            return rl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int ensureIntTexture(int existingId, int width, int height) {
        int prevBinding = GL11.glGetInteger((int)32873);
        int prevUnpackAlignment = GL11.glGetInteger((int)3317);
        try {
            if (existingId != 0) {
                GlStateManager._bindTexture((int)existingId);
                int n = existingId;
                return n;
            }
            int id = TextureUtil.generateTextureId();
            GlStateManager._bindTexture((int)id);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glPixelStorei((int)3317, (int)1);
            GL11.glTexImage2D((int)3553, (int)0, (int)33334, (int)width, (int)height, (int)0, (int)36244, (int)5125, (IntBuffer)null);
            int n = id;
            return n;
        }
        finally {
            GL11.glPixelStorei((int)3317, (int)prevUnpackAlignment);
            GlStateManager._bindTexture((int)prevBinding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int ensureByteTexture(int existingId, int width, int height) {
        int prevBinding = GL11.glGetInteger((int)32873);
        int prevUnpackAlignment = GL11.glGetInteger((int)3317);
        try {
            if (existingId != 0) {
                GlStateManager._bindTexture((int)existingId);
                int n = existingId;
                return n;
            }
            int id = TextureUtil.generateTextureId();
            GlStateManager._bindTexture((int)id);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            GL11.glPixelStorei((int)3317, (int)1);
            GL11.glTexImage2D((int)3553, (int)0, (int)33321, (int)width, (int)height, (int)0, (int)6403, (int)5121, (ByteBuffer)null);
            int n = id;
            return n;
        }
        finally {
            GL11.glPixelStorei((int)3317, (int)prevUnpackAlignment);
            GlStateManager._bindTexture((int)prevBinding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadByteTexture(int texId, int width, int height, ByteBuffer data) {
        int prevBinding = GL11.glGetInteger((int)32873);
        int prevUnpackAlignment = GL11.glGetInteger((int)3317);
        try {
            GlStateManager._bindTexture((int)texId);
            GL11.glPixelStorei((int)3317, (int)1);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)6403, (int)5121, (ByteBuffer)data);
        }
        finally {
            GL11.glPixelStorei((int)3317, (int)prevUnpackAlignment);
            GlStateManager._bindTexture((int)prevBinding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadIntTexture(int texId, int width, int height, IntBuffer data) {
        int prevBinding = GL11.glGetInteger((int)32873);
        int prevUnpackAlignment = GL11.glGetInteger((int)3317);
        try {
            GlStateManager._bindTexture((int)texId);
            GL11.glPixelStorei((int)3317, (int)1);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)36244, (int)5125, (IntBuffer)data);
        }
        finally {
            GL11.glPixelStorei((int)3317, (int)prevUnpackAlignment);
            GlStateManager._bindTexture((int)prevBinding);
        }
    }

    private static final class ShaderHandles {
        private ShaderInstance shader;
        private boolean supported;
        private Uniform cullEnabled;
        private Uniform isShipPass;
        private Uniform cameraWorldPos;
        private Uniform waterStillUv;
        private Uniform waterFlowUv;
        private Uniform waterOverlayUv;
        private Uniform shipWaterTintEnabled;
        private Uniform shipWaterTint;
        private final Uniform[] shipAabbMin = new Uniform[9];
        private final Uniform[] shipAabbMax = new Uniform[9];
        private final Uniform[] cameraShipPos = new Uniform[9];
        private final Uniform[] gridMin = new Uniform[9];
        private final Uniform[] gridSize = new Uniform[9];
        private final Uniform[] worldToShip = new Uniform[9];

        private ShaderHandles() {
        }
    }

    private static final class ShipMasks {
        private final long shipId;
        private long geometryRevision;
        private int minX;
        private int minY;
        private int minZ;
        private int sizeX;
        private int sizeY;
        private int sizeZ;
        private int maskTexId;
        private int maskTexHeight;
        private long lastMaskUploadRevision = Long.MIN_VALUE;
        private final Matrix4f worldToShip = new Matrix4f();
        private int[] maskData;
        private IntBuffer maskBuffer;
        private CompletableFuture<int[]> pendingMaskWordsFuture;
        private long pendingMaskBuildRevision = Long.MIN_VALUE;

        private ShipMasks(long shipId) {
            this.shipId = shipId;
        }

        private void close() {
            if (this.pendingMaskWordsFuture != null) {
                this.pendingMaskWordsFuture.cancel(true);
                this.pendingMaskWordsFuture = null;
            }
            if (this.maskTexId != 0) {
                TextureUtil.releaseTextureId((int)this.maskTexId);
                this.maskTexId = 0;
            }
        }
    }

    private static final class ProgramHandles {
        private final int programId;
        private boolean supported = false;
        private boolean embeddiumChunkProgram = false;
        private int regionOffsetLoc = -1;
        private int blockTexLoc = -1;
        private int cullEnabledLoc = -1;
        private int isShipPassLoc = -1;
        private int cameraWorldPosLoc = -1;
        private int waterStillUvLoc = -1;
        private int waterFlowUvLoc = -1;
        private int waterOverlayUvLoc = -1;
        private int fluidMaskLoc = -1;
        private int shipWaterTintEnabledLoc = -1;
        private int shipWaterTintLoc = -1;
        private int chunkWorldOriginLoc = -1;
        private int maxMaskSlots = 9;
        private int maxSafeTextureUnits = 12;
        private final int[] shipAabbMinLoc = new int[9];
        private final int[] shipAabbMaxLoc = new int[9];
        private final int[] cameraShipPosLoc = new int[9];
        private final int[] gridMinLoc = new int[9];
        private final int[] gridSizeLoc = new int[9];
        private final int[] worldToShipLoc = new int[9];
        private final int[] maskLoc = new int[9];
        private final boolean[] shipSlotSupported = new boolean[9];

        private ProgramHandles(int programId) {
            this.programId = programId;
        }
    }
}

