/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.client.feature.ship_water_pockets;

import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public final class ShipWaterPocketExternalWaterCullRenderContext {
    private static int worldFluidDepth = 0;
    private static int shipRenderDepth = 0;
    @Nullable
    private static ClientLevel level = null;
    private static double camX;
    private static double camY;
    private static double camZ;
    private static boolean fluidChunkLayersInitialized;
    private static final HashSet<RenderType> FLUID_CHUNK_LAYERS;
    private static final int MAX_WORLD_STACK_DEPTH = 8;
    @Nullable
    private static final ClientLevel[] LEVEL_STACK;
    private static final double[] CAM_X_STACK;
    private static final double[] CAM_Y_STACK;
    private static final double[] CAM_Z_STACK;

    private ShipWaterPocketExternalWaterCullRenderContext() {
    }

    private static void ensureFluidChunkLayersInitialized() {
        if (fluidChunkLayersInitialized) {
            return;
        }
        fluidChunkLayersInitialized = true;
        FLUID_CHUNK_LAYERS.clear();
        try {
            for (Fluid fluid : BuiltInRegistries.f_257020_) {
                if (fluid == null) continue;
                if (fluid instanceof FlowingFluid) {
                    FlowingFluid flowing = (FlowingFluid)fluid;
                    ShipWaterPocketExternalWaterCullRenderContext.addFluidChunkLayer(flowing.m_5613_().m_76145_());
                    ShipWaterPocketExternalWaterCullRenderContext.addFluidChunkLayer(flowing.m_5615_().m_76145_());
                    continue;
                }
                ShipWaterPocketExternalWaterCullRenderContext.addFluidChunkLayer(fluid.m_76145_());
            }
        }
        catch (Throwable ignored) {
            FLUID_CHUNK_LAYERS.add(RenderType.m_110466_());
        }
    }

    private static void addFluidChunkLayer(FluidState state) {
        if (state == null || state.m_76178_()) {
            return;
        }
        RenderType layer = ItemBlockRenderTypes.m_109287_((FluidState)state);
        if (layer != null) {
            FLUID_CHUNK_LAYERS.add(layer);
        }
    }

    public static boolean isFluidChunkLayer(RenderType renderType) {
        if (renderType == null) {
            return false;
        }
        ShipWaterPocketExternalWaterCullRenderContext.ensureFluidChunkLayersInitialized();
        return FLUID_CHUNK_LAYERS.contains(renderType);
    }

    public static void beginWorldFluidChunkLayer(ClientLevel level, RenderType renderType, double camX, double camY, double camZ) {
        if (level == null) {
            return;
        }
        if (!ShipWaterPocketExternalWaterCullRenderContext.isFluidChunkLayer(renderType)) {
            return;
        }
        if (worldFluidDepth < 8) {
            int idx = worldFluidDepth;
            ShipWaterPocketExternalWaterCullRenderContext.LEVEL_STACK[idx] = ShipWaterPocketExternalWaterCullRenderContext.level;
            ShipWaterPocketExternalWaterCullRenderContext.CAM_X_STACK[idx] = ShipWaterPocketExternalWaterCullRenderContext.camX;
            ShipWaterPocketExternalWaterCullRenderContext.CAM_Y_STACK[idx] = ShipWaterPocketExternalWaterCullRenderContext.camY;
            ShipWaterPocketExternalWaterCullRenderContext.CAM_Z_STACK[idx] = ShipWaterPocketExternalWaterCullRenderContext.camZ;
        }
        ++worldFluidDepth;
        ShipWaterPocketExternalWaterCullRenderContext.level = level;
        ShipWaterPocketExternalWaterCullRenderContext.camX = camX;
        ShipWaterPocketExternalWaterCullRenderContext.camY = camY;
        ShipWaterPocketExternalWaterCullRenderContext.camZ = camZ;
    }

    public static void endWorldFluidChunkLayer() {
        if (--worldFluidDepth <= 0) {
            worldFluidDepth = 0;
            level = null;
            camX = 0.0;
            camY = 0.0;
            camZ = 0.0;
            return;
        }
        int idx = worldFluidDepth;
        if (idx >= 0 && idx < 8) {
            level = LEVEL_STACK[idx];
            camX = CAM_X_STACK[idx];
            camY = CAM_Y_STACK[idx];
            camZ = CAM_Z_STACK[idx];
            ShipWaterPocketExternalWaterCullRenderContext.LEVEL_STACK[idx] = null;
        }
    }

    public static void beginShipRender() {
        ++shipRenderDepth;
    }

    public static void endShipRender() {
        if (--shipRenderDepth < 0) {
            shipRenderDepth = 0;
        }
    }

    public static void clear() {
        worldFluidDepth = 0;
        level = null;
        camX = 0.0;
        camY = 0.0;
        camZ = 0.0;
        Arrays.fill(LEVEL_STACK, null);
        shipRenderDepth = 0;
        fluidChunkLayersInitialized = false;
        FLUID_CHUNK_LAYERS.clear();
    }

    public static boolean isInWorldFluidChunkLayer() {
        return worldFluidDepth > 0;
    }

    public static boolean isInShipRender() {
        return shipRenderDepth > 0;
    }

    @Nullable
    public static ClientLevel getLevel() {
        return level;
    }

    public static double getCamX() {
        return camX;
    }

    public static double getCamY() {
        return camY;
    }

    public static double getCamZ() {
        return camZ;
    }

    static {
        fluidChunkLayersInitialized = false;
        FLUID_CHUNK_LAYERS = new HashSet();
        LEVEL_STACK = new ClientLevel[8];
        CAM_X_STACK = new double[8];
        CAM_Y_STACK = new double[8];
        CAM_Z_STACK = new double[8];
    }
}

