/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.feature.ship_water_pockets;

import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.PersistedShipPocketState;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketPersistenceKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketSavedData;", "Lnet/minecraft/world/level/saveddata/SavedData;", "", "shipId", "Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/PersistedShipPocketState;", "getState", "(J)Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/PersistedShipPocketState;", "state", "", "putState", "(JLorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/PersistedShipPocketState;)V", "removeState", "(J)V", "Lnet/minecraft/nbt/CompoundTag;", "compoundTag", "save", "(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;", "", "persistedStates", "Ljava/util/Map;", "<init>", "()V", "Companion", "valkyrien-air"})
public final class ShipPocketSavedData
extends SavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Long, PersistedShipPocketState> persistedStates = new HashMap();
    private static final int FORMAT_VERSION = 3;
    @NotNull
    private static final String TAG_FORMAT_VERSION = "format_version";
    @NotNull
    private static final String TAG_SHIPS = "ships";
    @NotNull
    private static final String TAG_SHIP_ID = "ship_id";
    @NotNull
    private static final String TAG_MIN_X = "min_x";
    @NotNull
    private static final String TAG_MIN_Y = "min_y";
    @NotNull
    private static final String TAG_MIN_Z = "min_z";
    @NotNull
    private static final String TAG_SIZE_X = "size_x";
    @NotNull
    private static final String TAG_SIZE_Y = "size_y";
    @NotNull
    private static final String TAG_SIZE_Z = "size_z";
    @NotNull
    private static final String TAG_FLOOD_FLUID = "flood_fluid";
    @NotNull
    private static final String TAG_GEOMETRY_REVISION = "geometry_revision";
    @NotNull
    private static final String TAG_GEOMETRY_SIGNATURE = "geometry_signature";
    @NotNull
    private static final String TAG_OPEN = "open";
    @NotNull
    private static final String TAG_EXTERIOR = "exterior";
    @NotNull
    private static final String TAG_STRICT_INTERIOR = "strict_interior";
    @NotNull
    private static final String TAG_SIMULATION_DOMAIN = "simulation_domain";
    @NotNull
    private static final String TAG_OUTSIDE_VOID = "outside_void";
    @NotNull
    private static final String TAG_INTERIOR = "interior";
    @NotNull
    private static final String TAG_FLOODED = "flooded";
    @NotNull
    private static final String TAG_MATERIALIZED_WATER = "materialized_water";
    @NotNull
    private static final String TAG_WATER_REACHABLE = "water_reachable";
    @NotNull
    private static final String TAG_UNREACHABLE_VOID = "unreachable_void";
    @NotNull
    private static final String TAG_FACE_COND_XP = "face_cond_xp";
    @NotNull
    private static final String TAG_FACE_COND_YP = "face_cond_yp";
    @NotNull
    private static final String TAG_FACE_COND_ZP = "face_cond_zp";
    @NotNull
    private static final String TAG_VOXEL_EXTERIOR_COMPONENT_MASK = "voxel_exterior_component_mask";
    @NotNull
    private static final String TAG_VOXEL_INTERIOR_COMPONENT_MASK = "voxel_interior_component_mask";
    @NotNull
    private static final String TAG_VOXEL_SIMULATION_COMPONENT_MASK = "voxel_simulation_component_mask";
    @NotNull
    private static final String TAG_FLOOD_PLANE_KEYS = "flood_plane_keys";
    @NotNull
    private static final String TAG_FLOOD_PLANE_VALUES = "flood_plane_values";

    @Nullable
    public final PersistedShipPocketState getState(long shipId) {
        return this.persistedStates.get(shipId);
    }

    public final void putState(long shipId, @NotNull PersistedShipPocketState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Long l = shipId;
        this.persistedStates.put(l, state);
        this.m_77762_();
    }

    public final void removeState(long shipId) {
        if (this.persistedStates.remove(shipId) != null) {
            this.m_77762_();
        }
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compoundTag) {
        Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
        compoundTag.m_128405_(TAG_FORMAT_VERSION, 3);
        ListTag ships = new ListTag();
        for (Map.Entry<Long, PersistedShipPocketState> entry : this.persistedStates.entrySet()) {
            ObjectIterator it;
            long shipId = ((Number)entry.getKey()).longValue();
            PersistedShipPocketState state = entry.getValue();
            CompoundTag shipTag = new CompoundTag();
            shipTag.m_128356_(TAG_SHIP_ID, shipId);
            shipTag.m_128405_(TAG_MIN_X, state.getMinX());
            shipTag.m_128405_(TAG_MIN_Y, state.getMinY());
            shipTag.m_128405_(TAG_MIN_Z, state.getMinZ());
            shipTag.m_128405_(TAG_SIZE_X, state.getSizeX());
            shipTag.m_128405_(TAG_SIZE_Y, state.getSizeY());
            shipTag.m_128405_(TAG_SIZE_Z, state.getSizeZ());
            shipTag.m_128359_(TAG_FLOOD_FLUID, ShipPocketSavedData.Companion.fluidRegistryName(state.getFloodFluid()));
            shipTag.m_128356_(TAG_GEOMETRY_REVISION, state.getGeometryRevision());
            shipTag.m_128356_(TAG_GEOMETRY_SIGNATURE, state.getGeometrySignature());
            shipTag.m_128382_(TAG_OPEN, ShipWaterPocketPersistenceKt.access$encodeBitSet(state.getOpen()));
            shipTag.m_128382_(TAG_EXTERIOR, ShipWaterPocketPersistenceKt.access$encodeBitSet(state.getExterior()));
            shipTag.m_128382_(TAG_STRICT_INTERIOR, ShipWaterPocketPersistenceKt.access$encodeBitSet(state.getStrictInterior()));
            shipTag.m_128382_(TAG_SIMULATION_DOMAIN, ShipWaterPocketPersistenceKt.access$encodeBitSet(state.getSimulationDomain()));
            shipTag.m_128382_(TAG_OUTSIDE_VOID, ShipWaterPocketPersistenceKt.access$encodeBitSet(state.getOutsideVoid()));
            shipTag.m_128382_(TAG_INTERIOR, ShipWaterPocketPersistenceKt.access$encodeBitSet(state.getInterior()));
            shipTag.m_128382_(TAG_FLOODED, ShipWaterPocketPersistenceKt.access$encodeBitSet(state.getFlooded()));
            shipTag.m_128382_(TAG_MATERIALIZED_WATER, ShipWaterPocketPersistenceKt.access$encodeBitSet(state.getMaterializedWater()));
            shipTag.m_128382_(TAG_WATER_REACHABLE, ShipWaterPocketPersistenceKt.access$encodeBitSet(state.getWaterReachable()));
            shipTag.m_128382_(TAG_UNREACHABLE_VOID, ShipWaterPocketPersistenceKt.access$encodeBitSet(state.getUnreachableVoid()));
            shipTag.m_128382_(TAG_FACE_COND_XP, ShipWaterPocketPersistenceKt.access$encodeShortArray(state.getFaceCondXP()));
            shipTag.m_128382_(TAG_FACE_COND_YP, ShipWaterPocketPersistenceKt.access$encodeShortArray(state.getFaceCondYP()));
            shipTag.m_128382_(TAG_FACE_COND_ZP, ShipWaterPocketPersistenceKt.access$encodeShortArray(state.getFaceCondZP()));
            shipTag.m_128382_(TAG_VOXEL_EXTERIOR_COMPONENT_MASK, ShipWaterPocketPersistenceKt.access$encodeLongArray(state.getVoxelExteriorComponentMask()));
            shipTag.m_128382_(TAG_VOXEL_INTERIOR_COMPONENT_MASK, ShipWaterPocketPersistenceKt.access$encodeLongArray(state.getVoxelInteriorComponentMask()));
            shipTag.m_128382_(TAG_VOXEL_SIMULATION_COMPONENT_MASK, ShipWaterPocketPersistenceKt.access$encodeLongArray(state.getVoxelSimulationComponentMask()));
            int planeCount = state.getFloodPlaneByComponent().size();
            int[] planeKeys = new int[planeCount];
            long[] planeValues = new long[planeCount];
            int i = 0;
            Intrinsics.checkNotNullExpressionValue((Object)state.getFloodPlaneByComponent().int2DoubleEntrySet().iterator(), (String)"iterator(...)");
            while (it.hasNext()) {
                Int2DoubleMap.Entry entry2 = (Int2DoubleMap.Entry)it.next();
                planeKeys[i] = entry2.getIntKey();
                planeValues[i] = Double.doubleToLongBits(entry2.getDoubleValue());
                ++i;
            }
            shipTag.m_128385_(TAG_FLOOD_PLANE_KEYS, planeKeys);
            shipTag.m_128388_(TAG_FLOOD_PLANE_VALUES, planeValues);
            ships.add((Object)shipTag);
        }
        compoundTag.m_128365_(TAG_SHIPS, (Tag)ships);
        return compoundTag;
    }

    @JvmStatic
    @NotNull
    public static final ShipPocketSavedData load(@NotNull CompoundTag compoundTag) {
        return Companion.load(compoundTag);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b$\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b3\u00104J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0015R\u0014\u0010\u001a\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0015R\u0014\u0010\u001b\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0015R\u0014\u0010\u001d\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0015R\u0014\u0010\u001e\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0015R\u0014\u0010\u001f\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u0015R\u0014\u0010 \u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b \u0010\u0015R\u0014\u0010!\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b!\u0010\u0015R\u0014\u0010\"\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\"\u0010\u0015R\u0014\u0010#\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b#\u0010\u0015R\u0014\u0010$\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b$\u0010\u0015R\u0014\u0010%\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b%\u0010\u0015R\u0014\u0010&\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b&\u0010\u0015R\u0014\u0010'\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b'\u0010\u0015R\u0014\u0010(\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b(\u0010\u0015R\u0014\u0010)\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b)\u0010\u0015R\u0014\u0010*\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b*\u0010\u0015R\u0014\u0010+\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b+\u0010\u0015R\u0014\u0010,\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b,\u0010\u0015R\u0014\u0010-\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b-\u0010\u0015R\u0014\u0010.\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b.\u0010\u0015R\u0014\u0010/\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b/\u0010\u0015R\u0014\u00100\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b0\u0010\u0015R\u0014\u00101\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b1\u0010\u0015R\u0014\u00102\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b2\u0010\u0015\u00a8\u00065"}, d2={"Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketSavedData$Companion;", "", "Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketSavedData;", "createEmpty", "()Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketSavedData;", "Lnet/minecraft/nbt/CompoundTag;", "compoundTag", "load", "(Lnet/minecraft/nbt/CompoundTag;)Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketSavedData;", "Lnet/minecraft/world/level/material/Fluid;", "fluid", "", "fluidRegistryName", "(Lnet/minecraft/world/level/material/Fluid;)Ljava/lang/String;", "id", "parseFluid", "(Ljava/lang/String;)Lnet/minecraft/world/level/material/Fluid;", "", "FORMAT_VERSION", "I", "TAG_FORMAT_VERSION", "Ljava/lang/String;", "TAG_SHIPS", "TAG_SHIP_ID", "TAG_MIN_X", "TAG_MIN_Y", "TAG_MIN_Z", "TAG_SIZE_X", "TAG_SIZE_Y", "TAG_SIZE_Z", "TAG_FLOOD_FLUID", "TAG_GEOMETRY_REVISION", "TAG_GEOMETRY_SIGNATURE", "TAG_OPEN", "TAG_EXTERIOR", "TAG_STRICT_INTERIOR", "TAG_SIMULATION_DOMAIN", "TAG_OUTSIDE_VOID", "TAG_INTERIOR", "TAG_FLOODED", "TAG_MATERIALIZED_WATER", "TAG_WATER_REACHABLE", "TAG_UNREACHABLE_VOID", "TAG_FACE_COND_XP", "TAG_FACE_COND_YP", "TAG_FACE_COND_ZP", "TAG_VOXEL_EXTERIOR_COMPONENT_MASK", "TAG_VOXEL_INTERIOR_COMPONENT_MASK", "TAG_VOXEL_SIMULATION_COMPONENT_MASK", "TAG_FLOOD_PLANE_KEYS", "TAG_FLOOD_PLANE_VALUES", "<init>", "()V", "valkyrien-air"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ShipPocketSavedData createEmpty() {
            return new ShipPocketSavedData();
        }

        @JvmStatic
        @NotNull
        public final ShipPocketSavedData load(@NotNull CompoundTag compoundTag) {
            Intrinsics.checkNotNullParameter((Object)compoundTag, (String)"compoundTag");
            ShipPocketSavedData data = new ShipPocketSavedData();
            int version = compoundTag.m_128451_(ShipPocketSavedData.TAG_FORMAT_VERSION);
            if (version <= 0 || version > 3) {
                return data;
            }
            ListTag ships = compoundTag.m_128437_(ShipPocketSavedData.TAG_SHIPS, 10);
            int n = ships.size();
            for (int i = 0; i < n; ++i) {
                BitSet bitSet;
                long[] lArray;
                short[] sArray;
                BitSet bitSet2;
                BitSet strictInterior;
                long volumeLong;
                CompoundTag shipTag = ships.m_128728_(i);
                long shipId = shipTag.m_128454_(ShipPocketSavedData.TAG_SHIP_ID);
                int minX = shipTag.m_128451_(ShipPocketSavedData.TAG_MIN_X);
                int minY = shipTag.m_128451_(ShipPocketSavedData.TAG_MIN_Y);
                int minZ = shipTag.m_128451_(ShipPocketSavedData.TAG_MIN_Z);
                int sizeX = shipTag.m_128451_(ShipPocketSavedData.TAG_SIZE_X);
                int sizeY = shipTag.m_128451_(ShipPocketSavedData.TAG_SIZE_Y);
                int sizeZ = shipTag.m_128451_(ShipPocketSavedData.TAG_SIZE_Z);
                if (sizeX <= 0 || sizeY <= 0 || sizeZ <= 0 || (volumeLong = (long)sizeX * (long)sizeY * (long)sizeZ) <= 0L || volumeLong > Integer.MAX_VALUE) continue;
                int volume = (int)volumeLong;
                String string = shipTag.m_128461_(ShipPocketSavedData.TAG_FLOOD_FLUID);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
                Fluid floodFluid = this.parseFluid(string);
                Int2DoubleOpenHashMap floodPlanes = new Int2DoubleOpenHashMap();
                int[] planeKeys = shipTag.m_128465_(ShipPocketSavedData.TAG_FLOOD_PLANE_KEYS);
                long[] planeValues = shipTag.m_128467_(ShipPocketSavedData.TAG_FLOOD_PLANE_VALUES);
                int planeCount = Math.min(planeKeys.length, planeValues.length);
                for (int planeIdx = 0; planeIdx < planeCount; ++planeIdx) {
                    floodPlanes.put(planeKeys[planeIdx], Double.longBitsToDouble(planeValues[planeIdx]));
                }
                byte[] byArray = shipTag.m_128463_(ShipPocketSavedData.TAG_OPEN);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getByteArray(...)");
                BitSet open = ShipWaterPocketPersistenceKt.access$decodeBitSet(byArray);
                byte[] byArray2 = shipTag.m_128463_(ShipPocketSavedData.TAG_EXTERIOR);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getByteArray(...)");
                BitSet exterior = ShipWaterPocketPersistenceKt.access$decodeBitSet(byArray2);
                byte[] byArray3 = shipTag.m_128463_(ShipPocketSavedData.TAG_INTERIOR);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getByteArray(...)");
                BitSet interiorLegacy = ShipWaterPocketPersistenceKt.access$decodeBitSet(byArray3);
                if (version >= 2) {
                    byte[] byArray4 = shipTag.m_128463_(ShipPocketSavedData.TAG_STRICT_INTERIOR);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"getByteArray(...)");
                    v5 = ShipWaterPocketPersistenceKt.access$decodeBitSet(byArray4);
                } else {
                    Object object = interiorLegacy.clone();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.BitSet");
                    v5 = strictInterior = (BitSet)object;
                }
                if (version >= 2) {
                    byte[] byArray5 = shipTag.m_128463_(ShipPocketSavedData.TAG_SIMULATION_DOMAIN);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"getByteArray(...)");
                    bitSet2 = ShipWaterPocketPersistenceKt.access$decodeBitSet(byArray5);
                } else {
                    Object object = interiorLegacy.clone();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.BitSet");
                    bitSet2 = (BitSet)object;
                }
                BitSet simulationDomain = bitSet2;
                boolean requiresResave = false;
                requiresResave = version < 3;
                byte[] byArray6 = shipTag.m_128463_(ShipPocketSavedData.TAG_FACE_COND_XP);
                Intrinsics.checkNotNullExpressionValue((Object)byArray6, (String)"getByteArray(...)");
                short[] faceCondXPRaw = ShipWaterPocketPersistenceKt.access$decodeShortArray(byArray6);
                byte[] byArray7 = shipTag.m_128463_(ShipPocketSavedData.TAG_FACE_COND_YP);
                Intrinsics.checkNotNullExpressionValue((Object)byArray7, (String)"getByteArray(...)");
                short[] faceCondYPRaw = ShipWaterPocketPersistenceKt.access$decodeShortArray(byArray7);
                byte[] byArray8 = shipTag.m_128463_(ShipPocketSavedData.TAG_FACE_COND_ZP);
                Intrinsics.checkNotNullExpressionValue((Object)byArray8, (String)"getByteArray(...)");
                short[] faceCondZPRaw = ShipWaterPocketPersistenceKt.access$decodeShortArray(byArray8);
                short[] it = sArray = ShipWaterPocketPersistenceKt.access$sanitizeFaceConductance(faceCondXPRaw, volume);
                boolean bl = false;
                if (it.length != faceCondXPRaw.length || !(faceCondXPRaw.length == 0) && it.length == 0) {
                    requiresResave = true;
                }
                short[] faceCondXP = sArray;
                short[] it2 = it = ShipWaterPocketPersistenceKt.access$sanitizeFaceConductance(faceCondYPRaw, volume);
                boolean bl2 = false;
                if (it2.length != faceCondYPRaw.length || !(faceCondYPRaw.length == 0) && it2.length == 0) {
                    requiresResave = true;
                }
                short[] faceCondYP = it;
                short[] it3 = it2 = ShipWaterPocketPersistenceKt.access$sanitizeFaceConductance(faceCondZPRaw, volume);
                boolean bl3 = false;
                if (it3.length != faceCondZPRaw.length || !(faceCondZPRaw.length == 0) && it3.length == 0) {
                    requiresResave = true;
                }
                short[] faceCondZP = it2;
                byte[] byArray9 = shipTag.m_128463_(ShipPocketSavedData.TAG_VOXEL_EXTERIOR_COMPONENT_MASK);
                Intrinsics.checkNotNullExpressionValue((Object)byArray9, (String)"getByteArray(...)");
                long[] voxelExteriorMaskRaw = ShipWaterPocketPersistenceKt.access$decodeLongArray(byArray9);
                long[] it4 = bl3 = ShipWaterPocketPersistenceKt.access$sanitizeVoxelMasks(voxelExteriorMaskRaw, volume);
                boolean bl4 = false;
                if (it4.length != voxelExteriorMaskRaw.length) {
                    requiresResave = true;
                }
                long[] voxelExteriorMask = bl3;
                byte[] byArray10 = shipTag.m_128463_(ShipPocketSavedData.TAG_VOXEL_INTERIOR_COMPONENT_MASK);
                Intrinsics.checkNotNullExpressionValue((Object)byArray10, (String)"getByteArray(...)");
                long[] voxelInteriorMaskRaw = ShipWaterPocketPersistenceKt.access$decodeLongArray(byArray10);
                long[] it5 = bl4 = ShipWaterPocketPersistenceKt.access$sanitizeVoxelMasks(voxelInteriorMaskRaw, volume);
                boolean bl5 = false;
                if (it5.length != voxelInteriorMaskRaw.length) {
                    requiresResave = true;
                }
                long[] voxelInteriorMask = bl4;
                if (version >= 2) {
                    byte[] byArray11 = shipTag.m_128463_(ShipPocketSavedData.TAG_VOXEL_SIMULATION_COMPONENT_MASK);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray11, (String)"getByteArray(...)");
                    lArray = ShipWaterPocketPersistenceKt.access$decodeLongArray(byArray11);
                } else {
                    long[] lArray2 = Arrays.copyOf(voxelInteriorMask, voxelInteriorMask.length);
                    lArray = lArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"copyOf(...)");
                }
                long[] voxelSimulationMaskRaw = lArray;
                long[] it6 = bl5 = ShipWaterPocketPersistenceKt.access$sanitizeVoxelMasks(voxelSimulationMaskRaw, volume);
                boolean bl6 = false;
                if (it6.length != voxelSimulationMaskRaw.length) {
                    requiresResave = true;
                }
                long[] voxelSimulationMask = bl5;
                byte[] byArray12 = shipTag.m_128463_(ShipPocketSavedData.TAG_FLOODED);
                Intrinsics.checkNotNullExpressionValue((Object)byArray12, (String)"getByteArray(...)");
                BitSet flooded = ShipWaterPocketPersistenceKt.access$decodeBitSet(byArray12);
                byte[] byArray13 = shipTag.m_128463_(ShipPocketSavedData.TAG_MATERIALIZED_WATER);
                Intrinsics.checkNotNullExpressionValue((Object)byArray13, (String)"getByteArray(...)");
                BitSet materializedWater = ShipWaterPocketPersistenceKt.access$decodeBitSet(byArray13);
                byte[] byArray14 = shipTag.m_128463_(ShipPocketSavedData.TAG_WATER_REACHABLE);
                Intrinsics.checkNotNullExpressionValue((Object)byArray14, (String)"getByteArray(...)");
                BitSet waterReachable = ShipWaterPocketPersistenceKt.access$decodeBitSet(byArray14);
                byte[] byArray15 = shipTag.m_128463_(ShipPocketSavedData.TAG_UNREACHABLE_VOID);
                Intrinsics.checkNotNullExpressionValue((Object)byArray15, (String)"getByteArray(...)");
                BitSet unreachableVoid = ShipWaterPocketPersistenceKt.access$decodeBitSet(byArray15);
                if (version >= 3) {
                    byte[] byArray16 = shipTag.m_128463_(ShipPocketSavedData.TAG_OUTSIDE_VOID);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray16, (String)"getByteArray(...)");
                    bitSet = ShipWaterPocketPersistenceKt.access$decodeBitSet(byArray16);
                } else {
                    BitSet bitSet3;
                    BitSet it7 = bitSet3 = ShipWaterPocketPersistenceKt.access$reconstructOutsideVoidForLegacy(open, simulationDomain, sizeX, sizeY, sizeZ, faceCondXP, faceCondYP, faceCondZP);
                    boolean bl7 = false;
                    requiresResave = true;
                    bitSet = bitSet3;
                }
                BitSet outsideVoid = bitSet;
                boolean normalized = ShipWaterPocketPersistenceKt.access$normalizePersistedMasks(volume, open, exterior, strictInterior, simulationDomain, outsideVoid, interiorLegacy, flooded, materializedWater, waterReachable, unreachableVoid);
                if (normalized) {
                    requiresResave = true;
                }
                Long l = shipId;
                data.persistedStates.put(l, new PersistedShipPocketState(minX, minY, minZ, sizeX, sizeY, sizeZ, open, exterior, strictInterior, simulationDomain, outsideVoid, interiorLegacy, floodFluid, flooded, materializedWater, waterReachable, unreachableVoid, faceCondXP, faceCondYP, faceCondZP, voxelExteriorMask, voxelInteriorMask, voxelSimulationMask, floodPlanes, shipTag.m_128454_(ShipPocketSavedData.TAG_GEOMETRY_REVISION), shipTag.m_128454_(ShipPocketSavedData.TAG_GEOMETRY_SIGNATURE), requiresResave));
            }
            return data;
        }

        private final String fluidRegistryName(Fluid fluid) {
            ResourceLocation resourceLocation = BuiltInRegistries.f_257020_.m_7981_((Object)ShipWaterPocketPersistenceKt.access$canonicalFloodSource(fluid));
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
            ResourceLocation key = resourceLocation;
            String string = key.toString();
            if (string == null) {
                String string2 = BuiltInRegistries.f_257020_.m_7981_((Object)Fluids.f_76193_).toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            return string;
        }

        private final Fluid parseFluid(String id) {
            Fluid fluid;
            ResourceLocation resourceLocation = ResourceLocation.m_135820_((String)id);
            if (resourceLocation == null) {
                FlowingFluid flowingFluid = Fluids.f_76193_;
                Intrinsics.checkNotNullExpressionValue((Object)flowingFluid, (String)"WATER");
                return (Fluid)flowingFluid;
            }
            ResourceLocation location = resourceLocation;
            Object object = BuiltInRegistries.f_257020_.m_7745_(location);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            Fluid fluid2 = (Fluid)object;
            if (Intrinsics.areEqual((Object)fluid2, (Object)Fluids.f_76191_)) {
                FlowingFluid flowingFluid = Fluids.f_76193_;
                Intrinsics.checkNotNullExpressionValue((Object)flowingFluid, (String)"WATER");
                fluid = (Fluid)flowingFluid;
            } else {
                fluid = ShipWaterPocketPersistenceKt.access$canonicalFloodSource(fluid2);
            }
            return fluid;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

