/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.feature.ship_water_pockets;

import java.util.BitSet;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShapeCellTemplate;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipPocketState;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketGeometryKt;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketStateAccessKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a\u001f\u0010\n\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b\n\u0010\t\u001a\u001f\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b\u000b\u0010\t\u001a'\u0010\r\u001a\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u001a?\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0093\u0001\u0010(\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001e26\u0010'\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b(%\u0012\u0004\u0012\u00020&0!H\u0000\u00a2\u0006\u0004\b(\u0010)\"\u0014\u0010*\u001a\u00020\u00058\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;", "state", "", "hasComponentTraversalSupport", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;)Z", "", "idx", "", "interiorComponentMaskAt", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;I)J", "exteriorComponentMaskAt", "allOpenComponentMaskAt", "dirCode", "neighborIndex", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;II)I", "idxA", "idxB", "dirCodeFromA", "componentMaskA", "componentMaskB", "connectedNeighborComponentMask", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;IIIJJ)J", "seedVoxel", "seedMask", "Lkotlin/Function1;", "allowedMaskAt", "Ljava/util/BitSet;", "visitedVoxels", "", "queueIdx", "", "queueMask", "visitedMaskByVoxel", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "voxelIdx", "newlyVisitedMask", "", "onVisit", "traverseConnectedComponents", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;IJLkotlin/jvm/functions/Function1;Ljava/util/BitSet;[I[J[JLkotlin/jvm/functions/Function2;)Z", "COMPONENT_TRAVERSAL_MAX_STEPS", "I", "valkyrien-air"})
@SourceDebugExtension(value={"SMAP\nShipWaterPocketComponentTraversal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShipWaterPocketComponentTraversal.kt\norg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipWaterPocketComponentTraversalKt\n+ 2 ShipWaterPocketGeometry.kt\norg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipWaterPocketGeometryKt\n*L\n1#1,161:1\n223#2,13:162\n*S KotlinDebug\n*F\n+ 1 ShipWaterPocketComponentTraversal.kt\norg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipWaterPocketComponentTraversalKt\n*L\n89#1:162,13\n*E\n"})
public final class ShipWaterPocketComponentTraversalKt {
    public static final int COMPONENT_TRAVERSAL_MAX_STEPS = 12000000;

    public static final boolean hasComponentTraversalSupport(@NotNull ShipPocketState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int volume = state.getSizeX() * state.getSizeY() * state.getSizeZ();
        if (volume <= 0) {
            return false;
        }
        if (state.getComponentGraphDegraded()) {
            return false;
        }
        if (state.getTemplateIndexByVoxel().length != volume) {
            return false;
        }
        if (state.getShapeTemplatePalette().isEmpty()) {
            return false;
        }
        if (state.getVoxelInteriorComponentMask().length < volume) {
            return false;
        }
        if (state.getVoxelExteriorComponentMask().length < volume) {
            return false;
        }
        return state.getVoxelSimulationComponentMask().length >= volume;
    }

    public static final long interiorComponentMaskAt(@NotNull ShipPocketState state, int idx) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (idx < 0 || idx >= state.getVoxelInteriorComponentMask().length) {
            return 0L;
        }
        return state.getVoxelInteriorComponentMask()[idx];
    }

    public static final long exteriorComponentMaskAt(@NotNull ShipPocketState state, int idx) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (idx < 0 || idx >= state.getVoxelExteriorComponentMask().length) {
            return 0L;
        }
        return state.getVoxelExteriorComponentMask()[idx];
    }

    public static final long allOpenComponentMaskAt(@NotNull ShipPocketState state, int idx) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return ShipWaterPocketComponentTraversalKt.interiorComponentMaskAt(state, idx) | ShipWaterPocketComponentTraversalKt.exteriorComponentMaskAt(state, idx);
    }

    public static final int neighborIndex(@NotNull ShipPocketState state, int idx, int dirCode) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int sizeX = state.getSizeX();
        int sizeY = state.getSizeY();
        int sizeZ = state.getSizeZ();
        int strideY = sizeX;
        int strideZ = sizeX * sizeY;
        int lx = idx % sizeX;
        int t = idx / sizeX;
        int ly = t % sizeY;
        int lz = t / sizeY;
        return switch (dirCode) {
            case 0 -> {
                if (lx > 0) {
                    yield idx - 1;
                }
                yield -1;
            }
            case 1 -> {
                if (lx + 1 < sizeX) {
                    yield idx + 1;
                }
                yield -1;
            }
            case 2 -> {
                if (ly > 0) {
                    yield idx - strideY;
                }
                yield -1;
            }
            case 3 -> {
                if (ly + 1 < sizeY) {
                    yield idx + strideY;
                }
                yield -1;
            }
            case 4 -> {
                if (lz > 0) {
                    yield idx - strideZ;
                }
                yield -1;
            }
            default -> lz + 1 < sizeZ ? idx + strideZ : -1;
        };
    }

    /*
     * WARNING - void declaration
     */
    public static final long connectedNeighborComponentMask(@NotNull ShipPocketState state, int idxA, int idxB, int dirCodeFromA, long componentMaskA, long componentMaskB) {
        int templateBIdx;
        int templateAIdx;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                if (componentMaskA == 0L || componentMaskB == 0L) {
                    return 0L;
                }
                if (!ShipWaterPocketComponentTraversalKt.hasComponentTraversalSupport(state)) {
                    return ShipWaterPocketStateAccessKt.computeFilteredFaceConductance(state, idxA, idxB, dirCodeFromA, componentMaskA, componentMaskB) > 0 ? componentMaskB : 0L;
                }
                templateAIdx = state.getTemplateIndexByVoxel()[idxA];
                templateBIdx = state.getTemplateIndexByVoxel()[idxB];
                boolean bl = 0 <= templateAIdx ? templateAIdx < ((Collection)state.getShapeTemplatePalette()).size() : false;
                if (!bl) break block6;
                if (0 <= templateBIdx ? templateBIdx < ((Collection)state.getShapeTemplatePalette()).size() : false) break block7;
            }
            return 0L;
        }
        ShapeCellTemplate templateA = state.getShapeTemplatePalette().get(templateAIdx);
        ShapeCellTemplate templateB = state.getShapeTemplatePalette().get(templateBIdx);
        long outMask = 0L;
        boolean $i$f$forEachTemplateFaceConnection = false;
        int faceA$iv = ShipWaterPocketGeometryKt.access$faceForDirCode(dirCodeFromA);
        int faceB$iv = ShipWaterPocketGeometryKt.access$oppositeFace(faceA$iv);
        int faceOffsetA$iv = faceA$iv * 64;
        int faceOffsetB$iv = faceB$iv * 64;
        for (int sampleIdx$iv = 0; sampleIdx$iv < 64; ++sampleIdx$iv) {
            void componentB;
            byte componentB$iv;
            byte componentA$iv = templateA.getFaceSampleComponent()[faceOffsetA$iv + sampleIdx$iv];
            if (componentA$iv < 0 || (componentB$iv = templateB.getFaceSampleComponent()[faceOffsetB$iv + sampleIdx$iv]) < 0) continue;
            byte by = componentB$iv;
            byte componentA = componentA$iv;
            boolean bl = false;
            if ((componentMaskA >>> componentA & 1L) == 0L || (componentMaskB >>> componentB & 1L) == 0L) continue;
            outMask |= 1L << componentB;
        }
        return outMask;
    }

    public static final boolean traverseConnectedComponents(@NotNull ShipPocketState state, int seedVoxel, long seedMask, @NotNull Function1<? super Integer, Long> allowedMaskAt, @NotNull BitSet visitedVoxels, @NotNull int[] queueIdx, @NotNull long[] queueMask, @NotNull long[] visitedMaskByVoxel, @NotNull Function2<? super Integer, ? super Long, Unit> onVisit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(allowedMaskAt, (String)"allowedMaskAt");
        Intrinsics.checkNotNullParameter((Object)visitedVoxels, (String)"visitedVoxels");
        Intrinsics.checkNotNullParameter((Object)queueIdx, (String)"queueIdx");
        Intrinsics.checkNotNullParameter((Object)queueMask, (String)"queueMask");
        Intrinsics.checkNotNullParameter((Object)visitedMaskByVoxel, (String)"visitedMaskByVoxel");
        Intrinsics.checkNotNullParameter(onVisit, (String)"onVisit");
        if (seedVoxel < 0 || seedMask == 0L) {
            return true;
        }
        int volume = state.getSizeX() * state.getSizeY() * state.getSizeZ();
        if (seedVoxel >= volume) {
            return true;
        }
        int head = 0;
        int tail = 0;
        queueIdx[tail] = seedVoxel;
        queueMask[tail] = seedMask;
        ++tail;
        int steps = 0;
        while (head < tail) {
            if (++steps > 12000000) {
                return false;
            }
            int curIdx = queueIdx[head];
            long curMaskRaw = queueMask[head];
            ++head;
            long allowedCurMask = ((Number)allowedMaskAt.invoke((Object)curIdx)).longValue();
            long newMask = curMaskRaw & allowedCurMask & (visitedMaskByVoxel[curIdx] ^ 0xFFFFFFFFFFFFFFFFL);
            if (newMask == 0L) continue;
            visitedMaskByVoxel[curIdx] = visitedMaskByVoxel[curIdx] | newMask;
            visitedVoxels.set(curIdx);
            onVisit.invoke((Object)curIdx, (Object)newMask);
            for (int dirCode = 0; dirCode < 6; ++dirCode) {
                long nMask;
                long nAllowed;
                int nIdx = ShipWaterPocketComponentTraversalKt.neighborIndex(state, curIdx, dirCode);
                if (nIdx < 0 || nIdx >= volume || !state.getOpen().get(nIdx) || (nAllowed = ((Number)allowedMaskAt.invoke((Object)nIdx)).longValue()) == 0L || (nMask = ShipWaterPocketComponentTraversalKt.connectedNeighborComponentMask(state, curIdx, nIdx, dirCode, newMask, nAllowed) & (visitedMaskByVoxel[nIdx] ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
                if (tail >= queueIdx.length || tail >= queueMask.length) {
                    return false;
                }
                queueIdx[tail] = nIdx;
                queueMask[tail] = nMask;
                ++tail;
            }
        }
        return true;
    }
}

