/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.feature.ship_water_pockets;

import java.util.Arrays;
import java.util.BitSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.FloodWriteFlushResult;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipPocketState;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketStateAccessKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0017\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\b\u0010\t\u001a/\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a/\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010\u001a'\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013H\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018\u001a\u0017\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001a\u001aG\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0!2\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00160\u001fH\u0002\u00a2\u0006\u0004\b\"\u0010#\u001a\u00da\u0001\u00103\u001a\u0002022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010%\u001a\u00020$2\b\b\u0002\u0010&\u001a\u00020\u001c2\b\b\u0002\u0010'\u001a\u00020\u001c2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00160\u001f2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00070\u001f2u\u00101\u001aq\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(%\u0012\u0013\u0012\u00110-\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(.\u0012\u0013\u0012\u00110-\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(/\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b+\u0012\b\b,\u0012\u0004\b\b(0\u0012\u0004\u0012\u00020\u00070*H\u0000\u00a2\u0006\u0004\b3\u00104\"\u0014\u00105\u001a\u00020\u001c8\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b5\u00106\"\u0014\u00107\u001a\u00020\u001c8\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\b7\u00106\"\u0014\u00108\u001a\u00020\u001c8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b8\u00106\u00a8\u00069"}, d2={"Lnet/minecraft/world/level/material/Fluid;", "fluid", "canonicalFloodSource", "(Lnet/minecraft/world/level/material/Fluid;)Lnet/minecraft/world/level/material/Fluid;", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "floodFluid", "", "isWaterloggableForFlood", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/material/Fluid;)Z", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lnet/minecraft/core/BlockPos$MutableBlockPos;", "pos", "current", "tryPlaceFluidInContainer", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos$MutableBlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/material/Fluid;)Z", "tryDrainFluidFromContainer", "Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;", "Ljava/util/BitSet;", "toAdd", "toRemove", "", "enqueueFloodWriteDiffs", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;Ljava/util/BitSet;Ljava/util/BitSet;)V", "clearFloodWriteQueues", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;)V", "queue", "", "startCursor", "budget", "Lkotlin/Function1;", "handle", "Lkotlin/Pair;", "processQueuedIndices", "(Ljava/util/BitSet;IILkotlin/jvm/functions/Function1;)Lkotlin/Pair;", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "shipTransform", "removeCap", "addCap", "setApplyingInternalUpdates", "isFloodFluidType", "Lkotlin/Function5;", "Lkotlin/ParameterName;", "name", "Lorg/joml/Vector3d;", "shipPosTmp", "worldPosTmp", "worldBlockPos", "isIngressQualifiedForAdd", "Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/FloodWriteFlushResult;", "flushFloodWriteQueue", "(Lnet/minecraft/server/level/ServerLevel;Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;IILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function5;)Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/FloodWriteFlushResult;", "FLOOD_QUEUE_REMOVE_CAP_PER_TICK", "I", "FLOOD_QUEUE_ADD_CAP_PER_TICK", "FLOOD_QUEUE_SETBLOCK_FLAGS", "valkyrien-air"})
public final class ShipWaterPocketFloodWritesKt {
    public static final int FLOOD_QUEUE_REMOVE_CAP_PER_TICK = 512;
    public static final int FLOOD_QUEUE_ADD_CAP_PER_TICK = 512;
    private static final int FLOOD_QUEUE_SETBLOCK_FLAGS = 3;

    private static final Fluid canonicalFloodSource(Fluid fluid) {
        Fluid fluid2;
        if (fluid instanceof FlowingFluid) {
            Fluid fluid3 = ((FlowingFluid)fluid).m_5613_();
            fluid2 = fluid3;
            Intrinsics.checkNotNullExpressionValue((Object)fluid3, (String)"getSource(...)");
        } else {
            fluid2 = fluid;
        }
        return fluid2;
    }

    private static final boolean isWaterloggableForFlood(BlockState state, Fluid floodFluid) {
        return Intrinsics.areEqual((Object)ShipWaterPocketFloodWritesKt.canonicalFloodSource(floodFluid), (Object)Fluids.f_76193_) && state.m_61138_((Property)BlockStateProperties.f_61362_);
    }

    private static final boolean tryPlaceFluidInContainer(ServerLevel level, BlockPos.MutableBlockPos pos, BlockState current, Fluid floodFluid) {
        boolean bl;
        Fluid canonical = ShipWaterPocketFloodWritesKt.canonicalFloodSource(floodFluid);
        FlowingFluid flowingFluid = canonical instanceof FlowingFluid ? (FlowingFluid)canonical : null;
        if (flowingFluid == null) {
            return false;
        }
        FlowingFluid flowing = flowingFluid;
        Block block = current.m_60734_();
        if (!(block instanceof LiquidBlockContainer)) {
            return false;
        }
        try {
            if (!((LiquidBlockContainer)block).m_6044_((BlockGetter)level, (BlockPos)pos, current, canonical)) {
                return false;
            }
            if (!((LiquidBlockContainer)block).m_7361_((LevelAccessor)level, (BlockPos)pos, current, flowing.m_5613_().m_76145_())) {
                return false;
            }
            level.m_186469_((BlockPos)pos, canonical, 1);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private static final boolean tryDrainFluidFromContainer(ServerLevel level, BlockPos.MutableBlockPos pos, BlockState current, Fluid floodFluid) {
        boolean bl;
        Fluid canonical;
        block8: {
            block7: {
                canonical = ShipWaterPocketFloodWritesKt.canonicalFloodSource(floodFluid);
                FluidState currentFluid = current.m_60819_();
                if (currentFluid.m_76178_()) break block7;
                Fluid fluid = currentFluid.m_76152_();
                Intrinsics.checkNotNullExpressionValue((Object)fluid, (String)"getType(...)");
                if (Intrinsics.areEqual((Object)ShipWaterPocketFloodWritesKt.canonicalFloodSource(fluid), (Object)canonical)) break block8;
            }
            return false;
        }
        Block block = current.m_60734_();
        if (!(block instanceof BucketPickup)) {
            return false;
        }
        try {
            ItemStack picked = ((BucketPickup)block).m_142598_((LevelAccessor)level, (BlockPos)pos, current);
            if (picked.m_41619_()) {
                return false;
            }
            level.m_186469_((BlockPos)pos, canonical, 1);
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    public static final void enqueueFloodWriteDiffs(@NotNull ShipPocketState state, @NotNull BitSet toAdd, @NotNull BitSet toRemove) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)toAdd, (String)"toAdd");
        Intrinsics.checkNotNullParameter((Object)toRemove, (String)"toRemove");
        if (!toRemove.isEmpty()) {
            state.getQueuedFloodRemoves().or(toRemove);
            state.getQueuedFloodAdds().andNot(toRemove);
        }
        if (!toAdd.isEmpty()) {
            state.getQueuedFloodAdds().or(toAdd);
            state.getQueuedFloodRemoves().andNot(toAdd);
        }
    }

    public static final void clearFloodWriteQueues(@NotNull ShipPocketState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        state.getQueuedFloodAdds().clear();
        state.getQueuedFloodRemoves().clear();
        state.setNextQueuedAddIdx(0);
        state.setNextQueuedRemoveIdx(0);
    }

    private static final Pair<Integer, Integer> processQueuedIndices(BitSet queue, int startCursor, int budget, Function1<? super Integer, Unit> handle) {
        if (budget <= 0 || queue.isEmpty()) {
            return TuplesKt.to((Object)0, (Object)0);
        }
        int processed = 0;
        int start = RangesKt.coerceAtLeast((int)startCursor, (int)0);
        int idx = queue.nextSetBit(start);
        if (idx < 0 && start > 0) {
            idx = queue.nextSetBit(0);
        }
        while (idx >= 0 && processed < budget) {
            int current = idx;
            idx = queue.nextSetBit(current + 1);
            handle.invoke((Object)current);
            queue.clear(current);
            if (idx >= 0 || ++processed >= budget) continue;
            idx = queue.nextSetBit(0);
        }
        return TuplesKt.to((Object)processed, (Object)(idx >= 0 ? idx : 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final FloodWriteFlushResult flushFloodWriteQueue(@NotNull ServerLevel level, @NotNull ShipPocketState state, @NotNull ShipTransform shipTransform, int removeCap, int addCap, @NotNull Function1<? super Boolean, Unit> setApplyingInternalUpdates, @NotNull Function1<? super Fluid, Boolean> isFloodFluidType, @NotNull Function5<? super BlockPos.MutableBlockPos, ? super ShipTransform, ? super Vector3d, ? super Vector3d, ? super BlockPos.MutableBlockPos, Boolean> isIngressQualifiedForAdd) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)shipTransform, (String)"shipTransform");
        Intrinsics.checkNotNullParameter(setApplyingInternalUpdates, (String)"setApplyingInternalUpdates");
        Intrinsics.checkNotNullParameter(isFloodFluidType, (String)"isFloodFluidType");
        Intrinsics.checkNotNullParameter(isIngressQualifiedForAdd, (String)"isIngressQualifiedForAdd");
        if (state.getQueuedFloodAdds().isEmpty() && state.getQueuedFloodRemoves().isEmpty()) {
            return new FloodWriteFlushResult(0, 0, 0, 0, new int[0], 0);
        }
        int volume = state.getSizeX() * state.getSizeY() * state.getSizeZ();
        if (volume <= 0) {
            ShipWaterPocketFloodWritesKt.clearFloodWriteQueues(state);
            return new FloodWriteFlushResult(0, 0, 0, 0, new int[0], 0);
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Vector3d worldPosTmp = new Vector3d();
        Vector3d shipPosTmp = new Vector3d();
        BlockPos.MutableBlockPos worldBlockPos = new BlockPos.MutableBlockPos();
        BlockState sourceBlockState = state.getFloodFluid().m_76145_().m_76188_();
        Fluid floodCanonical = ShipWaterPocketFloodWritesKt.canonicalFloodSource(state.getFloodFluid());
        Ref.IntRef removedApplied = new Ref.IntRef();
        Ref.IntRef addedApplied = new Ref.IntRef();
        Ref.IntRef rejectedAdds = new Ref.IntRef();
        int blockedExteriorWaterlogs = 0;
        int addedSamplesMax = 48;
        int[] addedSampleIndices = new int[addedSamplesMax];
        Ref.IntRef addedSampleCount = new Ref.IntRef();
        setApplyingInternalUpdates.invoke((Object)true);
        try {
            Pair<Integer, Integer> removeResult = ShipWaterPocketFloodWritesKt.processQueuedIndices(state.getQueuedFloodRemoves(), state.getNextQueuedRemoveIdx(), removeCap, (Function1<? super Integer, Unit>)((Function1)arg_0 -> ShipWaterPocketFloodWritesKt.flushFloodWriteQueue$lambda$0(volume, state, pos, level, isFloodFluidType, removedApplied, floodCanonical, arg_0)));
            state.setNextQueuedRemoveIdx(((Number)removeResult.getSecond()).intValue());
            Pair<Integer, Integer> addResult = ShipWaterPocketFloodWritesKt.processQueuedIndices(state.getQueuedFloodAdds(), state.getNextQueuedAddIdx(), addCap, (Function1<? super Integer, Unit>)((Function1)arg_0 -> ShipWaterPocketFloodWritesKt.flushFloodWriteQueue$lambda$1(volume, state, pos, level, isFloodFluidType, isIngressQualifiedForAdd, shipTransform, shipPosTmp, worldPosTmp, worldBlockPos, rejectedAdds, floodCanonical, addedApplied, sourceBlockState, addedSampleCount, addedSamplesMax, addedSampleIndices, arg_0)));
            state.setNextQueuedAddIdx(((Number)addResult.getSecond()).intValue());
        }
        finally {
            setApplyingInternalUpdates.invoke((Object)false);
        }
        int n = removedApplied.element;
        int n2 = addedApplied.element;
        int n3 = rejectedAdds.element;
        int[] nArray = Arrays.copyOf(addedSampleIndices, addedSampleCount.element);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"copyOf(...)");
        return new FloodWriteFlushResult(n, n2, n3, blockedExteriorWaterlogs, nArray, state.getQueuedFloodAdds().cardinality() + state.getQueuedFloodRemoves().cardinality());
    }

    public static /* synthetic */ FloodWriteFlushResult flushFloodWriteQueue$default(ServerLevel serverLevel, ShipPocketState shipPocketState, ShipTransform shipTransform, int n, int n2, Function1 function1, Function1 function12, Function5 function5, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n = 512;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 512;
        }
        return ShipWaterPocketFloodWritesKt.flushFloodWriteQueue(serverLevel, shipPocketState, shipTransform, n, n2, (Function1<? super Boolean, Unit>)function1, (Function1<? super Fluid, Boolean>)function12, (Function5<? super BlockPos.MutableBlockPos, ? super ShipTransform, ? super Vector3d, ? super Vector3d, ? super BlockPos.MutableBlockPos, Boolean>)function5);
    }

    private static final void flushFloodWriteQueue$recordAddedSample(Ref.IntRef addedSampleCount, int addedSamplesMax, int[] addedSampleIndices, int idx) {
        if (addedSampleCount.element >= addedSamplesMax) {
            return;
        }
        int n = addedSampleCount.element;
        addedSampleCount.element = n + 1;
        addedSampleIndices[n] = idx;
    }

    /*
     * Unable to fully structure code
     */
    private static final Unit flushFloodWriteQueue$lambda$0(int $volume, ShipPocketState $state, BlockPos.MutableBlockPos $pos, ServerLevel $level, Function1 $isFloodFluidType, Ref.IntRef $removedApplied, Fluid $floodCanonical, int idx) {
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$isFloodFluidType, (String)"$isFloodFluidType");
        Intrinsics.checkNotNullParameter((Object)$removedApplied, (String)"$removedApplied");
        Intrinsics.checkNotNullParameter((Object)$floodCanonical, (String)"$floodCanonical");
        if (idx < 0 || idx >= $volume) {
            return Unit.INSTANCE;
        }
        ShipWaterPocketStateAccessKt.posFromIndex($state, idx, $pos);
        current = $level.m_8055_((BlockPos)$pos);
        currentFluid = current.m_60819_();
        if (!(current.m_60734_() instanceof LiquidBlock) || currentFluid.m_76178_()) ** GOTO lbl-1000
        v0 = currentFluid.m_76152_();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getType(...)");
        if (((Boolean)$isFloodFluidType.invoke((Object)v0)).booleanValue()) {
            $level.m_7731_((BlockPos)$pos, Blocks.f_50016_.m_49966_(), 3);
            $level.m_186469_((BlockPos)$pos, $state.getFloodFluid(), 1);
            var10_10 = $removedApplied.element;
            $removedApplied.element = var10_10 + 1;
        } else lbl-1000:
        // 2 sources

        {
            Intrinsics.checkNotNull((Object)current);
            if (ShipWaterPocketFloodWritesKt.tryDrainFluidFromContainer($level, $pos, current, $floodCanonical)) {
                var10_11 = $removedApplied.element;
                $removedApplied.element = var10_11 + 1;
            } else if (ShipWaterPocketFloodWritesKt.isWaterloggableForFlood(current, $floodCanonical) && ((Boolean)current.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                drained = (BlockState)current.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
                $level.m_7731_((BlockPos)$pos, drained, 3);
                $level.m_186469_((BlockPos)$pos, (Fluid)Fluids.f_76193_, 1);
                var11_13 = $removedApplied.element;
                $removedApplied.element = var11_13 + 1;
            }
        }
        $state.getMaterializedWater().clear(idx);
        return Unit.INSTANCE;
    }

    private static final Unit flushFloodWriteQueue$lambda$1(int $volume, ShipPocketState $state, BlockPos.MutableBlockPos $pos, ServerLevel $level, Function1 $isFloodFluidType, Function5 $isIngressQualifiedForAdd, ShipTransform $shipTransform, Vector3d $shipPosTmp, Vector3d $worldPosTmp, BlockPos.MutableBlockPos $worldBlockPos, Ref.IntRef $rejectedAdds, Fluid $floodCanonical, Ref.IntRef $addedApplied, BlockState $sourceBlockState, Ref.IntRef $addedSampleCount, int $addedSamplesMax, int[] $addedSampleIndices, int idx) {
        boolean ingressQualified;
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$isFloodFluidType, (String)"$isFloodFluidType");
        Intrinsics.checkNotNullParameter((Object)$isIngressQualifiedForAdd, (String)"$isIngressQualifiedForAdd");
        Intrinsics.checkNotNullParameter((Object)$shipTransform, (String)"$shipTransform");
        Intrinsics.checkNotNullParameter((Object)$shipPosTmp, (String)"$shipPosTmp");
        Intrinsics.checkNotNullParameter((Object)$worldPosTmp, (String)"$worldPosTmp");
        Intrinsics.checkNotNullParameter((Object)$worldBlockPos, (String)"$worldBlockPos");
        Intrinsics.checkNotNullParameter((Object)$rejectedAdds, (String)"$rejectedAdds");
        Intrinsics.checkNotNullParameter((Object)$floodCanonical, (String)"$floodCanonical");
        Intrinsics.checkNotNullParameter((Object)$addedApplied, (String)"$addedApplied");
        Intrinsics.checkNotNullParameter((Object)$addedSampleCount, (String)"$addedSampleCount");
        Intrinsics.checkNotNullParameter((Object)$addedSampleIndices, (String)"$addedSampleIndices");
        if (idx < 0 || idx >= $volume) {
            return Unit.INSTANCE;
        }
        ShipWaterPocketStateAccessKt.posFromIndex($state, idx, $pos);
        BlockState current = $level.m_8055_((BlockPos)$pos);
        FluidState currentFluid = current.m_60819_();
        if (!currentFluid.m_76178_()) {
            Fluid fluid = currentFluid.m_76152_();
            Intrinsics.checkNotNullExpressionValue((Object)fluid, (String)"getType(...)");
            if (((Boolean)$isFloodFluidType.invoke((Object)fluid)).booleanValue()) {
                $state.getMaterializedWater().set(idx);
                return Unit.INSTANCE;
            }
        }
        if (!(ingressQualified = ((Boolean)$isIngressQualifiedForAdd.invoke((Object)$pos, (Object)$shipTransform, (Object)$shipPosTmp, (Object)$worldPosTmp, (Object)$worldBlockPos)).booleanValue())) {
            int n = $rejectedAdds.element;
            $rejectedAdds.element = n + 1;
            return Unit.INSTANCE;
        }
        if (!current.m_60795_()) {
            Intrinsics.checkNotNull((Object)current);
            if (ShipWaterPocketFloodWritesKt.tryPlaceFluidInContainer($level, $pos, current, $floodCanonical)) {
                int n = $addedApplied.element;
                $addedApplied.element = n + 1;
                $state.getMaterializedWater().set(idx);
                ShipWaterPocketFloodWritesKt.flushFloodWriteQueue$recordAddedSample($addedSampleCount, $addedSamplesMax, $addedSampleIndices, idx);
                return Unit.INSTANCE;
            }
            if (ShipWaterPocketFloodWritesKt.isWaterloggableForFlood(current, $floodCanonical)) {
                if (!((Boolean)current.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    BlockState waterlogged = (BlockState)current.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                    $level.m_7731_((BlockPos)$pos, waterlogged, 3);
                    $level.m_186469_((BlockPos)$pos, (Fluid)Fluids.f_76193_, 1);
                    int n = $addedApplied.element;
                    $addedApplied.element = n + 1;
                }
                $state.getMaterializedWater().set(idx);
                ShipWaterPocketFloodWritesKt.flushFloodWriteQueue$recordAddedSample($addedSampleCount, $addedSamplesMax, $addedSampleIndices, idx);
            }
            return Unit.INSTANCE;
        }
        $level.m_7731_((BlockPos)$pos, $sourceBlockState, 3);
        $level.m_186469_((BlockPos)$pos, $state.getFloodFluid(), 1);
        $state.getMaterializedWater().set(idx);
        int n = $addedApplied.element;
        $addedApplied.element = n + 1;
        ShipWaterPocketFloodWritesKt.flushFloodWriteQueue$recordAddedSample($addedSampleCount, $addedSamplesMax, $addedSampleIndices, idx);
        return Unit.INSTANCE;
    }
}

