/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.feature.ship_water_pockets;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShapeCellTemplate;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShapeWaterGeometry;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketGeometryKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0005\n\u0002\b\u0004\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a'\u0010\b\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\b\u0010\t\u001a\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u001f\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0017\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0017\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0019\u001a\u0017\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001ac\u0010)\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u000026\u0010(\u001a2\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u00100#H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b)\u0010*\u001a;\u0010-\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010+\u001a\u00020\u00022\b\b\u0002\u0010,\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b-\u0010.\u001a'\u00100\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b0\u00101\u001a\u0017\u00104\u001a\u00020\r2\u0006\u00103\u001a\u000202H\u0002\u00a2\u0006\u0004\b4\u00105\u001a\u0017\u00109\u001a\u0002082\u0006\u00107\u001a\u000206H\u0002\u00a2\u0006\u0004\b9\u0010:\u001a'\u0010?\u001a\u0002062\u0006\u0010<\u001a\u00020;2\u0006\u0010>\u001a\u00020=2\u0006\u00103\u001a\u000202H\u0002\u00a2\u0006\u0004\b?\u0010@\u001a\u0017\u0010B\u001a\u0002082\u0006\u0010A\u001a\u000208H\u0002\u00a2\u0006\u0004\bB\u0010C\u001a\u0017\u0010F\u001a\u00020D2\u0006\u0010E\u001a\u00020DH\u0002\u00a2\u0006\u0004\bF\u0010G\u001a\u0017\u0010H\u001a\u0002082\u0006\u0010A\u001a\u000208H\u0002\u00a2\u0006\u0004\bH\u0010C\u001a\u0017\u0010I\u001a\u00020D2\u0006\u0010E\u001a\u00020DH\u0002\u00a2\u0006\u0004\bI\u0010G\u001a\u0017\u0010J\u001a\u00020\r2\u0006\u0010E\u001a\u00020DH\u0002\u00a2\u0006\u0004\bJ\u0010K\u001a%\u0010N\u001a\u00020\r2\u0006\u00107\u001a\u0002062\f\u0010M\u001a\b\u0012\u0004\u0012\u00020D0LH\u0002\u00a2\u0006\u0004\bN\u0010O\u001a'\u0010P\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020;2\u0006\u0010>\u001a\u00020=2\u0006\u00103\u001a\u000202H\u0000\u00a2\u0006\u0004\bP\u0010Q\u001a/\u0010U\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010R\u001a\u0002082\u0006\u0010S\u001a\u0002082\u0006\u0010T\u001a\u000208H\u0002\u00a2\u0006\u0004\bU\u0010V\u001a\u0017\u0010W\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001bH\u0000\u00a2\u0006\u0004\bW\u0010X\u001a'\u0010[\u001a\u00020\u00002\u0006\u0010Y\u001a\u00020\u001b2\u0006\u0010Z\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b[\u0010\\\u001a/\u0010b\u001a\u00020]2\u0006\u0010^\u001a\u00020]2\u0006\u0010_\u001a\u00020\u00002\u0006\u0010`\u001a\u00020\u00002\u0006\u0010a\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\bb\u0010c\"\u0014\u0010d\u001a\u00020\u00008\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bd\u0010e\"\u0014\u0010f\u001a\u00020\u00008\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bf\u0010e\"\u0014\u0010g\u001a\u0002088\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bg\u0010h\"\u0014\u0010i\u001a\u0002088\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bi\u0010h\"\u0014\u0010j\u001a\u00020\u00008\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\bj\u0010e\"\u0014\u0010k\u001a\u00020\u00008\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\bk\u0010e\"\u0014\u0010l\u001a\u00020\u00008\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\bl\u0010e\"\u0014\u0010m\u001a\u00020\u00008\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\bm\u0010e\"\u0014\u0010n\u001a\u00020\u00008\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\bn\u0010e\"\u0014\u0010o\u001a\u00020\u00008\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\bo\u0010e\"\u0014\u0010p\u001a\u00020\u00008\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\bp\u0010e\"\u0014\u0010q\u001a\u00020\u00008\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\bq\u0010e\"\u0014\u0010r\u001a\u00020\u00008\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\br\u0010e\"\u0014\u0010s\u001a\u00020\u00008\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\bs\u0010e\"\u0014\u0010t\u001a\u00020\u00008\u0000X\u0080T\u00a2\u0006\u0006\n\u0004\bt\u0010e\"\u0014\u0010v\u001a\u00020u8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bv\u0010w\"\u0014\u0010x\u001a\u00020u8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bx\u0010w\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006y"}, d2={"", "componentCount", "", "fullComponentMask", "(I)J", "sx", "sy", "sz", "subcellIndex", "(III)I", "", "occupancyMask", "subIdx", "", "subcellSolid", "([JI)Z", "", "setSubcellSolid", "([JI)V", "face", "sampleIdx", "faceSampleSubcellIndex", "(II)I", "dirCode", "faceForDirCode", "(I)I", "oppositeFace", "Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeWaterGeometry;", "geom", "Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeCellTemplate;", "buildShapeCellTemplate", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeWaterGeometry;)Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeCellTemplate;", "templateA", "templateB", "dirCodeFromA", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "componentA", "componentB", "block", "forEachTemplateFaceConnection", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeCellTemplate;Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeCellTemplate;ILkotlin/jvm/functions/Function2;)V", "componentMaskA", "componentMaskB", "computeTemplateFaceConductance", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeCellTemplate;Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeCellTemplate;IJJ)I", "axis", "computeTemplateAxisConductance", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeCellTemplate;Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeCellTemplate;I)I", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "isGameplaySealedState", "(Lnet/minecraft/world/level/block/state/BlockState;)Z", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "shape", "", "shapeBlockingScore", "(Lnet/minecraft/world/phys/shapes/VoxelShape;)D", "Lnet/minecraft/world/level/Level;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "resolveFluidOcclusionShape", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/phys/shapes/VoxelShape;", "value", "snapBoundaryCoord", "(D)D", "Lnet/minecraft/world/phys/AABB;", "box", "snapFluidBoundaryBox", "(Lnet/minecraft/world/phys/AABB;)Lnet/minecraft/world/phys/AABB;", "snapFacePlaneCoord", "stabilizeOpenTrapdoorFacePlane", "isFullCubeBox", "(Lnet/minecraft/world/phys/AABB;)Z", "", "boxes", "requiresRefinedSampling", "(Lnet/minecraft/world/phys/shapes/VoxelShape;Ljava/util/List;)Z", "computeShapeWaterGeometry", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeWaterGeometry;", "x", "y", "z", "isSolidAt", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeWaterGeometry;DDD)Z", "hasOpenVolume", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeWaterGeometry;)Z", "geomA", "geomB", "computeFaceConductance", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeWaterGeometry;Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShapeWaterGeometry;I)I", "Ljava/util/BitSet;", "open", "sizeX", "sizeY", "sizeZ", "computeInteriorMaskHeuristic", "(Ljava/util/BitSet;III)Ljava/util/BitSet;", "GEOMETRY_FACE_SAMPLES_BASE", "I", "GEOMETRY_FACE_SAMPLES_REFINED", "GEOMETRY_SAMPLE_EPS", "D", "GEOMETRY_BOUNDARY_SNAP_EPS", "SHAPE_SUBCELL_RES", "SHAPE_SUBCELL_COUNT", "SHAPE_FACE_SAMPLE_RES", "SHAPE_FACE_SAMPLE_COUNT", "SHAPE_MAX_COMPONENTS", "SHAPE_FACE_NEG_X", "SHAPE_FACE_POS_X", "SHAPE_FACE_NEG_Y", "SHAPE_FACE_POS_Y", "SHAPE_FACE_NEG_Z", "SHAPE_FACE_POS_Z", "", "SHAPE_COMPONENT_SOLID", "B", "SHAPE_COMPONENT_UNASSIGNED", "valkyrien-air"})
@SourceDebugExtension(value={"SMAP\nShipWaterPocketGeometry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShipWaterPocketGeometry.kt\norg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipWaterPocketGeometryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,788:1\n223#1,13:789\n1557#2:802\n1628#2,3:803\n1755#2,3:806\n*S KotlinDebug\n*F\n+ 1 ShipWaterPocketGeometry.kt\norg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipWaterPocketGeometryKt\n*L\n245#1:789,13\n421#1:802\n421#1:803,3\n426#1:806,3\n*E\n"})
public final class ShipWaterPocketGeometryKt {
    private static final int GEOMETRY_FACE_SAMPLES_BASE = 8;
    private static final int GEOMETRY_FACE_SAMPLES_REFINED = 16;
    private static final double GEOMETRY_SAMPLE_EPS = 1.0E-4;
    private static final double GEOMETRY_BOUNDARY_SNAP_EPS = 0.00390625;
    public static final int SHAPE_SUBCELL_RES = 8;
    public static final int SHAPE_SUBCELL_COUNT = 512;
    public static final int SHAPE_FACE_SAMPLE_RES = 8;
    public static final int SHAPE_FACE_SAMPLE_COUNT = 64;
    public static final int SHAPE_MAX_COMPONENTS = 64;
    public static final int SHAPE_FACE_NEG_X = 0;
    public static final int SHAPE_FACE_POS_X = 1;
    public static final int SHAPE_FACE_NEG_Y = 2;
    public static final int SHAPE_FACE_POS_Y = 3;
    public static final int SHAPE_FACE_NEG_Z = 4;
    public static final int SHAPE_FACE_POS_Z = 5;
    private static final byte SHAPE_COMPONENT_SOLID = -1;
    private static final byte SHAPE_COMPONENT_UNASSIGNED = -2;

    public static final long fullComponentMask(int componentCount) {
        return componentCount <= 0 ? 0L : (componentCount >= 64 ? -1L : (1L << componentCount) - 1L);
    }

    private static final int subcellIndex(int sx, int sy, int sz) {
        return sx + 8 * (sy + 8 * sz);
    }

    private static final boolean subcellSolid(long[] occupancyMask, int subIdx) {
        int word = subIdx >>> 6;
        int bit = subIdx & 0x3F;
        return (occupancyMask[word] >>> bit & 1L) != 0L;
    }

    private static final void setSubcellSolid(long[] occupancyMask, int subIdx) {
        int word = subIdx >>> 6;
        int bit = subIdx & 0x3F;
        occupancyMask[word] = occupancyMask[word] | 1L << bit;
    }

    private static final int faceSampleSubcellIndex(int face, int sampleIdx) {
        int u = sampleIdx & 7;
        int v = sampleIdx >>> 3;
        return switch (face) {
            case 0 -> ShipWaterPocketGeometryKt.subcellIndex(0, u, v);
            case 1 -> ShipWaterPocketGeometryKt.subcellIndex(7, u, v);
            case 2 -> ShipWaterPocketGeometryKt.subcellIndex(u, 0, v);
            case 3 -> ShipWaterPocketGeometryKt.subcellIndex(u, 7, v);
            case 4 -> ShipWaterPocketGeometryKt.subcellIndex(u, v, 0);
            default -> ShipWaterPocketGeometryKt.subcellIndex(u, v, 7);
        };
    }

    private static final int faceForDirCode(int dirCode) {
        return switch (dirCode) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
            case 4 -> 4;
            default -> 5;
        };
    }

    private static final int oppositeFace(int face) {
        return switch (face) {
            case 0 -> 1;
            case 1 -> 0;
            case 2 -> 3;
            case 3 -> 2;
            case 4 -> 5;
            default -> 4;
        };
    }

    @NotNull
    public static final ShapeCellTemplate buildShapeCellTemplate(@NotNull ShapeWaterGeometry geom) {
        int cur;
        Object tail;
        int sx;
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        long[] occupancyMask = new long[8];
        int n = 0;
        byte[] byArray = new byte[512];
        while (n < 512) {
            int n2 = n++;
            byArray[n2] = -2;
        }
        byte[] componentBySubcell = byArray;
        boolean hasOpen = false;
        for (int sz = 0; sz < 8; ++sz) {
            double z = ((double)sz + 0.5) / 8.0;
            for (int sy = 0; sy < 8; ++sy) {
                double y = ((double)sy + 0.5) / 8.0;
                for (sx = 0; sx < 8; ++sx) {
                    double x = ((double)sx + 0.5) / 8.0;
                    int subIdx = ShipWaterPocketGeometryKt.subcellIndex(sx, sy, sz);
                    if (ShipWaterPocketGeometryKt.isSolidAt(geom, x, y, z)) {
                        componentBySubcell[subIdx] = -1;
                        ShipWaterPocketGeometryKt.setSubcellSolid(occupancyMask, subIdx);
                        continue;
                    }
                    hasOpen = true;
                }
            }
        }
        int componentCount = 0;
        if (hasOpen) {
            int[] queue = new int[512];
            for (int start = 0; start < 512; ++start) {
                int componentId;
                if (ShipWaterPocketGeometryKt.subcellSolid(occupancyMask, start) || componentBySubcell[start] != -2) continue;
                int n3 = componentId = componentCount < 64 ? componentCount : 63;
                if (componentCount < 64) {
                    ++componentCount;
                }
                int head = 0;
                tail = new Ref.IntRef();
                sx = tail.element;
                tail.element = sx + 1;
                queue[sx] = start;
                componentBySubcell[start] = (byte)componentId;
                while (head < tail.element) {
                    cur = queue[head++];
                    int cx = cur & 7;
                    int ct = cur >>> 3;
                    int cy = ct & 7;
                    int cz = ct >>> 3;
                    ShipWaterPocketGeometryKt.buildShapeCellTemplate$tryNeighbor(occupancyMask, componentBySubcell, componentId, queue, (Ref.IntRef)tail, cx - 1, cy, cz);
                    ShipWaterPocketGeometryKt.buildShapeCellTemplate$tryNeighbor(occupancyMask, componentBySubcell, componentId, queue, (Ref.IntRef)tail, cx + 1, cy, cz);
                    ShipWaterPocketGeometryKt.buildShapeCellTemplate$tryNeighbor(occupancyMask, componentBySubcell, componentId, queue, (Ref.IntRef)tail, cx, cy - 1, cz);
                    ShipWaterPocketGeometryKt.buildShapeCellTemplate$tryNeighbor(occupancyMask, componentBySubcell, componentId, queue, (Ref.IntRef)tail, cx, cy + 1, cz);
                    ShipWaterPocketGeometryKt.buildShapeCellTemplate$tryNeighbor(occupancyMask, componentBySubcell, componentId, queue, (Ref.IntRef)tail, cx, cy, cz - 1);
                    ShipWaterPocketGeometryKt.buildShapeCellTemplate$tryNeighbor(occupancyMask, componentBySubcell, componentId, queue, (Ref.IntRef)tail, cx, cy, cz + 1);
                }
            }
        }
        long[] faceComponentMask = new long[6];
        int[] faceOpenCount = new int[6];
        int head = 0;
        tail = new byte[384];
        while (head < 384) {
            cur = head++;
            tail[cur] = -1;
        }
        byte[] faceSampleComponent = tail;
        for (int face = 0; face < 6; ++face) {
            int faceOffset = face * 64;
            for (int sampleIdx = 0; sampleIdx < 64; ++sampleIdx) {
                int subIdx = ShipWaterPocketGeometryKt.faceSampleSubcellIndex(face, sampleIdx);
                byte component = componentBySubcell[subIdx];
                faceSampleComponent[faceOffset + sampleIdx] = component;
                if (component < 0) continue;
                int n4 = face;
                int n5 = faceOpenCount[n4];
                faceOpenCount[n4] = n5 + 1;
                faceComponentMask[face] = faceComponentMask[face] | 1L << component;
            }
        }
        return new ShapeCellTemplate(occupancyMask, componentBySubcell, componentCount, faceComponentMask, faceOpenCount, faceSampleComponent);
    }

    public static final void forEachTemplateFaceConnection(@NotNull ShapeCellTemplate templateA, @NotNull ShapeCellTemplate templateB, int dirCodeFromA, @NotNull Function2<? super Integer, ? super Integer, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)templateA, (String)"templateA");
        Intrinsics.checkNotNullParameter((Object)templateB, (String)"templateB");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$forEachTemplateFaceConnection = false;
        int faceA = ShipWaterPocketGeometryKt.faceForDirCode(dirCodeFromA);
        int faceB = ShipWaterPocketGeometryKt.oppositeFace(faceA);
        int faceOffsetA = faceA * 64;
        int faceOffsetB = faceB * 64;
        for (int sampleIdx = 0; sampleIdx < 64; ++sampleIdx) {
            byte componentB;
            byte componentA = templateA.getFaceSampleComponent()[faceOffsetA + sampleIdx];
            if (componentA < 0 || (componentB = templateB.getFaceSampleComponent()[faceOffsetB + sampleIdx]) < 0) continue;
            block.invoke((Object)componentA, (Object)componentB);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final int computeTemplateFaceConductance(@NotNull ShapeCellTemplate templateA, @NotNull ShapeCellTemplate templateB, int dirCodeFromA, long componentMaskA, long componentMaskB) {
        Intrinsics.checkNotNullParameter((Object)templateA, (String)"templateA");
        Intrinsics.checkNotNullParameter((Object)templateB, (String)"templateB");
        int count = 0;
        boolean $i$f$forEachTemplateFaceConnection = false;
        int faceA$iv = ShipWaterPocketGeometryKt.faceForDirCode(dirCodeFromA);
        int faceB$iv = ShipWaterPocketGeometryKt.oppositeFace(faceA$iv);
        int faceOffsetA$iv = faceA$iv * 64;
        int faceOffsetB$iv = faceB$iv * 64;
        for (int sampleIdx$iv = 0; sampleIdx$iv < 64; ++sampleIdx$iv) {
            void componentB;
            byte componentB$iv;
            byte componentA$iv = templateA.getFaceSampleComponent()[faceOffsetA$iv + sampleIdx$iv];
            if (componentA$iv < 0 || (componentB$iv = templateB.getFaceSampleComponent()[faceOffsetB$iv + sampleIdx$iv]) < 0) continue;
            byte by = componentB$iv;
            byte componentA = componentA$iv;
            boolean bl = false;
            if (componentMaskA != -1L && (componentMaskA >>> componentA & 1L) == 0L || componentMaskB != -1L && (componentMaskB >>> componentB & 1L) == 0L) continue;
            ++count;
        }
        return count;
    }

    public static /* synthetic */ int computeTemplateFaceConductance$default(ShapeCellTemplate shapeCellTemplate, ShapeCellTemplate shapeCellTemplate2, int n, long l, long l2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            l = -1L;
        }
        if ((n2 & 0x10) != 0) {
            l2 = -1L;
        }
        return ShipWaterPocketGeometryKt.computeTemplateFaceConductance(shapeCellTemplate, shapeCellTemplate2, n, l, l2);
    }

    public static final int computeTemplateAxisConductance(@NotNull ShapeCellTemplate templateA, @NotNull ShapeCellTemplate templateB, int axis) {
        Intrinsics.checkNotNullParameter((Object)templateA, (String)"templateA");
        Intrinsics.checkNotNullParameter((Object)templateB, (String)"templateB");
        int dirCode = switch (axis) {
            case 0 -> 1;
            case 1 -> 3;
            default -> 5;
        };
        return ShipWaterPocketGeometryKt.computeTemplateFaceConductance$default(templateA, templateB, dirCode, 0L, 0L, 24, null);
    }

    private static final boolean isGameplaySealedState(BlockState state) {
        Block block = state.m_60734_();
        Block block2 = block;
        return block2 instanceof DoorBlock ? !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue() : (block2 instanceof FenceGateBlock ? !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue() : false);
    }

    private static final double shapeBlockingScore(VoxelShape shape) {
        if (shape.m_83281_()) {
            return Double.NEGATIVE_INFINITY;
        }
        double score = 0.0;
        for (AABB box : shape.m_83299_()) {
            double dx = RangesKt.coerceIn((double)(box.f_82291_ - box.f_82288_), (double)0.0, (double)1.0);
            double dy = RangesKt.coerceIn((double)(box.f_82292_ - box.f_82289_), (double)0.0, (double)1.0);
            double dz = RangesKt.coerceIn((double)(box.f_82293_ - box.f_82290_), (double)0.0, (double)1.0);
            score += dx * dy * dz;
        }
        return score;
    }

    private static final VoxelShape resolveFluidOcclusionShape(Level level, BlockPos pos, BlockState state) {
        VoxelShape collision = state.m_60812_((BlockGetter)level, pos);
        VoxelShape occlusion = state.m_60768_((BlockGetter)level, pos);
        VoxelShape union = collision.m_83281_() && occlusion.m_83281_() ? Shapes.m_83040_() : (collision.m_83281_() ? occlusion : (occlusion.m_83281_() ? collision : Shapes.m_83110_((VoxelShape)collision, (VoxelShape)occlusion)));
        VoxelShape best = Shapes.m_83040_();
        double bestScore = Double.NEGATIVE_INFINITY;
        VoxelShape voxelShape = new VoxelShape[]{collision, occlusion, union};
        for (VoxelShape candidate : voxelShape) {
            Intrinsics.checkNotNull((Object)candidate);
            double score = ShipWaterPocketGeometryKt.shapeBlockingScore(candidate);
            if (!(score > bestScore + 1.0E-9)) continue;
            bestScore = score;
            best = candidate;
        }
        VoxelShape voxelShape2 = best;
        Intrinsics.checkNotNull((Object)voxelShape2);
        return voxelShape2;
    }

    private static final double snapBoundaryCoord(double value) {
        double clamped = RangesKt.coerceIn((double)value, (double)0.0, (double)1.0);
        if (clamped <= 0.00390625) {
            return 0.0;
        }
        if (clamped >= 0.99609375) {
            return 1.0;
        }
        return clamped;
    }

    private static final AABB snapFluidBoundaryBox(AABB box) {
        double minX = ShipWaterPocketGeometryKt.snapBoundaryCoord(box.f_82288_);
        double minY = ShipWaterPocketGeometryKt.snapBoundaryCoord(box.f_82289_);
        double minZ = ShipWaterPocketGeometryKt.snapBoundaryCoord(box.f_82290_);
        double maxX = ShipWaterPocketGeometryKt.snapBoundaryCoord(box.f_82291_);
        double maxY = ShipWaterPocketGeometryKt.snapBoundaryCoord(box.f_82292_);
        double maxZ = ShipWaterPocketGeometryKt.snapBoundaryCoord(box.f_82293_);
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static final double snapFacePlaneCoord(double value) {
        double snapped16;
        double clamped = RangesKt.coerceIn((double)value, (double)0.0, (double)1.0);
        return Math.abs(clamped - (snapped16 = Math.rint(clamped * 16.0) / 16.0)) <= 0.00390625 ? RangesKt.coerceIn((double)snapped16, (double)0.0, (double)1.0) : clamped;
    }

    private static final AABB stabilizeOpenTrapdoorFacePlane(AABB box) {
        double minX = ShipWaterPocketGeometryKt.snapFacePlaneCoord(box.f_82288_);
        double minY = ShipWaterPocketGeometryKt.snapFacePlaneCoord(box.f_82289_);
        double minZ = ShipWaterPocketGeometryKt.snapFacePlaneCoord(box.f_82290_);
        double maxX = ShipWaterPocketGeometryKt.snapFacePlaneCoord(box.f_82291_);
        double maxY = ShipWaterPocketGeometryKt.snapFacePlaneCoord(box.f_82292_);
        double maxZ = ShipWaterPocketGeometryKt.snapFacePlaneCoord(box.f_82293_);
        if (maxX - minX <= 0.00390625) {
            if (minX <= 0.00390625) {
                minX = 0.0;
                maxX = Math.max(maxX, 0.00390625);
            } else if (maxX >= 0.99609375) {
                maxX = 1.0;
                minX = Math.min(minX, 0.99609375);
            }
        }
        if (maxY - minY <= 0.00390625) {
            if (minY <= 0.00390625) {
                minY = 0.0;
                maxY = Math.max(maxY, 0.00390625);
            } else if (maxY >= 0.99609375) {
                maxY = 1.0;
                minY = Math.min(minY, 0.99609375);
            }
        }
        if (maxZ - minZ <= 0.00390625) {
            if (minZ <= 0.00390625) {
                minZ = 0.0;
                maxZ = Math.max(maxZ, 0.00390625);
            } else if (maxZ >= 0.99609375) {
                maxZ = 1.0;
                minZ = Math.min(minZ, 0.99609375);
            }
        }
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static final boolean isFullCubeBox(AABB box) {
        double eps = 1.0E-6;
        return box.f_82288_ <= eps && box.f_82289_ <= eps && box.f_82290_ <= eps && box.f_82291_ >= 1.0 - eps && box.f_82292_ >= 1.0 - eps && box.f_82293_ >= 1.0 - eps;
    }

    private static final boolean requiresRefinedSampling(VoxelShape shape, List<? extends AABB> boxes) {
        if (shape.m_83281_() || boxes.isEmpty()) {
            return false;
        }
        if (boxes.size() != 1) {
            return true;
        }
        AABB box = boxes.get(0);
        double eps = 1.0E-6;
        return !ShipWaterPocketGeometryKt.requiresRefinedSampling$isGridAligned(eps, box.f_82288_) || !ShipWaterPocketGeometryKt.requiresRefinedSampling$isGridAligned(eps, box.f_82291_) || !ShipWaterPocketGeometryKt.requiresRefinedSampling$isGridAligned(eps, box.f_82289_) || !ShipWaterPocketGeometryKt.requiresRefinedSampling$isGridAligned(eps, box.f_82292_) || !ShipWaterPocketGeometryKt.requiresRefinedSampling$isGridAligned(eps, box.f_82290_) || !ShipWaterPocketGeometryKt.requiresRefinedSampling$isGridAligned(eps, box.f_82293_);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final ShapeWaterGeometry computeShapeWaterGeometry(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (state.m_60795_()) {
                return new ShapeWaterGeometry(false, false, CollectionsKt.emptyList());
            }
            if (ShipWaterPocketGeometryKt.isGameplaySealedState(state)) {
                return new ShapeWaterGeometry(true, true, CollectionsKt.listOf((Object)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)));
            }
            shape = ShipWaterPocketGeometryKt.resolveFluidOcclusionShape(level, pos, state);
            if (shape.m_83281_()) {
                return new ShapeWaterGeometry(false, false, CollectionsKt.emptyList());
            }
            v0 = shape.m_83299_();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toAabbs(...)");
            rawBoxes = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)v0), (Function1)computeShapeWaterGeometry.rawBoxes.1.INSTANCE), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, computeShapeWaterGeometry$lambda$1(net.minecraft.world.phys.AABB ), (Lnet/minecraft/world/phys/AABB;)Ljava/lang/Boolean;)()));
            v1 = forceRefined = state.m_60734_() instanceof TrapDoorBlock != false && state.m_61138_((Property)BlockStateProperties.f_61446_) != false && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_) != false;
            if (forceRefined) {
                $this$map$iv = rawBoxes;
                $i$f$map = false;
                var9_10 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var14_18 = (AABB)item$iv$iv;
                    var16_20 = destination$iv$iv;
                    $i$a$-map-ShipWaterPocketGeometryKt$computeShapeWaterGeometry$boxes$1 = false;
                    var16_20.add(ShipWaterPocketGeometryKt.stabilizeOpenTrapdoorFacePlane((AABB)p0));
                }
                v2 = (List)destination$iv$iv;
            } else {
                v2 = boxes = rawBoxes;
            }
            if (boxes.isEmpty()) {
                return new ShapeWaterGeometry(false, false, CollectionsKt.emptyList());
            }
            if (state.m_60838_((BlockGetter)level, pos)) ** GOTO lbl-1000
            $this$any$iv = boxes;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v3 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    p0 = (AABB)element$iv;
                    $i$a$-any-ShipWaterPocketGeometryKt$computeShapeWaterGeometry$fullSolid$1 = false;
                    if (!ShipWaterPocketGeometryKt.isFullCubeBox(p0)) continue;
                    v3 = true;
                    break block13;
                }
                v3 = false;
            }
        }
        if (v3) lbl-1000:
        // 2 sources

        {
            v4 = true;
        } else {
            v4 = fullSolid = false;
        }
        if (fullSolid) {
            return new ShapeWaterGeometry(true, false, CollectionsKt.listOf((Object)new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)));
        }
        return new ShapeWaterGeometry(false, forceRefined != false || ShipWaterPocketGeometryKt.requiresRefinedSampling(shape, boxes) != false, boxes);
    }

    private static final boolean isSolidAt(ShapeWaterGeometry geom, double x, double y, double z) {
        if (geom.getFullSolid()) {
            return true;
        }
        if (geom.getBoxes().isEmpty()) {
            return false;
        }
        double eps = 1.0E-8;
        for (AABB box : geom.getBoxes()) {
            if (!(x >= box.f_82288_ - eps) || !(x <= box.f_82291_ + eps) || !(y >= box.f_82289_ - eps) || !(y <= box.f_82292_ + eps) || !(z >= box.f_82290_ - eps) || !(z <= box.f_82293_ + eps)) continue;
            return true;
        }
        return false;
    }

    public static final boolean hasOpenVolume(@NotNull ShapeWaterGeometry geom) {
        Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
        if (geom.getFullSolid()) {
            return false;
        }
        if (geom.getBoxes().isEmpty()) {
            return true;
        }
        int samples = geom.getRefined() ? 16 : 8;
        for (int sz = 0; sz < samples; ++sz) {
            double z = ((double)sz + 0.5) / (double)samples;
            for (int sy = 0; sy < samples; ++sy) {
                double y = ((double)sy + 0.5) / (double)samples;
                for (int sx = 0; sx < samples; ++sx) {
                    double x = ((double)sx + 0.5) / (double)samples;
                    if (ShipWaterPocketGeometryKt.isSolidAt(geom, x, y, z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final int computeFaceConductance(@NotNull ShapeWaterGeometry geomA, @NotNull ShapeWaterGeometry geomB, int axis) {
        Intrinsics.checkNotNullParameter((Object)geomA, (String)"geomA");
        Intrinsics.checkNotNullParameter((Object)geomB, (String)"geomB");
        if (geomA.getFullSolid() || geomB.getFullSolid()) {
            return 0;
        }
        int samples = geomA.getRefined() || geomB.getRefined() ? 16 : 8;
        double eps = 1.0E-4;
        int openSamples = 0;
        for (int sv = 0; sv < samples; ++sv) {
            double v = ((double)sv + 0.5) / (double)samples;
            for (int su = 0; su < samples; ++su) {
                double u = ((double)su + 0.5) / (double)samples;
                boolean aSolid = false;
                boolean bSolid = false;
                switch (axis) {
                    case 0: {
                        aSolid = ShipWaterPocketGeometryKt.isSolidAt(geomA, 1.0 - eps, u, v);
                        bSolid = ShipWaterPocketGeometryKt.isSolidAt(geomB, eps, u, v);
                        break;
                    }
                    case 1: {
                        aSolid = ShipWaterPocketGeometryKt.isSolidAt(geomA, u, 1.0 - eps, v);
                        bSolid = ShipWaterPocketGeometryKt.isSolidAt(geomB, u, eps, v);
                        break;
                    }
                    default: {
                        aSolid = ShipWaterPocketGeometryKt.isSolidAt(geomA, u, v, 1.0 - eps);
                        bSolid = ShipWaterPocketGeometryKt.isSolidAt(geomB, u, v, eps);
                    }
                }
                if (aSolid || bSolid) continue;
                ++openSamples;
            }
        }
        return openSamples;
    }

    @NotNull
    public static final BitSet computeInteriorMaskHeuristic(@NotNull BitSet open, int sizeX, int sizeY, int sizeZ) {
        int idx;
        boolean seenSolid;
        int x;
        int z;
        Intrinsics.checkNotNullParameter((Object)open, (String)"open");
        long volumeLong = (long)sizeX * (long)sizeY * (long)sizeZ;
        if (volumeLong <= 0L) {
            return new BitSet();
        }
        int volume = (int)volumeLong;
        if (open.isEmpty()) {
            return new BitSet(volume);
        }
        int strideY = sizeX;
        int strideZ = sizeX * sizeY;
        BitSet negX = new BitSet(volume);
        BitSet posX = new BitSet(volume);
        BitSet negY = new BitSet(volume);
        BitSet posY = new BitSet(volume);
        BitSet negZ = new BitSet(volume);
        BitSet posZ = new BitSet(volume);
        BitSet negXZ = new BitSet(volume);
        BitSet posXZ = new BitSet(volume);
        BitSet negXPosZ = new BitSet(volume);
        BitSet posXNegZ = new BitSet(volume);
        for (z = 0; z < sizeZ; ++z) {
            for (int y = 0; y < sizeY; ++y) {
                int idx2;
                int x2;
                int base = sizeX * (y + sizeY * z);
                boolean seenSolid2 = false;
                for (x2 = 0; x2 < sizeX; ++x2) {
                    idx2 = base + x2;
                    if (!open.get(idx2)) {
                        seenSolid2 = true;
                        continue;
                    }
                    if (!seenSolid2) continue;
                    negX.set(idx2);
                }
                seenSolid2 = false;
                for (x2 = sizeX - 1; -1 < x2; --x2) {
                    idx2 = base + x2;
                    if (!open.get(idx2)) {
                        seenSolid2 = true;
                        continue;
                    }
                    if (!seenSolid2) continue;
                    posX.set(idx2);
                }
            }
        }
        for (z = 0; z < sizeZ; ++z) {
            for (x = 0; x < sizeX; ++x) {
                int y;
                seenSolid = false;
                idx = x + strideZ * z;
                for (y = 0; y < sizeY; ++y) {
                    if (!open.get(idx)) {
                        seenSolid = true;
                    } else if (seenSolid) {
                        negY.set(idx);
                    }
                    idx += strideY;
                }
                seenSolid = false;
                idx = x + strideZ * z + strideY * (sizeY - 1);
                for (y = sizeY - 1; -1 < y; --y) {
                    if (!open.get(idx)) {
                        seenSolid = true;
                    } else if (seenSolid) {
                        posY.set(idx);
                    }
                    idx -= strideY;
                }
            }
        }
        for (int y = 0; y < sizeY; ++y) {
            for (x = 0; x < sizeX; ++x) {
                int z2;
                seenSolid = false;
                idx = x + strideY * y;
                for (z2 = 0; z2 < sizeZ; ++z2) {
                    if (!open.get(idx)) {
                        seenSolid = true;
                    } else if (seenSolid) {
                        negZ.set(idx);
                    }
                    idx += strideZ;
                }
                seenSolid = false;
                idx = x + strideY * y + strideZ * (sizeZ - 1);
                for (z2 = sizeZ - 1; -1 < z2; --z2) {
                    if (!open.get(idx)) {
                        seenSolid = true;
                    } else if (seenSolid) {
                        posZ.set(idx);
                    }
                    idx -= strideZ;
                }
            }
        }
        int diagInc = 1 + strideZ;
        int diagDec = 1 - strideZ;
        int diagDecRev = strideZ - 1;
        for (int y = 0; y < sizeY; ++y) {
            int startZ;
            boolean seenSolid3;
            int idx3;
            int z3;
            int x3;
            int startX;
            int yBase = strideY * y;
            for (startX = 0; startX < sizeX; ++startX) {
                x3 = startX;
                z3 = 0;
                idx3 = yBase + startX;
                seenSolid3 = false;
                while (x3 < sizeX && z3 < sizeZ) {
                    if (!open.get(idx3)) {
                        seenSolid3 = true;
                    } else if (seenSolid3) {
                        negXZ.set(idx3);
                    }
                    ++x3;
                    ++z3;
                    idx3 += diagInc;
                }
            }
            for (startZ = 1; startZ < sizeZ; ++startZ) {
                x3 = 0;
                z3 = startZ;
                idx3 = yBase + strideZ * startZ;
                seenSolid3 = false;
                while (x3 < sizeX && z3 < sizeZ) {
                    if (!open.get(idx3)) {
                        seenSolid3 = true;
                    } else if (seenSolid3) {
                        negXZ.set(idx3);
                    }
                    ++x3;
                    ++z3;
                    idx3 += diagInc;
                }
            }
            for (startX = 0; startX < sizeX; ++startX) {
                x3 = startX;
                z3 = sizeZ - 1;
                idx3 = yBase + startX + strideZ * (sizeZ - 1);
                seenSolid3 = false;
                while (x3 >= 0 && z3 >= 0) {
                    if (!open.get(idx3)) {
                        seenSolid3 = true;
                    } else if (seenSolid3) {
                        posXZ.set(idx3);
                    }
                    --x3;
                    --z3;
                    idx3 -= diagInc;
                }
            }
            for (startZ = sizeZ - 2; -1 < startZ; --startZ) {
                x3 = sizeX - 1;
                z3 = startZ;
                idx3 = yBase + (sizeX - 1) + strideZ * startZ;
                seenSolid3 = false;
                while (x3 >= 0 && z3 >= 0) {
                    if (!open.get(idx3)) {
                        seenSolid3 = true;
                    } else if (seenSolid3) {
                        posXZ.set(idx3);
                    }
                    --x3;
                    --z3;
                    idx3 -= diagInc;
                }
            }
            for (startX = 0; startX < sizeX; ++startX) {
                x3 = startX;
                z3 = sizeZ - 1;
                idx3 = yBase + startX + strideZ * (sizeZ - 1);
                seenSolid3 = false;
                while (x3 < sizeX && z3 >= 0) {
                    if (!open.get(idx3)) {
                        seenSolid3 = true;
                    } else if (seenSolid3) {
                        negXPosZ.set(idx3);
                    }
                    ++x3;
                    --z3;
                    idx3 += diagDec;
                }
            }
            for (startZ = sizeZ - 2; -1 < startZ; --startZ) {
                x3 = 0;
                z3 = startZ;
                idx3 = yBase + strideZ * startZ;
                seenSolid3 = false;
                while (x3 < sizeX && z3 >= 0) {
                    if (!open.get(idx3)) {
                        seenSolid3 = true;
                    } else if (seenSolid3) {
                        negXPosZ.set(idx3);
                    }
                    ++x3;
                    --z3;
                    idx3 += diagDec;
                }
            }
            for (startX = 0; startX < sizeX; ++startX) {
                x3 = startX;
                z3 = 0;
                idx3 = yBase + startX;
                seenSolid3 = false;
                while (x3 >= 0 && z3 < sizeZ) {
                    if (!open.get(idx3)) {
                        seenSolid3 = true;
                    } else if (seenSolid3) {
                        posXNegZ.set(idx3);
                    }
                    --x3;
                    ++z3;
                    idx3 += diagDecRev;
                }
            }
            for (startZ = 1; startZ < sizeZ; ++startZ) {
                x3 = sizeX - 1;
                z3 = startZ;
                idx3 = yBase + (sizeX - 1) + strideZ * startZ;
                seenSolid3 = false;
                while (x3 >= 0 && z3 < sizeZ) {
                    if (!open.get(idx3)) {
                        seenSolid3 = true;
                    } else if (seenSolid3) {
                        posXNegZ.set(idx3);
                    }
                    --x3;
                    ++z3;
                    idx3 += diagDecRev;
                }
            }
        }
        BitSet interior = new BitSet(volume);
        int idx4 = open.nextSetBit(0);
        while (idx4 >= 0 && idx4 < volume) {
            int lx = idx4 % sizeX;
            int t = idx4 / sizeX;
            int ly = t % sizeY;
            int lz = t / sizeY;
            if (lx == 0 || lx + 1 == sizeX || ly == 0 || ly + 1 == sizeY || lz == 0 || lz + 1 == sizeZ) {
                idx4 = open.nextSetBit(idx4 + 1);
                continue;
            }
            boolean pairX = negX.get(idx4) && posX.get(idx4);
            boolean pairY = negY.get(idx4) && posY.get(idx4);
            boolean pairZ = negZ.get(idx4) && posZ.get(idx4);
            boolean pairDiagA = negXZ.get(idx4) && posXZ.get(idx4);
            boolean pairDiagB = negXPosZ.get(idx4) && posXNegZ.get(idx4);
            int axisPairs = 0;
            if (pairX) {
                ++axisPairs;
            }
            if (pairY) {
                ++axisPairs;
            }
            if (pairZ) {
                ++axisPairs;
            }
            if (pairDiagA) {
                ++axisPairs;
            }
            if (pairDiagB) {
                ++axisPairs;
            }
            int diagPairs = (pairDiagA ? 1 : 0) + (pairDiagB ? 1 : 0);
            if (axisPairs >= 3 && (pairY || diagPairs == 2)) {
                interior.set(idx4);
            }
            idx4 = open.nextSetBit(idx4 + 1);
        }
        return interior;
    }

    private static final void buildShapeCellTemplate$tryNeighbor(long[] occupancyMask, byte[] componentBySubcell, int componentId, int[] queue, Ref.IntRef tail, int nx, int ny, int nz) {
        block6: {
            block5: {
                boolean bl = 0 <= nx ? nx < 8 : false;
                if (!bl) break block5;
                boolean bl2 = 0 <= ny ? ny < 8 : false;
                if (!bl2) break block5;
                if (0 <= nz ? nz < 8 : false) break block6;
            }
            return;
        }
        int n = ShipWaterPocketGeometryKt.subcellIndex(nx, ny, nz);
        if (ShipWaterPocketGeometryKt.subcellSolid(occupancyMask, n)) {
            return;
        }
        if (componentBySubcell[n] != -2) {
            return;
        }
        componentBySubcell[n] = (byte)componentId;
        int n2 = tail.element;
        tail.element = n2 + 1;
        queue[n2] = n;
    }

    private static final boolean requiresRefinedSampling$isGridAligned(double eps, double v) {
        double n = v * 8.0;
        return Math.abs(n - Math.rint(n)) <= eps;
    }

    private static final boolean computeShapeWaterGeometry$lambda$1(AABB it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.f_82291_ - it.f_82288_ > 1.0E-9 && it.f_82292_ - it.f_82289_ > 1.0E-9 && it.f_82293_ - it.f_82290_ > 1.0E-9;
    }

    public static final /* synthetic */ AABB access$snapFluidBoundaryBox(AABB box) {
        return ShipWaterPocketGeometryKt.snapFluidBoundaryBox(box);
    }
}

