/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.feature.ship_water_pockets;

import it.unimi.dsi.fastutil.ints.Int2DoubleMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.BitSet;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.PersistedShipPocketState;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipPocketState;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketDomainKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0013\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0002H\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u001f\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001aO\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001ag\u0010&\u001a\u00020%2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b&\u0010'\u001a\u0017\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002\u00a2\u0006\u0004\b*\u0010+\u001a\u0017\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b.\u0010/\u001a\u0017\u00101\u001a\u00020\u00122\u0006\u00100\u001a\u00020-H\u0002\u00a2\u0006\u0004\b1\u00102\u001a\u0017\u00103\u001a\u00020-2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b3\u00104\u001a\u0017\u00105\u001a\u00020\t2\u0006\u00100\u001a\u00020-H\u0002\u00a2\u0006\u0004\b5\u00106\u001a\u0017\u00107\u001a\u00020-2\u0006\u0010\n\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b7\u00108\u001a\u0017\u00109\u001a\u00020\u000f2\u0006\u00100\u001a\u00020-H\u0002\u00a2\u0006\u0004\b9\u0010:\u001a\u0017\u0010<\u001a\u00020-2\u0006\u0010;\u001a\u00020-H\u0002\u00a2\u0006\u0004\b<\u0010=\u001a\u0017\u0010?\u001a\u00020-2\u0006\u0010>\u001a\u00020-H\u0002\u00a2\u0006\u0004\b?\u0010=\u00a8\u0006@"}, d2={"Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;", "state", "Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/PersistedShipPocketState;", "snapshotStateForPersistence", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;)Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/PersistedShipPocketState;", "persisted", "", "applyPersistedState", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/PersistedShipPocketState;)V", "", "values", "", "volume", "sanitizeFaceConductance", "([SI)[S", "", "sanitizeVoxelMasks", "([JI)[J", "Ljava/util/BitSet;", "open", "simulationDomain", "sizeX", "sizeY", "sizeZ", "faceCondXP", "faceCondYP", "faceCondZP", "reconstructOutsideVoidForLegacy", "(Ljava/util/BitSet;Ljava/util/BitSet;III[S[S[S)Ljava/util/BitSet;", "exterior", "strictInterior", "outsideVoid", "interiorLegacy", "flooded", "materializedWater", "waterReachable", "unreachableVoid", "", "normalizePersistedMasks", "(ILjava/util/BitSet;Ljava/util/BitSet;Ljava/util/BitSet;Ljava/util/BitSet;Ljava/util/BitSet;Ljava/util/BitSet;Ljava/util/BitSet;Ljava/util/BitSet;Ljava/util/BitSet;Ljava/util/BitSet;)Z", "Lnet/minecraft/world/level/material/Fluid;", "fluid", "canonicalFloodSource", "(Lnet/minecraft/world/level/material/Fluid;)Lnet/minecraft/world/level/material/Fluid;", "bits", "", "encodeBitSet", "(Ljava/util/BitSet;)[B", "bytes", "decodeBitSet", "([B)Ljava/util/BitSet;", "encodeShortArray", "([S)[B", "decodeShortArray", "([B)[S", "encodeLongArray", "([J)[B", "decodeLongArray", "([B)[J", "raw", "compressBytes", "([B)[B", "compressed", "decompressBytes", "valkyrien-air"})
public final class ShipWaterPocketPersistenceKt {
    @NotNull
    public static final PersistedShipPocketState snapshotStateForPersistence(@NotNull ShipPocketState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int n = state.getMinX();
        int n2 = state.getMinY();
        int n3 = state.getMinZ();
        int n4 = state.getSizeX();
        int n5 = state.getSizeY();
        int n6 = state.getSizeZ();
        Object object = state.getOpen().clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.BitSet");
        BitSet bitSet = (BitSet)object;
        Object object2 = state.getExterior().clone();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.util.BitSet");
        BitSet bitSet2 = (BitSet)object2;
        Object object3 = state.getStrictInterior().clone();
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type java.util.BitSet");
        BitSet bitSet3 = (BitSet)object3;
        Object object4 = state.getSimulationDomain().clone();
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type java.util.BitSet");
        BitSet bitSet4 = (BitSet)object4;
        Object object5 = state.getOutsideVoid().clone();
        Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type java.util.BitSet");
        BitSet bitSet5 = (BitSet)object5;
        Object object6 = state.getInterior().clone();
        Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type java.util.BitSet");
        BitSet bitSet6 = (BitSet)object6;
        Fluid fluid = ShipWaterPocketPersistenceKt.canonicalFloodSource(state.getFloodFluid());
        Object object7 = state.getFlooded().clone();
        Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type java.util.BitSet");
        BitSet bitSet7 = (BitSet)object7;
        Object object8 = state.getMaterializedWater().clone();
        Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type java.util.BitSet");
        BitSet bitSet8 = (BitSet)object8;
        Object object9 = state.getWaterReachable().clone();
        Intrinsics.checkNotNull((Object)object9, (String)"null cannot be cast to non-null type java.util.BitSet");
        BitSet bitSet9 = (BitSet)object9;
        Object object10 = state.getUnreachableVoid().clone();
        Intrinsics.checkNotNull((Object)object10, (String)"null cannot be cast to non-null type java.util.BitSet");
        BitSet bitSet10 = (BitSet)object10;
        short[] sArray = state.getFaceCondXP();
        short[] sArray2 = Arrays.copyOf(sArray, sArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)sArray2, (String)"copyOf(...)");
        short[] sArray3 = state.getFaceCondYP();
        short[] sArray4 = Arrays.copyOf(sArray3, sArray3.length);
        Intrinsics.checkNotNullExpressionValue((Object)sArray4, (String)"copyOf(...)");
        short[] sArray5 = state.getFaceCondZP();
        short[] sArray6 = Arrays.copyOf(sArray5, sArray5.length);
        Intrinsics.checkNotNullExpressionValue((Object)sArray6, (String)"copyOf(...)");
        long[] lArray = state.getVoxelExteriorComponentMask();
        long[] lArray2 = Arrays.copyOf(lArray, lArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"copyOf(...)");
        long[] lArray3 = state.getVoxelInteriorComponentMask();
        long[] lArray4 = Arrays.copyOf(lArray3, lArray3.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray4, (String)"copyOf(...)");
        long[] lArray5 = state.getVoxelSimulationComponentMask();
        long[] lArray6 = Arrays.copyOf(lArray5, lArray5.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray6, (String)"copyOf(...)");
        return new PersistedShipPocketState(n, n2, n3, n4, n5, n6, bitSet, bitSet2, bitSet3, bitSet4, bitSet5, bitSet6, fluid, bitSet7, bitSet8, bitSet9, bitSet10, sArray2, sArray4, sArray6, lArray2, lArray4, lArray6, new Int2DoubleOpenHashMap((Int2DoubleMap)state.getFloodPlaneByComponent()), state.getGeometryRevision(), state.getGeometrySignature(), false, 0x4000000, null);
    }

    public static final void applyPersistedState(@NotNull ShipPocketState state, @NotNull PersistedShipPocketState persisted) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)persisted, (String)"persisted");
        state.setMinX(persisted.getMinX());
        state.setMinY(persisted.getMinY());
        state.setMinZ(persisted.getMinZ());
        state.setSizeX(persisted.getSizeX());
        state.setSizeY(persisted.getSizeY());
        state.setSizeZ(persisted.getSizeZ());
        Object object = persisted.getOpen().clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.BitSet");
        state.setOpen((BitSet)object);
        Object object2 = persisted.getExterior().clone();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.util.BitSet");
        state.setExterior((BitSet)object2);
        Object object3 = persisted.getStrictInterior().clone();
        Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type java.util.BitSet");
        state.setStrictInterior((BitSet)object3);
        Object object4 = persisted.getSimulationDomain().clone();
        Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type java.util.BitSet");
        state.setSimulationDomain((BitSet)object4);
        Object object5 = persisted.getOutsideVoid().clone();
        Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type java.util.BitSet");
        state.setOutsideVoid((BitSet)object5);
        Object object6 = persisted.getStrictInterior().clone();
        Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type java.util.BitSet");
        state.setInterior((BitSet)object6);
        state.setFloodFluid(ShipWaterPocketPersistenceKt.canonicalFloodSource(persisted.getFloodFluid()));
        Object object7 = persisted.getFlooded().clone();
        Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type java.util.BitSet");
        state.setFlooded((BitSet)object7);
        Object object8 = persisted.getMaterializedWater().clone();
        Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type java.util.BitSet");
        state.setMaterializedWater((BitSet)object8);
        Object object9 = persisted.getWaterReachable().clone();
        Intrinsics.checkNotNull((Object)object9, (String)"null cannot be cast to non-null type java.util.BitSet");
        state.setWaterReachable((BitSet)object9);
        Object object10 = persisted.getUnreachableVoid().clone();
        Intrinsics.checkNotNull((Object)object10, (String)"null cannot be cast to non-null type java.util.BitSet");
        state.setUnreachableVoid((BitSet)object10);
        short[] sArray = persisted.getFaceCondXP();
        short[] sArray2 = Arrays.copyOf(sArray, sArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)sArray2, (String)"copyOf(...)");
        state.setFaceCondXP(sArray2);
        short[] sArray3 = persisted.getFaceCondYP();
        short[] sArray4 = Arrays.copyOf(sArray3, sArray3.length);
        Intrinsics.checkNotNullExpressionValue((Object)sArray4, (String)"copyOf(...)");
        state.setFaceCondYP(sArray4);
        short[] sArray5 = persisted.getFaceCondZP();
        short[] sArray6 = Arrays.copyOf(sArray5, sArray5.length);
        Intrinsics.checkNotNullExpressionValue((Object)sArray6, (String)"copyOf(...)");
        state.setFaceCondZP(sArray6);
        state.setShapeTemplatePalette(CollectionsKt.emptyList());
        state.setTemplateIndexByVoxel(new int[0]);
        long[] lArray = persisted.getVoxelExteriorComponentMask();
        long[] lArray2 = Arrays.copyOf(lArray, lArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"copyOf(...)");
        state.setVoxelExteriorComponentMask(lArray2);
        long[] lArray3 = persisted.getVoxelInteriorComponentMask();
        long[] lArray4 = Arrays.copyOf(lArray3, lArray3.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray4, (String)"copyOf(...)");
        state.setVoxelInteriorComponentMask(lArray4);
        long[] lArray5 = persisted.getVoxelSimulationComponentMask();
        long[] lArray6 = Arrays.copyOf(lArray5, lArray5.length);
        Intrinsics.checkNotNullExpressionValue((Object)lArray6, (String)"copyOf(...)");
        state.setVoxelSimulationComponentMask(lArray6);
        state.setComponentGraphDegraded(true);
        state.setFloodPlaneByComponent(new Int2DoubleOpenHashMap((Int2DoubleMap)persisted.getFloodPlaneByComponent()));
        state.setGeometryRevision(persisted.getGeometryRevision());
        state.setGeometrySignature(persisted.getGeometrySignature());
        state.setDirty(true);
        state.setPersistDirty(persisted.getRequiresResave());
        state.setRestoredFromPersistence(true);
        state.setAwaitingGeometryValidation(true);
    }

    private static final short[] sanitizeFaceConductance(short[] values, int volume) {
        short[] sArray;
        if (values.length == 0) {
            return values;
        }
        if (values.length >= volume) {
            short[] sArray2 = Arrays.copyOf(values, volume);
            sArray = sArray2;
            Intrinsics.checkNotNullExpressionValue((Object)sArray2, (String)"copyOf(...)");
        } else {
            sArray = new short[]{};
        }
        return sArray;
    }

    private static final long[] sanitizeVoxelMasks(long[] values, int volume) {
        long[] lArray;
        if (values.length > volume) {
            long[] lArray2 = Arrays.copyOf(values, volume);
            lArray = lArray2;
            Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"copyOf(...)");
        } else {
            lArray = values;
        }
        return lArray;
    }

    private static final BitSet reconstructOutsideVoidForLegacy(BitSet open, BitSet simulationDomain, int sizeX, int sizeY, int sizeZ, short[] faceCondXP, short[] faceCondYP, short[] faceCondZP) {
        boolean hasValidFaceConductance;
        int volume = sizeX * sizeY * sizeZ;
        boolean bl = hasValidFaceConductance = faceCondXP.length == volume && faceCondYP.length == volume && faceCondZP.length == volume;
        if (hasValidFaceConductance) {
            return ShipWaterPocketDomainKt.computeOutsideVoidFromGeometry$default(open, simulationDomain, sizeX, sizeY, sizeZ, faceCondXP, faceCondYP, faceCondZP, 0, 256, null);
        }
        Object object = open.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.BitSet");
        BitSet fallback = (BitSet)object;
        fallback.andNot(simulationDomain);
        return fallback;
    }

    private static final boolean normalizePersistedMasks(int volume, BitSet open, BitSet exterior, BitSet strictInterior, BitSet simulationDomain, BitSet outsideVoid, BitSet interiorLegacy, BitSet flooded, BitSet materializedWater, BitSet waterReachable, BitSet unreachableVoid) {
        boolean changed = false;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampToVolume(volume, open);
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampToVolume(volume, exterior) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampToVolume(volume, strictInterior) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampToVolume(volume, simulationDomain) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampToVolume(volume, outsideVoid) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampToVolume(volume, interiorLegacy) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampToVolume(volume, flooded) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampToVolume(volume, materializedWater) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampToVolume(volume, waterReachable) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampToVolume(volume, unreachableVoid) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampSubset(exterior, open) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampSubset(strictInterior, open) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampSubset(simulationDomain, open) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampSubset(interiorLegacy, open) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampSubset(flooded, open) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampSubset(materializedWater, open) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampSubset(waterReachable, open) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampSubset(unreachableVoid, open) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampSubset(flooded, simulationDomain) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampSubset(materializedWater, simulationDomain) || changed;
        changed = ShipWaterPocketPersistenceKt.normalizePersistedMasks$clampSubset(outsideVoid, open) || changed;
        int outsideBefore = outsideVoid.cardinality();
        outsideVoid.andNot(simulationDomain);
        if (outsideVoid.cardinality() != outsideBefore) {
            changed = true;
        }
        return changed;
    }

    private static final Fluid canonicalFloodSource(Fluid fluid) {
        Fluid fluid2;
        if (fluid instanceof FlowingFluid) {
            Fluid fluid3 = ((FlowingFluid)fluid).m_5613_();
            fluid2 = fluid3;
            Intrinsics.checkNotNullExpressionValue((Object)fluid3, (String)"getSource(...)");
        } else {
            fluid2 = fluid;
        }
        return fluid2;
    }

    private static final byte[] encodeBitSet(BitSet bits) {
        long[] lArray = bits.toLongArray();
        Intrinsics.checkNotNullExpressionValue((Object)lArray, (String)"toLongArray(...)");
        return ShipWaterPocketPersistenceKt.encodeLongArray(lArray);
    }

    private static final BitSet decodeBitSet(byte[] bytes) {
        long[] longs = ShipWaterPocketPersistenceKt.decodeLongArray(bytes);
        BitSet bitSet = BitSet.valueOf(longs);
        Intrinsics.checkNotNullExpressionValue((Object)bitSet, (String)"valueOf(...)");
        return bitSet;
    }

    private static final byte[] encodeShortArray(short[] values) {
        if (values.length == 0) {
            return new byte[0];
        }
        byte[] raw = new byte[values.length * 2];
        ByteBuffer bb = ByteBuffer.wrap(raw).order(ByteOrder.LITTLE_ENDIAN);
        for (short value : values) {
            bb.putShort(value);
        }
        return ShipWaterPocketPersistenceKt.compressBytes(raw);
    }

    private static final short[] decodeShortArray(byte[] bytes) {
        if (bytes.length == 0) {
            return new short[0];
        }
        byte[] raw = ShipWaterPocketPersistenceKt.decompressBytes(bytes);
        if (raw.length == 0 || raw.length % 2 != 0) {
            return new short[0];
        }
        short[] out = new short[raw.length / 2];
        ByteBuffer bb = ByteBuffer.wrap(raw).order(ByteOrder.LITTLE_ENDIAN);
        int n = out.length;
        for (int i = 0; i < n; ++i) {
            out[i] = bb.getShort();
        }
        return out;
    }

    private static final byte[] encodeLongArray(long[] values) {
        if (values.length == 0) {
            return new byte[0];
        }
        byte[] raw = new byte[values.length * 8];
        ByteBuffer bb = ByteBuffer.wrap(raw).order(ByteOrder.LITTLE_ENDIAN);
        for (long value : values) {
            bb.putLong(value);
        }
        return ShipWaterPocketPersistenceKt.compressBytes(raw);
    }

    private static final long[] decodeLongArray(byte[] bytes) {
        if (bytes.length == 0) {
            return new long[0];
        }
        byte[] raw = ShipWaterPocketPersistenceKt.decompressBytes(bytes);
        if (raw.length == 0 || raw.length % 8 != 0) {
            return new long[0];
        }
        long[] out = new long[raw.length / 8];
        ByteBuffer bb = ByteBuffer.wrap(raw).order(ByteOrder.LITTLE_ENDIAN);
        int n = out.length;
        for (int i = 0; i < n; ++i) {
            out[i] = bb.getLong();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] compressBytes(byte[] raw) {
        if (raw.length == 0) {
            return raw;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream(raw.length);
        Closeable closeable = new DeflaterOutputStream(output);
        Throwable throwable = null;
        try {
            DeflaterOutputStream deflater = (DeflaterOutputStream)closeable;
            boolean bl = false;
            deflater.write(raw);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = output.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] decompressBytes(byte[] compressed) {
        Object object;
        if (compressed.length == 0) {
            return compressed;
        }
        try {
            byte[] byArray;
            object = new InflaterInputStream(new ByteArrayInputStream(compressed));
            Throwable throwable = null;
            try {
                InflaterInputStream inflater = (InflaterInputStream)object;
                boolean bl = false;
                byArray = ByteStreamsKt.readBytes((InputStream)inflater);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = byArray;
        }
        catch (Throwable throwable) {
            object = new byte[]{};
        }
        return object;
    }

    private static final boolean normalizePersistedMasks$clampToVolume(int $volume, BitSet bits) {
        int firstOutOfRange = bits.nextSetBit($volume);
        if (firstOutOfRange >= 0) {
            bits.clear($volume, bits.length());
            return true;
        }
        return false;
    }

    private static final boolean normalizePersistedMasks$clampSubset(BitSet bits, BitSet superset) {
        int originalCardinality = bits.cardinality();
        bits.and(superset);
        return bits.cardinality() != originalCardinality;
    }

    public static final /* synthetic */ byte[] access$encodeBitSet(BitSet bits) {
        return ShipWaterPocketPersistenceKt.encodeBitSet(bits);
    }

    public static final /* synthetic */ byte[] access$encodeShortArray(short[] values) {
        return ShipWaterPocketPersistenceKt.encodeShortArray(values);
    }

    public static final /* synthetic */ byte[] access$encodeLongArray(long[] values) {
        return ShipWaterPocketPersistenceKt.encodeLongArray(values);
    }

    public static final /* synthetic */ BitSet access$decodeBitSet(byte[] bytes) {
        return ShipWaterPocketPersistenceKt.decodeBitSet(bytes);
    }

    public static final /* synthetic */ short[] access$decodeShortArray(byte[] bytes) {
        return ShipWaterPocketPersistenceKt.decodeShortArray(bytes);
    }

    public static final /* synthetic */ short[] access$sanitizeFaceConductance(short[] values, int volume) {
        return ShipWaterPocketPersistenceKt.sanitizeFaceConductance(values, volume);
    }

    public static final /* synthetic */ long[] access$decodeLongArray(byte[] bytes) {
        return ShipWaterPocketPersistenceKt.decodeLongArray(bytes);
    }

    public static final /* synthetic */ long[] access$sanitizeVoxelMasks(long[] values, int volume) {
        return ShipWaterPocketPersistenceKt.sanitizeVoxelMasks(values, volume);
    }

    public static final /* synthetic */ BitSet access$reconstructOutsideVoidForLegacy(BitSet open, BitSet simulationDomain, int sizeX, int sizeY, int sizeZ, short[] faceCondXP, short[] faceCondYP, short[] faceCondZP) {
        return ShipWaterPocketPersistenceKt.reconstructOutsideVoidForLegacy(open, simulationDomain, sizeX, sizeY, sizeZ, faceCondXP, faceCondYP, faceCondZP);
    }

    public static final /* synthetic */ boolean access$normalizePersistedMasks(int volume, BitSet open, BitSet exterior, BitSet strictInterior, BitSet simulationDomain, BitSet outsideVoid, BitSet interiorLegacy, BitSet flooded, BitSet materializedWater, BitSet waterReachable, BitSet unreachableVoid) {
        return ShipWaterPocketPersistenceKt.normalizePersistedMasks(volume, open, exterior, strictInterior, simulationDomain, outsideVoid, interiorLegacy, flooded, materializedWater, waterReachable, unreachableVoid);
    }

    public static final /* synthetic */ Fluid access$canonicalFloodSource(Fluid fluid) {
        return ShipWaterPocketPersistenceKt.canonicalFloodSource(fluid);
    }
}

