/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.feature.ship_water_pockets;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipPocketState;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketPointQueriesKt;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketStateAccessKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\u001a1\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a'\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a1\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a1\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0011\u001aK\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018\"\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lnet/minecraft/world/level/Level;", "level", "Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;", "state", "Lorg/joml/Vector3d;", "shipPos", "Lnet/minecraft/core/BlockPos$MutableBlockPos;", "tmp", "findOpenShipBlockPosForPoint", "(Lnet/minecraft/world/level/Level;Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;Lorg/joml/Vector3d;Lnet/minecraft/core/BlockPos$MutableBlockPos;)Lnet/minecraft/core/BlockPos$MutableBlockPos;", "shipBlockPos", "Lnet/minecraft/world/level/material/FluidState;", "findShipFluidAtShipPoint", "(Lnet/minecraft/world/level/Level;Lorg/joml/Vector3d;Lnet/minecraft/core/BlockPos$MutableBlockPos;)Lnet/minecraft/world/level/material/FluidState;", "", "radius", "findNearbyAirPocket", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;Lorg/joml/Vector3d;Lnet/minecraft/core/BlockPos$MutableBlockPos;I)Lnet/minecraft/core/BlockPos$MutableBlockPos;", "findNearbyWorldFluidSuppressionZone", "Lkotlin/Function2;", "Lnet/minecraft/core/BlockPos;", "", "predicate", "findNearbyStateCellByPredicate", "(Lorg/valkyrienskies/valkyrienair/feature/ship_water_pockets/ShipPocketState;Lorg/joml/Vector3d;Lnet/minecraft/core/BlockPos$MutableBlockPos;ILkotlin/jvm/functions/Function2;)Lnet/minecraft/core/BlockPos$MutableBlockPos;", "", "POINT_QUERY_EPS", "D", "valkyrien-air"})
public final class ShipWaterPocketPointQueriesKt {
    private static final double POINT_QUERY_EPS = 1.0E-5;

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final BlockPos.MutableBlockPos findOpenShipBlockPosForPoint(@NotNull Level level, @NotNull ShipPocketState state, @NotNull Vector3d shipPos, @NotNull BlockPos.MutableBlockPos tmp) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)shipPos, (String)"shipPos");
        Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
        x = shipPos.x;
        y = shipPos.y;
        z = shipPos.z;
        if (ShipWaterPocketStateAccessKt.isOpenAtShipPoint(state, x, y, z, tmp)) {
            return tmp;
        }
        e = 1.0E-5;
        var13_8 = new double[]{-e, 0.0, e};
        for (double dx : var13_8) {
            var18_18 = new double[]{-e, 0.0, e};
            for (double dy : var18_18) {
                var23_26 = new double[]{-e, 0.0, e};
                for (double dz : var23_26) {
                    if (dx == 0.0 && dy == 0.0 && dz == 0.0 || !ShipWaterPocketStateAccessKt.isOpenAtShipPoint(state, x + dx, y + dy, z + dz, tmp)) continue;
                    return tmp;
                }
            }
        }
        baseX = Mth.m_14107_((double)x);
        baseY = Mth.m_14107_((double)y);
        baseZ = Mth.m_14107_((double)z);
        baseLX = baseX - state.getMinX();
        baseLY = baseY - state.getMinY();
        baseLZ = baseZ - state.getMinZ();
        v0 = 0 <= baseLX ? baseLX < state.getSizeX() : false;
        if (!v0) ** GOTO lbl-1000
        v1 = 0 <= baseLY ? baseLY < state.getSizeY() : false;
        if (!v1) ** GOTO lbl-1000
        v2 = 0 <= baseLZ ? baseLZ < state.getSizeZ() : false;
        if (v2) {
            v3 = true;
        } else lbl-1000:
        // 3 sources

        {
            v3 = false;
        }
        baseInBounds = v3;
        baseIdx = baseInBounds != false ? ShipWaterPocketStateAccessKt.indexOf(state, baseLX, baseLY, baseLZ) : -1;
        $i$a$-run-ShipWaterPocketPointQueriesKt$findOpenShipBlockPosForPoint$1 = false;
        tmp.m_122178_(baseX, baseY, baseZ);
        bs = level.m_8055_((BlockPos)tmp);
        shape = bs.m_60812_((BlockGetter)level, (BlockPos)tmp);
        if (!shape.m_83281_()) {
            fullBlock = bs.m_60838_((BlockGetter)level, (BlockPos)tmp);
            fx = RangesKt.coerceIn((double)(x - (double)baseX), (double)0.0, (double)1.0);
            fy = RangesKt.coerceIn((double)(y - (double)baseY), (double)0.0, (double)1.0);
            fz = RangesKt.coerceIn((double)(z - (double)baseZ), (double)0.0, (double)1.0);
            eps = 1.0E-4;
            v4 = shape.m_83299_();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toAabbs(...)");
            boxes = v4;
            var33_40 = new double[]{Infinity, 0.0, 0.0, 0.0, 0.0};
            best = var33_40;
            ShipWaterPocketPointQueriesKt.findOpenShipBlockPosForPoint$lambda$0$consider(tmp, baseX, baseY, baseZ, state, fullBlock, boxes, baseIdx, baseLX, baseLY, baseLZ, -1, 0, 0, 0, eps, fy, fz, fx, best);
            ShipWaterPocketPointQueriesKt.findOpenShipBlockPosForPoint$lambda$0$consider(tmp, baseX, baseY, baseZ, state, fullBlock, boxes, baseIdx, baseLX, baseLY, baseLZ, 1, 0, 0, 1, 1.0 - eps, fy, fz, 1.0 - fx, best);
            ShipWaterPocketPointQueriesKt.findOpenShipBlockPosForPoint$lambda$0$consider(tmp, baseX, baseY, baseZ, state, fullBlock, boxes, baseIdx, baseLX, baseLY, baseLZ, 0, -1, 0, 2, fx, eps, fz, fy, best);
            ShipWaterPocketPointQueriesKt.findOpenShipBlockPosForPoint$lambda$0$consider(tmp, baseX, baseY, baseZ, state, fullBlock, boxes, baseIdx, baseLX, baseLY, baseLZ, 0, 1, 0, 3, fx, 1.0 - eps, fz, 1.0 - fy, best);
            ShipWaterPocketPointQueriesKt.findOpenShipBlockPosForPoint$lambda$0$consider(tmp, baseX, baseY, baseZ, state, fullBlock, boxes, baseIdx, baseLX, baseLY, baseLZ, 0, 0, -1, 4, fx, fy, eps, fz, best);
            ShipWaterPocketPointQueriesKt.findOpenShipBlockPosForPoint$lambda$0$consider(tmp, baseX, baseY, baseZ, state, fullBlock, boxes, baseIdx, baseLX, baseLY, baseLZ, 0, 0, 1, 5, fx, fy, 1.0 - eps, 1.0 - fz, best);
            if (!(best[0] == Infinity)) {
                tmp.m_122178_((int)best[2], (int)best[3], (int)best[4]);
                return tmp;
            }
        }
        bestDistSq = Infinity;
        bestX = 0;
        bestY = 0;
        bestZ = 0;
        for (dx = -1; dx < 2; ++dx) {
            px = baseX + dx;
            cx = (double)px + 0.5;
            ddx = x - cx;
            for (dy = -1; dy < 2; ++dy) {
                py = baseY + dy;
                cy = (double)py + 0.5;
                ddy = y - cy;
                for (dz = -1; dz < 2; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    pz = baseZ + dz;
                    tmp.m_122178_(px, py, pz);
                    if (!ShipWaterPocketStateAccessKt.isOpen(state, (BlockPos)tmp)) continue;
                    if (baseIdx >= 0 && (manhattan = Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) == 1) {
                        v5 = dx < 0 ? 0 : (dx > 0 ? 1 : (dy < 0 ? 2 : (dy > 0 ? 3 : (dirCode = dz < 0 ? 4 : 5))));
                        if (!ShipWaterPocketPointQueriesKt.findOpenShipBlockPosForPoint$edgePasses(baseIdx, state, baseLX, baseLY, baseLZ, dirCode)) continue;
                    }
                    if (!((distSq = ddx * ddx + ddy * ddy + (ddz = z - (cz = (double)pz + 0.5)) * ddz) < bestDistSq - 1.0E-12)) continue;
                    bestDistSq = distSq;
                    bestX = px;
                    bestY = py;
                    bestZ = pz;
                }
            }
        }
        if (!(bestDistSq == Infinity)) {
            tmp.m_122178_(bestX, bestY, bestZ);
            return tmp;
        }
        return null;
    }

    @NotNull
    public static final FluidState findShipFluidAtShipPoint(@NotNull Level level, @NotNull Vector3d shipPos, @NotNull BlockPos.MutableBlockPos shipBlockPos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)shipPos, (String)"shipPos");
        Intrinsics.checkNotNullParameter((Object)shipBlockPos, (String)"shipBlockPos");
        int baseX = shipBlockPos.m_123341_();
        int baseY = shipBlockPos.m_123342_();
        int baseZ = shipBlockPos.m_123343_();
        FluidState shipFluid = level.m_8055_((BlockPos)shipBlockPos).m_60819_();
        if (!shipFluid.m_76178_()) {
            FluidState fluidState = shipFluid;
            Intrinsics.checkNotNull((Object)fluidState);
            return fluidState;
        }
        double e = 1.0E-5;
        for (int dxi = -1; dxi < 2; ++dxi) {
            double dx = (double)dxi * e;
            for (int dyi = -1; dyi < 2; ++dyi) {
                double dy = (double)dyi * e;
                for (int dzi = -1; dzi < 2; ++dzi) {
                    double dz = (double)dzi * e;
                    if (dxi == 0 && dyi == 0 && dzi == 0) continue;
                    shipBlockPos.m_122178_(Mth.m_14107_((double)(shipPos.x + dx)), Mth.m_14107_((double)(shipPos.y + dy)), Mth.m_14107_((double)(shipPos.z + dz)));
                    shipFluid = level.m_8055_((BlockPos)shipBlockPos).m_60819_();
                    if (shipFluid.m_76178_()) continue;
                    FluidState fluidState = shipFluid;
                    Intrinsics.checkNotNull((Object)fluidState);
                    return fluidState;
                }
            }
        }
        shipBlockPos.m_122178_(baseX, baseY, baseZ);
        FluidState fluidState = shipFluid;
        Intrinsics.checkNotNull((Object)fluidState);
        return fluidState;
    }

    @Nullable
    public static final BlockPos.MutableBlockPos findNearbyAirPocket(@NotNull ShipPocketState state, @NotNull Vector3d shipPos, @NotNull BlockPos.MutableBlockPos shipBlockPos, int radius) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)shipPos, (String)"shipPos");
        Intrinsics.checkNotNullParameter((Object)shipBlockPos, (String)"shipBlockPos");
        return ShipWaterPocketPointQueriesKt.findNearbyStateCellByPredicate(state, shipPos, shipBlockPos, radius, (Function2<? super ShipPocketState, ? super BlockPos, Boolean>)((Function2)findNearbyAirPocket.1.INSTANCE));
    }

    @Nullable
    public static final BlockPos.MutableBlockPos findNearbyWorldFluidSuppressionZone(@NotNull ShipPocketState state, @NotNull Vector3d shipPos, @NotNull BlockPos.MutableBlockPos shipBlockPos, int radius) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)shipPos, (String)"shipPos");
        Intrinsics.checkNotNullParameter((Object)shipBlockPos, (String)"shipBlockPos");
        return ShipWaterPocketPointQueriesKt.findNearbyStateCellByPredicate(state, shipPos, shipBlockPos, radius, (Function2<? super ShipPocketState, ? super BlockPos, Boolean>)((Function2)findNearbyWorldFluidSuppressionZone.1.INSTANCE));
    }

    private static final BlockPos.MutableBlockPos findNearbyStateCellByPredicate(ShipPocketState state, Vector3d shipPos, BlockPos.MutableBlockPos shipBlockPos, int radius, Function2<? super ShipPocketState, ? super BlockPos, Boolean> predicate) {
        int baseX = shipBlockPos.m_123341_();
        int baseY = shipBlockPos.m_123342_();
        int baseZ = shipBlockPos.m_123343_();
        if (((Boolean)predicate.invoke((Object)state, (Object)shipBlockPos)).booleanValue()) {
            return shipBlockPos;
        }
        double e = 1.0E-5;
        for (int dxi = -1; dxi < 2; ++dxi) {
            double dx = (double)dxi * e;
            for (int dyi = -1; dyi < 2; ++dyi) {
                double dy = (double)dyi * e;
                for (int dzi = -1; dzi < 2; ++dzi) {
                    double dz = (double)dzi * e;
                    if (dx == 0.0 && dy == 0.0 && dz == 0.0) continue;
                    shipBlockPos.m_122178_(Mth.m_14107_((double)(shipPos.x + dx)), Mth.m_14107_((double)(shipPos.y + dy)), Mth.m_14107_((double)(shipPos.z + dz)));
                    if (!((Boolean)predicate.invoke((Object)state, (Object)shipBlockPos)).booleanValue()) continue;
                    return shipBlockPos;
                }
            }
        }
        if (radius <= 0) {
            return null;
        }
        double bestDistSq = Double.POSITIVE_INFINITY;
        int bestX = 0;
        int bestY = 0;
        int bestZ = 0;
        double x = shipPos.x;
        double y = shipPos.y;
        double z = shipPos.z;
        int dx = -radius;
        if (dx <= radius) {
            while (true) {
                int px = baseX + dx;
                double cx = (double)px + 0.5;
                double ddx = x - cx;
                int dy = -radius;
                if (dy <= radius) {
                    while (true) {
                        int py = baseY + dy;
                        double cy = (double)py + 0.5;
                        double ddy = y - cy;
                        int dz = -radius;
                        if (dz <= radius) {
                            while (true) {
                                double cz;
                                double ddz;
                                double distSq;
                                int pz = baseZ + dz;
                                shipBlockPos.m_122178_(px, py, pz);
                                if (((Boolean)predicate.invoke((Object)state, (Object)shipBlockPos)).booleanValue() && (distSq = ddx * ddx + ddy * ddy + (ddz = z - (cz = (double)pz + 0.5)) * ddz) < bestDistSq - 1.0E-12) {
                                    bestDistSq = distSq;
                                    bestX = px;
                                    bestY = py;
                                    bestZ = pz;
                                }
                                if (dz == radius) break;
                                ++dz;
                            }
                        }
                        if (dy == radius) break;
                        ++dy;
                    }
                }
                if (dx == radius) break;
                ++dx;
            }
        }
        if (!(bestDistSq == Double.POSITIVE_INFINITY)) {
            shipBlockPos.m_122178_(bestX, bestY, bestZ);
            return shipBlockPos;
        }
        return null;
    }

    private static final boolean findOpenShipBlockPosForPoint$edgePasses(int baseIdx, ShipPocketState $state, int baseLX, int baseLY, int baseLZ, int dirCode) {
        if (baseIdx < 0) {
            return true;
        }
        return ShipWaterPocketStateAccessKt.edgeConductance($state, baseIdx, baseLX, baseLY, baseLZ, dirCode) > 0;
    }

    private static final boolean findOpenShipBlockPosForPoint$lambda$0$contains(boolean fullBlock, List<? extends AABB> boxes, double px, double py, double pz) {
        if (fullBlock) {
            return false;
        }
        for (AABB aABB : boxes) {
            if (!(px >= aABB.f_82288_) || !(px <= aABB.f_82291_) || !(py >= aABB.f_82289_) || !(py <= aABB.f_82292_) || !(pz >= aABB.f_82290_) || !(pz <= aABB.f_82293_)) continue;
            return true;
        }
        return false;
    }

    private static final void findOpenShipBlockPosForPoint$lambda$0$consider(BlockPos.MutableBlockPos $tmp, int baseX, int baseY, int baseZ, ShipPocketState $state, boolean fullBlock, List<? extends AABB> boxes, int baseIdx, int baseLX, int baseLY, int baseLZ, int dirX, int dirY, int dirZ, int dirCode, double sampleX, double sampleY, double sampleZ, double faceDist, double[] best) {
        if (ShipWaterPocketPointQueriesKt.findOpenShipBlockPosForPoint$lambda$0$contains(fullBlock, boxes, sampleX, sampleY, sampleZ)) {
            return;
        }
        if (!ShipWaterPocketPointQueriesKt.findOpenShipBlockPosForPoint$edgePasses(baseIdx, $state, baseLX, baseLY, baseLZ, dirCode)) {
            return;
        }
        $tmp.m_122178_(baseX + dirX, baseY + dirY, baseZ + dirZ);
        if (!ShipWaterPocketStateAccessKt.isOpen($state, (BlockPos)$tmp)) {
            return;
        }
        boolean interior = ShipWaterPocketStateAccessKt.isInterior($state, (BlockPos)$tmp);
        if (faceDist < best[0] - 1.0E-12 || faceDist <= best[0] + 1.0E-12 && interior && best[1] == 0.0) {
            best[0] = faceDist;
            best[1] = interior ? 1.0 : 0.0;
            best[2] = $tmp.m_123341_();
            best[3] = $tmp.m_123342_();
            best[4] = $tmp.m_123343_();
        }
    }
}

