/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.forge;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.valkyrienair.config.ValkyrienAirConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0018\u0010\u000bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bR\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lorg/valkyrienskies/valkyrienair/forge/ValkyrienAirForgeConfig;", "", "Lnet/minecraftforge/fml/event/config/ModConfigEvent$Loading;", "event", "", "onConfigLoading", "(Lnet/minecraftforge/fml/event/config/ModConfigEvent$Loading;)V", "Lnet/minecraftforge/fml/event/config/ModConfigEvent$Reloading;", "onConfigReloading", "(Lnet/minecraftforge/fml/event/config/ModConfigEvent$Reloading;)V", "applyToCommonConfig", "()V", "Lnet/minecraftforge/common/ForgeConfigSpec;", "spec", "Lnet/minecraftforge/common/ForgeConfigSpec;", "getSpec", "()Lnet/minecraftforge/common/ForgeConfigSpec;", "Lnet/minecraftforge/common/ForgeConfigSpec$BooleanValue;", "enableShipWaterPocketsValue", "Lnet/minecraftforge/common/ForgeConfigSpec$BooleanValue;", "Lnet/minecraftforge/common/ForgeConfigSpec$DoubleValue;", "shipPocketFloodRateMultiplierValue", "Lnet/minecraftforge/common/ForgeConfigSpec$DoubleValue;", "shipPocketParticleSpeedMultiplierValue", "<init>", "valkyrien-air"})
public final class ValkyrienAirForgeConfig {
    @NotNull
    public static final ValkyrienAirForgeConfig INSTANCE = new ValkyrienAirForgeConfig();
    @NotNull
    private static final ForgeConfigSpec spec;
    @NotNull
    private static final ForgeConfigSpec.BooleanValue enableShipWaterPocketsValue;
    @NotNull
    private static final ForgeConfigSpec.DoubleValue shipPocketFloodRateMultiplierValue;
    @NotNull
    private static final ForgeConfigSpec.DoubleValue shipPocketParticleSpeedMultiplierValue;

    private ValkyrienAirForgeConfig() {
    }

    @NotNull
    public final ForgeConfigSpec getSpec() {
        return spec;
    }

    public final void onConfigLoading(@NotNull ModConfigEvent.Loading event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getConfig().getModId(), (Object)"valkyrienair")) {
            return;
        }
        this.applyToCommonConfig();
    }

    public final void onConfigReloading(@NotNull ModConfigEvent.Reloading event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getConfig().getModId(), (Object)"valkyrienair")) {
            return;
        }
        this.applyToCommonConfig();
    }

    public final void applyToCommonConfig() {
        ValkyrienAirConfig.setEnableShipWaterPockets((Boolean)enableShipWaterPocketsValue.get());
        ValkyrienAirConfig.setShipPocketFloodRateMultiplier(((Number)shipPocketFloodRateMultiplierValue.get()).doubleValue());
        ValkyrienAirConfig.setShipPocketParticleSpeedMultiplier(((Number)shipPocketParticleSpeedMultiplierValue.get()).doubleValue());
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("ship_water_pockets");
        enableShipWaterPocketsValue = builder.comment("Enable ship air/water pocket simulation.").define("enable_ship_water_pockets", ValkyrienAirConfig.getEnableShipWaterPockets());
        shipPocketFloodRateMultiplierValue = builder.comment("Flood speed multiplier for ship air pockets. 1.0 = baseline, 0.3333 = ~3x slower flooding.").defineInRange("flood_rate_multiplier", ValkyrienAirConfig.getShipPocketFloodRateMultiplier(), 0.05, 5.0);
        shipPocketParticleSpeedMultiplierValue = builder.comment("Leak/flood particle speed multiplier.").defineInRange("particle_speed_multiplier", ValkyrienAirConfig.getShipPocketParticleSpeedMultiplier(), 0.1, 5.0);
        builder.pop();
        spec = builder.build();
    }
}

