/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.valkyrienskies.valkyrienair.config.ValkyrienAirConfig;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketManager;

@Mixin(value={Camera.class}, priority=2000)
public abstract class MixinCamera {
    @Shadow
    public abstract Vec3 m_90583_();

    @WrapOperation(method={"getFluidInCamera"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/BlockGetter;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;")})
    private FluidState valkyrienair$overrideFluidInCamera(BlockGetter instance, BlockPos blockPos, Operation<FluidState> getFluidState) {
        FluidState original = (FluidState)getFluidState.call(new Object[]{instance, blockPos});
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return original;
        }
        if (!(instance instanceof Level)) {
            return original;
        }
        Level level = (Level)instance;
        Vec3 pos = this.m_90583_();
        return ShipWaterPocketManager.overrideWaterFluidState(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, original);
    }

    @WrapOperation(method={"getFluidInCamera"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;getHeight(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F")})
    private float valkyrienair$overrideFluidInCameraHeight(FluidState fluidState, BlockGetter blockGetter, BlockPos worldBlockPos, Operation<Float> getHeight) {
        float originalHeight = ((Float)getHeight.call(new Object[]{fluidState, blockGetter, worldBlockPos})).floatValue();
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return originalHeight;
        }
        if (!(blockGetter instanceof Level)) {
            return originalHeight;
        }
        Level level = (Level)blockGetter;
        Float shipHeight = ShipWaterPocketManager.computeShipFluidHeight(level, worldBlockPos);
        return shipHeight != null ? shipHeight.floatValue() : originalHeight;
    }
}

