/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.mixin.feature.ship_water_pockets;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.valkyrienair.config.ValkyrienAirConfig;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketManager;
import org.valkyrienskies.valkyrienair.mixinducks.feature.ship_water_pockets.ShipWaterPocketEntityDuck;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements ShipWaterPocketEntityDuck {
    @Shadow
    public Level f_19853_;
    @Shadow
    protected boolean f_19798_;
    @Unique
    private static final FluidState vs$WATER = Fluids.f_76193_.m_76145_();
    @Unique
    private static final FluidState vs$EMPTY = Fluids.f_76191_.m_76145_();
    @Unique
    private long vs$airPocketCacheTick = Long.MIN_VALUE;
    @Unique
    private boolean vs$airPocketCacheValue = false;

    @Shadow
    public abstract double m_20188_();

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract AABB m_20191_();

    @Override
    public boolean vs$isInShipAirPocketForWorldWater() {
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return false;
        }
        Level lvl = this.f_19853_;
        if (lvl == null) {
            return false;
        }
        long now = lvl.m_46467_();
        if (this.vs$airPocketCacheTick == now) {
            return this.vs$airPocketCacheValue;
        }
        boolean value = this.vs$computeInShipAirPocketNow(lvl);
        this.vs$airPocketCacheTick = now;
        this.vs$airPocketCacheValue = value;
        return value;
    }

    @Unique
    private boolean vs$computeInShipAirPocketNow(Level level) {
        AABB bb = this.m_20191_();
        double halfX = (bb.f_82291_ - bb.f_82288_) * 0.5;
        double halfZ = (bb.f_82293_ - bb.f_82290_) * 0.5;
        double ox = Math.min(0.125, halfX * 0.5);
        double oz = Math.min(0.125, halfZ * 0.5);
        double eyeY = this.m_20188_() - 0.1111111119389534;
        double feetY = bb.f_82289_ + 0.1;
        if (this.vs$isInShipFluidAtHeight(level, eyeY, ox, oz) || this.vs$isInShipFluidAtHeight(level, feetY, ox, oz)) {
            return false;
        }
        return this.vs$isInAirPocketAtHeight(level, eyeY, ox, oz) || this.vs$isInAirPocketAtHeight(level, feetY, ox, oz);
    }

    @Unique
    private boolean vs$isInAirPocketAtHeight(Level level, double y, double ox, double oz) {
        double z;
        double x = this.m_20185_();
        if (MixinEntity.vs$isAirPocketAtPoint(level, x, y, z = this.m_20189_())) {
            return true;
        }
        if (ox <= 0.0 && oz <= 0.0) {
            return false;
        }
        if (ox > 0.0) {
            if (MixinEntity.vs$isAirPocketAtPoint(level, x + ox, y, z)) {
                return true;
            }
            if (MixinEntity.vs$isAirPocketAtPoint(level, x - ox, y, z)) {
                return true;
            }
        }
        if (oz > 0.0) {
            if (MixinEntity.vs$isAirPocketAtPoint(level, x, y, z + oz)) {
                return true;
            }
            if (MixinEntity.vs$isAirPocketAtPoint(level, x, y, z - oz)) {
                return true;
            }
        }
        if (ox > 0.0 && oz > 0.0) {
            if (MixinEntity.vs$isAirPocketAtPoint(level, x + ox, y, z + oz)) {
                return true;
            }
            if (MixinEntity.vs$isAirPocketAtPoint(level, x + ox, y, z - oz)) {
                return true;
            }
            if (MixinEntity.vs$isAirPocketAtPoint(level, x - ox, y, z + oz)) {
                return true;
            }
            if (MixinEntity.vs$isAirPocketAtPoint(level, x - ox, y, z - oz)) {
                return true;
            }
        }
        return false;
    }

    @Unique
    private static boolean vs$isAirPocketAtPoint(Level level, double x, double y, double z) {
        return ShipWaterPocketManager.isWorldPosInShipWorldFluidSuppressionZone(level, x, y, z);
    }

    @Unique
    private boolean vs$isInShipFluidAtHeight(Level level, double y, double ox, double oz) {
        double z;
        double x = this.m_20185_();
        if (MixinEntity.vs$isShipFluidAtPoint(level, x, y, z = this.m_20189_())) {
            return true;
        }
        if (ox <= 0.0 && oz <= 0.0) {
            return false;
        }
        if (ox > 0.0) {
            if (MixinEntity.vs$isShipFluidAtPoint(level, x + ox, y, z)) {
                return true;
            }
            if (MixinEntity.vs$isShipFluidAtPoint(level, x - ox, y, z)) {
                return true;
            }
        }
        if (oz > 0.0) {
            if (MixinEntity.vs$isShipFluidAtPoint(level, x, y, z + oz)) {
                return true;
            }
            if (MixinEntity.vs$isShipFluidAtPoint(level, x, y, z - oz)) {
                return true;
            }
        }
        if (ox > 0.0 && oz > 0.0) {
            if (MixinEntity.vs$isShipFluidAtPoint(level, x + ox, y, z + oz)) {
                return true;
            }
            if (MixinEntity.vs$isShipFluidAtPoint(level, x + ox, y, z - oz)) {
                return true;
            }
            if (MixinEntity.vs$isShipFluidAtPoint(level, x - ox, y, z + oz)) {
                return true;
            }
            if (MixinEntity.vs$isShipFluidAtPoint(level, x - ox, y, z - oz)) {
                return true;
            }
        }
        return false;
    }

    @Unique
    private static boolean vs$isShipFluidAtPoint(Level level, double x, double y, double z) {
        FluidState overridden = ShipWaterPocketManager.overrideWaterFluidState(level, x, y, z, vs$EMPTY);
        return !overridden.m_76178_();
    }

    @WrapOperation(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setRemainingFireTicks(I)V", ordinal=1)}, require=0)
    private void valkyrienair$preventWaterExtinguishInShipAirPockets(Entity entity, int fireTicks, Operation<Void> setRemainingFireTicks) {
        if (this.vs$isInShipAirPocketForWorldWater()) {
            return;
        }
        setRemainingFireTicks.call(new Object[]{entity, fireTicks});
    }

    @WrapOperation(method={"updateFluidHeightAndDoFluidPushing(Lnet/minecraft/tags/TagKey;D)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;getFlow(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/phys/Vec3;")}, require=0)
    private Vec3 valkyrienair$rotateFlowVectorVanilla(FluidState fluidState, BlockGetter blockGetter, BlockPos worldBlockPos, Operation<Vec3> getFlow) {
        Vec3 originalFlow = (Vec3)getFlow.call(new Object[]{fluidState, blockGetter, worldBlockPos});
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return originalFlow;
        }
        if (!(blockGetter instanceof Level)) {
            return originalFlow;
        }
        Level level = (Level)blockGetter;
        Vec3 rotated = ShipWaterPocketManager.computeRotatedShipFluidFlow(level, worldBlockPos);
        return rotated != null ? rotated : originalFlow;
    }

    @WrapOperation(method={"updateFluidHeightAndDoFluidPushing(Lnet/minecraft/tags/TagKey;D)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;getHeight(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F")}, require=0)
    private float valkyrienair$overrideFluidHeightVanilla(FluidState fluidState, BlockGetter blockGetter, BlockPos worldBlockPos, Operation<Float> getHeight) {
        float originalHeight = ((Float)getHeight.call(new Object[]{fluidState, blockGetter, worldBlockPos})).floatValue();
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return originalHeight;
        }
        if (!(blockGetter instanceof Level)) {
            return originalHeight;
        }
        Level level = (Level)blockGetter;
        Float shipHeight = ShipWaterPocketManager.computeShipFluidHeight(level, worldBlockPos);
        return shipHeight != null ? shipHeight.floatValue() : originalHeight;
    }

    @WrapOperation(method={"updateFluidHeightAndDoFluidPushing(Ljava/util/function/Predicate;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;getFlow(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/phys/Vec3;")}, require=0)
    private Vec3 valkyrienair$rotateFlowVectorForge(FluidState fluidState, BlockGetter blockGetter, BlockPos worldBlockPos, Operation<Vec3> getFlow) {
        Vec3 originalFlow = (Vec3)getFlow.call(new Object[]{fluidState, blockGetter, worldBlockPos});
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return originalFlow;
        }
        if (!(blockGetter instanceof Level)) {
            return originalFlow;
        }
        Level level = (Level)blockGetter;
        Vec3 rotated = ShipWaterPocketManager.computeRotatedShipFluidFlow(level, worldBlockPos);
        return rotated != null ? rotated : originalFlow;
    }

    @WrapOperation(method={"updateFluidHeightAndDoFluidPushing(Ljava/util/function/Predicate;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;getHeight(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F")}, require=0)
    private float valkyrienair$overrideFluidHeightForge(FluidState fluidState, BlockGetter blockGetter, BlockPos worldBlockPos, Operation<Float> getHeight) {
        float originalHeight = ((Float)getHeight.call(new Object[]{fluidState, blockGetter, worldBlockPos})).floatValue();
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return originalHeight;
        }
        if (!(blockGetter instanceof Level)) {
            return originalHeight;
        }
        Level level = (Level)blockGetter;
        Float shipHeight = ShipWaterPocketManager.computeShipFluidHeight(level, worldBlockPos);
        return shipHeight != null ? shipHeight.floatValue() : originalHeight;
    }

    @WrapOperation(method={"updateFluidOnEyes"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;")})
    private FluidState valkyrienair$overrideUpdateFluidOnEyes(Level level, BlockPos blockPos, Operation<FluidState> getFluidState) {
        FluidState original = (FluidState)getFluidState.call(new Object[]{level, blockPos});
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return original;
        }
        double eyeY = this.m_20188_() - 0.1111111119389534;
        return ShipWaterPocketManager.overrideWaterFluidState(level, this.m_20185_(), eyeY, this.m_20189_(), original);
    }

    @WrapOperation(method={"updateFluidOnEyes"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;getHeight(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)F")}, require=0)
    private float valkyrienair$overrideUpdateFluidOnEyesFluidHeight(FluidState fluidState, BlockGetter blockGetter, BlockPos worldBlockPos, Operation<Float> getHeight) {
        float originalHeight = ((Float)getHeight.call(new Object[]{fluidState, blockGetter, worldBlockPos})).floatValue();
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return originalHeight;
        }
        if (!(blockGetter instanceof Level)) {
            return originalHeight;
        }
        Level level = (Level)blockGetter;
        Float shipHeight = ShipWaterPocketManager.computeShipFluidHeight(level, worldBlockPos);
        return shipHeight != null ? shipHeight.floatValue() : originalHeight;
    }

    @WrapOperation(method={"updateFluidHeightAndDoFluidPushing(Lnet/minecraft/tags/TagKey;D)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;")}, require=0)
    private FluidState valkyrienair$overrideUpdateFluidHeightAndDoFluidPushing(Level level, BlockPos blockPos, Operation<FluidState> getFluidState) {
        FluidState original = (FluidState)getFluidState.call(new Object[]{level, blockPos});
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return original;
        }
        return ShipWaterPocketManager.overrideWaterFluidState(level, blockPos, original);
    }

    @WrapOperation(method={"updateFluidHeightAndDoFluidPushing(Ljava/util/function/Predicate;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;")}, require=0)
    private FluidState valkyrienair$overrideUpdateFluidHeightAndDoFluidPushingPredicate(Level level, BlockPos blockPos, Operation<FluidState> getFluidState) {
        FluidState original = (FluidState)getFluidState.call(new Object[]{level, blockPos});
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return original;
        }
        return ShipWaterPocketManager.overrideWaterFluidState(level, blockPos, original);
    }

    @WrapOperation(method={"updateSwimming"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;")}, require=0)
    private FluidState valkyrienair$overrideUpdateSwimmingFluidCheck(Level level, BlockPos blockPos, Operation<FluidState> getFluidState) {
        FluidState original = (FluidState)getFluidState.call(new Object[]{level, blockPos});
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return original;
        }
        return ShipWaterPocketManager.overrideWaterFluidState(level, blockPos, original);
    }

    @Inject(method={"updateInWaterStateAndDoWaterCurrentPushing"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void valkyrienair$cancelWaterCurrentPushingInShipAirPockets(CallbackInfo ci) {
        if (this.vs$isInShipAirPocketForWorldWater()) {
            this.f_19798_ = false;
            ci.cancel();
        }
    }

    @Inject(method={"clearFire"}, at={@At(value="HEAD")}, cancellable=true)
    private void vs$preventFireExtinguishInShipAirPockets(CallbackInfo ci) {
        if (this.vs$isInShipAirPocketForWorldWater()) {
            ci.cancel();
        }
    }

    @Inject(method={"isInFluidType()Z"}, at={@At(value="RETURN")}, cancellable=true, require=0)
    private void valkyrienair$ignoreFluidTypeFlagInShipAirPockets(CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValueZ()) {
            return;
        }
        if (this.vs$isInShipAirPocketForWorldWater()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isInFluidType(Ljava/util/function/BiPredicate;Z)Z"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void valkyrienair$ignoreFluidTypeChecksInShipAirPockets(BiPredicate<?, ?> predicate, boolean doAllMatch, CallbackInfoReturnable<Boolean> cir) {
        if (this.vs$isInShipAirPocketForWorldWater()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isInFluidType(Ljava/util/function/BiPredicate;)Z"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private void valkyrienair$ignoreFluidTypePredicateChecksInShipAirPockets(BiPredicate<?, ?> predicate, CallbackInfoReturnable<Boolean> cir) {
        if (this.vs$isInShipAirPocketForWorldWater()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"doWaterSplashEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void vs$cancelSplashInShipAirPockets(CallbackInfo ci) {
        if (this.vs$isInShipAirPocketForWorldWater()) {
            ci.cancel();
        }
    }

    @Inject(method={"waterSwimSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void vs$cancelSwimSplashSoundInShipAirPockets(CallbackInfo ci) {
        if (this.vs$isInShipAirPocketForWorldWater()) {
            ci.cancel();
        }
    }

    @Inject(method={"playSwimSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void vs$cancelSwimSoundInShipAirPockets(float volume, CallbackInfo ci) {
        if (this.vs$isInShipAirPocketForWorldWater()) {
            ci.cancel();
        }
    }

    @Inject(method={"isInWater"}, at={@At(value="RETURN")}, cancellable=true)
    private void vs$overrideInWaterFlagInShipAirPockets(CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValueZ()) {
            return;
        }
        if (this.vs$isInShipAirPocketForWorldWater()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isInWaterOrRain"}, at={@At(value="RETURN")}, cancellable=true)
    private void vs$overrideInWaterOrRainFlagInShipAirPockets(CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValueZ()) {
            return;
        }
        if (this.vs$isInShipAirPocketForWorldWater()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isInWaterRainOrBubble"}, at={@At(value="RETURN")}, cancellable=true)
    private void vs$overrideInWaterRainOrBubbleFlagInShipAirPockets(CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValueZ()) {
            return;
        }
        if (this.vs$isInShipAirPocketForWorldWater()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isInWaterOrBubble"}, at={@At(value="RETURN")}, cancellable=true)
    private void vs$overrideInWaterOrBubbleFlagInShipAirPockets(CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValueZ()) {
            return;
        }
        if (this.vs$isInShipAirPocketForWorldWater()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"isUnderWater"}, at={@At(value="RETURN")}, cancellable=true)
    private void vs$overrideUnderWaterFlagInShipAirPockets(CallbackInfoReturnable<Boolean> cir) {
        if (!cir.getReturnValueZ()) {
            return;
        }
        if (this.vs$isInShipAirPocketForWorldWater()) {
            cir.setReturnValue((Object)false);
        }
    }
}

