/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.mixin.feature.ship_water_pockets;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.valkyrienair.config.ValkyrienAirConfig;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipGravityDownDirCache;

@Mixin(value={FlowingFluid.class})
public abstract class MixinFlowingFluid {
    @Unique
    private static final ThreadLocal<ShipGravityDownDirCache> valkyrienair$shipDownCache = ThreadLocal.withInitial(ShipGravityDownDirCache::new);
    @Unique
    private static final ThreadLocal<Vector3d> valkyrienair$tmpRotVec = ThreadLocal.withInitial(Vector3d::new);
    @Unique
    private static final Direction[][] valkyrienair$LATERAL_DIRS = new Direction[Direction.values().length][];

    @Unique
    private static Direction valkyrienair$getShipGravityDown(Level level, BlockPos pos) {
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return null;
        }
        if (!VSGameUtilsKt.isBlockInShipyard((Level)level, (BlockPos)pos)) {
            return null;
        }
        ShipGravityDownDirCache cache = valkyrienair$shipDownCache.get();
        long now = level.m_46467_();
        long posLong = pos.m_121878_();
        if (cache.lastLevel == level && cache.lastGameTime == now && cache.lastPosLong == posLong) {
            return cache.lastDown;
        }
        cache.lastLevel = level;
        cache.lastGameTime = now;
        cache.lastPosLong = posLong;
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)pos);
        if (ship == null) {
            cache.lastDown = null;
            return null;
        }
        ShipTransform transform = ship.getTransform();
        Quaterniondc rot = transform.getShipToWorldRotation();
        Vector3d v = valkyrienair$tmpRotVec.get();
        v.set(0.0, 1.0, 0.0);
        rot.transform(v);
        double yY = v.y;
        v.set(1.0, 0.0, 0.0);
        rot.transform(v);
        double yX = v.y;
        v.set(0.0, 0.0, 1.0);
        rot.transform(v);
        double yZ = v.y;
        Direction best = Direction.DOWN;
        double bestY = -yY;
        if (yY < bestY) {
            bestY = yY;
            best = Direction.UP;
        }
        if (yX < bestY) {
            bestY = yX;
            best = Direction.EAST;
        }
        if (-yX < bestY) {
            bestY = -yX;
            best = Direction.WEST;
        }
        if (yZ < bestY) {
            bestY = yZ;
            best = Direction.SOUTH;
        }
        if (-yZ < bestY) {
            bestY = -yZ;
            best = Direction.NORTH;
        }
        cache.lastDown = best;
        return best;
    }

    @Unique
    private static Iterator<Direction> valkyrienair$getLateralIterator(Direction.Plane plane, Direction down) {
        if (down == null) {
            return plane.iterator();
        }
        if (down.m_122434_() == Direction.Axis.Y) {
            return plane.iterator();
        }
        Direction[] dirs = valkyrienair$LATERAL_DIRS[down.ordinal()];
        if (dirs == null) {
            return plane.iterator();
        }
        return new ValkyrienAirDirIter(dirs);
    }

    @Redirect(method={"spread"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;below()Lnet/minecraft/core/BlockPos;"), require=0)
    private BlockPos valkyrienair$spreadBelow(BlockPos instance, Level level, BlockPos pos, FluidState state) {
        Direction down = MixinFlowingFluid.valkyrienair$getShipGravityDown(level, pos);
        return down != null ? instance.m_121945_(down) : instance.m_7495_();
    }

    @Redirect(method={"spread"}, at=@At(value="FIELD", target="Lnet/minecraft/core/Direction;DOWN:Lnet/minecraft/core/Direction;"), require=0)
    private Direction valkyrienair$spreadDownDirection(Level level, BlockPos pos, FluidState state) {
        Direction down = MixinFlowingFluid.valkyrienair$getShipGravityDown(level, pos);
        return down != null ? down : Direction.DOWN;
    }

    @Redirect(method={"spread"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/Direction$Plane;iterator()Ljava/util/Iterator;"), require=0)
    private Iterator<Direction> valkyrienair$spreadHorizontalIterator(Direction.Plane instance, Level level, BlockPos pos, FluidState state) {
        Direction down = MixinFlowingFluid.valkyrienair$getShipGravityDown(level, pos);
        return MixinFlowingFluid.valkyrienair$getLateralIterator(instance, down);
    }

    @Redirect(method={"getNewLiquid"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;below()Lnet/minecraft/core/BlockPos;"), require=0)
    private BlockPos valkyrienair$getNewLiquidBelow(BlockPos instance, Level level, BlockPos pos, BlockState state) {
        Direction down = MixinFlowingFluid.valkyrienair$getShipGravityDown(level, pos);
        return down != null ? instance.m_121945_(down) : instance.m_7495_();
    }

    @Redirect(method={"getNewLiquid"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;above()Lnet/minecraft/core/BlockPos;"), require=0)
    private BlockPos valkyrienair$getNewLiquidAbove(BlockPos instance, Level level, BlockPos pos, BlockState state) {
        Direction down = MixinFlowingFluid.valkyrienair$getShipGravityDown(level, pos);
        if (down == null) {
            return instance.m_7494_();
        }
        return instance.m_121945_(down.m_122424_());
    }

    @Redirect(method={"getNewLiquid"}, at=@At(value="FIELD", target="Lnet/minecraft/core/Direction;UP:Lnet/minecraft/core/Direction;"), require=0)
    private Direction valkyrienair$getNewLiquidUpDirection(Level level, BlockPos pos, BlockState state) {
        Direction down = MixinFlowingFluid.valkyrienair$getShipGravityDown(level, pos);
        return down != null ? down.m_122424_() : Direction.UP;
    }

    @Redirect(method={"getNewLiquid"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/Direction$Plane;iterator()Ljava/util/Iterator;"), require=0)
    private Iterator<Direction> valkyrienair$getNewLiquidHorizontalIterator(Direction.Plane instance, Level level, BlockPos pos, BlockState state) {
        Direction down = MixinFlowingFluid.valkyrienair$getShipGravityDown(level, pos);
        return MixinFlowingFluid.valkyrienair$getLateralIterator(instance, down);
    }

    @Redirect(method={"isWaterHole"}, at=@At(value="FIELD", target="Lnet/minecraft/core/Direction;DOWN:Lnet/minecraft/core/Direction;"), require=0)
    private Direction valkyrienair$isWaterHoleDownDirection(BlockGetter getter, Fluid fluid, BlockPos pos, BlockState state, BlockPos otherPos, BlockState otherState) {
        if (!(getter instanceof Level)) {
            return Direction.DOWN;
        }
        Level level = (Level)getter;
        Direction down = MixinFlowingFluid.valkyrienair$getShipGravityDown(level, pos);
        return down != null ? down : Direction.DOWN;
    }

    @Redirect(method={"getFlow"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos$MutableBlockPos;below()Lnet/minecraft/core/BlockPos;"), require=0)
    private BlockPos valkyrienair$getFlowBelow(BlockPos.MutableBlockPos instance, BlockGetter getter, BlockPos pos, FluidState state) {
        if (!(getter instanceof Level)) {
            return instance.m_7495_();
        }
        Level level = (Level)getter;
        Direction down = MixinFlowingFluid.valkyrienair$getShipGravityDown(level, pos);
        return down != null ? instance.m_122173_(down) : instance.m_7495_();
    }

    @Redirect(method={"getFlow"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos$MutableBlockPos;above()Lnet/minecraft/core/BlockPos;"), require=0)
    private BlockPos valkyrienair$getFlowAbove(BlockPos.MutableBlockPos instance, BlockGetter getter, BlockPos pos, FluidState state) {
        if (!(getter instanceof Level)) {
            return instance.m_7494_();
        }
        Level level = (Level)getter;
        Direction down = MixinFlowingFluid.valkyrienair$getShipGravityDown(level, pos);
        if (down == null) {
            return instance.m_7494_();
        }
        return instance.m_122173_(down.m_122424_());
    }

    @Redirect(method={"getFlow"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/Direction$Plane;iterator()Ljava/util/Iterator;"), require=0)
    private Iterator<Direction> valkyrienair$getFlowHorizontalIterator(Direction.Plane instance, BlockGetter getter, BlockPos pos, FluidState state) {
        if (!(getter instanceof Level)) {
            return instance.iterator();
        }
        Level level = (Level)getter;
        Direction down = MixinFlowingFluid.valkyrienair$getShipGravityDown(level, pos);
        return MixinFlowingFluid.valkyrienair$getLateralIterator(instance, down);
    }

    static {
        for (Direction down : Direction.values()) {
            if (down.m_122434_() == Direction.Axis.Y) continue;
            Direction[] arr = new Direction[4];
            int j = 0;
            for (Direction d : Direction.values()) {
                if (d == down || d == down.m_122424_()) continue;
                arr[j++] = d;
            }
            MixinFlowingFluid.valkyrienair$LATERAL_DIRS[down.ordinal()] = arr;
        }
    }

    @Unique
    private static final class ValkyrienAirDirIter
    implements Iterator<Direction> {
        private final Direction[] dirs;
        private int idx = 0;

        private ValkyrienAirDirIter(Direction[] dirs) {
            this.dirs = dirs;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.dirs.length;
        }

        @Override
        public Direction next() {
            return this.dirs[this.idx++];
        }
    }
}

