/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.mixin.feature.ship_water_pockets;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.valkyrienair.config.ValkyrienAirConfig;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketManager;

@Mixin(value={Level.class})
public abstract class MixinLevel {
    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void valkyrienair$redirectFirePlacementToShipyardInAirPockets(BlockPos pos, BlockState state, int flags, int recursionLeft, CallbackInfoReturnable<Boolean> cir) {
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return;
        }
        Level level = (Level)Level.class.cast(this);
        if (level.f_46443_) {
            return;
        }
        if (ShipWaterPocketManager.isApplyingInternalUpdates()) {
            return;
        }
        if (VSGameUtilsKt.isBlockInShipyard((Level)level, (BlockPos)pos)) {
            return;
        }
        if (!state.m_60713_(Blocks.f_50083_) && !state.m_60713_(Blocks.f_50084_)) {
            return;
        }
        BlockPos shipPos = ShipWaterPocketManager.getShipBlockPosForWorldPosInShipAirPocket(level, pos);
        if (shipPos == null) {
            return;
        }
        if (shipPos.equals((Object)pos)) {
            return;
        }
        if (!VSGameUtilsKt.isBlockInShipyard((Level)level, (BlockPos)shipPos)) {
            return;
        }
        BlockState existing = level.m_8055_(shipPos);
        if (!existing.m_60795_() && !existing.m_60713_(state.m_60734_())) {
            cir.setReturnValue((Object)false);
            cir.cancel();
            return;
        }
        boolean ok = level.m_6933_(shipPos, state, flags, recursionLeft);
        cir.setReturnValue((Object)ok);
        cir.cancel();
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void valkyrienair$blockShipyardWaterFromLeakingIntoWorldWater(BlockPos pos, BlockState state, int flags, int recursionLeft, CallbackInfoReturnable<Boolean> cir) {
        Ship ship;
        Ship ship2;
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return;
        }
        Level level = (Level)Level.class.cast(this);
        if (level.f_46443_) {
            return;
        }
        if (ShipWaterPocketManager.isApplyingInternalUpdates()) {
            return;
        }
        if (!VSGameUtilsKt.isBlockInShipyard((Level)level, (BlockPos)pos)) {
            return;
        }
        BlockState existing = level.m_8055_(pos);
        if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && existing.m_61138_((Property)BlockStateProperties.f_61362_) && !((Boolean)existing.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && (ship2 = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)pos)) != null && ShipWaterPocketManager.shouldBlockShipyardWaterPlacement(level, ship2.getId(), pos)) {
            cir.setReturnValue((Object)false);
            cir.cancel();
            return;
        }
        FluidState fluidState = state.m_60819_();
        if (fluidState.m_76178_()) {
            return;
        }
        if (!(state.m_60734_() instanceof LiquidBlock)) {
            return;
        }
        FluidState existingFluid = existing.m_60819_();
        if (!(existing.m_60734_() instanceof LiquidBlock) && !existingFluid.m_76178_()) {
            if (existing.m_60734_() instanceof BucketPickup || existing.m_60734_() instanceof LiquidBlockContainer) {
                return;
            }
            if (!existing.m_61138_((Property)BlockStateProperties.f_61362_) || ((Boolean)existing.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                return;
            }
        }
        if ((ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)pos)) == null) {
            return;
        }
        if (ShipWaterPocketManager.shouldBlockShipyardWaterPlacement(level, ship.getId(), pos)) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Inject(method={"setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z"}, at={@At(value="TAIL")})
    private void vs$markShipWaterPocketDirty(BlockPos pos, BlockState state, int flags, int recursionLeft, CallbackInfoReturnable<Boolean> cir) {
    }

    @Inject(method={"getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;"}, at={@At(value="RETURN")}, cancellable=true)
    private void valkyrienair$overrideFluidStateForModCompat(BlockPos pos, CallbackInfoReturnable<FluidState> cir) {
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return;
        }
        Level level = (Level)Level.class.cast(this);
        if (ShipWaterPocketManager.isBypassingFluidOverrides()) {
            return;
        }
        FluidState original = (FluidState)cir.getReturnValue();
        FluidState overridden = ShipWaterPocketManager.overrideWaterFluidState(level, pos, original);
        if (overridden != original) {
            cir.setReturnValue((Object)overridden);
        }
    }

    @Inject(method={"getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="RETURN")}, cancellable=true)
    private void valkyrienair$overrideBlockStateForModCompat(BlockPos pos, CallbackInfoReturnable<BlockState> cir) {
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return;
        }
        Level level = (Level)Level.class.cast(this);
        if (ShipWaterPocketManager.isBypassingFluidOverrides()) {
            return;
        }
        if (VSGameUtilsKt.isBlockInShipyard((Level)level, (BlockPos)pos)) {
            return;
        }
        BlockState original = (BlockState)cir.getReturnValue();
        FluidState originalFluid = original.m_60819_();
        if (originalFluid.m_76178_()) {
            return;
        }
        if (ShipWaterPocketManager.isWorldPosInShipWorldFluidSuppressionZone(level, pos)) {
            cir.setReturnValue((Object)Blocks.f_50016_.m_49966_());
        }
    }
}

