/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.mixin.feature.ship_water_pockets;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.valkyrienair.config.ValkyrienAirConfig;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketManager;

@Mixin(value={LevelChunk.class})
public abstract class MixinLevelChunk {
    @Shadow
    @Final
    private Level f_62776_;

    @Inject(method={"setBlockState"}, at={@At(value="TAIL")})
    private void vs$markShipWaterPocketDirtyOnChunkSetBlock(BlockPos pos, BlockState state, boolean isMoving, CallbackInfoReturnable<BlockState> cir) {
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return;
        }
        if (this.f_62776_.f_46443_) {
            return;
        }
        if (ShipWaterPocketManager.isApplyingInternalUpdates()) {
            return;
        }
        BlockState previousState = (BlockState)cir.getReturnValue();
        if (previousState == null || previousState.equals(state)) {
            return;
        }
        if (!VSGameUtilsKt.isBlockInShipyard((Level)this.f_62776_, (BlockPos)pos)) {
            return;
        }
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)this.f_62776_, (BlockPos)pos);
        if (ship == null) {
            return;
        }
        boolean geometryDirty = ShipWaterPocketManager.shouldMarkShipGeometryDirtyForBlockChange(this.f_62776_, pos, previousState, state);
        FluidState placedFluid = state.m_60819_();
        FluidState previousFluid = previousState.m_60819_();
        if (!placedFluid.m_76178_() && (previousFluid.m_76178_() || previousFluid.m_76152_() != placedFluid.m_76152_())) {
            ShipWaterPocketManager.onExternalShipFluidPlacement(this.f_62776_, ship.getId(), pos, placedFluid.m_76152_());
        }
        if (geometryDirty) {
            ShipWaterPocketManager.markShipDirty(this.f_62776_, ship.getId());
        }
    }
}

