/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.mixin.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.valkyrienair.config.ValkyrienAirConfig;

@Mixin(value={AbstractCauldronBlock.class})
public abstract class MixinAbstractCauldronBlock {
    @Shadow
    protected abstract double m_142446_(BlockState var1);

    @Inject(method={"isEntityInsideContent"}, at={@At(value="HEAD")}, cancellable=true)
    private void valkyrienair$shipyardCauldronContentCheck(BlockState state, BlockPos pos, Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return;
        }
        Level level = entity.m_9236_();
        if (level.f_46443_) {
            return;
        }
        if (!VSGameUtilsKt.isBlockInShipyard((Level)level, (BlockPos)pos)) {
            return;
        }
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)pos);
        if (ship == null) {
            return;
        }
        ShipTransform shipTransform = ship.getTransform();
        Matrix4dc worldToShip = shipTransform.getWorldToShip();
        double minX = entity.m_20191_().f_82288_;
        double minY = entity.m_20191_().f_82289_;
        double minZ = entity.m_20191_().f_82290_;
        double maxX = entity.m_20191_().f_82291_;
        double maxY = entity.m_20191_().f_82292_;
        double maxZ = entity.m_20191_().f_82293_;
        double shipMinX = Double.POSITIVE_INFINITY;
        double shipMinY = Double.POSITIVE_INFINITY;
        double shipMinZ = Double.POSITIVE_INFINITY;
        double shipMaxX = Double.NEGATIVE_INFINITY;
        double shipMaxY = Double.NEGATIVE_INFINITY;
        double shipMaxZ = Double.NEGATIVE_INFINITY;
        for (int xi = 0; xi < 2; ++xi) {
            double wx = xi == 0 ? minX : maxX;
            for (int yi = 0; yi < 2; ++yi) {
                double wy = yi == 0 ? minY : maxY;
                for (int zi = 0; zi < 2; ++zi) {
                    double wz = zi == 0 ? minZ : maxZ;
                    double sx = worldToShip.m00() * wx + worldToShip.m10() * wy + worldToShip.m20() * wz + worldToShip.m30();
                    double sy = worldToShip.m01() * wx + worldToShip.m11() * wy + worldToShip.m21() * wz + worldToShip.m31();
                    double sz = worldToShip.m02() * wx + worldToShip.m12() * wy + worldToShip.m22() * wz + worldToShip.m32();
                    if (sx < shipMinX) {
                        shipMinX = sx;
                    }
                    if (sy < shipMinY) {
                        shipMinY = sy;
                    }
                    if (sz < shipMinZ) {
                        shipMinZ = sz;
                    }
                    if (sx > shipMaxX) {
                        shipMaxX = sx;
                    }
                    if (sy > shipMaxY) {
                        shipMaxY = sy;
                    }
                    if (!(sz > shipMaxZ)) continue;
                    shipMaxZ = sz;
                }
            }
        }
        double eps = 1.0E-7;
        int blockX = pos.m_123341_();
        int blockZ = pos.m_123343_();
        double wx = entity.m_20185_();
        double wy = entity.m_20186_();
        double wz = entity.m_20189_();
        double shipEntityX = worldToShip.m00() * wx + worldToShip.m10() * wy + worldToShip.m20() * wz + worldToShip.m30();
        double shipEntityY = worldToShip.m01() * wx + worldToShip.m11() * wy + worldToShip.m21() * wz + worldToShip.m31();
        double shipEntityZ = worldToShip.m02() * wx + worldToShip.m12() * wy + worldToShip.m22() * wz + worldToShip.m32();
        if (shipEntityX <= (double)blockX + 1.0E-7 || shipEntityX >= (double)blockX + 1.0 - 1.0E-7 || shipEntityZ <= (double)blockZ + 1.0E-7 || shipEntityZ >= (double)blockZ + 1.0 - 1.0E-7) {
            cir.setReturnValue((Object)false);
            cir.cancel();
            return;
        }
        double contentTopY = (double)pos.m_123342_() + this.m_142446_(state);
        boolean inside = shipEntityY < contentTopY && shipMaxY > (double)pos.m_123342_() + 0.25;
        cir.setReturnValue((Object)inside);
        cir.cancel();
    }
}

