/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.valkyrienair.mixin.world.level.block;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.valkyrienair.config.ValkyrienAirConfig;
import org.valkyrienskies.valkyrienair.feature.ship_water_pockets.ShipWaterPocketManager;

@Mixin(value={FarmBlock.class})
public abstract class MixinFarmBlock {
    @Unique
    private static final FluidState vs$EMPTY = Fluids.f_76191_.m_76145_();

    @Inject(method={"isNearWater(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private static void valkyrienair$ignoreWorldWaterMoistureInShipAirPockets(LevelReader levelReader, BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (!ValkyrienAirConfig.getEnableShipWaterPockets()) {
            return;
        }
        if (!(levelReader instanceof Level)) {
            return;
        }
        Level level = (Level)levelReader;
        if (!ShipWaterPocketManager.isWorldPosInShipAirPocket(level, pos)) {
            return;
        }
        BlockPos from = pos.m_7918_(-4, 0, -4);
        BlockPos to = pos.m_7918_(4, 1, 4);
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)from, (BlockPos)to)) {
            FluidState shipFluidOnly = ShipWaterPocketManager.overrideWaterFluidState(level, checkPos, vs$EMPTY);
            if (shipFluidOnly.m_76178_() || !shipFluidOnly.m_205070_(FluidTags.f_13131_)) continue;
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)false);
    }
}

