/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.api.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0015\u001a\u00020\u0014\u0012\u0006\u0010\u0019\u001a\u00020\u0011\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\u0003\u001a\u00020\u0002H$\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\u0007\u001a\u00020\u00022\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\tH\u0004\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u001b\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0015\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u0013R8\u0010\u001e\u001a&\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\u001cj\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e`\u001d8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"Lorg/valkyrienskies/mod/api/datagen/VSShipyardEntityDataProvider;", "Lnet/minecraft/data/DataProvider;", "", "registerEntries", "()V", "Lnet/minecraft/resources/ResourceLocation;", "id", "addEntity", "(Lnet/minecraft/resources/ResourceLocation;)V", "Lnet/minecraft/world/entity/EntityType;", "type", "(Lnet/minecraft/world/entity/EntityType;)V", "Lnet/minecraft/data/CachedOutput;", "cachedOutput", "Ljava/util/concurrent/CompletableFuture;", "run", "(Lnet/minecraft/data/CachedOutput;)Ljava/util/concurrent/CompletableFuture;", "", "getName", "()Ljava/lang/String;", "Lnet/minecraft/data/PackOutput;", "output", "Lnet/minecraft/data/PackOutput;", "getOutput", "()Lnet/minecraft/data/PackOutput;", "modId", "Ljava/lang/String;", "getModId", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "entries", "Ljava/util/HashMap;", "<init>", "(Lnet/minecraft/data/PackOutput;Ljava/lang/String;)V", "valkyrienskies-120"})
@SourceDebugExtension(value={"SMAP\nVSShipyardEntityDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VSShipyardEntityDataProvider.kt\norg/valkyrienskies/mod/api/datagen/VSShipyardEntityDataProvider\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,71:1\n37#2:72\n36#2,3:73\n*S KotlinDebug\n*F\n+ 1 VSShipyardEntityDataProvider.kt\norg/valkyrienskies/mod/api/datagen/VSShipyardEntityDataProvider\n*L\n64#1:72\n64#1:73,3\n*E\n"})
public abstract class VSShipyardEntityDataProvider
implements DataProvider {
    @NotNull
    private final PackOutput output;
    @NotNull
    private final String modId;
    @NotNull
    private final HashMap<ResourceLocation, CompletableFuture<?>> entries;

    public VSShipyardEntityDataProvider(@NotNull PackOutput output, @NotNull String modId) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        this.output = output;
        this.modId = modId;
        this.entries = new HashMap();
    }

    @NotNull
    public final PackOutput getOutput() {
        return this.output;
    }

    @NotNull
    public final String getModId() {
        return this.modId;
    }

    protected abstract void registerEntries();

    protected final void addEntity(@NotNull ResourceLocation id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        if (((Map)this.entries).containsKey(id2)) {
            throw new RuntimeException("Duplicate Block Into Entries for " + id2);
        }
        Path path = this.output.m_245114_().resolve("data").resolve(id2.m_135827_()).resolve("vs_entities").resolve(id2.m_135815_() + ".json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        ((Map)this.entries).put(id2, CompletableFuture.supplyAsync(() -> VSShipyardEntityDataProvider.addEntity$lambda$0(path2)).join());
    }

    protected final void addEntity(@NotNull EntityType<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        ResourceLocation resourceLocation = type.m_204041_().m_205785_().m_135782_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
        this.addEntity(resourceLocation);
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cachedOutput) {
        Intrinsics.checkNotNullParameter((Object)cachedOutput, (String)"cachedOutput");
        this.registerEntries();
        Collection<CompletableFuture<?>> collection = this.entries.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Collection<CompletableFuture<?>> $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection<CompletableFuture<?>> thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"allOf(...)");
        return completableFuture;
    }

    @NotNull
    public String m_6055_() {
        return "VS Shipyard Entity Data Provider: " + this.modId;
    }

    private static final CompletableFuture addEntity$lambda$0(Path $path) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        try {
            JsonObject json = new JsonObject();
            json.addProperty("handler", "valkyrienskies:shipyard");
            return DataProvider.m_253162_((CachedOutput)CachedOutput.f_236016_, (JsonElement)((JsonElement)json), (Path)$path);
        }
        catch (Exception e2) {
            throw new RuntimeException("Failed to save " + $path, e2);
        }
    }
}

