/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.entity;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.valkyrienskies.core.api.attachment.AttachmentHolder;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.impl.networking.simple.SimplePacketNetworking;
import org.valkyrienskies.mod.api.SeatedControllingPlayer;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.config.VSKeyBindings;
import org.valkyrienskies.mod.common.networking.PacketPlayerDriving;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00000!\u0012\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0004J\u0017\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0004J\u0011\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001c\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006'"}, d2={"Lorg/valkyrienskies/mod/common/entity/ShipMountingEntity;", "Lnet/minecraft/world/entity/Entity;", "", "tick", "()V", "Lnet/minecraft/world/entity/LivingEntity;", "livingEntity", "Lnet/minecraft/world/phys/Vec3;", "getDismountLocationForPassenger", "(Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/nbt/CompoundTag;", "compound", "readAdditionalSaveData", "(Lnet/minecraft/nbt/CompoundTag;)V", "addAdditionalSaveData", "defineSynchedData", "Lnet/minecraft/world/entity/Entity$RemovalReason;", "removalReason", "remove", "(Lnet/minecraft/world/entity/Entity$RemovalReason;)V", "sendDrivingPacket", "getControllingPassenger", "()Lnet/minecraft/world/entity/LivingEntity;", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getAddEntityPacket", "()Lnet/minecraft/network/protocol/Packet;", "", "isController", "Z", "()Z", "setController", "(Z)V", "Lnet/minecraft/world/entity/EntityType;", "type", "Lnet/minecraft/world/level/Level;", "level", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "valkyrienskies-120"})
@SourceDebugExtension(value={"SMAP\nShipMountingEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShipMountingEntity.kt\norg/valkyrienskies/mod/common/entity/ShipMountingEntity\n+ 2 LoadedServerShip.kt\norg/valkyrienskies/core/api/ships/LoadedServerShipKt\n+ 3 AttachmentHolder.kt\norg/valkyrienskies/core/api/attachment/AttachmentHolderKt\n*L\n1#1,120:1\n46#2:121\n80#3:122\n*S KotlinDebug\n*F\n+ 1 ShipMountingEntity.kt\norg/valkyrienskies/mod/common/entity/ShipMountingEntity\n*L\n81#1:121\n81#1:122\n*E\n"})
public class ShipMountingEntity
extends Entity {
    private boolean isController;

    public ShipMountingEntity(@NotNull EntityType<ShipMountingEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
        this.f_19850_ = false;
        this.f_19794_ = true;
    }

    public final boolean isController() {
        return this.isController;
    }

    public final void setController(boolean bl2) {
        this.isController = bl2;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_20197_().isEmpty()) {
            this.m_6074_();
            return;
        }
        Level level = this.m_9236_();
        BlockPos blockPos = this.m_20183_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
        if (VSGameUtilsKt.getLoadedShipManagingPos(level, (Vec3i)blockPos) != null) {
            this.sendDrivingPacket();
        }
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Level level = this.m_9236_();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        Vec3 vec3 = this.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        if (VSGameUtilsKt.isBlockInShipyard(level, vec3)) {
            Level level2 = this.m_9236_();
            Vec3 vec32 = this.m_20182_();
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"position(...)");
            if (VSGameUtilsKt.getShipManagingPos(level2, (Position)vec32) == null) {
                Vec3 vec33 = livingEntity.m_20182_();
                Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"position(...)");
                return vec33;
            }
        }
        Vec3 vec34 = super.m_7688_(livingEntity);
        Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"getDismountLocationForPassenger(...)");
        return vec34;
    }

    protected void m_7378_(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
    }

    protected void m_7380_(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
    }

    protected void m_8097_() {
    }

    /*
     * WARNING - void declaration
     */
    public void m_142687_(@NotNull Entity.RemovalReason removalReason) {
        Intrinsics.checkNotNullParameter((Object)removalReason, (String)"removalReason");
        if (this.isController && !this.m_9236_().f_46443_) {
            Level level = this.m_9236_();
            BlockPos blockPos = this.m_20183_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
            LoadedServerShip loadedServerShip = (LoadedServerShip)VSGameUtilsKt.getLoadedShipManagingPos(level, (Vec3i)blockPos);
            if (loadedServerShip != null) {
                void $this$setAttachment$iv;
                LoadedServerShip loadedServerShip2 = loadedServerShip;
                Object value$iv = null;
                boolean $i$f$setAttachment = false;
                AttachmentHolder $this$removeAttachment$iv$iv = (AttachmentHolder)$this$setAttachment$iv;
                boolean $i$f$removeAttachment = false;
                SeatedControllingPlayer cfr_ignored_0 = (SeatedControllingPlayer)$this$removeAttachment$iv$iv.removeAttachment(SeatedControllingPlayer.class);
            }
        }
        super.m_142687_(removalReason);
    }

    private final void sendDrivingPacket() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        Options opts = Minecraft.m_91087_().f_91066_;
        boolean forward = opts.f_92085_.m_90857_();
        boolean backward = opts.f_92087_.m_90857_();
        boolean left = opts.f_92086_.m_90857_();
        boolean right = opts.f_92088_.m_90857_();
        boolean up2 = opts.f_92089_.m_90857_();
        LivingEntity livingEntity = this.m_6688_();
        boolean sprint = livingEntity != null ? livingEntity.m_20142_() : false;
        boolean down = VSKeyBindings.INSTANCE.getShipDown().get().m_90857_();
        boolean cruise = VSKeyBindings.INSTANCE.getShipCruise().get().m_90857_();
        Vector3f impulse = new Vector3f();
        float f2 = forward == backward ? 0.0f : (impulse.z = forward ? 1.0f : -1.0f);
        float f3 = left == right ? 0.0f : (impulse.x = left ? 1.0f : -1.0f);
        impulse.y = up2 == down ? 0.0f : (up2 ? 1.0f : -1.0f);
        SimplePacketNetworking $this$sendDrivingPacket_u24lambda_u240 = VSGameUtilsKt.getVsCore().getSimplePacketNetworking();
        boolean bl2 = false;
        $this$sendDrivingPacket_u24lambda_u240.sendToServer1(new PacketPlayerDriving(impulse, sprint, cruise));
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity livingEntity;
        if (this.isController) {
            List list = this.m_20197_();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPassengers(...)");
            Object object = CollectionsKt.getOrNull((List)list, (int)0);
            livingEntity = object instanceof LivingEntity ? (LivingEntity)object : null;
        } else {
            livingEntity = null;
        }
        return livingEntity;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return (Packet)new ClientboundAddEntityPacket((Entity)this);
    }
}

