/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\nJ\u001d\u0010\u000f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lorg/valkyrienskies/mod/common/util/EntityLerper;", "", "Lorg/valkyrienskies/mod/common/util/EntityDraggingInformation;", "dragInfo", "Lorg/valkyrienskies/core/api/ships/Ship;", "refship", "Lnet/minecraft/world/entity/Entity;", "entity", "", "lerpStep", "(Lorg/valkyrienskies/mod/common/util/EntityDraggingInformation;Lorg/valkyrienskies/core/api/ships/Ship;Lnet/minecraft/world/entity/Entity;)V", "lerpHeadStep", "ship", "", "yaw", "yawToWorld", "(Lorg/valkyrienskies/core/api/ships/Ship;D)D", "yawToShip", "<init>", "()V", "valkyrienskies-120"})
public final class EntityLerper {
    @NotNull
    public static final EntityLerper INSTANCE = new EntityLerper();

    private EntityLerper() {
    }

    public final void lerpStep(@NotNull EntityDraggingInformation dragInfo, @NotNull Ship refship, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)dragInfo, (String)"dragInfo");
        Intrinsics.checkNotNullParameter((Object)refship, (String)"refship");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(refship instanceof ClientShip) || !dragInfo.isEntityBeingDraggedByAShip()) {
            return;
        }
        ClientShip ship = (ClientShip)refship;
        int n2 = dragInfo.getTicksSinceLastServerPacket();
        dragInfo.setTicksSinceLastServerPacket(n2 + 1);
        if (dragInfo.getTicksSinceLastServerPacket() > 19) {
            // empty if block
        }
        if (dragInfo.getLerpSteps() > 0) {
            if (dragInfo.getChangedShipLastTick()) {
                dragInfo.setChangedShipLastTick(false);
            }
            Level level = entity.m_9236_();
            Vector3dc vector3dc = dragInfo.getLerpPositionOnShip();
            Intrinsics.checkNotNull((Object)vector3dc);
            LoadedShip lerpship = VSGameUtilsKt.getLoadedShipManagingPos(level, vector3dc);
            Level level2 = entity.m_9236_();
            Vector3dc vector3dc2 = dragInfo.getRelativePositionOnShip();
            Intrinsics.checkNotNull((Object)vector3dc2);
            LoadedShip posship = VSGameUtilsKt.getLoadedShipManagingPos(level2, vector3dc2);
            if (dragInfo.getLerpPositionOnShip() != null && lerpship != null && lerpship.getId() != ship.getId()) {
                Vector3d worldPos = lerpship.getTransform().getShipToWorld().transformPosition((Vector3dc)new Vector3d(dragInfo.getLerpPositionOnShip()), new Vector3d());
                dragInfo.setLerpPositionOnShip((Vector3dc)ship.getTransform().getWorldToShip().transformPosition((Vector3dc)worldPos, new Vector3d()));
            }
            if (dragInfo.getRelativePositionOnShip() != null && posship != null && posship.getId() != ship.getId()) {
                Vector3d worldRelativePos = posship.getShipToWorld().transformPosition((Vector3dc)new Vector3d(dragInfo.getRelativePositionOnShip()), new Vector3d());
                dragInfo.setRelativePositionOnShip((Vector3dc)ship.getTransform().getWorldToShip().transformPosition((Vector3dc)worldRelativePos, new Vector3d()));
            }
            Vector3dc vector3dc3 = dragInfo.getRelativePositionOnShip();
            if (vector3dc3 == null) {
                return;
            }
            double currentX = vector3dc3.x();
            Vector3dc vector3dc4 = dragInfo.getRelativePositionOnShip();
            Intrinsics.checkNotNull((Object)vector3dc4);
            double currentY = vector3dc4.y();
            Vector3dc vector3dc5 = dragInfo.getRelativePositionOnShip();
            Intrinsics.checkNotNull((Object)vector3dc5);
            double currentZ = vector3dc5.z();
            Vector3dc vector3dc6 = dragInfo.getLerpPositionOnShip();
            Intrinsics.checkNotNull((Object)vector3dc6);
            double lerpX = vector3dc6.x();
            Vector3dc vector3dc7 = dragInfo.getLerpPositionOnShip();
            Intrinsics.checkNotNull((Object)vector3dc7);
            double lerpY = vector3dc7.y();
            Vector3dc vector3dc8 = dragInfo.getLerpPositionOnShip();
            Intrinsics.checkNotNull((Object)vector3dc8);
            double lerpZ = vector3dc8.z();
            Double d2 = dragInfo.getRelativeYawOnShip();
            if (d2 == null) {
                return;
            }
            double currentYaw = d2;
            Double d3 = dragInfo.getLerpYawOnShip();
            if (d3 == null) {
                return;
            }
            double lerpYaw = d3;
            double newX = currentX + (lerpX - currentX) / (double)dragInfo.getLerpSteps();
            double newY = currentY + (lerpY - currentY) / (double)dragInfo.getLerpSteps();
            double newZ = currentZ + (lerpZ - currentZ) / (double)dragInfo.getLerpSteps();
            Vector3d newPos = VSGameUtilsKt.toWorldCoordinates(entity.m_9236_(), newX, newY, newZ, new Vector3d());
            double currentYawWorld = this.yawToWorld((Ship)ship, currentYaw);
            double lerpYawWorld = this.yawToWorld((Ship)ship, lerpYaw);
            dragInfo.setRelativePositionOnShip((Vector3dc)new Vector3d(newX, newY, newZ));
            entity.m_6034_(newPos.x(), newPos.y(), newPos.z());
            double g2 = Mth.m_14175_((double)(lerpYawWorld - currentYawWorld));
            float newYaw = (float)(currentYawWorld + g2 / (double)dragInfo.getLerpSteps());
            entity.m_146922_(newYaw);
            dragInfo.setRelativeYawOnShip(this.yawToShip((Ship)ship, newYaw));
            dragInfo.setLerpSteps(dragInfo.getLerpSteps() - 1);
        }
    }

    public final void lerpHeadStep(@NotNull EntityDraggingInformation dragInfo, @NotNull Ship refship, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)dragInfo, (String)"dragInfo");
        Intrinsics.checkNotNullParameter((Object)refship, (String)"refship");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(refship instanceof ClientShip)) {
            return;
        }
        ClientShip ship = (ClientShip)refship;
        if (dragInfo.getHeadLerpSteps() > 0) {
            Double d2 = dragInfo.getRelativeHeadYawOnShip();
            if (d2 == null) {
                return;
            }
            double currentHeadYaw = d2;
            Double d3 = dragInfo.getLerpHeadYawOnShip();
            if (d3 == null) {
                return;
            }
            double lerpHeadYaw = d3;
            double currentHeadYawWorld = this.yawToWorld((Ship)ship, currentHeadYaw);
            double lerpHeadYawWorld = this.yawToWorld((Ship)ship, lerpHeadYaw);
            double newHeadYaw = currentHeadYawWorld + Mth.m_14175_((double)(lerpHeadYawWorld - currentHeadYawWorld)) / (double)dragInfo.getHeadLerpSteps();
            float f2 = entity.m_146909_();
            Double d4 = dragInfo.getLerpPitchOnShip();
            Intrinsics.checkNotNull((Object)d4);
            entity.m_146926_(f2 + ((float)d4.doubleValue() - entity.m_146909_()) / (float)dragInfo.getHeadLerpSteps());
            entity.m_5616_((float)newHeadYaw);
            dragInfo.setRelativeHeadYawOnShip(this.yawToShip((Ship)ship, newHeadYaw));
            int n2 = dragInfo.getHeadLerpSteps();
            dragInfo.setHeadLerpSteps(n2 + -1);
        }
    }

    public final double yawToWorld(@NotNull Ship ship, double yaw) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Vector3dc entityYawOnly = (Vector3dc)new Vector3d(Math.sin(yaw), 0.0, Math.cos(yaw));
        Vector3d newLookIdeal = ship.getTransform().transformDirectionNoScalingFromShipToWorld(entityYawOnly, new Vector3d());
        double newYRot = Math.atan2(newLookIdeal.x(), newLookIdeal.z());
        return Mth.m_14175_((double)(newYRot * 180.0 / Math.PI));
    }

    public final double yawToShip(@NotNull Ship ship, double yaw) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"ship");
        Vector3dc entityYawOnly = (Vector3dc)new Vector3d(Math.sin(yaw * Math.PI / 180.0), 0.0, Math.cos(yaw * Math.PI / 180.0));
        Vector3d newLookIdeal = ship.getTransform().transformDirectionNoScalingFromWorldToShip(entityYawOnly, new Vector3d());
        double newYRot = Math.atan2(newLookIdeal.x(), newLookIdeal.z());
        return newYRot;
    }
}

