/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.internal.collision.VsiConvexPolygonc;
import org.valkyrienskies.core.internal.collision.VsiEntityPolygonCollider;
import org.valkyrienskies.core.util.AABBdUtilKt;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixinducks.feature.tickets.PlayerKnownShipsDuck;
import org.valkyrienskies.mod.util.BugFixUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J%\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u001c\u001a\u00020\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ5\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Lorg/valkyrienskies/mod/common/util/EntityShipCollisionUtils;", "", "Lorg/valkyrienskies/core/api/ships/Ship;", "ship", "Lorg/joml/primitives/AABBi;", "getShipyardChunkAABBAround", "(Lorg/valkyrienskies/core/api/ships/Ship;)Lorg/joml/primitives/AABBi;", "Lnet/minecraft/world/level/Level;", "level", "Lorg/joml/primitives/AABBd;", "aabb", "Ljava/util/stream/Stream;", "getAllShipsIntersectingEvenIfNotYetFullyLoaded", "(Lnet/minecraft/world/level/Level;Lorg/joml/primitives/AABBd;)Ljava/util/stream/Stream;", "Lnet/minecraft/world/entity/Entity;", "entity", "", "isCollidingWithUnloadedShips", "(Lnet/minecraft/world/entity/Entity;)Z", "Lorg/joml/primitives/AABBdc;", "aABB", "areAllChunksLoaded", "(Lorg/valkyrienskies/core/api/ships/Ship;Lorg/joml/primitives/AABBdc;Lnet/minecraft/world/level/Level;)Z", "Lnet/minecraft/world/phys/Vec3;", "movement", "Lnet/minecraft/world/phys/AABB;", "entityBoundingBox", "world", "adjustEntityMovementForShipCollisions", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;)Lnet/minecraft/world/phys/Vec3;", "", "Lorg/valkyrienskies/core/internal/collision/VsiConvexPolygonc;", "getShipPolygonsCollidingWithEntity", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;)Ljava/util/List;", "Lorg/valkyrienskies/core/internal/collision/VsiEntityPolygonCollider;", "collider", "Lorg/valkyrienskies/core/internal/collision/VsiEntityPolygonCollider;", "<init>", "()V", "valkyrienskies-120"})
@SourceDebugExtension(value={"SMAP\nEntityShipCollisionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityShipCollisionUtils.kt\norg/valkyrienskies/mod/common/util/EntityShipCollisionUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,178:1\n1863#2,2:179\n*S KotlinDebug\n*F\n+ 1 EntityShipCollisionUtils.kt\norg/valkyrienskies/mod/common/util/EntityShipCollisionUtils\n*L\n164#1:179,2\n*E\n"})
public final class EntityShipCollisionUtils {
    @NotNull
    public static final EntityShipCollisionUtils INSTANCE = new EntityShipCollisionUtils();
    @NotNull
    private static final VsiEntityPolygonCollider collider = VSGameUtilsKt.getVsCore().getEntityPolygonCollider();

    private EntityShipCollisionUtils() {
    }

    private final AABBi getShipyardChunkAABBAround(Ship ship) {
        AABBi box = new AABBi();
        AABBic aABBic = ship.getShipAABB();
        int minY = (aABBic != null ? aABBic.minY() : Mth.m_14107_((double)ship.getTransform().getPosition().y())) - 16;
        AABBic aABBic2 = ship.getShipAABB();
        int maxY = (aABBic2 != null ? aABBic2.maxY() : Mth.m_14165_((double)ship.getTransform().getPosition().y())) + 16;
        ship.getActiveChunksSet().forEach((arg_0, arg_1) -> EntityShipCollisionUtils.getShipyardChunkAABBAround$lambda$0(box, minY, maxY, arg_0, arg_1));
        return box;
    }

    private final Stream<Ship> getAllShipsIntersectingEvenIfNotYetFullyLoaded(Level level, AABBd aabb) {
        Stream<Object> stream = VSGameUtilsKt.getAllShips(level).stream().filter(arg_0 -> EntityShipCollisionUtils.getAllShipsIntersectingEvenIfNotYetFullyLoaded$lambda$2(arg_0 -> EntityShipCollisionUtils.getAllShipsIntersectingEvenIfNotYetFullyLoaded$lambda$1(level, aabb, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"filter(...)");
        return stream;
    }

    @JvmStatic
    public static final boolean isCollidingWithUnloadedShips(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel || level.f_46443_ && level instanceof ClientLevel) {
            if (level.f_46443_ && level instanceof ClientLevel && !VSGameUtilsKt.getShipObjectWorld((ClientLevel)level).isSyncedWithServer()) {
                return true;
            }
            AABB aABB = entity.m_20191_();
            Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"getBoundingBox(...)");
            AABBd aabb = VectorConversionsMCKt.toJOML(aABB);
            return !INSTANCE.getAllShipsIntersectingEvenIfNotYetFullyLoaded(level, aabb).allMatch(arg_0 -> EntityShipCollisionUtils.isCollidingWithUnloadedShips$lambda$4(arg_0 -> EntityShipCollisionUtils.isCollidingWithUnloadedShips$lambda$3(entity, aabb, level, arg_0), arg_0));
        }
        return false;
    }

    private final boolean areAllChunksLoaded(Ship ship, AABBdc aABB, Level level) {
        int minX = Mth.m_14107_((double)(aABB.minX() - 1.0E-7)) - 1 >> 4;
        int maxX = Mth.m_14107_((double)(aABB.maxX() + 1.0E-7)) + 1 >> 4;
        int minZ = Mth.m_14107_((double)(aABB.minZ() - 1.0E-7)) - 1 >> 4;
        int maxZ = Mth.m_14107_((double)(aABB.maxZ() + 1.0E-7)) + 1 >> 4;
        int chunkX = minX;
        if (chunkX <= maxX) {
            while (true) {
                int chunkZ;
                if ((chunkZ = minZ) <= maxZ) {
                    while (true) {
                        if (ship.getActiveChunksSet().contains(chunkX, chunkZ) && level.m_7925_(chunkX, chunkZ) == null) {
                            return false;
                        }
                        if (chunkZ == maxZ) break;
                        ++chunkZ;
                    }
                }
                if (chunkX == maxX) break;
                ++chunkX;
            }
        }
        return true;
    }

    @NotNull
    public final Vec3 adjustEntityMovementForShipCollisions(@Nullable Entity entity, @NotNull Vec3 movement, @NotNull AABB entityBoundingBox, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)movement, (String)"movement");
        Intrinsics.checkNotNullParameter((Object)entityBoundingBox, (String)"entityBoundingBox");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        double inflation = entity instanceof Player ? 0.5 : 0.1;
        Entity entity2 = entity;
        double stepHeight = entity2 != null ? (double)entity2.m_274421_() : 0.0;
        Vec3 vec3 = new Vec3(movement.m_7096_(), movement.m_7098_() + stepHeight / (double)2, movement.m_7094_());
        AABB aABB = entityBoundingBox.m_82377_(inflation, inflation + stepHeight / (double)2, inflation);
        Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"inflate(...)");
        List<VsiConvexPolygonc> collidingShipPolygons = this.getShipPolygonsCollidingWithEntity(entity, vec3, aABB, world);
        if (collidingShipPolygons.isEmpty()) {
            return movement;
        }
        Pair<Vector3dc, Long> pair = collider.adjustEntityMovementForPolygonCollisions((Vector3dc)VectorConversionsMCKt.toJOML(movement), (AABBdc)VectorConversionsMCKt.toJOML(entityBoundingBox), stepHeight, collidingShipPolygons);
        Vector3dc newMovement = (Vector3dc)pair.component1();
        Long shipCollidingWith = (Long)pair.component2();
        if (entity != null) {
            Level level = entity.m_9236_();
            BlockPos blockPos = entity.m_20097_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getOnPos(...)");
            LoadedShip standingOnShip = VSGameUtilsKt.getLoadedShipManagingPos(level, (Vec3i)blockPos);
            if (shipCollidingWith != null && standingOnShip != null && standingOnShip.getId() == shipCollidingWith.longValue()) {
                ((IEntityDraggingInformationProvider)entity).getDraggingInformation().setLastShipStoodOn(shipCollidingWith);
                for (Entity entityRiding : entity.m_146897_()) {
                    Intrinsics.checkNotNull((Object)entityRiding, (String)"null cannot be cast to non-null type org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider");
                    ((IEntityDraggingInformationProvider)entityRiding).getDraggingInformation().setLastShipStoodOn(shipCollidingWith);
                }
            }
        }
        return VectorConversionsMCKt.toMinecraft(newMovement);
    }

    @NotNull
    public final List<VsiConvexPolygonc> getShipPolygonsCollidingWithEntity(@Nullable Entity entity, @NotNull Vec3 movement, @NotNull AABB entityBoundingBox, @NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)movement, (String)"movement");
        Intrinsics.checkNotNullParameter((Object)entityBoundingBox, (String)"entityBoundingBox");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        AABB entityBoxWithMovement = entityBoundingBox.m_82369_(movement);
        List collidingPolygons = new ArrayList();
        AABBd entityBoundingBoxExtended = AABBdUtilKt.extend((AABBd)VectorConversionsMCKt.toJOML(entityBoundingBox), (Vector3dc)((Vector3dc)VectorConversionsMCKt.toJOML(movement)));
        for (LoadedShip shipObject : VSGameUtilsKt.getShipObjectWorld(world).getLoadedShips().getIntersecting((AABBdc)entityBoundingBoxExtended, VSGameUtilsKt.getDimensionId(world))) {
            ShipTransform shipTransform = shipObject.getTransform();
            Intrinsics.checkNotNull((Object)entityBoxWithMovement);
            VsiConvexPolygonc entityPolyInShipCoordinates = VsiEntityPolygonCollider.createPolygonFromAABB$default(collider, (AABBdc)VectorConversionsMCKt.toJOML(entityBoxWithMovement), shipTransform.getWorldToShip(), null, 4, null);
            AABBdc entityBoundingBoxInShipCoordinates = (AABBdc)entityPolyInShipCoordinates.getEnclosingAABB(new AABBd());
            if (BugFixUtil.INSTANCE.isCollisionBoxTooBig(VectorConversionsMCKt.toMinecraft(entityBoundingBoxInShipCoordinates))) continue;
            Iterable shipBlockCollisionStream = world.m_186434_(entity, VectorConversionsMCKt.toMinecraft(entityBoundingBoxInShipCoordinates));
            Intrinsics.checkNotNull((Object)shipBlockCollisionStream);
            Iterable $this$forEach$iv = shipBlockCollisionStream;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VoxelShape voxelShape = (VoxelShape)element$iv;
                boolean bl2 = false;
                voxelShape.m_83286_((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> EntityShipCollisionUtils.getShipPolygonsCollidingWithEntity$lambda$6$lambda$5(shipTransform, shipObject, collidingPolygons, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5));
            }
        }
        return collidingPolygons;
    }

    private static final void getShipyardChunkAABBAround$lambda$0(AABBi $box, int $minY, int $maxY, int x2, int z2) {
        Intrinsics.checkNotNullParameter((Object)$box, (String)"$box");
        int minX = SectionPos.m_123223_((int)x2);
        int minZ = SectionPos.m_123223_((int)z2);
        int maxX = SectionPos.m_175554_((int)x2, (int)15);
        int maxZ = SectionPos.m_175554_((int)z2, (int)15);
        $box.union(minX, $minY, minZ).union(maxX, $maxY, maxZ);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getAllShipsIntersectingEvenIfNotYetFullyLoaded$lambda$1(Level $level, AABBd $aabb, Ship ship) {
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        Intrinsics.checkNotNullParameter((Object)$aabb, (String)"$aabb");
        if (!Intrinsics.areEqual((Object)ship.getChunkClaimDimension(), (Object)VSGameUtilsKt.getDimensionId($level))) return false;
        Intrinsics.checkNotNull((Object)ship);
        if (!AABBdUtilKt.toAABBd((AABBic)((AABBic)INSTANCE.getShipyardChunkAABBAround(ship)), (AABBd)new AABBd()).transform(ship.getShipToWorld()).intersectsAABB($aabb)) return false;
        return true;
    }

    private static final boolean getAllShipsIntersectingEvenIfNotYetFullyLoaded$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean isCollidingWithUnloadedShips$lambda$3(Entity $entity, AABBd $aabb, Level $level, Ship ship) {
        Intrinsics.checkNotNullParameter((Object)$entity, (String)"$entity");
        Intrinsics.checkNotNullParameter((Object)$aabb, (String)"$aabb");
        if ($entity instanceof PlayerKnownShipsDuck && !((PlayerKnownShipsDuck)$entity).vs_isKnownShip(ship.getId())) {
            return false;
        }
        AABBd aabbInShip = new AABBd((AABBdc)$aabb).transform(ship.getWorldToShip());
        Intrinsics.checkNotNull((Object)ship);
        Intrinsics.checkNotNull((Object)aabbInShip);
        return INSTANCE.areAllChunksLoaded(ship, (AABBdc)aabbInShip, $level);
    }

    private static final boolean isCollidingWithUnloadedShips$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void getShipPolygonsCollidingWithEntity$lambda$6$lambda$5(ShipTransform $shipTransform, LoadedShip $shipObject, List $collidingPolygons, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Intrinsics.checkNotNullParameter((Object)$shipTransform, (String)"$shipTransform");
        Intrinsics.checkNotNullParameter((Object)$shipObject, (String)"$shipObject");
        Intrinsics.checkNotNullParameter((Object)$collidingPolygons, (String)"$collidingPolygons");
        VsiConvexPolygonc shipPolygon = VSGameUtilsKt.getVsCore().getEntityPolygonCollider().createPolygonFromAABB((AABBdc)new AABBd(minX, minY, minZ, maxX, maxY, maxZ), $shipTransform.getShipToWorld(), $shipObject.getId());
        $collidingPolygons.add(shipPolygon);
    }
}

