/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.forge.mixin.compat.connectiblechains.client;

import com.lilypuree.connectiblechains.chain.ChainLink;
import com.lilypuree.connectiblechains.client.render.entity.ChainKnotEntityRenderer;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.CompatUtil;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Mixin(value={ChainKnotEntityRenderer.class}, remap=false)
public abstract class MixinChainKnotEntityRenderer {
    @Inject(method={"renderChainLink"}, at={@At(value="NEW", target="org/joml/Vector3f")})
    private void adjustPositions(ChainLink link, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumerProvider, CallbackInfo ci2, @Local(ordinal=3) LocalRef<Vec3> srcPos, @Local(ordinal=4) LocalRef<Vec3> destPos) {
        ClientShip srcShip = (ClientShip)VSGameUtilsKt.getShipManaging((Entity)link.primary);
        ClientShip destShip = (ClientShip)VSGameUtilsKt.getShipManaging(link.secondary);
        if (srcShip != null || destShip != null) {
            Vec3 newSrcPos = CompatUtil.INSTANCE.toSameSpaceAs(link.primary.m_9236_(), (Vec3)srcPos.get(), (Ship)null);
            Vec3 newDestPos = CompatUtil.INSTANCE.toSameSpaceAs(link.secondary.m_9236_(), (Vec3)destPos.get(), (Ship)null);
            srcPos.set((Object)newSrcPos);
            if (srcShip != null) {
                Vector3dc scale = srcShip.getRenderTransform().getScaling();
                destPos.set((Object)newSrcPos.m_82549_(newDestPos.m_82546_(newSrcPos).m_82542_(1.0 / scale.x(), 1.0 / scale.y(), 1.0 / scale.z())));
                matrices.m_252781_(new Quaternionf(srcShip.getRenderTransform().getShipToWorldRotation()).invert());
            } else {
                destPos.set((Object)newDestPos);
            }
        }
    }

    @WrapOperation(method={"shouldRender(Lcom/lilypuree/connectiblechains/entity/ChainKnotEntity;Lnet/minecraft/client/renderer/culling/Frustum;DDD)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;shouldRender(DDD)Z")}, remap=true)
    private boolean adjustHolderAABB(Entity chainHolder, double x2, double y2, double z2, Operation<Boolean> original) {
        ClientShip ship = (ClientShip)VSGameUtilsKt.getShipManaging(chainHolder);
        if (ship != null) {
            Vector3d cameraPosInShip = ship.getRenderTransform().getWorldToShip().transformPosition(x2, y2, z2, new Vector3d());
            return (Boolean)original.call(new Object[]{chainHolder, cameraPosInShip.x, cameraPosInShip.y, cameraPosInShip.z});
        }
        return (Boolean)original.call(new Object[]{chainHolder, x2, y2, z2});
    }

    @ModifyConstant(method={"renderChainLink"}, constant={@Constant(classValue=HangingEntity.class)})
    private Class<?> disableBakingForShips(Object object, Class<?> constant, @Local(argsOnly=true) ChainLink link) {
        ClientShip srcShip = (ClientShip)VSGameUtilsKt.getShipManaging((Entity)link.primary);
        ClientShip destShip = (ClientShip)VSGameUtilsKt.getShipManaging(link.secondary);
        if (srcShip != null || destShip != null) {
            return Class.class;
        }
        return constant;
    }
}

