/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.client.world;

import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3ic;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.joml.primitives.AABBi;
import org.joml.primitives.AABBic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.internal.world.VsiClientShipWorld;
import org.valkyrienskies.core.util.AABBdUtilKt;
import org.valkyrienskies.core.util.VectorConversionsKt;
import org.valkyrienskies.mod.client.audio.SimpleSoundInstanceOnShip;
import org.valkyrienskies.mod.common.IShipObjectWorldClientProvider;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.config.DimensionParametersResolver;
import org.valkyrienskies.mod.util.McMathUtilKt;

@Mixin(value={ClientLevel.class})
public abstract class MixinClientLevel
implements IShipObjectWorldClientProvider {
    @Unique
    private final RandomSource vsRandom = RandomSource.m_216327_();
    @Shadow
    @Final
    private Minecraft f_104565_;
    @Shadow
    @Final
    private ClientChunkCache f_104559_;
    @Unique
    private final Map<ChunkPos, List<Vector3ic>> vs$knownChunks = new HashMap<ChunkPos, List<Vector3ic>>();
    @Unique
    private final Long2LongOpenHashMap vs$chunksToUnload = new Long2LongOpenHashMap();

    @Override
    @NotNull
    public VsiClientShipWorld getShipObjectWorld() {
        return ((IShipObjectWorldClientProvider)this.f_104565_).getShipObjectWorld();
    }

    @Shadow
    private void m_104689_(BlockPos blockPos, BlockState blockState, ParticleOptions particleData, boolean shapeDownSolid) {
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(ClientPacketListener clientPacketListener, ClientLevel.ClientLevelData clientLevelData, ResourceKey resourceKey, Holder holder, int i2, int j2, Supplier supplier, LevelRenderer levelRenderer, boolean bl2, long l2, CallbackInfo ci2) {
        if (this.getShipObjectWorld() != null) {
            DimensionParametersResolver.Parameters params = DimensionParametersResolver.INSTANCE.getDimensionMap().get(VSGameUtilsKt.getDimensionId((Level)((ClientLevel)this)));
            if (params != null) {
                this.getShipObjectWorld().addDimension(VSGameUtilsKt.getDimensionId((Level)((ClientLevel)this)), VSGameUtilsKt.getYRange((Level)((ClientLevel)this)), params.getGravity(), params.getSeaLevel(), params.getMaxY());
                return;
            }
            this.getShipObjectWorld().addDimension(VSGameUtilsKt.getDimensionId((Level)((ClientLevel)this)), VSGameUtilsKt.getYRange((Level)((ClientLevel)this)), McMathUtilKt.getDEFAULT_WORLD_GRAVITY(), 62.0, 962.0);
        }
    }

    @Inject(method={"disconnect"}, at={@At(value="TAIL")})
    private void afterDisconnect(CallbackInfo ci2) {
        ValkyrienSkiesMod.getVsCore().getHooks().afterDisconnect();
    }

    @Inject(at={@At(value="TAIL")}, method={"animateTick"})
    private void afterAnimatedTick(int posX, int posY, int posZ, CallbackInfo ci2) {
        boolean holdingBarrierItem = false;
        if (this.f_104565_.f_91072_.m_105295_() == GameType.CREATIVE) {
            for (ItemStack itemStack : this.f_104565_.f_91074_.m_6167_()) {
                if (itemStack.m_41720_() != Blocks.f_50375_.m_5456_()) continue;
                holdingBarrierItem = true;
                break;
            }
        }
        LocalPlayer player = this.f_104565_.f_91074_;
        assert (player != null);
        double playerScale = player.m_20205_() / Player.f_36088_.f_20377_;
        Vec3 pos = player.m_20182_();
        AABBd playerCenterBB = new AABBd(pos.f_82479_, pos.f_82480_, pos.f_82481_, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        AABBd shipIntersectBB = AABBdUtilKt.expand((AABBd)new AABBd((AABBdc)playerCenterBB), (double)32.0);
        double biggerBBProbability = 0.0203857421875;
        double smallerBBProbability = 0.1630859375;
        AABBd temp0 = new AABBd();
        AABBi temp1 = new AABBi();
        AABBd temp2 = new AABBd();
        AABBi temp3 = new AABBi();
        AABBi temp4 = new AABBi();
        AABBi temp5 = new AABBi();
        AABBd temp6 = new AABBd();
        AABBd temp7 = new AABBd();
        for (Ship ship : VSGameUtilsKt.getShipsIntersecting((Level)ClientLevel.class.cast(this), (AABBdc)shipIntersectBB)) {
            AABBic shipVoxelAABB = ship.getShipAABB();
            if (shipVoxelAABB == null) continue;
            AABBd biggerBB = AABBdUtilKt.expand((AABBd)temp6.set((AABBdc)playerCenterBB), (double)(32.0 * playerScale));
            AABBd smallerBB = AABBdUtilKt.expand((AABBd)temp7.set((AABBdc)playerCenterBB), (double)(16.0 * playerScale));
            AABBi biggerBBTransformed = VectorConversionsKt.toAABBi((AABBdc)biggerBB.transform(ship.getWorldToShip(), temp0), (AABBi)temp1);
            AABBi smallerBBTransformed = VectorConversionsKt.toAABBi((AABBdc)smallerBB.transform(ship.getWorldToShip(), temp2), (AABBi)temp3);
            AABBi biggerBBIntersection = VectorConversionsKt.expand((AABBic)shipVoxelAABB, (int)1, (AABBi)temp4).intersection((AABBic)biggerBBTransformed);
            AABBi smallerBBIntersection = VectorConversionsKt.expand((AABBic)shipVoxelAABB, (int)1, (AABBi)temp5).intersection((AABBic)smallerBBTransformed);
            if (biggerBBIntersection.isValid()) {
                this.animateTickVS((AABBic)biggerBBIntersection, 0.0203857421875, holdingBarrierItem);
            }
            if (!smallerBBIntersection.isValid()) continue;
            this.animateTickVS((AABBic)smallerBBIntersection, 0.1630859375, holdingBarrierItem);
        }
    }

    @Unique
    private void animateTickVS(AABBic region, double regionBlockProbability, boolean holdingBarrierItem) {
        int volume = (region.maxX() - region.minX() + 1) * (region.maxY() - region.minY() + 1) * (region.maxZ() - region.minZ() + 1);
        double blocksToTickAsDouble = (double)volume * regionBlockProbability;
        int blocksToTick = (int)Math.floor(blocksToTickAsDouble);
        if (this.vsRandom.m_188500_() > blocksToTickAsDouble - (double)blocksToTick) {
            ++blocksToTick;
        }
        ClientLevel thisAsClientLevel = (ClientLevel)ClientLevel.class.cast(this);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int minCX = SectionPos.m_123171_((int)region.minX());
        int maxCX = SectionPos.m_123171_((int)region.maxX());
        int minCZ = SectionPos.m_123171_((int)region.minZ());
        int maxCZ = SectionPos.m_123171_((int)region.maxZ());
        LevelChunk[][] chunkCache = new LevelChunk[maxCX - minCX + 1][maxCZ - minCZ + 1];
        for (int i2 = 0; i2 < blocksToTick; ++i2) {
            int cz2;
            int posX = region.minX() + this.vsRandom.m_188503_(region.maxX() - region.minX() + 1);
            int posY = region.minY() + this.vsRandom.m_188503_(region.maxY() - region.minY() + 1);
            int posZ = region.minZ() + this.vsRandom.m_188503_(region.maxZ() - region.minZ() + 1);
            mutableBlockPos.m_122178_(posX, posY, posZ);
            if (thisAsClientLevel.m_151570_((BlockPos)mutableBlockPos)) continue;
            int cx2 = SectionPos.m_123171_((int)posX) - minCX;
            LevelChunk levelChunk = chunkCache[cx2][cz2 = SectionPos.m_123171_((int)posZ) - minCZ];
            if (levelChunk == null) {
                chunkCache[cx2][cz2] = levelChunk = thisAsClientLevel.m_6325_(cx2 + minCX, cz2 + minCZ);
            }
            BlockState blockState = levelChunk.m_8055_((BlockPos)mutableBlockPos);
            blockState.m_60734_().m_214162_(blockState, (Level)thisAsClientLevel, (BlockPos)mutableBlockPos, this.vsRandom);
            FluidState fluidState = levelChunk.m_6425_((BlockPos)mutableBlockPos);
            if (!fluidState.m_76178_()) {
                fluidState.m_230558_((Level)thisAsClientLevel, (BlockPos)mutableBlockPos, this.vsRandom);
                ParticleOptions particleOptions = fluidState.m_76189_();
                if (particleOptions != null && this.vsRandom.m_188503_(10) == 0) {
                    boolean bl2 = blockState.m_60783_((BlockGetter)thisAsClientLevel, (BlockPos)mutableBlockPos, Direction.DOWN);
                    BlockPos blockPos = mutableBlockPos.m_7495_();
                    if (!thisAsClientLevel.m_151570_(blockPos)) {
                        this.m_104689_(blockPos, levelChunk.m_8055_(blockPos), particleOptions, bl2);
                    }
                }
            }
            if (!holdingBarrierItem || !blockState.m_60713_(Blocks.f_50375_)) continue;
            thisAsClientLevel.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_194652_, blockState), (double)posX + 0.5, (double)posY + 0.5, (double)posZ + 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Redirect(at=@At(value="NEW", target="(Lnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFLnet/minecraft/util/RandomSource;DDD)Lnet/minecraft/client/resources/sounds/SimpleSoundInstance;"), method={"playSound(DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFZJ)V"})
    private SimpleSoundInstance redirectNewSoundInstance(SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch, RandomSource randomSource, double x2, double y2, double z2) {
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)ClientLevel.class.cast(this), x2, y2, z2);
        if (ship != null) {
            return new SimpleSoundInstanceOnShip(soundEvent, soundSource, volume, pitch, randomSource, x2, y2, z2, ship);
        }
        return new SimpleSoundInstance(soundEvent, soundSource, volume, pitch, randomSource, x2, y2, z2);
    }
}

