/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.entity;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.LoadedShip;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.internal.world.VsiShipWorld;
import org.valkyrienskies.mod.api.ValkyrienSkies;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.entity.ShipMountedToData;
import org.valkyrienskies.mod.common.util.EntityDragger;
import org.valkyrienskies.mod.common.util.EntityDraggingInformation;
import org.valkyrienskies.mod.common.util.IEntityDraggingInformationProvider;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;

@Mixin(value={Entity.class})
public abstract class MixinEntity
implements IEntityDraggingInformationProvider {
    @Unique
    private final EntityDraggingInformation draggingInformation = new EntityDraggingInformation();
    @Unique
    private boolean vs$isInSealedArea = false;
    @Unique
    private BlockPos vs$lastCheckedSealedPos = BlockPos.f_121853_;
    @Shadow
    public Level f_19853_;
    @Shadow
    public boolean f_19812_;
    @Shadow
    protected boolean f_19798_;
    @Shadow
    protected boolean f_19800_;
    @Shadow
    @Final
    private Set<TagKey<Fluid>> f_19801_;

    @Redirect(method={"pick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;clip(Lnet/minecraft/world/level/ClipContext;)Lnet/minecraft/world/phys/BlockHitResult;"))
    public BlockHitResult addShipsToRaycast(Level receiver, ClipContext ctx) {
        return RaycastUtilsKt.clipIncludeShips(receiver, ctx);
    }

    @Inject(method={"baseTick"}, at={@At(value="HEAD")})
    private void onBaseTick(CallbackInfo ci2) {
        if (this.f_19853_ != null && !this.m_213877_()) {
            Entity entity = (Entity)this;
            Vec3 relativePosition = Vec3.f_82478_;
            if (this.getDraggingInformation().isEntityBeingDraggedByAShip()) {
                relativePosition = EntityDragger.INSTANCE.serversidePosition(entity);
            } else if (VSGameUtilsKt.getShipMountedTo(entity) != null) {
                relativePosition = VectorConversionsMCKt.toMinecraft((Vector3dc)VSGameUtilsKt.getShipMountedToData(entity, null).getMountPosInShip().add(0.0, (double)entity.m_20236_(entity.m_20089_()), 0.0, new Vector3d()));
            }
            boolean isInSealedArea = false;
            if (!isInSealedArea) {
                if (relativePosition != Vec3.f_82478_ && VSGameUtilsKt.isBlockInShipyard(this.f_19853_, BlockPos.m_274446_((Position)relativePosition))) {
                    if (BlockPos.m_274446_((Position)relativePosition).equals((Object)this.vs$lastCheckedSealedPos)) {
                        isInSealedArea = this.vs$isInSealedArea();
                    } else {
                        isInSealedArea = VSGameUtilsKt.isPositionSealed(this.f_19853_, BlockPos.m_274446_((Position)relativePosition));
                        this.vs$lastCheckedSealedPos = BlockPos.m_274446_((Position)relativePosition);
                    }
                } else if (!VSGameUtilsKt.isBlockInShipyard(this.f_19853_, BlockPos.m_274446_((Position)relativePosition))) {
                    VsiShipWorld shipWorld = VSGameUtilsKt.getShipObjectWorld(this.f_19853_);
                    for (Ship ship : shipWorld.getAllShips().getIntersecting((AABBdc)VectorConversionsMCKt.toJOML(entity.m_20191_().m_82400_(1.0)), VSGameUtilsKt.getDimensionId(this.f_19853_))) {
                        relativePosition = VectorConversionsMCKt.toMinecraft((Vector3dc)ship.getWorldToShip().transformPosition((Vector3dc)VectorConversionsMCKt.toJOML(entity.m_20182_()), new Vector3d()));
                        if (!VSGameUtilsKt.isPositionSealed(this.f_19853_, BlockPos.m_274446_((Position)relativePosition))) continue;
                        this.vs$lastCheckedSealedPos = BlockPos.m_274446_((Position)relativePosition);
                        isInSealedArea = true;
                        break;
                    }
                }
            }
            this.vs$setInSealedArea(isInSealedArea && ValkyrienSkies.isConnectivityEnabled(this.f_19853_.f_46443_));
        }
    }

    @WrapMethod(method={"updateFluidOnEyes"})
    private void onFluidOnEyes(Operation<Void> original) {
        if (this.vs$isInSealedArea() && ValkyrienSkies.isConnectivityEnabled(this.f_19853_.f_46443_)) {
            this.f_19800_ = false;
            this.f_19801_.clear();
            return;
        }
        original.call(new Object[0]);
    }

    @WrapMethod(method={"updateSwimming"})
    private void onUpdateSwimming(Operation<Void> original) {
        if (this.vs$isInSealedArea && ValkyrienSkies.isConnectivityEnabled(this.f_19853_.f_46443_)) {
            this.f_19798_ = false;
            this.m_20282_(false);
            return;
        }
        original.call(new Object[0]);
    }

    @Inject(method={"updateInWaterStateAndDoWaterCurrentPushing"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUpdateInWaterStateAndDoWaterCurrentPushing(CallbackInfo ci2) {
        if (this.vs$isInSealedArea && ValkyrienSkies.isConnectivityEnabled(this.f_19853_.f_46443_)) {
            this.f_19798_ = false;
            ci2.cancel();
        }
    }

    @WrapMethod(method={"isInBubbleColumn"})
    private boolean onIsInBubbleColumn(Operation<Boolean> original) {
        if (this.vs$isInSealedArea && ValkyrienSkies.isConnectivityEnabled(this.f_19853_.f_46443_)) {
            return false;
        }
        return (Boolean)original.call(new Object[0]);
    }

    @Inject(at={@At(value="TAIL")}, method={"checkInsideBlocks"})
    private void afterCheckInside(CallbackInfo ci2) {
        AABBd boundingBox = VectorConversionsMCKt.toJOML(this.m_20191_());
        AABBd temp = new AABBd();
        for (Ship ship : VSGameUtilsKt.getShipsIntersecting(this.f_19853_, (AABBdc)boundingBox)) {
            AABBd inShipBB = boundingBox.transform(ship.getShipTransform().getWorldToShipMatrix(), temp);
            this.originalCheckInside(inShipBB);
        }
    }

    @Unique
    private void originalCheckInside(AABBd aABB) {
        Entity self = (Entity)Entity.class.cast(this);
        BlockPos blockPos = BlockPos.m_274561_((double)(aABB.minX + 0.001), (double)(aABB.minY + 0.001), (double)(aABB.minZ + 0.001));
        BlockPos blockPos2 = BlockPos.m_274561_((double)(aABB.maxX - 0.001), (double)(aABB.maxY - 0.001), (double)(aABB.maxZ - 0.001));
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        if (this.f_19853_.m_46832_(blockPos, blockPos2)) {
            for (int i2 = blockPos.m_123341_(); i2 <= blockPos2.m_123341_(); ++i2) {
                for (int j2 = blockPos.m_123342_(); j2 <= blockPos2.m_123342_(); ++j2) {
                    for (int k2 = blockPos.m_123343_(); k2 <= blockPos2.m_123343_(); ++k2) {
                        mutableBlockPos.m_122178_(i2, j2, k2);
                        BlockState blockState = this.f_19853_.m_8055_((BlockPos)mutableBlockPos);
                        try {
                            blockState.m_60682_(this.f_19853_, (BlockPos)mutableBlockPos, self);
                            this.m_6763_(blockState);
                            continue;
                        }
                        catch (Throwable var12) {
                            CrashReport crashReport = CrashReport.m_127521_((Throwable)var12, (String)"Colliding entity with block");
                            CrashReportCategory crashReportCategory = crashReport.m_127514_("Block being collided with");
                            CrashReportCategory.m_178950_((CrashReportCategory)crashReportCategory, (LevelHeightAccessor)this.f_19853_, (BlockPos)mutableBlockPos, (BlockState)blockState);
                            throw new ReportedException(crashReport);
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetEyePosition(float partialTicks, CallbackInfoReturnable<Vec3> cir) {
        ShipMountedToData shipMountedToData = VSGameUtilsKt.getShipMountedToData((Entity)Entity.class.cast(this), Float.valueOf(partialTicks));
        if (shipMountedToData == null) {
            Ship shipDraggedBy;
            IEntityDraggingInformationProvider dragProvider;
            Player player;
            Object t2 = Entity.class.cast(this);
            if (t2 instanceof Player && (player = (Player)t2) instanceof IEntityDraggingInformationProvider && (dragProvider = (IEntityDraggingInformationProvider)player).getDraggingInformation().isEntityBeingDraggedByAShip() && dragProvider.getDraggingInformation().getServerRelativePlayerYaw() != null && (shipDraggedBy = VSGameUtilsKt.getAllShips(this.f_19853_).getById(dragProvider.getDraggingInformation().getLastShipStoodOn())) != null) {
                Vec3 localEyePosition = EntityDragger.INSTANCE.serversideEyePosition((Entity)player);
                if (!VSGameUtilsKt.isBlockInShipyard(this.f_19853_, localEyePosition)) {
                    return;
                }
                ShipTransform shipTransform = shipDraggedBy instanceof ClientShip ? ((ClientShip)shipDraggedBy).getRenderTransform() : shipDraggedBy.getShipTransform();
                Vec3 worldEyePosition = VectorConversionsMCKt.toMinecraft((Vector3dc)shipTransform.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML(localEyePosition)));
                cir.setReturnValue((Object)worldEyePosition);
            }
            return;
        }
        LoadedShip shipMountedTo = shipMountedToData.getShipMountedTo();
        ShipTransform shipTransform = shipMountedTo instanceof ClientShip ? ((ClientShip)shipMountedTo).getRenderTransform() : shipMountedTo.getTransform();
        Vector3d basePos = shipTransform.getShipToWorld().transformPosition(shipMountedToData.getMountPosInShip(), new Vector3d());
        Vector3d eyeRelativePos = shipTransform.getShipToWorldRotation().transform(new Vector3d(0.0, (double)this.m_20192_(), 0.0));
        Vec3 newEyePos = VectorConversionsMCKt.toMinecraft((Vector3dc)basePos.add((Vector3dc)eyeRelativePos, new Vector3d()));
        cir.setReturnValue((Object)newEyePos);
    }

    @Inject(method={"getEyePosition()Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void preGetEyePositionServer(CallbackInfoReturnable<Vec3> cir) {
        ShipMountedToData shipMountedToData = VSGameUtilsKt.getShipMountedToData((Entity)Entity.class.cast(this), null);
        if (shipMountedToData == null) {
            return;
        }
        LoadedShip shipMountedTo = shipMountedToData.getShipMountedTo();
        ShipTransform shipTransform = shipMountedTo instanceof ClientShip ? ((ClientShip)shipMountedTo).getRenderTransform() : shipMountedTo.getShipTransform();
        Vector3d basePos = shipTransform.getShipToWorldMatrix().transformPosition(shipMountedToData.getMountPosInShip(), new Vector3d());
        Vector3d eyeRelativePos = shipTransform.getShipCoordinatesToWorldCoordinatesRotation().transform(new Vector3d(0.0, (double)this.m_20192_(), 0.0));
        Vec3 newEyePos = VectorConversionsMCKt.toMinecraft((Vector3dc)basePos.add((Vector3dc)eyeRelativePos, new Vector3d()));
        cir.setReturnValue((Object)newEyePos);
    }

    @Inject(method={"calculateViewVector"}, at={@At(value="HEAD")}, cancellable=true)
    private void preCalculateViewVector(float xRot, float yRot, CallbackInfoReturnable<Vec3> cir) {
        LoadedShip shipMountedTo = VSGameUtilsKt.getShipMountedTo((Entity)Entity.class.cast(this));
        if (shipMountedTo == null) {
            return;
        }
        float f2 = xRot * ((float)Math.PI / 180);
        float g2 = -yRot * ((float)Math.PI / 180);
        float h2 = Mth.m_14089_((float)g2);
        float i2 = Mth.m_14031_((float)g2);
        float j2 = Mth.m_14089_((float)f2);
        float k2 = Mth.m_14031_((float)f2);
        Vector3d originalViewVector = new Vector3d((double)(i2 * j2), (double)(-k2), (double)(h2 * j2));
        ShipTransform shipTransform = shipMountedTo instanceof ClientShip ? ((ClientShip)shipMountedTo).getRenderTransform() : shipMountedTo.getTransform();
        Vec3 newViewVector = VectorConversionsMCKt.toMinecraft((Vector3dc)shipTransform.getShipToWorldRotation().transform((Vector3dc)originalViewVector, new Vector3d()));
        cir.setReturnValue((Object)newViewVector);
    }

    @Inject(method={"shouldRender"}, at={@At(value="HEAD")}, cancellable=true)
    private void onShouldRender(double d2, double e2, double f2, CallbackInfoReturnable<Boolean> cir) {
        Ship ship;
        if (this.draggingInformation.isEntityBeingDraggedByAShip() && (ship = VSGameUtilsKt.getShipObjectWorld(this.f_19853_).getAllShips().getById(this.draggingInformation.getLastShipStoodOn())) != null) {
            ShipTransform shipTransform;
            ShipTransform shipTransform2 = shipTransform = ship instanceof ClientShip ? ((ClientShip)ship).getRenderTransform() : ship.getTransform();
            if (this.draggingInformation.getRelativePositionOnShip() != null) {
                Vector3d redir = shipTransform.getShipToWorld().transformPosition(this.draggingInformation.getRelativePositionOnShip(), new Vector3d());
                double distX = redir.x() - d2;
                double distY = redir.y() - e2;
                double distZ = redir.z() - f2;
                double sqrDist = distX * distX + distY * distY + distZ * distZ;
                cir.setReturnValue((Object)this.m_6783_(sqrDist));
            }
        }
    }

    @Shadow
    public abstract AABB m_20191_();

    @Shadow
    protected abstract void m_19956_(Entity var1, Entity.MoveFunction var2);

    @Shadow
    protected abstract void m_6763_(BlockState var1);

    @Shadow
    public abstract double m_20189_();

    @Shadow
    public abstract double m_20186_();

    @Shadow
    public abstract double m_20185_();

    @Shadow
    public abstract float m_20192_();

    @Shadow
    public abstract EntityType<?> m_6095_();

    @Shadow
    public abstract boolean m_6783_(double var1);

    @Shadow
    public abstract void m_5997_(double var1, double var3, double var5);

    @Shadow
    public abstract boolean m_213877_();

    @Shadow
    public abstract void m_20282_(boolean var1);

    @Override
    @NotNull
    public EntityDraggingInformation getDraggingInformation() {
        return this.draggingInformation;
    }

    @Override
    public boolean vs$shouldDrag() {
        return true;
    }

    @Override
    public boolean vs$isInSealedArea() {
        return this.vs$isInSealedArea;
    }

    @Override
    public void vs$setInSealedArea(boolean inSealedArea) {
        this.vs$isInSealedArea = inSealedArea;
    }

    @Override
    public void vs$dragImmediately(Ship ship) {
        if (ship == null) {
            return;
        }
        this.draggingInformation.setLastShipStoodOn(ship.getId());
        this.draggingInformation.setShouldImpulseMovement(false);
    }
}

