/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create.block;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.redstone.contact.RedstoneContactBlock;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBdc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

@Mixin(value={RedstoneContactBlock.class})
public abstract class MixinRedstoneContactBlock
extends WrenchableDirectionalBlock {
    @Shadow
    @Final
    public static BooleanProperty POWERED;
    @Unique
    private static final double CHECK_BOUND = 0.125;
    @Unique
    private static final double INTERSECT_BOUND = 0.225;

    protected MixinRedstoneContactBlock() {
        super(null);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        world.m_186460_(pos, (Block)this, 2);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void injectTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random, CallbackInfo ci2) {
        if (!world.m_183326_().m_183582_(pos, (Object)this)) {
            world.m_186460_(pos, (Block)this, 2);
        }
    }

    @Unique
    private static boolean hasContact(LevelAccessor world, BlockPos selfPos, Direction selfDir, Ship ship, BlockPos targetPos, Ship targetShip) {
        Vector3d checkPoint;
        int n2;
        int n3;
        Vector3d[] vector3dArray;
        Matrix4dc shipMat;
        BlockState blockState = world.m_8055_(targetPos);
        if (!MixinRedstoneContactBlock.isContact(blockState)) {
            return false;
        }
        Direction targetDir = (Direction)blockState.m_61143_((Property)f_52588_);
        Vector3d[] checkPoints = MixinRedstoneContactBlock.makeCheckPoints(targetPos.m_121945_(targetDir).m_252807_(), targetDir);
        if (targetShip != null) {
            shipMat = targetShip.getShipToWorld();
            vector3dArray = checkPoints;
            n3 = vector3dArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                checkPoint = vector3dArray[n2];
                shipMat.transformPosition(checkPoint);
            }
        }
        if (ship != null) {
            shipMat = ship.getWorldToShip();
            vector3dArray = checkPoints;
            n3 = vector3dArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                checkPoint = vector3dArray[n2];
                shipMat.transformPosition(checkPoint);
            }
        }
        for (Vector3d checkPoint2 : checkPoints) {
            if (!selfPos.equals((Object)BlockPos.m_274561_((double)checkPoint2.x, (double)checkPoint2.y, (double)checkPoint2.z))) continue;
            return true;
        }
        return false;
    }

    @Inject(method={"hasValidContact"}, at={@At(value="RETURN")}, cancellable=true)
    private static void injectHasValidContact(LevelAccessor world, BlockPos pos, Direction direction, CallbackInfoReturnable<Boolean> cir) {
        BlockState targetState;
        if (cir.getReturnValueZ()) {
            return;
        }
        Level level = (Level)world;
        BlockPos detectPos = pos.m_121945_(direction);
        BlockState facingState = world.m_8055_(detectPos);
        if (MixinRedstoneContactBlock.isContact(facingState)) {
            cir.setReturnValue((Object)(facingState.m_61143_((Property)f_52588_) == direction.m_122424_() ? 1 : 0));
            return;
        }
        if (world.m_8055_(pos).m_60713_((Block)AllBlocks.ELEVATOR_CONTACT.get())) {
            return;
        }
        Vec3 point = detectPos.m_252807_();
        Vector3d[] checkPoints = MixinRedstoneContactBlock.makeCheckPoints(point, direction);
        Ship ship = VSGameUtilsKt.getShipManagingPos(level, pos);
        if (ship != null) {
            Matrix4dc shipMat = ship.getShipToWorld();
            for (Vector3d checkPoint : checkPoints) {
                shipMat.transformPosition(checkPoint);
            }
        }
        AABB searchAABB = VSGameUtilsKt.transformAabbToWorld(level, new AABB(point.f_82479_ - 0.225, point.f_82480_ - 0.225, point.f_82481_ - 0.225, point.f_82479_ + 0.225, point.f_82480_ + 0.225, point.f_82481_ + 0.225));
        BlockPos foundBlock = null;
        boolean found = false;
        for (Vector3d checkPoint : checkPoints) {
            foundBlock = BlockPos.m_274561_((double)checkPoint.x, (double)checkPoint.y, (double)checkPoint.z);
            if (MixinRedstoneContactBlock.hasContact(world, pos, direction, ship, foundBlock, null)) {
                found = true;
                break;
            }
            Vec3 checkPos = new Vec3(checkPoint.x, checkPoint.y, checkPoint.z);
            for (AbstractContraptionEntity contraption : world.m_45976_(AbstractContraptionEntity.class, searchAABB)) {
                Vec3 localPos = contraption.toLocalVector(checkPos, 1.0f);
                StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getContraption().getBlocks().get(BlockPos.m_274446_((Position)localPos));
                if (info == null || !MixinRedstoneContactBlock.isContact(info.f_74676_())) continue;
                Direction dir = (Direction)info.f_74676_().m_61143_((Property)f_52588_);
                Vec3 checkVec = contraption.toGlobalVector(localPos.m_231075_(dir, 0.65), 1.0f);
                Vector3d checkP = new Vector3d(checkVec.f_82479_, checkVec.f_82480_, checkVec.f_82481_);
                if (ship != null) {
                    ship.getWorldToShip().transformPosition(checkP);
                }
                if (!pos.equals((Object)BlockPos.m_274561_((double)checkP.x, (double)checkP.y, (double)checkP.z))) continue;
                foundBlock = null;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found) {
            Vector3d foundPos = new Vector3d();
            for (Ship targetShip : VSGameUtilsKt.getShipsIntersecting(level, searchAABB)) {
                for (Vector3d checkPoint : checkPoints) {
                    targetShip.getWorldToShip().transformPosition((Vector3dc)checkPoint, foundPos);
                    if (targetShip != ship && MixinRedstoneContactBlock.hasContact(world, pos, direction, ship, foundBlock = BlockPos.m_274561_((double)foundPos.x, (double)foundPos.y, (double)foundPos.z), targetShip)) {
                        found = true;
                        break;
                    }
                    Vec3 checkPos = new Vec3(foundPos.x, foundPos.y, foundPos.z);
                    AABB searchAABB2 = VectorConversionsMCKt.toMinecraft((AABBdc)VectorConversionsMCKt.toJOML(searchAABB).transform(targetShip.getWorldToShip()));
                    for (AbstractContraptionEntity contraption : world.m_45976_(AbstractContraptionEntity.class, searchAABB2)) {
                        Vec3 localPos = contraption.toLocalVector(checkPos, 1.0f);
                        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getContraption().getBlocks().get(BlockPos.m_274446_((Position)localPos));
                        if (info == null || !MixinRedstoneContactBlock.isContact(info.f_74676_())) continue;
                        Direction dir = (Direction)info.f_74676_().m_61143_((Property)f_52588_);
                        Vec3 checkVec = contraption.toGlobalVector(localPos.m_231075_(dir, 0.65), 1.0f);
                        Vector3d checkP = new Vector3d(checkVec.f_82479_, checkVec.f_82480_, checkVec.f_82481_);
                        if (targetShip != ship) {
                            targetShip.getShipToWorld().transformPosition(checkP);
                            if (ship != null) {
                                ship.getWorldToShip().transformPosition(checkP);
                            }
                        }
                        if (!pos.equals((Object)BlockPos.m_274561_((double)checkP.x, (double)checkP.y, (double)checkP.z))) continue;
                        foundBlock = null;
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                if (!found) continue;
                break;
            }
        }
        if (!found) {
            return;
        }
        if (foundBlock != null && !((Boolean)(targetState = world.m_8055_(foundBlock)).m_61143_((Property)POWERED)).booleanValue()) {
            level.m_46597_(foundBlock, (BlockState)targetState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)));
        }
        cir.setReturnValue((Object)true);
    }

    @Unique
    private static boolean isContact(BlockState state) {
        return state.m_60713_((Block)AllBlocks.REDSTONE_CONTACT.get()) || state.m_60713_((Block)AllBlocks.ELEVATOR_CONTACT.get());
    }

    @Unique
    private static Vector3d[] makeCheckPoints(Vec3 point, Direction direction) {
        Vector3d[] vector3dArray;
        switch (direction.m_122434_()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case X: {
                Vector3d[] vector3dArray2 = new Vector3d[4];
                vector3dArray2[0] = new Vector3d(point.f_82479_, point.f_82480_ - 0.125, point.f_82481_ - 0.125);
                vector3dArray2[1] = new Vector3d(point.f_82479_, point.f_82480_ - 0.125, point.f_82481_ + 0.125);
                vector3dArray2[2] = new Vector3d(point.f_82479_, point.f_82480_ + 0.125, point.f_82481_ - 0.125);
                vector3dArray = vector3dArray2;
                vector3dArray2[3] = new Vector3d(point.f_82479_, point.f_82480_ + 0.125, point.f_82481_ + 0.125);
                break;
            }
            case Y: {
                Vector3d[] vector3dArray3 = new Vector3d[4];
                vector3dArray3[0] = new Vector3d(point.f_82479_ - 0.125, point.f_82480_, point.f_82481_ - 0.125);
                vector3dArray3[1] = new Vector3d(point.f_82479_ - 0.125, point.f_82480_, point.f_82481_ + 0.125);
                vector3dArray3[2] = new Vector3d(point.f_82479_ + 0.125, point.f_82480_, point.f_82481_ - 0.125);
                vector3dArray = vector3dArray3;
                vector3dArray3[3] = new Vector3d(point.f_82479_ + 0.125, point.f_82480_, point.f_82481_ + 0.125);
                break;
            }
            case Z: {
                Vector3d[] vector3dArray4 = new Vector3d[4];
                vector3dArray4[0] = new Vector3d(point.f_82479_ - 0.125, point.f_82480_ - 0.125, point.f_82481_);
                vector3dArray4[1] = new Vector3d(point.f_82479_ - 0.125, point.f_82480_ + 0.125, point.f_82481_);
                vector3dArray4[2] = new Vector3d(point.f_82479_ + 0.125, point.f_82480_ - 0.125, point.f_82481_);
                vector3dArray = vector3dArray4;
                vector3dArray4[3] = new Vector3d(point.f_82479_ + 0.125, point.f_82480_ + 0.125, point.f_82481_);
            }
        }
        return vector3dArray;
    }
}

