/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet;
import org.valkyrienskies.core.internal.ShipTeleportData;
import org.valkyrienskies.core.internal.VsiGameServer;
import org.valkyrienskies.core.internal.ships.VsiLoadedServerShip;
import org.valkyrienskies.core.internal.world.VsiPipeline;
import org.valkyrienskies.core.internal.world.VsiServerShipWorld;
import org.valkyrienskies.mod.common.IShipObjectWorldServerProvider;
import org.valkyrienskies.mod.common.ShipSavedData;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.config.DimensionParametersResolver;
import org.valkyrienskies.mod.common.config.MassDatapackResolver;
import org.valkyrienskies.mod.common.hooks.VSGameEvents;
import org.valkyrienskies.mod.common.util.EntityDragger;
import org.valkyrienskies.mod.common.util.ShipSettingsKt;
import org.valkyrienskies.mod.common.util.VSLevelChunk;
import org.valkyrienskies.mod.common.util.VSServerLevel;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.common.world.ChunkManagement;
import org.valkyrienskies.mod.compat.LoadedMods;
import org.valkyrienskies.mod.compat.Weather2Compat;
import org.valkyrienskies.mod.util.KrunchSupport;
import org.valkyrienskies.mod.util.McMathUtilKt;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer
implements IShipObjectWorldServerProvider,
VsiGameServer {
    @Shadow
    private PlayerList f_129763_;
    @Unique
    private VsiServerShipWorld shipWorld;
    @Unique
    private VsiPipeline vsPipeline;
    @Unique
    private Set<String> loadedLevels = new HashSet<String>();
    @Unique
    private final Map<String, ServerLevel> dimensionToLevelMap = new HashMap<String, ServerLevel>();

    @Shadow
    public abstract ServerLevel m_129783_();

    @Shadow
    public abstract Iterable<ServerLevel> m_129785_();

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;initServer()Z")}, method={"runServer"})
    private void beforeInitServer(CallbackInfo info) {
        ValkyrienSkiesMod.setCurrentServer((MinecraftServer)MinecraftServer.class.cast(this));
    }

    @Inject(at={@At(value="TAIL")}, method={"stopServer"})
    private void afterStopServer(CallbackInfo ci2) {
        ValkyrienSkiesMod.setCurrentServer(null);
    }

    @Override
    @Nullable
    public VsiServerShipWorld getShipObjectWorld() {
        return this.shipWorld;
    }

    @Override
    @Nullable
    public VsiPipeline getVsPipeline() {
        return this.vsPipeline;
    }

    @Inject(method={"createLevels"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;getDataStorage()Lnet/minecraft/world/level/storage/DimensionDataStorage;")})
    private void postCreateLevels(CallbackInfo ci2) {
        if (!MassDatapackResolver.INSTANCE.getRegisteredBlocks()) {
            ArrayList blockStateList = new ArrayList(Block.f_49791_.m_13562_());
            Block.f_49791_.forEach(blockStateList::add);
            MassDatapackResolver.INSTANCE.registerAllBlockStates(blockStateList);
            ValkyrienSkiesMod.getVsCore().registerBlockStates(MassDatapackResolver.INSTANCE.getBlockStateData());
        }
        ShipSavedData shipSavedData = (ShipSavedData)this.m_129783_().m_8895_().m_164861_(ShipSavedData::load, ShipSavedData.Companion::createEmpty, "vs_ship_data");
        Throwable ex2 = shipSavedData.getLoadingException();
        if (ex2 != null) {
            System.err.println("VALKYRIEN SKIES ERROR WHILE LOADING SHIP DATA");
            ex2.printStackTrace();
            throw new RuntimeException(ex2);
        }
        this.vsPipeline = shipSavedData.getPipeline();
        KrunchSupport.INSTANCE.setKrunchSupported(!this.vsPipeline.isUsingDummyPhysics());
        this.shipWorld = this.vsPipeline.getShipWorld();
        this.shipWorld.setGameServer(this);
        VSGameEvents.INSTANCE.getRegistriesCompleted().emit((Object)Unit.INSTANCE);
        DimensionParametersResolver.Parameters params = DimensionParametersResolver.INSTANCE.getDimensionMap().get(VSGameUtilsKt.getDimensionId((Level)this.m_129783_()));
        if (params != null) {
            this.getShipObjectWorld().addDimension(VSGameUtilsKt.getDimensionId((Level)this.m_129783_()), VSGameUtilsKt.getYRange((Level)this.m_129783_()), params.getGravity(), params.getSeaLevel(), params.getMaxY());
        } else {
            this.getShipObjectWorld().addDimension(VSGameUtilsKt.getDimensionId((Level)this.m_129783_()), VSGameUtilsKt.getYRange((Level)this.m_129783_()), McMathUtilKt.getDEFAULT_WORLD_GRAVITY(), 63.0, 962.0);
        }
    }

    @Inject(method={"tickServer"}, at={@At(value="HEAD")})
    private void preTick(CallbackInfo ci2) {
        Set vsPlayers = this.f_129763_.m_11314_().stream().map(VSGameUtilsKt::getPlayerWrapper).collect(Collectors.toSet());
        this.shipWorld.setPlayers(vsPlayers);
        HashMap<String, ServerLevel> newLoadedLevels = new HashMap<String, ServerLevel>();
        for (ServerLevel level : this.m_129785_()) {
            String dimensionId = VSGameUtilsKt.getDimensionId((Level)level);
            newLoadedLevels.put(dimensionId, level);
            this.dimensionToLevelMap.put(dimensionId, level);
        }
        for (String oldLoadedLevelId : this.loadedLevels) {
            if (newLoadedLevels.containsKey(oldLoadedLevelId)) continue;
            this.shipWorld.removeDimension(oldLoadedLevelId);
            this.dimensionToLevelMap.remove(oldLoadedLevelId);
        }
        this.loadedLevels = newLoadedLevels.keySet();
        this.vsPipeline.preTickGame();
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerConnectionListener;tick()V", shift=At.Shift.AFTER)})
    private void preConnectionTick(CallbackInfo ci2) {
        ChunkManagement.tickChunkLoading(this.shipWorld, (MinecraftServer)MinecraftServer.class.cast(this));
    }

    @Shadow
    public abstract ServerLevel m_129880_(ResourceKey<Level> var1);

    @Shadow
    public abstract boolean m_7079_();

    @Inject(method={"tickServer"}, at={@At(value="TAIL")})
    private void postTick(CallbackInfo ci2) {
        this.vsPipeline.postTickGame();
        for (ServerLevel level : this.m_129785_()) {
            EntityDragger.INSTANCE.dragEntitiesWithShips(level.m_8583_(), false);
            if (!LoadedMods.getWeather2()) continue;
            Weather2Compat.INSTANCE.tick(level);
        }
    }

    @Unique
    private void handleShipPortals() {
        ArrayList<LoadedServerShip> loadedShipsCopy = new ArrayList<LoadedServerShip>((Collection<LoadedServerShip>)((Object)this.shipWorld.getLoadedShips()));
        for (LoadedServerShip shipObject : loadedShipsCopy) {
            BlockPos blockPos2;
            if (!ShipSettingsKt.getSettings(shipObject).getChangeDimensionOnTouchPortals()) continue;
            ServerLevel level = this.dimensionToLevelMap.get(shipObject.getChunkClaimDimension());
            Vector3dc shipPos = shipObject.getTransform().getPositionInWorld();
            double bbRadius = 0.5;
            BlockPos blockPos = BlockPos.m_274561_((double)(shipPos.x() - 0.5), (double)(shipPos.y() - 0.5), (double)(shipPos.z() - 0.5));
            if (!level.m_46832_(blockPos, blockPos2 = BlockPos.m_274561_((double)(shipPos.x() + 0.5), (double)(shipPos.y() + 0.5), (double)(shipPos.z() + 0.5)))) continue;
            ((VsiLoadedServerShip)shipObject).decayPortalCoolDown();
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int i2 = blockPos.m_123341_(); i2 <= blockPos2.m_123341_(); ++i2) {
                for (int j2 = blockPos.m_123342_(); j2 <= blockPos2.m_123342_(); ++j2) {
                    for (int k2 = blockPos.m_123343_(); k2 <= blockPos2.m_123343_(); ++k2) {
                        ServerLevel destLevel;
                        mutableBlockPos.m_122178_(i2, j2, k2);
                        BlockState blockState = level.m_8055_((BlockPos)mutableBlockPos);
                        if (blockState.m_60734_() == Blocks.f_50142_) {
                            if (!((VsiLoadedServerShip)shipObject).isOnPortalCoolDown() && (destLevel = this.m_129880_((ResourceKey<Level>)(level.m_46472_() == Level.f_46429_ ? Level.f_46428_ : Level.f_46429_))) != null && this.m_7079_()) {
                                level.m_46473_().m_6180_("portal");
                                this.shipChangeDimension(level, destLevel, (BlockPos)mutableBlockPos, shipObject);
                                level.m_46473_().m_7238_();
                            }
                            ((VsiLoadedServerShip)shipObject).handleInsidePortal();
                            continue;
                        }
                        if (blockState.m_60734_() != Blocks.f_50257_) continue;
                        destLevel = level.m_7654_().m_129880_(level.m_46472_() == Level.f_46430_ ? Level.f_46428_ : Level.f_46430_);
                        if (destLevel == null) {
                            return;
                        }
                        this.shipChangeDimension(level, destLevel, null, shipObject);
                    }
                }
            }
        }
    }

    @Unique
    private void shipChangeDimension(@NotNull ServerLevel srcLevel, @NotNull ServerLevel destLevel, @Nullable BlockPos portalEntrancePos, @NotNull LoadedServerShip shipObject) {
        PortalInfo portalInfo = this.findDimensionEntryPoint(srcLevel, destLevel, portalEntrancePos, shipObject.getTransform().getPositionInWorld());
        if (portalInfo == null) {
            return;
        }
        ShipTeleportData shipTeleportData = ValkyrienSkiesMod.getVsCore().newShipTeleportData((Vector3dc)VectorConversionsMCKt.toJOML(portalInfo.f_77676_), shipObject.getTransform().getShipToWorldRotation(), (Vector3dc)new Vector3d(), (Vector3dc)new Vector3d(), VSGameUtilsKt.getDimensionId((Level)destLevel), null, null);
        this.shipWorld.teleportShip((ServerShip)shipObject, shipTeleportData);
    }

    @Unique
    @Nullable
    private PortalInfo findDimensionEntryPoint(@NotNull ServerLevel srcLevel, @NotNull ServerLevel destLevel, @Nullable BlockPos portalEntrancePos, @NotNull Vector3dc shipPos) {
        boolean bl3;
        boolean bl2 = srcLevel.m_46472_() == Level.f_46430_ && destLevel.m_46472_() == Level.f_46428_;
        boolean bl22 = destLevel.m_46472_() == Level.f_46430_;
        Vec3 deltaMovement = Vec3.f_82478_;
        EntityDimensions entityDimensions = new EntityDimensions(1.0f, 1.0f, true);
        if (bl2 || bl22) {
            BlockPos blockPos = bl22 ? ServerLevel.f_8562_ : destLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, destLevel.m_220360_());
            return new PortalInfo(new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5), deltaMovement, 0.0f, 0.0f);
        }
        boolean bl4 = bl3 = destLevel.m_46472_() == Level.f_46429_;
        if (srcLevel.m_46472_() != Level.f_46429_ && !bl3) {
            return null;
        }
        WorldBorder worldBorder = destLevel.m_6857_();
        double d2 = DimensionType.m_63908_((DimensionType)srcLevel.m_6042_(), (DimensionType)destLevel.m_6042_());
        BlockPos blockPos2 = worldBorder.m_187569_(shipPos.x() * d2, shipPos.y(), shipPos.z() * d2);
        return this.getExitPortal(destLevel, blockPos2, bl3, worldBorder).map(foundRectangle -> {
            Vec3 vec3;
            Direction.Axis axis;
            if (portalEntrancePos != null) {
                BlockState blockState = srcLevel.m_8055_(portalEntrancePos);
                if (blockState.m_61138_((Property)BlockStateProperties.f_61364_)) {
                    axis = (Direction.Axis)blockState.m_61143_((Property)BlockStateProperties.f_61364_);
                    BlockUtil.FoundRectangle foundRectangle2 = BlockUtil.m_124334_((BlockPos)portalEntrancePos, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, blockPos -> srcLevel.m_8055_(blockPos) == blockState);
                    vec3 = this.getRelativePortalPosition(axis, foundRectangle2, entityDimensions, VectorConversionsMCKt.toMinecraft(shipPos));
                } else {
                    axis = Direction.Axis.X;
                    vec3 = new Vec3(0.5, 0.0, 0.0);
                }
            } else {
                axis = Direction.Axis.X;
                vec3 = new Vec3(0.5, 0.0, 0.0);
            }
            return MixinMinecraftServer.valkyrienskies$createPortalInfo(destLevel, foundRectangle, axis, vec3, entityDimensions, deltaMovement, 0.0f, 0.0f);
        }).orElse(null);
    }

    @Unique
    private static PortalInfo valkyrienskies$createPortalInfo(ServerLevel serverLevel, BlockUtil.FoundRectangle foundRectangle, Direction.Axis axis, Vec3 vec3, EntityDimensions entityDimensions, Vec3 vec32, float f2, float g2) {
        BlockPos blockPos = foundRectangle.f_124348_;
        BlockState blockState = serverLevel.m_8055_(blockPos);
        Direction.Axis axis2 = blockState.m_61145_((Property)BlockStateProperties.f_61364_).orElse(Direction.Axis.X);
        double d2 = foundRectangle.f_124349_;
        double e2 = foundRectangle.f_124350_;
        int i2 = axis == axis2 ? 0 : 90;
        Vec3 vec33 = axis == axis2 ? vec32 : new Vec3(vec32.f_82481_, vec32.f_82480_, -vec32.f_82479_);
        double h2 = (double)entityDimensions.f_20377_ / 2.0 + (d2 - (double)entityDimensions.f_20377_) * vec3.m_7096_();
        double j2 = (e2 - (double)entityDimensions.f_20378_) * vec3.m_7098_();
        double k2 = 0.5 + vec3.m_7094_();
        boolean bl2 = axis2 == Direction.Axis.X;
        Vec3 vec34 = new Vec3((double)blockPos.m_123341_() + (bl2 ? h2 : k2), (double)blockPos.m_123342_() + j2, (double)blockPos.m_123343_() + (bl2 ? k2 : h2));
        Vec3 vec35 = MixinMinecraftServer.valkyrienskies$findCollisionFreePosition(vec34, serverLevel, entityDimensions);
        return new PortalInfo(vec35, vec33, f2 + (float)i2, g2);
    }

    @Unique
    private static Vec3 valkyrienskies$findCollisionFreePosition(Vec3 vec3, ServerLevel serverLevel, EntityDimensions entityDimensions) {
        if (!(entityDimensions.f_20377_ > 4.0f) && !(entityDimensions.f_20378_ > 4.0f)) {
            double d2 = (double)entityDimensions.f_20378_ / 2.0;
            Vec3 vec32 = vec3.m_82520_(0.0, d2, 0.0);
            VoxelShape voxelShape = Shapes.m_83064_((AABB)AABB.m_165882_((Vec3)vec32, (double)entityDimensions.f_20377_, (double)0.0, (double)entityDimensions.f_20377_).m_82363_(0.0, 1.0, 0.0).m_82400_(1.0E-6));
            Optional optional = serverLevel.m_151418_(null, voxelShape, vec32, (double)entityDimensions.f_20377_, (double)entityDimensions.f_20378_, (double)entityDimensions.f_20377_);
            Optional<Vec3> optional2 = optional.map(vec3x -> vec3x.m_82492_(0.0, d2, 0.0));
            return optional2.orElse(vec3);
        }
        return vec3;
    }

    @Unique
    private Vec3 getRelativePortalPosition(Direction.Axis axis, BlockUtil.FoundRectangle foundRectangle, EntityDimensions entityDimensions, Vec3 position) {
        return PortalShape.m_77738_((BlockUtil.FoundRectangle)foundRectangle, (Direction.Axis)axis, (Vec3)position, (EntityDimensions)entityDimensions);
    }

    @Unique
    private Optional<BlockUtil.FoundRectangle> getExitPortal(ServerLevel serverLevel, BlockPos blockPos, boolean bl2, WorldBorder worldBorder) {
        return serverLevel.m_8871_().m_192985_(blockPos, bl2, worldBorder);
    }

    @Inject(method={"stopServer"}, at={@At(value="HEAD")})
    private void preStopServer(CallbackInfo ci2) {
        if (this.vsPipeline != null) {
            this.vsPipeline.setDeleteResources(true);
            this.vsPipeline.setArePhysicsRunning(true);
        }
    }

    @Inject(method={"stopServer"}, at={@At(value="RETURN")})
    private void postStopServer(CallbackInfo ci2) {
        this.dimensionToLevelMap.clear();
        this.shipWorld.setGameServer(null);
        this.shipWorld = null;
    }

    @NotNull
    private ServerLevel getLevelFromDimensionId(@NotNull String dimensionId) {
        return this.dimensionToLevelMap.get(dimensionId);
    }

    @Override
    public void moveTerrainAcrossDimensions(@NotNull IShipActiveChunksSet shipChunks, @NotNull String srcDimension, @NotNull String destDimension) {
        ServerLevel srcLevel = this.getLevelFromDimensionId(srcDimension);
        ServerLevel destLevel = this.getLevelFromDimensionId(destDimension);
        shipChunks.forEach((x2, z2) -> {
            LevelChunk srcChunk = srcLevel.m_6325_(x2, z2);
            ((VSServerLevel)destLevel).removeChunk(x2, z2);
            LevelChunk destChunk = destLevel.m_6325_(x2, z2);
            ((VSLevelChunk)destChunk).copyChunkFromOtherDimension((VSLevelChunk)srcChunk);
        });
        shipChunks.forEach((x2, z2) -> {
            LevelChunk srcChunk = srcLevel.m_6325_(x2, z2);
            ((VSLevelChunk)srcChunk).clearChunk();
            ChunkPos chunkPos = srcChunk.m_7697_();
            srcLevel.m_7726_().m_6692_(chunkPos, false);
            ((VSServerLevel)srcLevel).removeChunk(x2, z2);
        });
    }
}

