/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.physics_api.joints.D6Joint;
import org.valkyrienskies.physics_api.joints.DistanceJoint;
import org.valkyrienskies.physics_api.joints.FixedJoint;
import org.valkyrienskies.physics_api.joints.GearJoint;
import org.valkyrienskies.physics_api.joints.JointAndId;
import org.valkyrienskies.physics_api.joints.JointData;
import org.valkyrienskies.physics_api.joints.JointType;
import org.valkyrienskies.physics_api.joints.PrismaticJoint;
import org.valkyrienskies.physics_api.joints.RackAndPinionJoint;
import org.valkyrienskies.physics_api.joints.RevoluteJoint;
import org.valkyrienskies.physics_api.joints.SphericalJoint;
import org.valkyrienskies.physics_api_krunch.encoders.JointCodec;

public class ConstraintEncoder {
    public static void encodeConstraint(@NotNull JointData constraint, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(constraint.getConstraintType().ordinal());
        switch (constraint.getConstraintType()) {
            case FIXED: {
                JointCodec.INSTANCE.encodeFixed((FixedJoint)constraint, writeBuffer);
                break;
            }
            case DISTANCE: {
                JointCodec.INSTANCE.encodeDistance((DistanceJoint)constraint, writeBuffer);
                break;
            }
            case SPHERICAL: {
                JointCodec.INSTANCE.encodeSpherical((SphericalJoint)constraint, writeBuffer);
                break;
            }
            case REVOLUTE: {
                JointCodec.INSTANCE.encodeRevolute((RevoluteJoint)constraint, writeBuffer);
                break;
            }
            case PRISMATIC: {
                JointCodec.INSTANCE.encodePrismatic((PrismaticJoint)constraint, writeBuffer);
                break;
            }
            case GEAR: {
                JointCodec.INSTANCE.encodeGear((GearJoint)constraint, writeBuffer);
                break;
            }
            case RACK_AND_PINION: {
                JointCodec.INSTANCE.encodeRackAndPinion((RackAndPinionJoint)constraint, writeBuffer);
                break;
            }
            case D6: {
                JointCodec.INSTANCE.encodeD6((D6Joint)constraint, writeBuffer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown JointType " + (Object)((Object)constraint.getConstraintType()));
            }
        }
    }

    @NotNull
    public static JointData decodeConstraint(@NotNull ByteBuffer readBuffer) {
        JointType constraintDataType = JointType.values()[readBuffer.getInt()];
        switch (constraintDataType) {
            case FIXED: {
                return JointCodec.INSTANCE.decodeFixed(readBuffer);
            }
            case DISTANCE: {
                return JointCodec.INSTANCE.decodeDistance(readBuffer);
            }
            case SPHERICAL: {
                return JointCodec.INSTANCE.decodeSpherical(readBuffer);
            }
            case REVOLUTE: {
                return JointCodec.INSTANCE.decodeRevolute(readBuffer);
            }
            case PRISMATIC: {
                return JointCodec.INSTANCE.decodePrismatic(readBuffer);
            }
            case GEAR: {
                return JointCodec.INSTANCE.decodeGear(readBuffer);
            }
            case RACK_AND_PINION: {
                return JointCodec.INSTANCE.decodeRackAndPinion(readBuffer);
            }
            case D6: {
                return JointCodec.INSTANCE.decodeD6(readBuffer);
            }
        }
        throw new IllegalArgumentException("Unknown JointType " + (Object)((Object)constraintDataType));
    }

    public static void encodeConstraints(@NotNull List<JointAndId> constraints, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(0);
        for (JointAndId constraintAndId : constraints) {
            ConstraintEncoder.encodeJointAndId(constraintAndId, writeBuffer);
        }
        int position = writeBuffer.position();
        writeBuffer.putInt(0, position);
    }

    @NotNull
    public static List<JointAndId> decodeConstraints(@NotNull ByteBuffer readBuffer) {
        ArrayList<JointAndId> constraints = new ArrayList<JointAndId>();
        int bytesSize = readBuffer.getInt();
        while (readBuffer.position() != bytesSize) {
            JointAndId constraintAndId = ConstraintEncoder.decodeJointAndId(readBuffer);
            constraints.add(constraintAndId);
        }
        return constraints;
    }

    public static void encodeJointAndId(@NotNull JointAndId constraintAndId, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putInt(constraintAndId.getJointId());
        ConstraintEncoder.encodeConstraint(constraintAndId.getJointData(), writeBuffer);
    }

    @NotNull
    public static JointAndId decodeJointAndId(@NotNull ByteBuffer readBuffer) {
        int constraintId = readBuffer.getInt();
        JointData constraint = ConstraintEncoder.decodeConstraint(readBuffer);
        return new JointAndId(constraintId, constraint);
    }

    public static void writeVector3dc(@NotNull Vector3dc vector3dc, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putDouble(vector3dc.x());
        writeBuffer.putDouble(vector3dc.y());
        writeBuffer.putDouble(vector3dc.z());
    }

    @NotNull
    public static Vector3dc readVector3dc(@NotNull ByteBuffer readBuffer) {
        return new Vector3d(readBuffer.getDouble(), readBuffer.getDouble(), readBuffer.getDouble());
    }

    private static void writeQuaterniondc(@NotNull Quaterniondc quaterniondc, @NotNull ByteBuffer writeBuffer) {
        writeBuffer.putDouble(quaterniondc.w());
        writeBuffer.putDouble(quaterniondc.x());
        writeBuffer.putDouble(quaterniondc.y());
        writeBuffer.putDouble(quaterniondc.z());
    }

    @NotNull
    private static Quaterniondc readQuaterniondc(@NotNull ByteBuffer readBuffer) {
        double w2 = readBuffer.getDouble();
        double x2 = readBuffer.getDouble();
        double y2 = readBuffer.getDouble();
        double z2 = readBuffer.getDouble();
        return new Quaterniond(x2, y2, z2, w2);
    }
}

